/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen.center;

import gregapi.data.CS;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenBeacon
extends WorldgenObject {
    public int mHeight = this.getConfigFile().get((Object)this.mCategory, "Height", (long)(WD.waterLevel() + 4));

    @SafeVarargs
    public WorldgenBeacon(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
        CS.GENERATE_BEACON = this.mEnabled;
    }

    @Override
    public boolean enabled(World aWorld, int aDimType) {
        return CS.GENERATE_BEACON && aWorld.field_73011_w.field_76574_g == 0;
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (aMinX != -16 && aMinX != 0 || aMinZ == -16 && aMinZ == 0) {
            return false;
        }
        if (!CS.GENERATE_STREETS) {
            int j;
            int i;
            for (i = -5; i < 5; ++i) {
                for (j = -5; j < 5; ++j) {
                    WD.set(aWorld, i, this.mHeight + 1, j, Blocks.field_150339_S, 0L, 0L);
                }
            }
            for (i = -4; i < 4; ++i) {
                for (j = -4; j < 4; ++j) {
                    WD.set(aWorld, i, this.mHeight + 2, j, Blocks.field_150339_S, 0L, 0L);
                }
            }
            for (i = -3; i < 3; ++i) {
                for (j = -3; j < 3; ++j) {
                    WD.set(aWorld, i, this.mHeight + 3, j, Blocks.field_150339_S, 0L, 0L);
                }
            }
            for (i = -2; i < 2; ++i) {
                for (j = -2; j < 2; ++j) {
                    WD.set(aWorld, i, this.mHeight + 4, j, Blocks.field_150339_S, 0L, 0L);
                }
            }
            WD.set(aWorld, -1, this.mHeight + 5, -1, (Block)Blocks.field_150461_bJ, 0L, 3L);
            TileEntity tTileEntity = WD.te(aWorld, -1, this.mHeight + 5, -1, true);
            if (tTileEntity instanceof TileEntityBeacon) {
                NBTTagCompound tNBT = UT.NBT.make();
                tTileEntity.func_145841_b(tNBT);
                tNBT.func_74768_a("Primary", Potion.field_76424_c.field_76415_H);
                tNBT.func_74768_a("Secondary", Potion.field_76424_c.field_76415_H);
                tNBT.func_74768_a("Levels", 4);
                tTileEntity.func_145839_a(tNBT);
            }
            WD.set(aWorld, -1, this.mHeight + 5, 0, (Block)Blocks.field_150461_bJ, 0L, 3L);
            tTileEntity = WD.te(aWorld, -1, this.mHeight + 5, 0, true);
            if (tTileEntity instanceof TileEntityBeacon) {
                NBTTagCompound tNBT = UT.NBT.make();
                tTileEntity.func_145841_b(tNBT);
                tNBT.func_74768_a("Primary", Potion.field_76422_e.field_76415_H);
                tNBT.func_74768_a("Secondary", Potion.field_76422_e.field_76415_H);
                tNBT.func_74768_a("Levels", 4);
                tTileEntity.func_145839_a(tNBT);
            }
            WD.set(aWorld, 0, this.mHeight + 5, -1, (Block)Blocks.field_150461_bJ, 0L, 3L);
            tTileEntity = WD.te(aWorld, 0, this.mHeight + 5, -1, true);
            if (tTileEntity instanceof TileEntityBeacon) {
                NBTTagCompound tNBT = UT.NBT.make();
                tTileEntity.func_145841_b(tNBT);
                tNBT.func_74768_a("Primary", Potion.field_76420_g.field_76415_H);
                tNBT.func_74768_a("Secondary", Potion.field_76420_g.field_76415_H);
                tNBT.func_74768_a("Levels", 4);
                tTileEntity.func_145839_a(tNBT);
            }
            WD.set(aWorld, 0, this.mHeight + 5, 0, (Block)Blocks.field_150461_bJ, 0L, 3L);
            tTileEntity = WD.te(aWorld, 0, this.mHeight + 5, 0, true);
            if (tTileEntity instanceof TileEntityBeacon) {
                NBTTagCompound tNBT = UT.NBT.make();
                tTileEntity.func_145841_b(tNBT);
                tNBT.func_74768_a("Primary", Potion.field_76429_m.field_76415_H);
                tNBT.func_74768_a("Secondary", Potion.field_76428_l.field_76415_H);
                tNBT.func_74768_a("Levels", 4);
                tTileEntity.func_145839_a(tNBT);
            }
        }
        aWorld.func_72950_A(0, this.mHeight + 5, 0);
        return true;
    }
}

