/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.OP;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureFluid;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;

public class MultiTileEntityBottleCrate
extends TileEntityBase09FacingSingle
implements IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public short[] mDisplay = new short[9];
    public IIconContainer mIcon = Textures.BlockIcons.RENDERING_ERROR;
    private ITexture mTexture;
    private ITexture mTextureFluid;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        short tShelfID;
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.texture") && UT.Code.exists(tShelfID = aNBT.func_74765_d("gt.texture"), CS.PlankData.PLANK_ICONS)) {
            this.mIcon = CS.PlankData.PLANK_ICONS[tShelfID];
        }
        if (this.mIcon == null || this.mIcon == Textures.BlockIcons.RENDERING_ERROR) {
            this.mIcon = this.mMaterial.mTextureSetsBlock.get(OP.casingMachine.mIconIndexBlock);
        }
        for (int i = 0; i < this.mDisplay.length; ++i) {
            FluidStack tFluid;
            this.mDisplay[i] = !this.slotHas(i) ? 0 : (ST.item(this.slot(i)) == Items.field_151069_bo || IL.BoP_Jar_Empty.equal(this.slot(i), true, true) || IL.HBM_Bottle_Empty_1.equal(this.slot(i), true, true) || IL.HBM_Bottle_Empty_2.equal(this.slot(i), true, true) ? Short.MIN_VALUE : ((tFluid = FL.getFluid(this.slot(i), true)) != null ? (int)(-FL.id(tFluid)) : (ST.item(this.slot(i)) == Items.field_151062_by ? (int)(-FL.Potion_Jump_1.id()) : (MD.HBM.owns(this.slot(i)) ? (int)(-FL.Potion_Harm_1.id()) : (MD.BoP.owns(this.slot(i)) ? Short.MIN_VALUE : (short)(-FL.Water.id()))))));
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.mInventoryChanged) {
            for (int i = 0; i < this.mDisplay.length; ++i) {
                FluidStack tFluid;
                this.mDisplay[i] = !this.slotHas(i) ? 0 : (ST.item(this.slot(i)) == Items.field_151069_bo || IL.BoP_Jar_Empty.equal(this.slot(i), true, true) || IL.HBM_Bottle_Empty_1.equal(this.slot(i), true, true) || IL.HBM_Bottle_Empty_2.equal(this.slot(i), true, true) ? Short.MIN_VALUE : ((tFluid = FL.getFluid(this.slot(i), true)) != null ? (int)(-FL.id(tFluid)) : (ST.item(this.slot(i)) == Items.field_151062_by ? (int)(-FL.Potion_Jump_1.id()) : (MD.HBM.owns(this.slot(i)) ? (int)(-FL.Potion_Harm_1.id()) : (MD.BoP.owns(this.slot(i)) ? Short.MIN_VALUE : (short)(-FL.Water.id()))))));
            }
            this.updateClientData();
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            this.swapBottles(aPlayer, (aHitX < CS.PX_P[5] + CS.PX_P[1] / 2.0f ? 0 : (aHitX < CS.PX_P[10] + CS.PX_P[1] / 2.0f ? 1 : 2)) + (aHitZ < CS.PX_P[5] + CS.PX_P[1] / 2.0f ? 0 : (aHitZ < CS.PX_P[10] + CS.PX_P[1] / 2.0f ? 3 : 6)));
        }
        return true;
    }

    private boolean swapBottles(EntityPlayer aPlayer, int aSlot) {
        if (this.slotHas(aSlot)) {
            if (ST.add((Entity)aPlayer, this.slot(aSlot), true)) {
                this.slotKill(aSlot);
                this.updateInventory();
                this.playCollect();
                return true;
            }
            return false;
        }
        ItemStack tStack = aPlayer.func_71045_bC();
        if (ST.valid(tStack) && this.canInsertItem2(aSlot, tStack, (byte)1)) {
            this.slot(aSlot, ST.copy(tStack));
            tStack.field_77994_a = 0;
            this.updateInventory();
            this.playCollect();
            return true;
        }
        return false;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getDirectionData(), UT.Code.toByteS(this.mDisplay[0], 0), UT.Code.toByteS(this.mDisplay[0], 1), UT.Code.toByteS(this.mDisplay[1], 0), UT.Code.toByteS(this.mDisplay[1], 1), UT.Code.toByteS(this.mDisplay[2], 0), UT.Code.toByteS(this.mDisplay[2], 1), UT.Code.toByteS(this.mDisplay[3], 0), UT.Code.toByteS(this.mDisplay[3], 1), UT.Code.toByteS(this.mDisplay[4], 0), UT.Code.toByteS(this.mDisplay[4], 1), UT.Code.toByteS(this.mDisplay[5], 0), UT.Code.toByteS(this.mDisplay[5], 1), UT.Code.toByteS(this.mDisplay[6], 0), UT.Code.toByteS(this.mDisplay[6], 1), UT.Code.toByteS(this.mDisplay[7], 0), UT.Code.toByteS(this.mDisplay[7], 1), UT.Code.toByteS(this.mDisplay[8], 0), UT.Code.toByteS(this.mDisplay[8], 1));
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[0]), UT.Code.unsignB(aData[1]), UT.Code.unsignB(aData[2])});
        this.setDirectionData(aData[3]);
        for (int i = 0; i < this.mDisplay.length; ++i) {
            this.mDisplay[i] = UT.Code.combine(aData[i * 2 + 4], aData[i * 2 + 5]);
        }
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        this.mTexture = BlockTextureDefault.get(this.mIcon, this.mRGBa);
        return 36;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass < 9) {
            return true;
        }
        short tDisplay = this.mDisplay[(aRenderPass - 9) / 3];
        if (tDisplay == 0) {
            return false;
        }
        if ((aRenderPass - 9) % 3 == 0) {
            if (tDisplay == Short.MIN_VALUE) {
                return false;
            }
            this.mTextureFluid = tDisplay < 0 ? BlockTextureFluid.get(FL.fluid(-tDisplay)) : (UT.Code.exists(tDisplay, OreDictMaterial.MATERIAL_ARRAY) ? OreDictMaterial.MATERIAL_ARRAY[tDisplay].getTextureMolten() : null);
        }
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return this.box(aBlock, CS.PX_P[1], CS.PX_P[0], CS.PX_P[1], CS.PX_N[1], CS.PX_N[15], CS.PX_N[1]);
            }
            case 1: {
                return this.box(aBlock, CS.PX_P[1], CS.PX_P[1], CS.PX_P[5], CS.PX_N[1], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 12 : 11], CS.PX_N[10]);
            }
            case 2: {
                return this.box(aBlock, CS.PX_P[1], CS.PX_P[1], CS.PX_P[10], CS.PX_N[1], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 12 : 11], CS.PX_N[5]);
            }
            case 3: {
                return this.box(aBlock, CS.PX_P[5], CS.PX_P[1], CS.PX_P[1], CS.PX_N[10], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 11 : 12], CS.PX_N[1]);
            }
            case 4: {
                return this.box(aBlock, CS.PX_P[10], CS.PX_P[1], CS.PX_P[1], CS.PX_N[5], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 11 : 12], CS.PX_N[1]);
            }
            case 5: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 15], CS.PX_N[8], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 15 : 0]);
            }
            case 6: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 15], CS.PX_P[0], CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 15 : 0], CS.PX_N[0], CS.PX_N[8], CS.PX_N[0]);
            }
            case 7: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 1], CS.PX_P[5], CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 1 : 0], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 15 : 1], CS.PX_N[9], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 1 : 15]);
            }
            case 8: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 15 : 1], CS.PX_P[5], CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 1 : 15], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 1], CS.PX_N[9], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 1 : 0]);
            }
            case 9: {
                return this.box(aBlock, CS.PX_P[1] + 0.01f, CS.PX_P[1], CS.PX_P[1] + 0.01f, CS.PX_P[5] - 0.01f, CS.PX_P[12], CS.PX_P[5] - 0.01f);
            }
            case 10: {
                return this.box(aBlock, CS.PX_P[1] + 0.005f, CS.PX_P[1], CS.PX_P[1] + 0.005f, CS.PX_P[5] - 0.005f, CS.PX_P[13], CS.PX_P[5] - 0.005f);
            }
            case 11: {
                return this.box(aBlock, CS.PX_P[2], CS.PX_P[13], CS.PX_P[2], CS.PX_P[4], CS.PX_P[16], CS.PX_P[4]);
            }
            case 12: {
                return this.box(aBlock, CS.PX_P[6] + 0.01f, CS.PX_P[1], CS.PX_P[1] + 0.01f, CS.PX_P[10] - 0.01f, CS.PX_P[12], CS.PX_P[5] - 0.01f);
            }
            case 13: {
                return this.box(aBlock, CS.PX_P[6] + 0.005f, CS.PX_P[1], CS.PX_P[1] + 0.005f, CS.PX_P[10] - 0.005f, CS.PX_P[13], CS.PX_P[5] - 0.005f);
            }
            case 14: {
                return this.box(aBlock, CS.PX_P[7], CS.PX_P[13], CS.PX_P[2], CS.PX_P[9], CS.PX_P[16], CS.PX_P[4]);
            }
            case 15: {
                return this.box(aBlock, CS.PX_P[11] + 0.01f, CS.PX_P[1], CS.PX_P[1] + 0.01f, CS.PX_P[15] - 0.01f, CS.PX_P[12], CS.PX_P[5] - 0.01f);
            }
            case 16: {
                return this.box(aBlock, CS.PX_P[11] + 0.005f, CS.PX_P[1], CS.PX_P[1] + 0.005f, CS.PX_P[15] - 0.005f, CS.PX_P[13], CS.PX_P[5] - 0.005f);
            }
            case 17: {
                return this.box(aBlock, CS.PX_P[12], CS.PX_P[13], CS.PX_P[2], CS.PX_P[14], CS.PX_P[16], CS.PX_P[4]);
            }
            case 18: {
                return this.box(aBlock, CS.PX_P[1] + 0.01f, CS.PX_P[1], CS.PX_P[6] + 0.01f, CS.PX_P[5] - 0.01f, CS.PX_P[12], CS.PX_P[10] - 0.01f);
            }
            case 19: {
                return this.box(aBlock, CS.PX_P[1] + 0.005f, CS.PX_P[1], CS.PX_P[6] + 0.005f, CS.PX_P[5] - 0.005f, CS.PX_P[13], CS.PX_P[10] - 0.005f);
            }
            case 20: {
                return this.box(aBlock, CS.PX_P[2], CS.PX_P[13], CS.PX_P[7], CS.PX_P[4], CS.PX_P[16], CS.PX_P[9]);
            }
            case 21: {
                return this.box(aBlock, CS.PX_P[6] + 0.01f, CS.PX_P[1], CS.PX_P[6] + 0.01f, CS.PX_P[10] - 0.01f, CS.PX_P[12], CS.PX_P[10] - 0.01f);
            }
            case 22: {
                return this.box(aBlock, CS.PX_P[6] + 0.005f, CS.PX_P[1], CS.PX_P[6] + 0.005f, CS.PX_P[10] - 0.005f, CS.PX_P[13], CS.PX_P[10] - 0.005f);
            }
            case 23: {
                return this.box(aBlock, CS.PX_P[7], CS.PX_P[13], CS.PX_P[7], CS.PX_P[9], CS.PX_P[16], CS.PX_P[9]);
            }
            case 24: {
                return this.box(aBlock, CS.PX_P[11] + 0.01f, CS.PX_P[1], CS.PX_P[6] + 0.01f, CS.PX_P[15] - 0.01f, CS.PX_P[12], CS.PX_P[10] - 0.01f);
            }
            case 25: {
                return this.box(aBlock, CS.PX_P[11] + 0.005f, CS.PX_P[1], CS.PX_P[6] + 0.005f, CS.PX_P[15] - 0.005f, CS.PX_P[13], CS.PX_P[10] - 0.005f);
            }
            case 26: {
                return this.box(aBlock, CS.PX_P[12], CS.PX_P[13], CS.PX_P[7], CS.PX_P[14], CS.PX_P[16], CS.PX_P[9]);
            }
            case 27: {
                return this.box(aBlock, CS.PX_P[1] + 0.01f, CS.PX_P[1], CS.PX_P[11] + 0.01f, CS.PX_P[5] - 0.01f, CS.PX_P[12], CS.PX_P[15] - 0.01f);
            }
            case 28: {
                return this.box(aBlock, CS.PX_P[1] + 0.005f, CS.PX_P[1], CS.PX_P[11] + 0.005f, CS.PX_P[5] - 0.005f, CS.PX_P[13], CS.PX_P[15] - 0.005f);
            }
            case 29: {
                return this.box(aBlock, CS.PX_P[2], CS.PX_P[13], CS.PX_P[12], CS.PX_P[4], CS.PX_P[16], CS.PX_P[14]);
            }
            case 30: {
                return this.box(aBlock, CS.PX_P[6] + 0.01f, CS.PX_P[1], CS.PX_P[11] + 0.01f, CS.PX_P[10] - 0.01f, CS.PX_P[12], CS.PX_P[15] - 0.01f);
            }
            case 31: {
                return this.box(aBlock, CS.PX_P[6] + 0.005f, CS.PX_P[1], CS.PX_P[11] + 0.005f, CS.PX_P[10] - 0.005f, CS.PX_P[13], CS.PX_P[15] - 0.005f);
            }
            case 32: {
                return this.box(aBlock, CS.PX_P[7], CS.PX_P[13], CS.PX_P[12], CS.PX_P[9], CS.PX_P[16], CS.PX_P[14]);
            }
            case 33: {
                return this.box(aBlock, CS.PX_P[11] + 0.01f, CS.PX_P[1], CS.PX_P[11] + 0.01f, CS.PX_P[15] - 0.01f, CS.PX_P[12], CS.PX_P[15] - 0.01f);
            }
            case 34: {
                return this.box(aBlock, CS.PX_P[11] + 0.005f, CS.PX_P[1], CS.PX_P[11] + 0.005f, CS.PX_P[15] - 0.005f, CS.PX_P[13], CS.PX_P[15] - 0.005f);
            }
            case 35: {
                return this.box(aBlock, CS.PX_P[12], CS.PX_P[13], CS.PX_P[12], CS.PX_P[14], CS.PX_P[16], CS.PX_P[14]);
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass < 9) {
            return this.mTexture;
        }
        if (CS.SIDES_BOTTOM[aSide]) {
            return null;
        }
        switch ((aRenderPass - 9) % 3) {
            default: {
                return this.mTextureFluid;
            }
            case 1: {
                return CS.SIDES_TOP[aSide] ? Textures.BlockIcons.BOTTLECRATE_BOTTLE_TOP.mTexture : Textures.BlockIcons.BOTTLECRATE_BOTTLE_SIDES.mTexture;
            }
            case 2: 
        }
        return CS.SIDES_TOP[aSide] ? Textures.BlockIcons.BOTTLECRATE_BOTTLE_CAP.mTexture : Textures.BlockIcons.BOTTLECRATE_BOTTLE_SIDES.mTexture;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[6], CS.PX_N[0]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_P[6], CS.PX_N[0]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_P[6], CS.PX_N[0]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? 0.5f : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[this.mDisplay.length];
    }

    @Override
    public boolean canDrop(int aSlot) {
        return false;
    }

    @Override
    public boolean keepSlot(int aSlot) {
        return true;
    }

    @Override
    public ItemStack getDefaultStack(int aSlot) {
        return IL.Bottle_Empty.get(1L, new Object[0]);
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        Item aItem = ST.item(aStack);
        if (aItem == null) {
            return false;
        }
        if (aItem == Items.field_151068_bn || aItem == Items.field_151069_bo || aItem == Items.field_151062_by || IL.BoP_Jar_Empty.equal(aStack, true, true) || IL.HBM_Bottle_Empty_1.equal(aStack, true, true) || IL.HBM_Bottle_Empty_2.equal(aStack, true, true)) {
            return true;
        }
        ItemStack aContainer = ST.container(aStack, true);
        return ST.item(aContainer) == Items.field_151069_bo || IL.BoP_Jar_Empty.equal(aContainer, true, true) || IL.HBM_Bottle_Empty_1.equal(aContainer, true, true) || IL.HBM_Bottle_Empty_2.equal(aContainer, true, true);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.crate.bottles";
    }
}

