/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.reactors;

import gregapi.data.LH;
import gregapi.util.ST;
import gregtech.tileentity.energy.reactors.MultiTileEntityReactorCore;
import gregtech.tileentity.energy.reactors.MultiTileEntityReactorRodBase;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntityReactorRodProduct
extends MultiTileEntityReactorRodBase {
    public short mBreeding = (short)-1;
    public String mBreedingName = "";

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.value")) {
            this.mBreeding = aNBT.func_74765_d("gt.value");
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + "Used in Nuclear Reactor Core");
        aList.add(LH.Chat.CYAN + "Emits half the Heat per Neutron on this Rod");
        aList.add(LH.Chat.CYAN + "Can be centrifuged to get valuable materials");
        if (this.mBreedingName.equals("")) {
            this.mBreedingName = ST.meta(aStack.func_77946_l(), this.mBreeding).func_82833_r();
        }
        aList.add(LH.Chat.GREEN + "Breed from " + this.mBreedingName);
    }

    @Override
    public boolean getReactorRodNeutronReaction(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        aReactor.mEnergy += (long)(aReactor.oNeutronCounts[aSlot] / 2);
        return true;
    }

    @Override
    public int getReactorRodNeutronReflection(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack, int aNeutrons, boolean aModerated) {
        int n = aSlot;
        aReactor.mNeutronCounts[n] = aReactor.mNeutronCounts[n] + aNeutrons;
        return 0;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.generator.reactor.rods.product";
    }
}

