/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.block.IBlockExtendedMetaData;
import gregapi.block.IBlockPlacable;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.worldgen.WorldgenBlob;
import gregapi.worldgen.WorldgenObject;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldgenStone
extends WorldgenBlob {
    @SafeVarargs
    public WorldgenStone(String aName, boolean aDefault, Block aBlock, int aBlockMeta, int aAmount, int aSize, int aProbability, int aMinY, int aMaxY, Collection<String> aBiomeList, boolean aAllowToGenerateinVoid, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aBlock, aBlockMeta, aAmount, aSize, aProbability, aMinY, aMaxY, aBiomeList, aAllowToGenerateinVoid, aLists);
    }

    @Override
    public boolean tryPlaceStuff(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        Block tTargetedBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (tTargetedBlock == CS.NB || tTargetedBlock.isAir((IBlockAccess)aWorld, aX, aY, aZ)) {
            return this.mAllowToGenerateinVoid && aWorld.func_147465_d(aX, aY, aZ, this.mBlock, this.mBlockMeta, 0);
        }
        if (tTargetedBlock instanceof IBlockExtendedMetaData) {
            return this.overrideBlock((IBlockExtendedMetaData)tTargetedBlock, aWorld, aX, aY, aZ);
        }
        return (tTargetedBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b) || tTargetedBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs) || tTargetedBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL)) && aWorld.func_147465_d(aX, aY, aZ, this.mBlock, this.mBlockMeta, 0);
    }

    private boolean overrideBlock(IBlockExtendedMetaData aBlock, World aWorld, int aX, int aY, int aZ) {
        if (!CS.BlocksGT.stoneOverridable.contains(aBlock)) {
            return false;
        }
        short aID = aBlock.getExtendedMetaData((IBlockAccess)aWorld, aX, aY, aZ);
        IBlockPlacable tBlock = null;
        if (CS.BlocksGT.stoneToNormalOres.values().contains(aBlock)) {
            tBlock = CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(this.mBlock, 1L, (long)this.mBlockMeta));
        } else if (CS.BlocksGT.stoneToSmallOres.values().contains(aBlock)) {
            tBlock = CS.BlocksGT.stoneToSmallOres.get(new ItemStackContainer(this.mBlock, 1L, (long)this.mBlockMeta));
        } else if (CS.BlocksGT.stoneToBrokenOres.values().contains(aBlock)) {
            tBlock = CS.BlocksGT.stoneToBrokenOres.get(new ItemStackContainer(this.mBlock, 1L, (long)this.mBlockMeta));
        }
        return tBlock != null && tBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, aID, null, false, true);
    }
}

