/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.WorldgenOnSurface;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.IPlantable;

public class WorldgenFlowers
extends WorldgenOnSurface {
    public final int mBlockMeta;
    public final Block mBlock;
    public final Collection<String> mBiomeList;

    @SafeVarargs
    public WorldgenFlowers(String aName, boolean aDefault, Block aBlock, int aBlockMeta, int aAmount, int aProbability, Collection<String> aBiomeList, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aAmount, aProbability, aLists);
        this.mBlock = aBlock instanceof IPlantable ? aBlock : Blocks.field_150327_N;
        this.mBlockMeta = UT.Code.bind4(aBlockMeta);
        this.mBiomeList = aBiomeList;
    }

    @Override
    public int canGenerate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return 0;
        }
        for (String tName : aBiomeNames) {
            if (!this.mBiomeList.contains(tName)) continue;
            return this.mAmount;
        }
        return 0;
    }

    @Override
    public boolean tryPlaceStuff(World aWorld, int aX, int aY, int aZ, Random aRandom, Block aContact) {
        return WD.easyRep(aWorld, aX, aY + 1, aZ) && this.mBlock.func_149718_j(aWorld, aX, aY + 1, aZ) && WD.set(aWorld, aX, aY + 1, aZ, this.mBlock, (long)this.mBlockMeta, 2L);
    }
}

