/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.block.BlockBase;
import gregapi.block.IBlockPlacable;
import gregapi.block.metatype.BlockStones;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.worldgen.StoneLayerOres;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class StoneLayer {
    public final Block mStone;
    public final Block mCobble;
    public final Block mMossy;
    public final byte mMetaStone;
    public final byte mMetaCobble;
    public final byte mMetaMossy;
    public final OreDictMaterial mMaterial;
    public final OreDictMaterial mMaterialSurface;
    public final ItemStackContainer mStack;
    public final List<StoneLayerOres> mOres;
    public IBlockPlacable mOre;
    public IBlockPlacable mOreSmall;
    public IBlockPlacable mOreBroken;
    public boolean mNoDeep = false;
    public static final Set<Block> REPLACEABLE_BLOCKS = new HashSetNoNulls<Block>(false, Blocks.field_150348_b, Blocks.field_150365_q, Blocks.field_150366_p, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150369_x, Blocks.field_150450_ax, Blocks.field_150439_ay);
    public static final List<StoneLayer> LAYERS = new ArrayListNoNulls<StoneLayer>();
    public static StoneLayer DEEPSLATE = null;
    public static final Map<OreDictMaterial, Map<OreDictMaterial, List<StoneLayerOres>>> MAP = new HashMap<OreDictMaterial, Map<OreDictMaterial, List<StoneLayerOres>>>();
    public static final List<OreDictMaterial> RANDOM_SMALL_GEM_ORES = new ArrayListNoNulls<OreDictMaterial>();
    public static OreDictMaterial oTop = null;
    public static OreDictMaterial oBottom = null;
    public static List<StoneLayerOres> oList = Collections.emptyList();

    public StoneLayer(BlockBase aStoneGT, StoneLayerOres ... aOreChances) {
        this((Block)(ST.invalid(aStoneGT) ? Blocks.field_150348_b : aStoneGT), ST.invalid(aStoneGT) ? 0L : 0L, (Block)(ST.invalid(aStoneGT) ? Blocks.field_150347_e : aStoneGT), ST.invalid(aStoneGT) ? 0L : 1L, (Block)(ST.invalid(aStoneGT) ? Blocks.field_150341_Y : aStoneGT), ST.invalid(aStoneGT) ? 0L : 2L, ST.invalid(aStoneGT) ? MT.Stone : ((BlockStones)aStoneGT).mMaterial, aOreChances);
    }

    public StoneLayer(BlockBase aStoneGT, OreDictMaterial aMaterial, Block aStone, StoneLayerOres ... aOreChances) {
        this((Block)(ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? Blocks.field_150348_b : aStoneGT) : aStone), ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? 0L : 0L) : 0L, (Block)(ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? Blocks.field_150347_e : aStoneGT) : Blocks.field_150347_e), ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? 0L : 1L) : 0L, (Block)(ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? Blocks.field_150341_Y : aStoneGT) : Blocks.field_150341_Y), ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? 0L : 2L) : 0L, aMaterial, aOreChances);
    }

    public StoneLayer(BlockBase aStoneGT, OreDictMaterial aMaterial, Block aStone, long aMetaStone, StoneLayerOres ... aOreChances) {
        this((Block)(ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? Blocks.field_150348_b : aStoneGT) : aStone), ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? 0L : 0L) : aMetaStone, (Block)(ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? Blocks.field_150347_e : aStoneGT) : Blocks.field_150347_e), ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? 0L : 1L) : 0L, (Block)(ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? Blocks.field_150341_Y : aStoneGT) : Blocks.field_150341_Y), ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? 0L : 2L) : 0L, aMaterial, aOreChances);
    }

    public StoneLayer(BlockBase aStoneGT, OreDictMaterial aMaterial, Block aStone, long aMetaStone, Block aCobble, long aMetaCobble, StoneLayerOres ... aOreChances) {
        this((Block)(ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? Blocks.field_150348_b : aStoneGT) : aStone), ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? 0L : 0L) : aMetaStone, (Block)(ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? Blocks.field_150347_e : aStoneGT) : aCobble), ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? 0L : 1L) : aMetaCobble, (Block)(ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? Blocks.field_150341_Y : aStoneGT) : Blocks.field_150341_Y), ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? 0L : 2L) : 0L, aMaterial, aOreChances);
    }

    public StoneLayer(BlockBase aStoneGT, OreDictMaterial aMaterial, Block aStone, long aMetaStone, Block aCobble, long aMetaCobble, Block aMossy, long aMetaMossy, StoneLayerOres ... aOreChances) {
        this((Block)(ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? Blocks.field_150348_b : aStoneGT) : aStone), ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? 0L : 0L) : aMetaStone, (Block)(ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? Blocks.field_150347_e : aStoneGT) : aCobble), ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? 0L : 1L) : aMetaCobble, (Block)(ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? Blocks.field_150341_Y : aStoneGT) : aMossy), ST.invalid(aStone) ? (ST.invalid(aStoneGT) ? 0L : 2L) : aMetaMossy, aMaterial, aOreChances);
    }

    public StoneLayer(Block aStone, OreDictMaterial aMaterial, StoneLayerOres ... aOreChances) {
        this(aStone, 0L, Blocks.field_150347_e, 0L, Blocks.field_150341_Y, 0L, aMaterial, aOreChances);
    }

    public StoneLayer(Block aStone, long aMetaStone, OreDictMaterial aMaterial, StoneLayerOres ... aOreChances) {
        this(aStone, aMetaStone, Blocks.field_150347_e, 0L, Blocks.field_150341_Y, 0L, aMaterial, aOreChances);
    }

    public StoneLayer(Block aStone, long aMetaStone, Block aCobble, long aMetaCobble, OreDictMaterial aMaterial, StoneLayerOres ... aOreChances) {
        this(aStone, aMetaStone, aCobble, aMetaCobble, aCobble, aMetaCobble, aMaterial, aOreChances);
    }

    public StoneLayer(Block aStone, long aMetaStone, Block aCobble, long aMetaCobble, Block aMossy, long aMetaMossy, OreDictMaterial aMaterial, StoneLayerOres ... aOreChances) {
        Block block = this.mStone = ST.invalid(aStone) ? Blocks.field_150348_b : aStone;
        Block block2 = ST.invalid(aCobble) ? (Blocks.field_150348_b == this.mStone ? Blocks.field_150347_e : this.mStone) : (this.mCobble = aCobble);
        this.mMossy = ST.invalid(aMossy) ? (Blocks.field_150347_e == this.mCobble ? Blocks.field_150341_Y : this.mCobble) : aMossy;
        this.mMetaStone = Blocks.field_150348_b == this.mStone ? (byte)0 : UT.Code.bind4(aMetaStone);
        this.mMetaCobble = Blocks.field_150347_e == this.mCobble ? (byte)0 : UT.Code.bind4(aMetaCobble);
        this.mMetaMossy = Blocks.field_150341_Y == this.mMossy ? (byte)0 : UT.Code.bind4(aMetaMossy);
        OreDictMaterial oreDictMaterial = this.mMaterial = aMaterial == null ? MT.Stone : aMaterial;
        this.mMaterialSurface = aStone == Blocks.field_150348_b ? MT.Stone : (aStone instanceof BlockStones ? ((BlockStones)aStone).mMaterial : this.mMaterial);
        this.mStack = new ItemStackContainer(this.mStone, 1L, (long)this.mMetaStone);
        this.mOre = CS.BlocksGT.stoneToNormalOres.get(this.mStack);
        this.mOreBroken = CS.BlocksGT.stoneToBrokenOres.get(this.mStack);
        this.mOreSmall = CS.BlocksGT.stoneToSmallOres.get(this.mStack);
        this.mOres = new ArrayListNoNulls<StoneLayerOres>(8);
        for (StoneLayerOres tOre : aOreChances) {
            if (tOre == null || tOre.mMaterial == MT.Empty || !CS.ConfigsGT.WORLDGEN.get((Object)("stonelayers." + this.mMaterial.mNameInternal), tOre.mMaterial.mNameInternal, true)) continue;
            this.mOres.add(tOre);
        }
    }

    public StoneLayer setNoDeep() {
        this.mNoDeep = true;
        return this;
    }

    public static boolean bothsides(OreDictMaterial aMaterialA, OreDictMaterial aMaterialB, StoneLayerOres ... aOreChances) {
        return StoneLayer.topbottom(aMaterialA, aMaterialB, aOreChances) && StoneLayer.topbottom(aMaterialB, aMaterialA, aOreChances);
    }

    public static boolean topbottom(OreDictMaterial aTop, OreDictMaterial aBottom, StoneLayerOres ... aOreChances) {
        List<StoneLayerOres> tList;
        if (aOreChances.length <= 0) {
            return false;
        }
        Map<OreDictMaterial, List<StoneLayerOres>> tMap = MAP.get(aTop);
        if (tMap == null) {
            tMap = new HashMap<OreDictMaterial, List<StoneLayerOres>>();
            MAP.put(aTop, tMap);
        }
        if ((tList = tMap.get(aBottom)) == null) {
            tList = new ArrayList<StoneLayerOres>(aOreChances.length);
            tMap.put(aBottom, tList);
        }
        for (StoneLayerOres tOre : aOreChances) {
            if (tOre == null || tOre.mMaterial == MT.Empty || !CS.ConfigsGT.WORLDGEN.get((Object)("doublelayers." + aTop.mNameInternal + "." + aBottom.mNameInternal), tOre.mMaterial.mNameInternal, true)) continue;
            tList.add(tOre);
        }
        return true;
    }

    public static List<StoneLayerOres> get(StoneLayer aTop, StoneLayer aBottom) {
        return StoneLayer.get(aTop.mMaterial, aBottom.mMaterial);
    }

    public static List<StoneLayerOres> get(OreDictMaterial aTop, OreDictMaterial aBottom) {
        if (aTop == oTop && aBottom == oBottom) {
            return oList;
        }
        oTop = aTop;
        oBottom = aBottom;
        Map<OreDictMaterial, List<StoneLayerOres>> tMap = MAP.get(aTop);
        if (tMap == null) {
            oList = Collections.emptyList();
            return oList;
        }
        List<StoneLayerOres> tList = tMap.get(aBottom);
        if (tList == null) {
            oList = Collections.emptyList();
            return oList;
        }
        oList = tList;
        return oList;
    }
}

