/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes;

import gregapi.code.TagData;
import gregapi.item.IItemEnergy;
import gregapi.item.IItemGTContainerTool;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.recipes.ICraftingRecipeGT;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class AdvancedCraftingShaped
extends ShapedOreRecipe
implements ICraftingRecipeGT {
    public final boolean mDismantleable;
    public final boolean mRemovableByGT;
    public final boolean mAutoCraftable;
    public final boolean mKeepingNBT;
    private final Enchantment[] mEnchantmentsAdded;
    private final int[] mEnchantmentLevelsAdded;

    public AdvancedCraftingShaped(ItemStack aResult, boolean aDismantleAble, boolean aRemovableByGT, boolean aKeepingNBT, boolean aAutoCraftable, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object ... aRecipe) {
        super(aResult, aRecipe);
        this.mEnchantmentsAdded = aEnchantmentsAdded;
        this.mEnchantmentLevelsAdded = aEnchantmentLevelsAdded;
        this.mRemovableByGT = aRemovableByGT;
        this.mKeepingNBT = aKeepingNBT;
        this.mDismantleable = aDismantleAble;
        this.mAutoCraftable = aAutoCraftable;
    }

    public boolean func_77569_a(InventoryCrafting aGrid, World aWorld) {
        if (this.mKeepingNBT) {
            ItemStack tStack = null;
            for (int i = 0; i < aGrid.func_70302_i_(); ++i) {
                if (aGrid.func_70301_a(i) == null || !aGrid.func_70301_a(i).func_77942_o()) continue;
                if (tStack != null && (tStack.func_77942_o() != aGrid.func_70301_a(i).func_77942_o() || tStack.func_77942_o() && !tStack.func_77978_p().equals((Object)aGrid.func_70301_a(i).func_77978_p()))) {
                    return false;
                }
                tStack = aGrid.func_70301_a(i);
            }
        }
        return super.func_77569_a(aGrid, aWorld);
    }

    public ItemStack func_77572_b(InventoryCrafting aGrid) {
        ItemStack rStack = super.func_77572_b(aGrid);
        if (rStack != null) {
            int i;
            ST.update(rStack);
            if (this.mKeepingNBT) {
                for (i = 0; i < aGrid.func_70302_i_(); ++i) {
                    if (aGrid.func_70301_a(i) == null || !aGrid.func_70301_a(i).func_77942_o()) continue;
                    UT.NBT.set(rStack, (NBTTagCompound)aGrid.func_70301_a(i).func_77978_p().func_74737_b());
                    break;
                }
            }
            if (rStack.func_77973_b() instanceof IItemEnergy) {
                for (TagData tEnergyType : ((IItemEnergy)rStack.func_77973_b()).getEnergyTypes(rStack)) {
                    long tCharge = 0L;
                    for (int i2 = 0; i2 < aGrid.func_70302_i_(); ++i2) {
                        if (aGrid.func_70301_a(i2) == null || !(aGrid.func_70301_a(i2).func_77973_b() instanceof IItemEnergy) || aGrid.func_70301_a(i2).func_77973_b() instanceof IItemGTContainerTool) continue;
                        tCharge += ((IItemEnergy)aGrid.func_70301_a(i2).func_77973_b()).getEnergyStored(tEnergyType, aGrid.func_70301_a(i2));
                    }
                    ((IItemEnergy)rStack.func_77973_b()).setEnergyStored(tEnergyType, rStack, tCharge);
                }
            }
            if (this.mDismantleable) {
                NBTTagCompound rNBT = rStack.func_77978_p();
                NBTTagCompound tNBT = UT.NBT.make();
                if (rNBT == null) {
                    rNBT = UT.NBT.make();
                }
                for (int i3 = 0; i3 < 9; ++i3) {
                    ItemStack tStack = aGrid.func_70301_a(i3);
                    if (tStack == null || ST.container(tStack, true) != null || tStack.func_77973_b() instanceof MultiItemTool) continue;
                    tStack = ST.amount(1L, tStack);
                    tNBT.func_74782_a("" + i3, (NBTBase)ST.save(tStack));
                }
                rNBT.func_74782_a("gt.recycling.comps", (NBTBase)tNBT);
                UT.NBT.set(rStack, rNBT);
            }
            for (i = 0; i < this.mEnchantmentsAdded.length; ++i) {
                UT.NBT.addEnchantment(rStack, this.mEnchantmentsAdded[i], UT.NBT.getEnchantmentLevel(this.mEnchantmentsAdded[i], rStack) + this.mEnchantmentLevelsAdded[i]);
            }
            ST.update(rStack);
        }
        return rStack;
    }

    @Override
    public boolean isRemovableByGT() {
        return this.mRemovableByGT;
    }

    @Override
    public boolean isAutocraftableByGT() {
        return this.mAutoCraftable;
    }
}

