/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen.center;

import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.util.ST;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregtech.blocks.fluids.BlockRiver;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class WorldgenCenterBiomes
extends WorldgenObject {
    public int mHeight = this.getConfigFile().get((Object)this.mCategory, "Height", (long)(WD.waterLevel() + 4));

    @SafeVarargs
    public WorldgenCenterBiomes(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
        CS.GENERATE_BIOMES = this.mEnabled;
    }

    @Override
    public boolean enabled(World aWorld, int aDimType) {
        return CS.GENERATE_BIOMES && aWorld.provider.dimensionId == 0;
    }

    @Override
    public void reset(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (CS.GENERATE_BIOMES && aDimType == 0 && aMinX >= -96 && aMinX <= 80 && aMinZ >= -96 && aMinZ <= 80) {
            CS.GENERATING_SPECIAL = true;
        }
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (aMinX >= -96 && aMinX <= 80 && aMinZ >= -96 && aMinZ <= 80) {
            if (CS.GENERATE_STREETS && aMinX >= -32 && aMinX <= 16 && aMinZ >= -32 && aMinZ <= 16) {
                Arrays.fill(aChunk.getBiomeArray(), (byte)BiomeGenBase.river.biomeID);
                return true;
            }
            if (CS.GENERATE_NEXUS && aMinX == 16 && aMinZ == -48) {
                Arrays.fill(aChunk.getBiomeArray(), (byte)BiomeGenBase.plains.biomeID);
                return true;
            }
            if (!(!CS.GENERATE_TESTING || aMinX != 32 && aMinX != 48 || aMinZ != -32 && aMinZ != -48)) {
                Arrays.fill(aChunk.getBiomeArray(), (byte)BiomeGenBase.plains.biomeID);
                return true;
            }
            if (aMinX == -16 || aMinX == 0 || aMinZ == -16 || aMinZ == 0) {
                Arrays.fill(aChunk.getBiomeArray(), (byte)BiomeGenBase.river.biomeID);
                BlockRiver.PLACEMENT_ALLOWED = true;
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        int k;
                        for (k = -3; k < 64; ++k) {
                            WD.set(aChunk, i, this.mHeight + k, j, CS.NB, 0L);
                        }
                        WD.set(aChunk, i, this.mHeight - 4, j, (Block)CS.BlocksGT.River, 0L);
                        WD.set(aChunk, i, this.mHeight - 5, j, (Block)CS.BlocksGT.River, 0L);
                        WD.set(aChunk, i, this.mHeight - 6, j, (Block)CS.BlocksGT.River, 0L);
                        WD.set(aChunk, i, this.mHeight - 7, j, CS.BlocksGT.Sands, aMinX < 0 ? (aMinZ < 0 ? 0L : 1L) : (aMinZ < 0 ? 2L : 0L));
                        WD.set(aChunk, i, this.mHeight - 8, j, Blocks.gravel, 1L);
                        WD.set(aChunk, i, this.mHeight - 9, j, Blocks.clay, 0L);
                        WD.set(aChunk, i, this.mHeight - 10, j, Blocks.clay, 0L);
                        for (k = 1; k < this.mHeight - 10; ++k) {
                            WD.set(aChunk, i, k, j, Blocks.stone, 1L);
                        }
                    }
                }
                BlockRiver.PLACEMENT_ALLOWED = false;
                aWorld.setSpawnLocation(0, this.mHeight + 5, 0);
                return true;
            }
            if (aMinX < 0) {
                if (aMinZ < 0) {
                    if (!(aMinX != -80 && aMinX != -64 || aMinZ != -80 && aMinZ != -64)) {
                        Arrays.fill(aChunk.getBiomeArray(), (byte)BiomeGenBase.icePlains.biomeID);
                        for (int i = 0; i < 16; ++i) {
                            for (int j = 0; j < 16; ++j) {
                                int k;
                                for (k = 1; k < 64; ++k) {
                                    WD.set(aChunk, i, this.mHeight + k, j, CS.NB, 0L);
                                }
                                WD.set(aChunk, i, this.mHeight, j, Blocks.ice, 0L);
                                WD.set(aChunk, i, this.mHeight - 1, j, Blocks.packed_ice, 0L);
                                WD.set(aChunk, i, this.mHeight - 2, j, Blocks.packed_ice, 0L);
                                WD.set(aChunk, i, this.mHeight - 3, j, Blocks.packed_ice, 0L);
                                WD.set(aChunk, i, this.mHeight - 4, j, Blocks.packed_ice, 0L);
                                WD.set(aChunk, i, this.mHeight - 5, j, Blocks.packed_ice, 0L);
                                for (k = 1; k < this.mHeight - 5; ++k) {
                                    WD.set(aChunk, i, k, j, k < 32 ? CS.BlocksGT.SchistGreen : CS.BlocksGT.SchistBlue, aRandom.nextBoolean() ? 2L : 0L);
                                }
                            }
                        }
                    } else {
                        Arrays.fill(aChunk.getBiomeArray(), (byte)BiomeGenBase.coldTaiga.biomeID);
                        for (int i = 0; i < 16; ++i) {
                            for (int j = 0; j < 16; ++j) {
                                int k;
                                for (k = 2; k < 64; ++k) {
                                    WD.set(aChunk, i, this.mHeight + k, j, CS.NB, 0L);
                                }
                                WD.set(aChunk, i, this.mHeight + 1, j, Blocks.snow_layer, aRandom.nextInt(2));
                                WD.set(aChunk, i, this.mHeight, j, Blocks.dirt, 2L);
                                WD.set(aChunk, i, this.mHeight - 1, j, Blocks.dirt, 2L);
                                WD.set(aChunk, i, this.mHeight - 2, j, Blocks.dirt, 2L);
                                WD.set(aChunk, i, this.mHeight - 3, j, Blocks.dirt, 2L);
                                WD.set(aChunk, i, this.mHeight - 4, j, Blocks.dirt, 2L);
                                WD.set(aChunk, i, this.mHeight - 5, j, Blocks.dirt, 2L);
                                for (k = 1; k < this.mHeight - 5; ++k) {
                                    WD.set(aChunk, i, k, j, Blocks.mossy_cobblestone, 0L);
                                }
                            }
                        }
                        WD.set(aChunk, 4, this.mHeight + 1, 4, CS.NB, aRandom.nextInt(2));
                        WD.set(aChunk, 12, this.mHeight + 1, 4, CS.NB, aRandom.nextInt(2));
                        WD.set(aChunk, 4, this.mHeight + 1, 12, CS.NB, aRandom.nextInt(2));
                        WD.set(aChunk, 12, this.mHeight + 1, 12, CS.NB, aRandom.nextInt(2));
                        new WorldGenTrees(false, 4 + aRandom.nextInt(3), 1, 1, false).generate(aWorld, aRandom, aMinX + 4, this.mHeight + 1, aMinZ + 4);
                        new WorldGenTrees(false, 4 + aRandom.nextInt(3), 1, 1, false).generate(aWorld, aRandom, aMinX + 12, this.mHeight + 1, aMinZ + 4);
                        new WorldGenTrees(false, 4 + aRandom.nextInt(3), 1, 1, false).generate(aWorld, aRandom, aMinX + 4, this.mHeight + 1, aMinZ + 12);
                        new WorldGenTrees(false, 4 + aRandom.nextInt(3), 1, 1, false).generate(aWorld, aRandom, aMinX + 12, this.mHeight + 1, aMinZ + 12);
                    }
                } else if (!(aMinX != -80 && aMinX != -64 || aMinZ != 48 && aMinZ != 64)) {
                    Arrays.fill(aChunk.getBiomeArray(), (byte)BiomeGenBase.forest.biomeID);
                    for (int i = 0; i < 16; ++i) {
                        for (int j = 0; j < 16; ++j) {
                            int k;
                            for (k = 1; k < 64; ++k) {
                                WD.set(aChunk, i, this.mHeight + k, j, CS.NB, 0L);
                            }
                            WD.set(aChunk, i, this.mHeight, j, (Block)Blocks.grass, 0L);
                            WD.set(aChunk, i, this.mHeight - 1, j, Blocks.dirt, 0L);
                            WD.set(aChunk, i, this.mHeight - 2, j, Blocks.dirt, 0L);
                            WD.set(aChunk, i, this.mHeight - 3, j, Blocks.dirt, 0L);
                            WD.set(aChunk, i, this.mHeight - 4, j, Blocks.dirt, 0L);
                            WD.set(aChunk, i, this.mHeight - 5, j, Blocks.dirt, 0L);
                            for (k = 1; k < this.mHeight - 5; ++k) {
                                WD.set(aChunk, i, k, j, k < 32 ? CS.BlocksGT.Kimberlite : CS.BlocksGT.Quartzite, aRandom.nextBoolean() ? 2L : 0L);
                            }
                        }
                    }
                    WD.set(aChunk, 6, this.mHeight + 1, 6, Blocks.pumpkin, 0L);
                    WD.set(aChunk, 10, this.mHeight + 1, 6, Blocks.pumpkin, 0L);
                    WD.set(aChunk, 6, this.mHeight + 1, 10, Blocks.pumpkin, 0L);
                    WD.set(aChunk, 10, this.mHeight + 1, 10, Blocks.pumpkin, 0L);
                    new WorldGenTrees(false, 4 + aRandom.nextInt(3), 0, 0, false).generate(aWorld, aRandom, aMinX + 4, this.mHeight + 1, aMinZ + 4);
                    new WorldGenTrees(false, 4 + aRandom.nextInt(3), 2, 2, false).generate(aWorld, aRandom, aMinX + 12, this.mHeight + 1, aMinZ + 4);
                    new WorldGenTrees(false, 4 + aRandom.nextInt(3), 2, 2, false).generate(aWorld, aRandom, aMinX + 4, this.mHeight + 1, aMinZ + 12);
                    new WorldGenTrees(false, 4 + aRandom.nextInt(3), 0, 0, false).generate(aWorld, aRandom, aMinX + 12, this.mHeight + 1, aMinZ + 12);
                } else {
                    MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
                    Arrays.fill(aChunk.getBiomeArray(), (byte)BiomeGenBase.plains.biomeID);
                    for (int i = 0; i < 16; ++i) {
                        block33: for (int j = 0; j < 16; ++j) {
                            int k;
                            for (k = 1; k < 64; ++k) {
                                WD.set(aChunk, i, this.mHeight + k, j, CS.NB, 0L);
                            }
                            WD.set(aChunk, i, this.mHeight, j, (Block)Blocks.grass, 0L);
                            WD.set(aChunk, i, this.mHeight - 1, j, Blocks.dirt, 0L);
                            WD.set(aChunk, i, this.mHeight - 2, j, CS.BlocksGT.Diggables, 1L);
                            WD.set(aChunk, i, this.mHeight - 3, j, CS.BlocksGT.Diggables, 3L);
                            WD.set(aChunk, i, this.mHeight - 4, j, CS.BlocksGT.Diggables, 4L);
                            WD.set(aChunk, i, this.mHeight - 5, j, CS.BlocksGT.Diggables, 5L);
                            WD.set(aChunk, i, this.mHeight - 6, j, CS.BlocksGT.Diggables, 6L);
                            for (k = 1; k < this.mHeight - 6; ++k) {
                                WD.set(aChunk, i, k, j, k < 32 ? CS.BlocksGT.Limestone : CS.BlocksGT.Marble, aRandom.nextBoolean() ? 2L : 0L);
                            }
                            switch (aRandom.nextInt(60)) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    if (tRegistry == null) continue block33;
                                    tRegistry.mBlock.placeBlock(aWorld, aMinX + i, this.mHeight + 1, aMinZ + j, (byte)6, (short)32757, ST.save("gt.value", ST.make(Items.flint, 1L, 0L)), false, true);
                                    continue block33;
                                }
                                case 3: 
                                case 4: 
                                case 5: {
                                    if (tRegistry == null) continue block33;
                                    tRegistry.mBlock.placeBlock(aWorld, aMinX + i, this.mHeight + 1, aMinZ + j, (byte)6, (short)32757, null, false, true);
                                    continue block33;
                                }
                                case 6: 
                                case 7: 
                                case 8: {
                                    if (tRegistry == null) continue block33;
                                    tRegistry.mBlock.placeBlock(aWorld, aMinX + i, this.mHeight + 1, aMinZ + j, (byte)6, (short)32756, null, false, true);
                                    continue block33;
                                }
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: {
                                    WD.set(aChunk, i, this.mHeight + 1, j, (Block)Blocks.tallgrass, 1L);
                                    continue block33;
                                }
                                case 15: {
                                    WD.set(aChunk, i, this.mHeight + 1, j, (Block)Blocks.yellow_flower, 0L);
                                    continue block33;
                                }
                                case 16: {
                                    WD.set(aChunk, i, this.mHeight + 1, j, (Block)Blocks.red_flower, 0L);
                                    continue block33;
                                }
                                case 17: {
                                    WD.set(aChunk, i, this.mHeight + 1, j, (Block)Blocks.red_flower, 1L);
                                    continue block33;
                                }
                                case 18: {
                                    WD.set(aChunk, i, this.mHeight + 1, j, (Block)Blocks.red_flower, 2L);
                                    continue block33;
                                }
                                case 19: {
                                    WD.set(aChunk, i, this.mHeight + 1, j, (Block)Blocks.red_flower, 3L);
                                    continue block33;
                                }
                                case 20: {
                                    WD.set(aChunk, i, this.mHeight + 1, j, (Block)Blocks.red_flower, 4L);
                                    continue block33;
                                }
                                case 21: {
                                    WD.set(aChunk, i, this.mHeight + 1, j, (Block)Blocks.red_flower, 5L);
                                    continue block33;
                                }
                                case 22: {
                                    WD.set(aChunk, i, this.mHeight + 1, j, (Block)Blocks.red_flower, 6L);
                                    continue block33;
                                }
                                case 23: {
                                    WD.set(aChunk, i, this.mHeight + 1, j, (Block)Blocks.red_flower, 7L);
                                    continue block33;
                                }
                                case 24: {
                                    WD.set(aChunk, i, this.mHeight + 1, j, (Block)Blocks.red_flower, 8L);
                                }
                            }
                        }
                    }
                }
            } else if (aMinZ < 0) {
                if (!(aMinX != 48 && aMinX != 64 || aMinZ != -80 && aMinZ != -64)) {
                    int i;
                    Arrays.fill(aChunk.getBiomeArray(), (byte)BiomeGenBase.mesa.biomeID);
                    for (i = 0; i < 16; ++i) {
                        for (int j = 0; j < 16; ++j) {
                            int k;
                            for (k = 1; k < 64; ++k) {
                                WD.set(aChunk, i, this.mHeight + k, j, CS.NB, 0L);
                            }
                            WD.set(aChunk, i, this.mHeight, j, (Block)Blocks.sand, 1L);
                            WD.set(aChunk, i, this.mHeight - 1, j, (Block)Blocks.sand, 1L);
                            WD.set(aChunk, i, this.mHeight - 2, j, (Block)Blocks.sand, 1L);
                            WD.set(aChunk, i, this.mHeight - 3, j, (Block)Blocks.sand, 1L);
                            WD.set(aChunk, i, this.mHeight - 4, j, (Block)Blocks.sand, 1L);
                            WD.set(aChunk, i, this.mHeight - 5, j, (Block)Blocks.sand, 1L);
                            for (k = 1; k < this.mHeight - 5; ++k) {
                                WD.set(aChunk, i, k, j, Blocks.hardened_clay, 0L);
                            }
                        }
                    }
                    for (i = 1; i <= 3; ++i) {
                        WD.set(aChunk, 4, this.mHeight + i, 4, Blocks.cactus, 0L);
                        WD.set(aChunk, 12, this.mHeight + i, 4, Blocks.cactus, 0L);
                        WD.set(aChunk, 4, this.mHeight + i, 12, Blocks.cactus, 0L);
                        WD.set(aChunk, 12, this.mHeight + i, 12, Blocks.cactus, 0L);
                    }
                } else {
                    Arrays.fill(aChunk.getBiomeArray(), (byte)BiomeGenBase.desert.biomeID);
                    for (int i = 0; i < 16; ++i) {
                        for (int j = 0; j < 16; ++j) {
                            int k;
                            for (k = 1; k < 64; ++k) {
                                WD.set(aChunk, i, this.mHeight + k, j, CS.NB, 0L);
                            }
                            WD.set(aChunk, i, this.mHeight, j, (Block)Blocks.sand, 0L);
                            WD.set(aChunk, i, this.mHeight - 1, j, (Block)Blocks.sand, 0L);
                            WD.set(aChunk, i, this.mHeight - 2, j, (Block)Blocks.sand, 0L);
                            WD.set(aChunk, i, this.mHeight - 3, j, (Block)Blocks.sand, 0L);
                            WD.set(aChunk, i, this.mHeight - 4, j, (Block)Blocks.sand, 0L);
                            WD.set(aChunk, i, this.mHeight - 5, j, (Block)Blocks.sand, 0L);
                            for (k = 1; k < this.mHeight - 5; ++k) {
                                WD.set(aChunk, i, k, j, Blocks.sandstone, 0L);
                            }
                        }
                    }
                }
            } else if (!(aMinX != 48 && aMinX != 64 || aMinZ != 48 && aMinZ != 64)) {
                Arrays.fill(aChunk.getBiomeArray(), (byte)BiomeGenBase.swampland.biomeID);
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        int k;
                        for (k = 1; k < 64; ++k) {
                            WD.set(aChunk, i, this.mHeight + k, j, CS.NB, 0L);
                        }
                        WD.set(aChunk, i, this.mHeight, j, Blocks.water, 0L);
                        WD.set(aChunk, i, this.mHeight - 1, j, CS.BlocksGT.Diggables, 0L);
                        WD.set(aChunk, i, this.mHeight - 2, j, CS.BlocksGT.Diggables, 0L);
                        WD.set(aChunk, i, this.mHeight - 3, j, CS.BlocksGT.Diggables, 2L);
                        WD.set(aChunk, i, this.mHeight - 4, j, CS.BlocksGT.Diggables, 2L);
                        WD.set(aChunk, i, this.mHeight - 5, j, CS.BlocksGT.Diggables, 2L);
                        for (k = 1; k < this.mHeight - 5; ++k) {
                            WD.set(aChunk, i, k, j, k < 32 ? CS.BlocksGT.GraniteRed : CS.BlocksGT.GraniteBlack, aRandom.nextBoolean() ? 2L : 0L);
                        }
                        if (aRandom.nextInt(8) != 0) continue;
                        WD.set(aChunk, i, this.mHeight + 1, j, CS.BlocksGT.Glowtus, aRandom.nextInt(16));
                    }
                }
                WD.set(aChunk, 4, this.mHeight + 1, 4, Blocks.waterlily, 0L);
                WD.set(aChunk, 12, this.mHeight + 1, 4, Blocks.waterlily, 0L);
                WD.set(aChunk, 4, this.mHeight + 1, 12, Blocks.waterlily, 0L);
                WD.set(aChunk, 12, this.mHeight + 1, 12, Blocks.waterlily, 0L);
            } else {
                Arrays.fill(aChunk.getBiomeArray(), (byte)BiomeGenBase.jungle.biomeID);
                if (IL.EtFu_Dirt.exists()) {
                    Block tBlock = IL.EtFu_Dirt.block();
                    for (int i = 0; i < 16; ++i) {
                        for (int j = 0; j < 16; ++j) {
                            int k;
                            for (k = 1; k < 64; ++k) {
                                WD.set(aChunk, i, this.mHeight + k, j, CS.NB, 0L);
                            }
                            WD.set(aChunk, i, this.mHeight, j, (Block)Blocks.grass, 0L);
                            WD.set(aChunk, i, this.mHeight - 1, j, tBlock, 0L);
                            WD.set(aChunk, i, this.mHeight - 2, j, tBlock, 0L);
                            WD.set(aChunk, i, this.mHeight - 3, j, tBlock, 0L);
                            WD.set(aChunk, i, this.mHeight - 4, j, tBlock, 0L);
                            WD.set(aChunk, i, this.mHeight - 5, j, tBlock, 0L);
                            for (k = 1; k < this.mHeight - 5; ++k) {
                                WD.set(aChunk, i, k, j, k < 32 ? CS.BlocksGT.Komatiite : CS.BlocksGT.Basalt, aRandom.nextBoolean() ? 2L : 0L);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < 16; ++i) {
                        for (int j = 0; j < 16; ++j) {
                            int k;
                            for (k = 1; k < 64; ++k) {
                                WD.set(aChunk, i, this.mHeight + k, j, CS.NB, 0L);
                            }
                            WD.set(aChunk, i, this.mHeight, j, (Block)Blocks.grass, 0L);
                            WD.set(aChunk, i, this.mHeight - 1, j, Blocks.dirt, 1L);
                            WD.set(aChunk, i, this.mHeight - 2, j, Blocks.dirt, 1L);
                            WD.set(aChunk, i, this.mHeight - 3, j, Blocks.dirt, 1L);
                            WD.set(aChunk, i, this.mHeight - 4, j, Blocks.dirt, 1L);
                            WD.set(aChunk, i, this.mHeight - 5, j, Blocks.dirt, 1L);
                            for (k = 1; k < this.mHeight - 5; ++k) {
                                WD.set(aChunk, i, k, j, k < 32 ? CS.BlocksGT.Komatiite : CS.BlocksGT.Basalt, aRandom.nextBoolean() ? 2L : 0L);
                            }
                        }
                    }
                }
                WD.set(aChunk, 6 + aRandom.nextInt(4), this.mHeight + 1, 6 + aRandom.nextInt(4), Blocks.melon_block, 0L);
                new WorldGenTrees(false, 9 + aRandom.nextInt(3), 3, 3, true).generate(aWorld, aRandom, aMinX + 4, this.mHeight + 1, aMinZ + 4);
                new WorldGenTrees(false, 9 + aRandom.nextInt(3), 3, 3, true).generate(aWorld, aRandom, aMinX + 12, this.mHeight + 1, aMinZ + 4);
                new WorldGenTrees(false, 9 + aRandom.nextInt(3), 3, 3, true).generate(aWorld, aRandom, aMinX + 4, this.mHeight + 1, aMinZ + 12);
                new WorldGenTrees(false, 9 + aRandom.nextInt(3), 3, 3, true).generate(aWorld, aRandom, aMinX + 12, this.mHeight + 1, aMinZ + 12);
            }
            return true;
        }
        return false;
    }
}

