/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.RM;
import gregapi.data.TD;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.machines.ITileEntityAnvil;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class MultiTileEntityAnvil
extends TileEntityBase09FacingSingle
implements ITileEntityAnvil,
IMultiTileEntity.IMTE_OnRegistration,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public short mMaterialA = 0;
    public short mMaterialB = 0;
    public byte mShapeA = 0;
    public byte mShapeB = 0;
    public long mDurability = 10000L;
    public ITexture mTextureAnvil;
    public ITexture mTextureA;
    public ITexture mTextureB;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.durability")) {
            this.mDurability = aNBT.getLong("gt.durability");
        }
        this.updateInventory();
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.durability", this.mDurability);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        UT.NBT.setNumber(aNBT, "gt.durability", this.mDurability);
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(RM.Anvil.mNameInternal) + LH.Chat.CYAN + " (D: " + LH.Chat.WHITE + UT.Code.makeString(UT.Code.divup(this.mDurability, 10000L)) + LH.Chat.CYAN + ")");
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.anvil.usage"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L || this.isClientSide()) {
            return rReturn;
        }
        if ((CS.SIDES_TOP_HORIZONTAL[aSide] || aPlayer == null) && aTool.equals("hammer") && (this.slotHas(0) || this.slotHas(1))) {
            Recipe tRecipe;
            Recipe.RecipeMap tRecipeMap = RM.Anvil;
            if (CS.SIDES_HORIZONTAL[aSide]) {
                if (CS.ALONG_AXIS[this.mFacing][aSide]) {
                    switch (this.mFacing) {
                        case 4: {
                            tRecipeMap = (double)aHitZ < 0.5 ? RM.AnvilBendSmall : RM.AnvilBendBig;
                            break;
                        }
                        case 5: {
                            tRecipeMap = (double)aHitZ > 0.5 ? RM.AnvilBendSmall : RM.AnvilBendBig;
                            break;
                        }
                        case 2: {
                            tRecipeMap = (double)aHitX < 0.5 ? RM.AnvilBendSmall : RM.AnvilBendBig;
                            break;
                        }
                        case 3: {
                            tRecipeMap = (double)aHitX > 0.5 ? RM.AnvilBendSmall : RM.AnvilBendBig;
                        }
                    }
                } else {
                    switch (this.mFacing) {
                        case 4: {
                            tRecipeMap = aSide == 2 ? RM.AnvilBendSmall : RM.AnvilBendBig;
                            break;
                        }
                        case 5: {
                            tRecipeMap = aSide == 3 ? RM.AnvilBendSmall : RM.AnvilBendBig;
                            break;
                        }
                        case 2: {
                            tRecipeMap = aSide == 4 ? RM.AnvilBendSmall : RM.AnvilBendBig;
                            break;
                        }
                        case 3: {
                            tRecipeMap = aSide == 5 ? RM.AnvilBendSmall : RM.AnvilBendBig;
                        }
                    }
                }
            }
            if ((tRecipe = tRecipeMap.findRecipe((IHasWorldAndCoords)this, null, false, Long.MAX_VALUE, CS.NI, CS.ZL_FLUIDTANKGT, this.slotHas(0) ? this.slot(0) : ST.emptySlot(), this.slotHas(1) ? this.slot(1) : ST.emptySlot())) != null) {
                ItemStack[] itemStackArray = new ItemStack[2];
                itemStackArray[0] = this.slotHas(0) ? this.slot(0) : ST.emptySlot();
                ItemStack itemStack = itemStackArray[1] = this.slotHas(1) ? this.slot(1) : ST.emptySlot();
                if (tRecipe.isRecipeInputEqual(true, false, CS.ZL_FLUIDTANKGT, itemStackArray)) {
                    ItemStack[] tOutputItems = tRecipe.getOutputs();
                    for (int i = 0; i < tOutputItems.length; ++i) {
                        if (!ST.valid(tOutputItems[i]) || ST.add(aPlayer, aPlayerInventory, tOutputItems[i], false)) continue;
                        ST.place(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 1.2, (double)this.zCoord + 0.5, tOutputItems[i]);
                    }
                    this.removeAllDroppableNullStacks();
                    UT.Entities.exhaust(aPlayer, (float)tRecipe.getAbsoluteTotalPower() / 5000.0f);
                    long tDurability = UT.Entities.getDurabilityUse(aPlayer, Math.max(10000L, UT.Code.divup(Math.max(1L, tRecipe.getAbsoluteTotalPower()), 4L)));
                    this.mDurability -= tDurability;
                    if (this.mDurability <= 0L) {
                        UT.Sounds.send("random.break", this, false);
                        ST.drop(this.worldObj, this.getCoords(), OP.scrapGt.mat(this.mMaterial.mTargetSmashing.mMaterial, (long)(48 + this.rng(16))));
                        this.setToAir();
                    }
                    this.updateInventory();
                    return tDurability;
                }
            }
            return 0L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add("Remaining Durability: " + UT.Code.makeString(UT.Code.divup(this.mDurability, 10000L)));
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide && this.mInventoryChanged) {
            OreDictItemData tData;
            this.mShapeB = 0;
            this.mShapeA = 0;
            if (CS.ToolsGT.contains("hammer", this.slot(0))) {
                this.mMaterialA = MultiItemTool.getPrimaryMaterial((ItemStack)this.slot((int)0), (OreDictMaterial)MT.Steel).mID;
                if (this.mMaterialA <= 0) {
                    this.mMaterialA = MT.Steel.mID;
                }
                this.mShapeA = (byte)8;
            } else if (CS.ToolsGT.contains("hammer", this.slot(1))) {
                this.mMaterialA = MultiItemTool.getSecondaryMaterial((ItemStack)this.slot((int)1), (OreDictMaterial)MT.WOODS.Spruce).mID;
                if (this.mMaterialA <= 0) {
                    this.mMaterialA = MT.WOODS.Spruce.mID;
                }
                this.mShapeA = (byte)9;
            } else if (this.slotHas(0)) {
                this.mMaterialA = MT.Fe.mID;
                tData = OM.anydata(this.slot(0));
                if (tData != null) {
                    if (tData.mMaterial != null && tData.mMaterial.mMaterial.mID > 0) {
                        this.mMaterialA = tData.mMaterial.mMaterial.mID;
                    }
                    if (tData.mPrefix != null) {
                        this.mShapeA = tData.mPrefix.containsAny(TD.Prefix.INGOT_BASED) ? (byte)1 : (tData.mPrefix.mNameInternal.startsWith("plate") ? (byte)2 : (tData.mPrefix.mNameInternal.startsWith("plank") ? (byte)2 : (tData.mPrefix.mNameInternal.startsWith("stick") ? (byte)3 : (tData.mPrefix.mNameInternal.startsWith("wire") ? (byte)3 : (tData.mPrefix.mNameInternal.startsWith("chunk") ? (byte)4 : (tData.mPrefix.mNameInternal.startsWith("ring") ? (byte)5 : (tData.mPrefix.mNameInternal.startsWith("gem") ? (byte)6 : (tData.mPrefix.mNameInternal.startsWith("ore") ? (byte)7 : (tData.mPrefix.mNameInternal.startsWith("rock") ? (byte)7 : (tData.mPrefix.containsAny(TD.Prefix.ORE, TD.Prefix.ORE_PROCESSING_BASED) ? (byte)7 : (byte)0))))))))));
                    }
                }
            } else {
                this.mMaterialA = 0;
            }
            if (CS.ToolsGT.contains("hammer", this.slot(1))) {
                this.mMaterialB = MultiItemTool.getPrimaryMaterial((ItemStack)this.slot((int)1), (OreDictMaterial)MT.Steel).mID;
                if (this.mMaterialB <= 0) {
                    this.mMaterialB = MT.Steel.mID;
                }
                this.mShapeB = (byte)8;
            } else if (CS.ToolsGT.contains("hammer", this.slot(0))) {
                this.mMaterialB = MultiItemTool.getSecondaryMaterial((ItemStack)this.slot((int)0), (OreDictMaterial)MT.WOODS.Spruce).mID;
                if (this.mMaterialB <= 0) {
                    this.mMaterialB = MT.WOODS.Spruce.mID;
                }
                this.mShapeB = (byte)9;
            } else if (this.slotHas(1)) {
                this.mMaterialB = MT.Fe.mID;
                tData = OM.anydata(this.slot(1));
                if (tData != null) {
                    if (tData.mMaterial != null && tData.mMaterial.mMaterial.mID > 0) {
                        this.mMaterialB = tData.mMaterial.mMaterial.mID;
                    }
                    if (tData.mPrefix != null) {
                        this.mShapeB = tData.mPrefix.containsAny(TD.Prefix.INGOT_BASED) ? (byte)1 : (tData.mPrefix.mNameInternal.startsWith("plate") ? (byte)2 : (tData.mPrefix.mNameInternal.startsWith("plank") ? (byte)2 : (tData.mPrefix.mNameInternal.startsWith("stick") ? (byte)3 : (tData.mPrefix.mNameInternal.startsWith("wire") ? (byte)3 : (tData.mPrefix.mNameInternal.startsWith("chunk") ? (byte)4 : (tData.mPrefix.mNameInternal.startsWith("ring") ? (byte)5 : (tData.mPrefix.mNameInternal.startsWith("gem") ? (byte)6 : (tData.mPrefix.mNameInternal.startsWith("ore") ? (byte)7 : (tData.mPrefix.mNameInternal.startsWith("rock") ? (byte)7 : (tData.mPrefix.containsAny(TD.Prefix.ORE, TD.Prefix.ORE_PROCESSING_BASED) ? (byte)7 : (byte)0))))))))));
                    }
                }
            } else {
                this.mMaterialB = 0;
            }
            this.updateClientData();
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            boolean tHasHammer;
            if (aHitY < CS.PX_P[4]) {
                return true;
            }
            ItemStack aStack = aPlayer.getCurrentEquippedItem();
            byte tSlot = (byte)(!((double)(CS.SIDES_AXIS_Z[this.mFacing] ? aHitX : aHitZ) < 0.5) ? 1 : 0);
            boolean bl = tHasHammer = CS.ToolsGT.contains("hammer", this.slot(0)) || CS.ToolsGT.contains("hammer", this.slot(1));
            if (CS.SIDES_TOP[aSide]) {
                if (tHasHammer) {
                    if (this.slotHas(0) && ST.give((Entity)aPlayer, this.slot(0), true, this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 1.2, (double)this.zCoord + 0.5)) {
                        this.slotKill(0);
                        this.updateInventory();
                        return true;
                    }
                    if (this.slotHas(1) && ST.give((Entity)aPlayer, this.slot(1), true, this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 1.2, (double)this.zCoord + 0.5)) {
                        this.slotKill(1);
                        this.updateInventory();
                        return true;
                    }
                    return true;
                }
                if (ST.valid(aStack)) {
                    if ((CS.ToolsGT.contains("hammer", aStack) && !this.slotHas(0) && !this.slotHas(1) || RM.Anvil.containsInput(aStack, (IHasWorldAndCoords)this, CS.NI) || RM.AnvilBendSmall.containsInput(aStack, (IHasWorldAndCoords)this, CS.NI) || RM.AnvilBendBig.containsInput(aStack, (IHasWorldAndCoords)this, CS.NI)) && ST.move((IInventory)aPlayer.inventory, this, aPlayer.inventory.currentItem, (int)tSlot) > 0) {
                        this.playClick();
                    }
                    return true;
                }
                if (this.slotHas(tSlot) && ST.give((Entity)aPlayer, this.slot(tSlot), true, this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 1.2, (double)this.zCoord + 0.5)) {
                    this.slotKill(tSlot);
                    this.updateInventory();
                    return true;
                }
            }
            if (this.slotHas(0)) {
                if (!this.slotHas(1)) {
                    if (this.slot((int)0).stackSize % 2 != 0 && ST.give((Entity)aPlayer, ST.amount(1L, this.slot(0)), true, this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 1.2, (double)this.zCoord + 0.5)) {
                        --this.slot((int)0).stackSize;
                    }
                    if (this.slot((int)0).stackSize > 1) {
                        this.slot((int)0).stackSize /= 2;
                        this.slot(1, ST.copy(this.slot(0)));
                    }
                    this.slotNull(0);
                    this.updateInventory();
                    return true;
                }
            } else if (this.slotHas(1)) {
                if (this.slot((int)1).stackSize % 2 != 0 && ST.give((Entity)aPlayer, ST.amount(1L, this.slot(1)), true, this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 1.2, (double)this.zCoord + 0.5)) {
                    --this.slot((int)1).stackSize;
                }
                if (this.slot((int)1).stackSize > 1) {
                    this.slot((int)1).stackSize /= 2;
                    this.slot(0, ST.copy(this.slot(1)));
                }
                this.slotNull(1);
                this.updateInventory();
                return true;
            }
            return true;
        }
        if (aHitY < CS.PX_P[4]) {
            RM.Anvil.openNEI();
            return true;
        }
        return true;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        super.onPlaced(aStack, aPlayer, aMTEContainer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ);
        if (aMTEContainer.mBlock.stepSound != Block.soundTypeMetal || this.mMaterial.contains(TD.Properties.STONE) || this.mMaterial == MT.IronWood) {
            return true;
        }
        aWorld.playSoundEffect((double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, Blocks.anvil.stepSound.func_150496_b(), (Blocks.anvil.stepSound.getVolume() + 1.0f) / 2.0f, Blocks.anvil.stepSound.getPitch() * 0.8f);
        return false;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getVisualData(), this.getDirectionData(), this.mShapeA, this.mShapeB, UT.Code.toByteS(this.mMaterialA, 0), UT.Code.toByteS(this.mMaterialA, 1), UT.Code.toByteS(this.mMaterialB, 0), UT.Code.toByteS(this.mMaterialB, 1));
        }
        return super.getClientDataPacket(aSendAll);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        super.receiveDataByteArray(aData, aNetworkHandler);
        if (aData.length > 4) {
            this.mShapeA = aData[5];
            this.mShapeB = aData[6];
            this.mMaterialA = UT.Code.combine(aData[7], aData[8]);
            this.mMaterialB = UT.Code.combine(aData[9], aData[10]);
        }
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        this.mTextureAnvil = this.mMaterial.getTextureSmooth(this.mRGBa, true);
        if (this.mMaterialA <= 0) {
            this.mTextureA = null;
        } else if (UT.Code.exists(this.mMaterialA, OreDictMaterial.MATERIAL_ARRAY)) {
            switch (this.mShapeA) {
                case 6: {
                    this.mTextureA = OreDictMaterial.MATERIAL_ARRAY[this.mMaterialA].getTextureGem();
                    break;
                }
                case 7: {
                    this.mTextureA = BlockTextureDefault.get(OreDictMaterial.MATERIAL_ARRAY[this.mMaterialA], OP.blockRaw);
                    break;
                }
                default: {
                    this.mTextureA = OreDictMaterial.MATERIAL_ARRAY[this.mMaterialA].getTextureSolid();
                    break;
                }
            }
        } else {
            this.mTextureA = BlockTextureCopied.get(Blocks.iron_block);
        }
        if (this.mMaterialB <= 0) {
            this.mTextureB = null;
        } else if (UT.Code.exists(this.mMaterialB, OreDictMaterial.MATERIAL_ARRAY)) {
            switch (this.mShapeB) {
                case 6: {
                    this.mTextureB = OreDictMaterial.MATERIAL_ARRAY[this.mMaterialB].getTextureGem();
                    break;
                }
                case 7: {
                    this.mTextureB = BlockTextureDefault.get(OreDictMaterial.MATERIAL_ARRAY[this.mMaterialB], OP.blockRaw);
                    break;
                }
                default: {
                    this.mTextureB = OreDictMaterial.MATERIAL_ARRAY[this.mMaterialB].getTextureSolid();
                    break;
                }
            }
        } else {
            this.mTextureB = BlockTextureCopied.get(Blocks.iron_block);
        }
        return this.mTextureB == null ? (this.mTextureA == null ? 6 : 7) : 8;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 4 : 2], CS.PX_P[0], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 4 : 2], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 4 : 2], CS.PX_N[12], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 4 : 2]);
            }
            case 1: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 4], CS.PX_P[4], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 4], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 4], CS.PX_N[8], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 4]);
            }
            case 2: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 4 : 1], CS.PX_P[8], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 4 : 1], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 4 : 1], CS.PX_N[4], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 4 : 1]);
            }
            case 3: {
                switch (this.mFacing) {
                    case 4: {
                        return this.box(aBlock, CS.PX_P[5], CS.PX_P[8], CS.PX_P[15], CS.PX_N[5], CS.PX_N[4], CS.PX_N[0]);
                    }
                    case 5: {
                        return this.box(aBlock, CS.PX_P[5], CS.PX_P[8], CS.PX_P[0], CS.PX_N[5], CS.PX_N[4], CS.PX_N[15]);
                    }
                    case 2: {
                        return this.box(aBlock, CS.PX_P[15], CS.PX_P[8], CS.PX_P[5], CS.PX_N[0], CS.PX_N[4], CS.PX_N[5]);
                    }
                }
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[8], CS.PX_P[5], CS.PX_N[15], CS.PX_N[4], CS.PX_N[5]);
            }
            case 4: {
                switch (this.mFacing) {
                    case 4: {
                        return this.box(aBlock, CS.PX_P[4], CS.PX_P[9], CS.PX_P[0], CS.PX_N[4], CS.PX_N[5], CS.PX_N[15]);
                    }
                    case 5: {
                        return this.box(aBlock, CS.PX_P[4], CS.PX_P[9], CS.PX_P[15], CS.PX_N[4], CS.PX_N[5], CS.PX_N[0]);
                    }
                    case 2: {
                        return this.box(aBlock, CS.PX_P[0], CS.PX_P[9], CS.PX_P[4], CS.PX_N[15], CS.PX_N[5], CS.PX_N[4]);
                    }
                }
                return this.box(aBlock, CS.PX_P[15], CS.PX_P[9], CS.PX_P[4], CS.PX_N[0], CS.PX_N[5], CS.PX_N[4]);
            }
            case 5: {
                switch (this.mFacing) {
                    case 4: {
                        return this.box(aBlock, CS.PX_P[4] - 1.0E-4f, CS.PX_P[0], CS.PX_P[2], CS.PX_P[12] + 1.0E-4f, CS.PX_P[2], CS.PX_P[4]);
                    }
                    case 5: {
                        return this.box(aBlock, CS.PX_P[4] - 1.0E-4f, CS.PX_P[0], CS.PX_P[12], CS.PX_P[12] + 1.0E-4f, CS.PX_P[2], CS.PX_P[14]);
                    }
                    case 2: {
                        return this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[4] - 1.0E-4f, CS.PX_P[4], CS.PX_P[2], CS.PX_P[12] + 1.0E-4f);
                    }
                }
                return this.box(aBlock, CS.PX_P[12], CS.PX_P[0], CS.PX_P[4] - 1.0E-4f, CS.PX_P[14], CS.PX_P[2], CS.PX_P[12] + 1.0E-4f);
            }
            case 6: {
                switch (this.mShapeA) {
                    case 1: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 3], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 3], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 10], CS.PX_N[1], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 10]);
                    }
                    case 2: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 1], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 1], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 9], CS.PX_N[3], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 9]);
                    }
                    case 3: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 1], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 1], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 9], CS.PX_N[2], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 9]);
                    }
                    case 4: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 2], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 2], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 10], CS.PX_N[2], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 10]);
                    }
                    case 5: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 2], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 2], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 10], CS.PX_N[3], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 10]);
                    }
                    case 6: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 2], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 2], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 10], CS.PX_N[0], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 10]);
                    }
                    case 7: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 1], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 1], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 9], CS.PX_N[0], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 9]);
                    }
                    case 8: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 2], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 2], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 10], CS.PX_N[0], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 10]);
                    }
                    case 9: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 1], CS.PX_P[13], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 1], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 1], CS.PX_N[1], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 1]);
                    }
                }
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 1], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 1], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 9], CS.PX_N[0], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 9]);
            }
            case 7: {
                switch (this.mShapeB) {
                    case 1: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 10], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 10], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 3], CS.PX_N[1], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 3]);
                    }
                    case 2: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 9], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 9], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 1], CS.PX_N[3], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 1]);
                    }
                    case 3: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 9], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 9], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 1], CS.PX_N[2], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 1]);
                    }
                    case 4: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 10], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 10], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 2], CS.PX_N[2], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 2]);
                    }
                    case 5: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 10], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 10], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 2], CS.PX_N[3], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 2]);
                    }
                    case 6: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 10], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 10], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 2], CS.PX_N[0], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 2]);
                    }
                    case 7: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 9], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 9], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 1], CS.PX_N[0], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 1]);
                    }
                    case 8: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 10], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 10], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 2], CS.PX_N[0], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 2]);
                    }
                    case 9: {
                        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 1], CS.PX_P[13], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 1], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 1], CS.PX_N[1], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 1]);
                    }
                }
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 9], CS.PX_P[12], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 9], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 5 : 1], CS.PX_N[0], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 5 : 1]);
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return CS.SIDES_TOP_HORIZONTAL[aSide] || aShouldSideBeRendered[aSide] ? this.mTextureAnvil : null;
            }
            case 1: {
                return CS.SIDES_HORIZONTAL[aSide] ? this.mTextureAnvil : null;
            }
            case 2: {
                return this.mTextureAnvil;
            }
            case 3: {
                return this.mTextureAnvil;
            }
            case 4: {
                return this.mTextureAnvil;
            }
            case 5: {
                return CS.ALONG_AXIS[this.mFacing][aSide] ? BI.nei() : null;
            }
            case 6: {
                return CS.SIDES_TOP_HORIZONTAL[aSide] ? this.mTextureA : null;
            }
            case 7: {
                return CS.SIDES_TOP_HORIZONTAL[aSide] ? this.mTextureB : null;
            }
        }
        return this.mTextureAnvil;
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 4 : 0], CS.PX_P[0], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 4 : 0], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 4 : 0], CS.PX_N[4], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 4 : 0]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 4 : 0], CS.PX_P[0], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 4 : 0], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 4 : 0], CS.PX_N[4], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 4 : 0]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 4 : 0], CS.PX_P[0], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 4 : 0], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 4 : 0], CS.PX_N[4], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 4 : 0]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 0.5f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 0.5f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] || CS.ALONG_AXIS[this.mFacing][aSide] ? CS.PX_P[4] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean isAnvil(byte aSide) {
        return true;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[2];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return !CS.ToolsGT.contains("hammer", this.slot(0)) && !CS.ToolsGT.contains("hammer", this.slot(1)) && (RM.Anvil.containsInput(aStack, (IHasWorldAndCoords)this, CS.NI) || RM.AnvilBendSmall.containsInput(aStack, (IHasWorldAndCoords)this, CS.NI) || RM.AnvilBendBig.containsInput(aStack, (IHasWorldAndCoords)this, CS.NI));
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public void onRegistration(MultiTileEntityRegistry aRegistry, short aID) {
        RM.Anvil.mRecipeMachineList.add(aRegistry.getItem(aID));
        RM.AnvilBendSmall.mRecipeMachineList.add(aRegistry.getItem(aID));
        RM.AnvilBendBig.mRecipeMachineList.add(aRegistry.getItem(aID));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.anvil.simple";
    }
}

