/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.sensors;

import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.IIconContainer;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.MultiTileEntitySensorTE;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;

public class MultiTileEntityProgressmeter
extends MultiTileEntitySensorTE {
    public static IIconContainer sTextureFront;
    public static IIconContainer sTextureBack;
    public static IIconContainer sTextureSide;
    public static IIconContainer sOverlayFront;
    public static IIconContainer sOverlayBack;
    public static IIconContainer sOverlaySide;

    @Override
    public String getSensorDescription() {
        return LH.get("gt.tooltip.sensor.progressmeter");
    }

    @Override
    public long getCurrentValue(DelegatorTileEntity<TileEntity> aDelegator) {
        MobSpawnerBaseLogic tLogic;
        if (aDelegator.mTileEntity instanceof ITileEntityProgress) {
            return ((ITileEntityProgress)aDelegator.mTileEntity).getProgressValue(aDelegator.mSideOfTileEntity);
        }
        if (aDelegator.mTileEntity instanceof TileEntityMobSpawner && (tLogic = ((TileEntityMobSpawner)aDelegator.mTileEntity).func_145881_a()) != null) {
            return tLogic.spawnDelay;
        }
        return 0L;
    }

    @Override
    public long getCurrentMax(DelegatorTileEntity<TileEntity> aDelegator) {
        MobSpawnerBaseLogic tLogic;
        if (aDelegator.mTileEntity instanceof ITileEntityProgress) {
            return ((ITileEntityProgress)aDelegator.mTileEntity).getProgressMax(aDelegator.mSideOfTileEntity);
        }
        if (aDelegator.mTileEntity instanceof TileEntityMobSpawner && (tLogic = ((TileEntityMobSpawner)aDelegator.mTileEntity).func_145881_a()) != null) {
            return Long.MAX_VALUE;
        }
        return 0L;
    }

    @Override
    public short[] getSymbolColor() {
        return CS.CA_LIGHT_BLUE_255;
    }

    @Override
    public IIconContainer getSymbolIcon() {
        return BI.CHAR_SCALE;
    }

    @Override
    public IIconContainer getTextureFront() {
        return sTextureFront;
    }

    @Override
    public IIconContainer getTextureBack() {
        return sTextureBack;
    }

    @Override
    public IIconContainer getTextureSide() {
        return sTextureSide;
    }

    @Override
    public IIconContainer getOverlayFront() {
        return sOverlayFront;
    }

    @Override
    public IIconContainer getOverlayBack() {
        return sOverlayBack;
    }

    @Override
    public IIconContainer getOverlaySide() {
        return sOverlaySide;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.redstone.sensors.progressmeter";
    }

    static {
        LH.add("gt.tooltip.sensor.progressmeter", "Measures Progress (also works on Mob Spawners)");
        sTextureFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/progressmeter/colored/front");
        sTextureBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/progressmeter/colored/back");
        sTextureSide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/progressmeter/colored/side");
        sOverlayFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/progressmeter/overlay/front");
        sOverlayBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/progressmeter/overlay/back");
        sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/progressmeter/overlay/side");
    }
}

