/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.sensors;

import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.IIconContainer;
import gregapi.tileentity.data.ITileEntityGibbl;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.MultiTileEntitySensorTE;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityGibblometer
extends MultiTileEntitySensorTE {
    public static IIconContainer sTextureFront;
    public static IIconContainer sTextureBack;
    public static IIconContainer sTextureSide;
    public static IIconContainer sOverlayFront;
    public static IIconContainer sOverlayBack;
    public static IIconContainer sOverlaySide;

    @Override
    public String getSensorDescription() {
        return LH.get("gt.tooltip.sensor.gibblometer");
    }

    @Override
    public long getCurrentValue(DelegatorTileEntity<TileEntity> aDelegator) {
        if (aDelegator.mTileEntity instanceof ITileEntityGibbl) {
            return ((ITileEntityGibbl)aDelegator.mTileEntity).getGibblValue(aDelegator.mSideOfTileEntity) / 1000L;
        }
        return 0L;
    }

    @Override
    public long getCurrentMax(DelegatorTileEntity<TileEntity> aDelegator) {
        if (aDelegator.mTileEntity instanceof ITileEntityGibbl) {
            return ((ITileEntityGibbl)aDelegator.mTileEntity).getGibblMax(aDelegator.mSideOfTileEntity) / 1000L;
        }
        return 0L;
    }

    @Override
    public short[] getSymbolColor() {
        return CS.CA_YELLOW_255;
    }

    @Override
    public IIconContainer getSymbolIcon() {
        return BI.CHAR_GIBBL;
    }

    @Override
    public IIconContainer getTextureFront() {
        return sTextureFront;
    }

    @Override
    public IIconContainer getTextureBack() {
        return sTextureBack;
    }

    @Override
    public IIconContainer getTextureSide() {
        return sTextureSide;
    }

    @Override
    public IIconContainer getOverlayFront() {
        return sOverlayFront;
    }

    @Override
    public IIconContainer getOverlayBack() {
        return sOverlayBack;
    }

    @Override
    public IIconContainer getOverlaySide() {
        return sOverlaySide;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.redstone.sensors.gibblometer";
    }

    static {
        LH.add("gt.tooltip.sensor.gibblometer", "Measures Compression (In Gibbl)");
        sTextureFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/gibblometer/colored/front");
        sTextureBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/gibblometer/colored/back");
        sTextureSide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/gibblometer/colored/side");
        sOverlayFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/gibblometer/overlay/front");
        sOverlayBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/gibblometer/overlay/back");
        sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/gibblometer/overlay/side");
    }
}

