/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.placeables;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlockInternal;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.config.ConfigCategories;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase04MultiTileEntities;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class MultiTileEntityCoin
extends TileEntityBase04MultiTileEntities
implements IMultiTileEntity.IMTE_OnDespawn,
IMultiTileEntity.IMTE_GetLifeSpan,
IMultiTileEntity.IMTE_GetSubItems,
IMultiTileEntity.IMTE_OnRegistration,
IMultiTileEntity.IMTE_OnRegistrationClient,
IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing,
IMultiTileEntity.IMTE_GetExplosionResistance,
IMultiTileEntity.IMTE_GetBlockHardness,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_AddCollisionBoxesToList,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetLightOpacity,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_OnPlaced,
IMultiTileEntity.IMTE_SyncDataByteArray {
    protected boolean mIsUnique = false;
    protected boolean[][][] mShape = new boolean[2][16][16];
    protected final byte[] mCoinStackSizes = new byte[16];
    protected OreDictMaterial mMaterial = MT.NULL;
    private static final byte COIN_STACKSIZE = 16;
    public static Map<OreDictMaterial, ItemStack> COIN_MAP = new HashMap<OreDictMaterial, ItemStack>();
    public static MultiTileEntityRegistry MTE_REGISTRY = null;
    public static MultiTileEntityCoin INSTANCE;
    private boolean mUseWorldRendering = false;
    private boolean mUseNormalRendering = true;
    private int mRenderPassIndex = 0;
    private static final float DIST = 0.015625f;
    private final ITexture[] mTextures = new ITexture[7];
    public static boolean ALLOW_3D_COINS;
    public static boolean ALLOW_3D_COINS_INV;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        int i;
        super.readFromNBT2(aNBT);
        for (i = 0; i < this.mShape[0].length; ++i) {
            this.mShape[0][i] = UT.Code.getBitsS(aNBT.getShort("gt.coin.shape.0." + i));
        }
        for (i = 0; i < this.mShape[1].length; ++i) {
            this.mShape[1][i] = UT.Code.getBitsS(aNBT.getShort("gt.coin.shape.1." + i));
        }
        for (i = 0; i < this.mCoinStackSizes.length; ++i) {
            this.mCoinStackSizes[i] = aNBT.getByte("gt.coin.stacksize." + i);
        }
        this.mIsUnique = aNBT.getBoolean("gt.coin.unique");
        this.mMaterial = OreDictMaterial.get(aNBT.getString("gt.material"));
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        int i;
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.coin.unique", this.mIsUnique);
        aNBT.setString("gt.material", this.mMaterial.toString());
        for (i = 0; i < this.mShape[0].length; ++i) {
            aNBT.setShort("gt.coin.shape.0." + i, (short)UT.Code.getBits(this.mShape[0][i]));
        }
        for (i = 0; i < this.mShape[1].length; ++i) {
            aNBT.setShort("gt.coin.shape.1." + i, (short)UT.Code.getBits(this.mShape[1][i]));
        }
        for (i = 0; i < this.mCoinStackSizes.length; ++i) {
            aNBT.setByte("gt.coin.stacksize." + i, this.mCoinStackSizes[i]);
        }
    }

    @Override
    public NBTTagCompound writeItemNBT(NBTTagCompound aNBT) {
        int i;
        aNBT = super.writeItemNBT(aNBT);
        OreDictMaterialStack.saveList("gt.recycling.mats", aNBT, Arrays.asList(OM.stack(this.mMaterial, 0x44BBB40L)));
        UT.NBT.setBoolean(aNBT, "gt.coin.unique", this.mIsUnique);
        aNBT.setString("gt.material", this.mMaterial.toString());
        for (i = 0; i < this.mShape[0].length; ++i) {
            aNBT.setShort("gt.coin.shape.0." + i, (short)UT.Code.getBits(this.mShape[0][i]));
        }
        for (i = 0; i < this.mShape[1].length; ++i) {
            aNBT.setShort("gt.coin.shape.1." + i, (short)UT.Code.getBits(this.mShape[1][i]));
        }
        return aNBT;
    }

    public ItemStack getCoin(long aAmount, MultiTileEntityRegistry aRegistry, short aID) {
        return aRegistry == null ? null : aRegistry.getItem(aID, aAmount, this.writeItemNBT(UT.NBT.make()));
    }

    @Override
    public ArrayListNoNulls<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        ArrayListNoNulls<ItemStack> rList = ST.arraylist(new ItemStack[0]);
        int tCoinAmount = 0;
        for (int i = 0; i < this.mCoinStackSizes.length; ++i) {
            tCoinAmount = (short)(tCoinAmount + this.mCoinStackSizes[i]);
        }
        while (tCoinAmount > 0) {
            byte tStackAmount = (byte)Math.min(64, tCoinAmount);
            rList.add(this.getCoin(tStackAmount, MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID()), this.getMultiTileEntityID()));
            tCoinAmount = (short)(tCoinAmount - tStackAmount);
        }
        return rList;
    }

    public static ItemStack getCoin(int aAmount, OreDictMaterial aMaterial, boolean aIsUnique, boolean[][][] aShape) {
        MultiTileEntityCoin.INSTANCE.mShape = aShape;
        MultiTileEntityCoin.INSTANCE.mIsUnique = aIsUnique;
        MultiTileEntityCoin.INSTANCE.mMaterial = aMaterial;
        return INSTANCE.getCoin(aAmount, MTE_REGISTRY, INSTANCE.getMultiTileEntityID());
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + this.mMaterial.getLocal() + (this.mIsUnique ? " (Unique)" : ""));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.coins.1"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.coins.2"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.coins.3"));
    }

    @Override
    public void onTick(long aTimer, boolean aIsServerSide) {
    }

    @Override
    public boolean onBlockActivated2(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && CS.SIDES_TOP[aSide]) {
            ItemStack aStack = aPlayer.getCurrentEquippedItem();
            ItemStack tStack = this.getCoin(1L, MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID()), this.getMultiTileEntityID());
            int tIndex = (int)(Math.min(0.99f, Math.max(0.0f, aHitX)) * 4.0f) * 4 + (int)(Math.min(0.99f, Math.max(0.0f, aHitZ)) * 4.0f);
            if (tStack != null) {
                if (aStack == null) {
                    if (this.mCoinStackSizes[tIndex] > 0 && (UT.Entities.hasInfiniteItems(aPlayer) || ST.add((Entity)aPlayer, tStack, false))) {
                        int n = tIndex;
                        this.mCoinStackSizes[n] = (byte)(this.mCoinStackSizes[n] - 1);
                        this.updateClientData();
                        this.playCollect();
                    }
                } else if (this.mCoinStackSizes[tIndex] < 16 && ST.equal(aStack, tStack)) {
                    if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                        --aStack.stackSize;
                    }
                    int n = tIndex;
                    this.mCoinStackSizes[n] = (byte)(this.mCoinStackSizes[n] + 1);
                    this.updateClientData();
                }
            }
            boolean temp = true;
            for (int i = 0; i < this.mCoinStackSizes.length; ++i) {
                if (this.mCoinStackSizes[i] <= 0) continue;
                temp = false;
                break;
            }
            if (temp) {
                this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
            }
        }
        return true;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public int getLifeSpan(World aWorld, ItemStack aStack) {
        return 200;
    }

    @Override
    public int onDespawn(EntityItem aEntity, ItemStack aStack) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null && !aEntity.worldObj.isRemote && aEntity.onGround) {
            int tDifference;
            if (aStack.stackSize > 0) {
                for (byte tSide : CS.ALL_SIDES_MIDDLE_DOWN) {
                    NBTTagCompound tNBT;
                    TileEntity tTileEntity;
                    if (aStack.stackSize <= 0 || !((tTileEntity = WD.te(aEntity.worldObj, UT.Code.roundDown(aEntity.posX) + CS.OFFX[tSide], UT.Code.roundDown(aEntity.posY) + CS.OFFY[tSide], UT.Code.roundDown(aEntity.posZ) + CS.OFFZ[tSide], true)) instanceof MultiTileEntityCoin) || !(tNBT = ((MultiTileEntityCoin)tTileEntity).writeItemNBT(UT.NBT.make())).equals((Object)aNBT)) continue;
                    for (int i = 0; i < this.mCoinStackSizes.length; ++i) {
                        tDifference = Math.min(aStack.stackSize, 16 - ((MultiTileEntityCoin)tTileEntity).mCoinStackSizes[i]);
                        if (tDifference <= 0) continue;
                        aStack.stackSize -= tDifference;
                        int n = i;
                        ((MultiTileEntityCoin)tTileEntity).mCoinStackSizes[n] = (byte)(((MultiTileEntityCoin)tTileEntity).mCoinStackSizes[n] + tDifference);
                    }
                    ((MultiTileEntityCoin)tTileEntity).shuffle();
                }
            }
            if (aStack.stackSize > 0) {
                for (byte tSide : CS.ALL_SIDES_MIDDLE_DOWN) {
                    if (aStack.stackSize <= 0 || !aEntity.worldObj.canPlaceEntityOnSide((Block)MultiTileEntityCoin.MTE_REGISTRY.mBlock, UT.Code.roundDown(aEntity.posX) + CS.OFFX[tSide], UT.Code.roundDown(aEntity.posY) + CS.OFFY[tSide], UT.Code.roundDown(aEntity.posZ) + CS.OFFZ[tSide], false, 1, (Entity)aEntity, aStack)) continue;
                    NBTTagCompound tNBT = (NBTTagCompound)aNBT.copy();
                    int tUsedAmount = 0;
                    for (int i = 0; i < this.mCoinStackSizes.length; ++i) {
                        tDifference = Math.min(aStack.stackSize - tUsedAmount, 16);
                        if (tDifference <= 0) continue;
                        tUsedAmount += tDifference;
                        tNBT.setByte("gt.coin.stacksize." + i, (byte)tDifference);
                    }
                    if (tUsedAmount <= 0 || !MultiTileEntityCoin.MTE_REGISTRY.mBlock.placeBlock(aEntity.worldObj, UT.Code.roundDown(aEntity.posX) + CS.OFFX[tSide], UT.Code.roundDown(aEntity.posY) + CS.OFFY[tSide], UT.Code.roundDown(aEntity.posZ) + CS.OFFZ[tSide], (byte)6, INSTANCE.getMultiTileEntityID(), tNBT, true, false)) continue;
                    aStack.stackSize -= tUsedAmount;
                    TileEntity tTileEntity = WD.te(aEntity.worldObj, UT.Code.roundDown(aEntity.posX) + CS.OFFX[tSide], UT.Code.roundDown(aEntity.posY) + CS.OFFY[tSide], UT.Code.roundDown(aEntity.posZ) + CS.OFFZ[tSide], true);
                    if (!(tTileEntity instanceof MultiTileEntityCoin)) continue;
                    ((MultiTileEntityCoin)tTileEntity).shuffle();
                }
            }
        }
        return 200;
    }

    private void shuffle() {
        int tAmount = 0;
        for (int i = 0; i < this.mCoinStackSizes.length; ++i) {
            tAmount += this.mCoinStackSizes[i];
            this.mCoinStackSizes[i] = 0;
        }
        while (tAmount > 0) {
            int tIndex = this.rng(this.mCoinStackSizes.length);
            if (this.mCoinStackSizes[tIndex] >= 16) continue;
            int n = tIndex;
            this.mCoinStackSizes[n] = (byte)(this.mCoinStackSizes[n] + 1);
            --tAmount;
        }
        this.updateClientData();
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        for (int i = 0; i < this.mCoinStackSizes.length; i = (int)((byte)(i + 1))) {
            if (this.mCoinStackSizes[i] <= 0) continue;
            return true;
        }
        this.mCoinStackSizes[(int)(Math.min((float)0.99f, (float)Math.max((float)0.0f, (float)aHitX)) * 4.0f) * 4 + (int)(Math.min((float)0.99f, (float)Math.max((float)0.0f, (float)aHitZ)) * 4.0f)] = 1;
        return true;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            int i;
            byte[] tPacket = new byte[82];
            for (i = 0; i < 32; ++i) {
                tPacket[i] = UT.Code.toByteS((short)UT.Code.getBits(this.mShape[0][i / 2]), i % 2);
            }
            for (i = 0; i < 32; ++i) {
                tPacket[i + 32] = UT.Code.toByteS((short)UT.Code.getBits(this.mShape[1][i / 2]), i % 2);
            }
            for (i = 0; i < 16; ++i) {
                tPacket[i + 64] = this.mCoinStackSizes[i];
            }
            tPacket[80] = UT.Code.toByteS(this.mMaterial.mID, 0);
            tPacket[81] = UT.Code.toByteS(this.mMaterial.mID, 1);
            return this.getClientDataPacketByteArray(aSendAll, tPacket);
        }
        return super.getClientDataPacket(aSendAll);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        int i;
        for (i = 0; i < 16; ++i) {
            this.mShape[0][i] = UT.Code.getBitsS(UT.Code.combine(aData[i * 2], aData[1 + i * 2]));
        }
        for (i = 0; i < 16; ++i) {
            this.mShape[1][i] = UT.Code.getBitsS(UT.Code.combine(aData[32 + i * 2], aData[33 + i * 2]));
        }
        for (i = 0; i < 16; ++i) {
            this.mCoinStackSizes[i] = aData[i + 64];
        }
        short tMaterial = UT.Code.combine(aData[80], aData[81]);
        if (UT.Code.exists(tMaterial, OreDictMaterial.MATERIAL_ARRAY)) {
            this.mMaterial = OreDictMaterial.MATERIAL_ARRAY[tMaterial];
        }
        return true;
    }

    @Override
    public void onRegistration(MultiTileEntityRegistry aRegistry, short aID) {
        INSTANCE = this;
        MTE_REGISTRY = aRegistry;
        for (OreDictMaterial tMaterial : OreDictMaterial.MATERIAL_ARRAY) {
            if (tMaterial == null || (tMaterial.mHidden || !OP.plateTiny.canGenerateItem(tMaterial)) && tMaterial != MT.Cu && tMaterial != MT.Ag && tMaterial != MT.Au && tMaterial != MT.Pt) continue;
            this.mMaterial = tMaterial;
            this.mIsUnique = true;
            this.mShape = new boolean[][][]{new boolean[][]{{true, true, true, true, true, true, false, false, false, false, true, true, true, true, true, true}, {true, true, true, true, false, false, false, false, false, false, false, false, true, true, true, true}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {true, true, false, false, false, false, false, true, true, false, false, false, false, false, true, true}, {true, false, false, false, false, true, false, true, true, false, true, false, false, false, false, true}, {true, false, false, false, true, true, true, true, true, true, true, true, false, false, false, true}, {false, false, false, false, false, true, true, false, false, true, true, false, false, false, false, false}, {false, false, false, true, true, true, false, false, false, false, true, true, true, false, false, false}, {false, false, false, true, true, true, false, false, false, false, true, true, true, false, false, false}, {false, false, false, false, false, true, true, false, false, true, true, false, false, false, false, false}, {true, false, false, false, true, true, true, true, true, true, true, true, false, false, false, true}, {true, false, false, false, false, true, false, true, true, false, true, false, false, false, false, true}, {true, true, false, false, false, false, false, true, true, false, false, false, false, false, true, true}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {true, true, true, true, false, false, false, false, false, false, false, false, true, true, true, true}, {true, true, true, true, true, true, false, false, false, false, true, true, true, true, true, true}}, new boolean[][]{{true, true, true, true, true, true, false, false, false, false, true, true, true, true, true, true}, {true, true, true, true, false, false, false, false, false, false, false, false, true, true, true, true}, {true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true}, {true, true, false, false, true, true, true, false, false, true, true, true, false, false, true, true}, {true, false, false, true, true, false, true, false, false, true, false, true, true, false, false, true}, {true, false, false, true, false, false, false, false, false, false, false, false, true, false, false, true}, {false, false, true, true, true, false, false, true, true, false, false, true, true, true, false, false}, {false, false, true, false, false, false, true, true, true, true, false, false, false, true, false, false}, {false, false, true, false, false, false, true, true, true, true, false, false, false, true, false, false}, {false, false, true, true, true, false, false, true, true, false, false, true, true, true, false, false}, {true, false, false, true, false, false, false, false, false, false, false, false, true, false, false, true}, {true, false, false, true, true, false, true, false, false, true, false, true, true, false, false, true}, {true, true, false, false, true, true, true, false, false, true, true, true, false, false, true, true}, {true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true}, {true, true, true, true, false, false, false, false, false, false, false, false, true, true, true, true}, {true, true, true, true, true, true, false, false, false, false, true, true, true, true, true, true}}};
            ItemStack tCoin = this.getCoin(1L, aRegistry, aID);
            COIN_MAP.put(tMaterial, tCoin);
        }
    }

    @Override
    public boolean getSubItems(MultiTileEntityBlockInternal aBlock, Item aItem, CreativeTabs aTab, List<ItemStack> aList, short aID) {
        for (ItemStack tStack : COIN_MAP.values()) {
            aList.add(ST.copy(tStack));
        }
        return false;
    }

    @Override
    public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
        int tPassAmount = 0;
        this.mRenderPassIndex = 0;
        this.mUseWorldRendering = false;
        this.mUseNormalRendering = ALLOW_3D_COINS_INV;
        for (int i = 0; i < this.mCoinStackSizes.length; i = (int)((byte)(i + 1))) {
            if (this.mCoinStackSizes[i] <= 0) continue;
            if (!this.mUseWorldRendering) {
                this.mUseNormalRendering = ALLOW_3D_COINS;
                if (this.mUseNormalRendering) {
                    this.mUseNormalRendering = false;
                    boolean[][][] blArray = this.mShape;
                    int n = blArray.length;
                    for (int j = 0; j < n; ++j) {
                        boolean[][] tShape2;
                        boolean[][] blArray2 = tShape2 = blArray[j];
                        int n2 = blArray2.length;
                        for (int k = 0; k < n2; ++k) {
                            boolean[] tShape1;
                            for (boolean tValue : tShape1 = blArray2[k]) {
                                if (!tValue) continue;
                                this.mUseNormalRendering = true;
                                break;
                            }
                            if (this.mUseNormalRendering) break;
                        }
                        if (this.mUseNormalRendering) break;
                    }
                }
            }
            this.mUseWorldRendering = true;
            tPassAmount += this.mUseNormalRendering ? 256 : 1;
        }
        return this.mUseWorldRendering ? tPassAmount : (this.mUseNormalRendering ? 256 : 1);
    }

    @Override
    public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (this.mUseWorldRendering) {
            if (this.mUseNormalRendering) {
                if (aRenderPass % 256 == 0) {
                    while (this.mCoinStackSizes[(aRenderPass + this.mRenderPassIndex) / 256] <= 0) {
                        this.mRenderPassIndex += 256;
                    }
                }
                this.box(aBlock, (float)((aRenderPass += this.mRenderPassIndex) / 1024) / 4.0f + 0.015625f * (float)(aRenderPass % 256 / 16), (this.mShape[0][aRenderPass % 256 / 16][aRenderPass % 16] ? 0.015625f : 0.0f) + (this.mShape[1][aRenderPass % 256 / 16][aRenderPass % 16] ? 0.03125f : 0.0f), (float)(aRenderPass % 1024 / 256) / 4.0f + 0.015625f * (float)(aRenderPass % 16), (float)(aRenderPass / 1024) / 4.0f + 0.015625f + 0.015625f * (float)(aRenderPass % 256 / 16), Math.max(0.0625f, (float)this.mCoinStackSizes[aRenderPass / 256] / 16.0f) - (this.mShape[0][aRenderPass % 256 / 16][aRenderPass % 16] ? 0.015625f : 0.0f) - (this.mShape[1][aRenderPass % 256 / 16][aRenderPass % 16] ? 0.03125f : 0.0f), (float)(aRenderPass % 1024 / 256) / 4.0f + 0.015625f + 0.015625f * (float)(aRenderPass % 16));
                return true;
            }
            while (this.mCoinStackSizes[aRenderPass + this.mRenderPassIndex] <= 0) {
                ++this.mRenderPassIndex;
            }
            this.box(aBlock, (float)((aRenderPass += this.mRenderPassIndex) / 4) / 4.0f, 0.0, (float)(aRenderPass % 4) / 4.0f, (float)(aRenderPass / 4) / 4.0f + 0.25f, (float)this.mCoinStackSizes[aRenderPass] / 16.0f, (float)(aRenderPass % 4) / 4.0f + 0.25f);
            return true;
        }
        if (this.mUseNormalRendering) {
            this.box(aBlock, CS.PX_P[aRenderPass / 16], CS.PX_P[7], CS.PX_P[aRenderPass % 16], CS.PX_P[1 + aRenderPass / 16], CS.PX_P[9] - (this.mShape[0][aRenderPass % 256 / 16][aRenderPass % 16] ? 0.015625f : 0.0f) - (this.mShape[1][aRenderPass % 256 / 16][aRenderPass % 16] ? 0.03125f : 0.0f), CS.PX_P[1 + aRenderPass % 16]);
            return true;
        }
        this.box(aBlock, CS.PX_P[0], CS.PX_P[7], CS.PX_P[0], CS.PX_N[0], CS.PX_P[9], CS.PX_N[0]);
        return true;
    }

    @Override
    public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0) {
            if (!this.mUseNormalRendering && this.mUseWorldRendering) {
                this.mTextures[1] = BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.COIN_TOP, this.mMaterial == null ? CS.UNCOLOURED : this.mMaterial.fRGBaSolid, false, false, true, !this.mUseNormalRendering);
                this.mTextures[0] = BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.COIN_BOTTOM, this.mMaterial == null ? CS.UNCOLOURED : this.mMaterial.fRGBaSolid, false, false, true, !this.mUseNormalRendering);
            } else {
                this.mTextures[0] = this.mTextures[1] = BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.COIN, this.mMaterial == null ? CS.UNCOLOURED : this.mMaterial.fRGBaSolid, false, false, true, !this.mUseNormalRendering);
            }
            this.mTextures[4] = this.mTextures[5] = BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.COIN_SIDE, this.mMaterial == null ? CS.UNCOLOURED : this.mMaterial.fRGBaSolid, false, false, true, !this.mUseNormalRendering);
            this.mTextures[3] = this.mTextures[5];
            this.mTextures[2] = this.mTextures[5];
        }
        if (this.mUseNormalRendering) {
            int aX = aRenderPass % 256 / 16;
            int aZ = aRenderPass % 16;
            int aHeight = 3 - (this.mShape[0][aX][aZ] ? 1 : 0) - (this.mShape[1][aX][aZ] ? 2 : 0);
            if (aHeight <= 0) {
                return null;
            }
            switch (aSide) {
                case 4: {
                    if (aX <= 0 || aHeight > 3 - (this.mShape[0][aX - 1][aZ] ? 1 : 0) - (this.mShape[1][aX - 1][aZ] ? 2 : 0)) break;
                    return null;
                }
                case 5: {
                    if (aX >= 15 || aHeight > 3 - (this.mShape[0][aX + 1][aZ] ? 1 : 0) - (this.mShape[1][aX + 1][aZ] ? 2 : 0)) break;
                    return null;
                }
                case 2: {
                    if (aZ <= 0 || aHeight > 3 - (this.mShape[0][aX][aZ - 1] ? 1 : 0) - (this.mShape[1][aX][aZ - 1] ? 2 : 0)) break;
                    return null;
                }
                case 3: {
                    if (aZ >= 15 || aHeight > 3 - (this.mShape[0][aX][aZ + 1] ? 1 : 0) - (this.mShape[1][aX][aZ + 1] ? 2 : 0)) break;
                    return null;
                }
            }
        }
        return this.mTextures[aSide];
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[2], CS.PX_P[2], CS.PX_P[2], CS.PX_N[2], CS.PX_N[2], CS.PX_N[2]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[14], CS.PX_N[0]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[14], CS.PX_N[0]);
    }

    @Override
    public void addCollisionBoxesToList(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            if (this.mCoinStackSizes[i] <= 0) continue;
            this.box(aAABB, aList, CS.PX_P[i / 4] * 4.0f, 0.0, CS.PX_P[i % 4] * 4.0f, CS.PX_P[i / 4] * 4.0f + CS.PX_P[4], (float)this.mCoinStackSizes[i] / 16.0f, CS.PX_P[i % 4] * 4.0f + CS.PX_P[4]);
        }
    }

    @Override
    public float getBlockHardness() {
        return 1.0f;
    }

    @Override
    public float getExplosionResistance2() {
        return 0.0f;
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegistrationClient(MultiTileEntityRegistry aRegistry, short aID) {
        ALLOW_3D_COINS = CS.ConfigsGT.CLIENT.get((Object)ConfigCategories.general, "use3DCoins", ALLOW_3D_COINS);
        ALLOW_3D_COINS_INV = CS.ConfigsGT.CLIENT.get((Object)ConfigCategories.general, "use3DCoinsInv", ALLOW_3D_COINS_INV);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.coin";
    }

    static {
        LH.add("gt.tooltip.coins.1", "Use the GregTech.cfg inside your Minecraft Root Directory");
        LH.add("gt.tooltip.coins.2", "to disable 3D Rendered Coins in World if they are too much");
        LH.add("gt.tooltip.coins.3", "Render Lag for your System.");
        ALLOW_3D_COINS = true;
        ALLOW_3D_COINS_INV = true;
    }
}

