/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks;

import gregapi.block.ItemBlockBase;
import gregapi.block.ToolCompat;
import gregapi.block.misc.BlockBaseRail;
import gregapi.data.CS;
import gregapi.render.IIconContainer;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRailRoad
extends BlockBaseRail {
    public BlockRailRoad(Class<? extends ItemBlockBase> aItemClass, String aNameInternal, String aLocalName, float aSpeed, float aExplosionResistance, int aHarvestLevel, IIconContainer aIconPrimary, IIconContainer aIconSecondary) {
        super(aItemClass, aNameInternal, aLocalName, true, false, aSpeed, aExplosionResistance, aHarvestLevel, aIconPrimary, aIconSecondary);
    }

    @Override
    protected boolean func_150057_a(World aWorld, int aX, int aY, int aZ, boolean p_150057_5_, int p_150057_6_, int p_150057_7_) {
        if (aWorld.getBlock(aX, aY, aZ) == this) {
            byte tRailMeta = WD.meta(7L, (IBlockAccess)aWorld, aX, aY, aZ);
            if (p_150057_7_ == 1 && (tRailMeta == 0 || tRailMeta == 4 || tRailMeta == 5)) {
                return false;
            }
            if (p_150057_7_ == 0 && (tRailMeta == 1 || tRailMeta == 2 || tRailMeta == 3)) {
                return false;
            }
        }
        return false;
    }

    public void onNeighborBlockChange(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        if (!aWorld.isRemote && !World.doesBlockHaveSolidTopSurface((IBlockAccess)aWorld, (int)aX, (int)(aY - 1), (int)aZ)) {
            this.dropBlockAsItem(aWorld, aX, aY, aZ, 0, 0);
            aWorld.setBlockToAir(aX, aY, aZ);
        }
    }

    @Override
    protected void func_150048_a(World aWorld, int aX, int aY, int aZ, int aMeta, int aData, Block aBlock) {
    }

    protected void func_150052_a(World aWorld, int aX, int aY, int aZ, boolean p_150052_5_) {
    }

    @Override
    public void onBlockAdded(World aWorld, int aX, int aY, int aZ) {
    }

    public void breakBlock(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMeta) {
    }

    @Override
    public long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, World aWorld, byte aSide, int aX, int aY, int aZ, float aHitX, float aHitY, float aHitZ) {
        if (!aWorld.isRemote && (aTool.equals("crowbar") || aTool.equals("chisel") || aTool.equals("shears") || aTool.equals("scissors") || aTool.equals("knife"))) {
            return aWorld.setBlock(aX, aY, aZ, (Block)this, WD.meta((IBlockAccess)aWorld, aX, aY, aZ) ^ 8, 0) ? 1000L : 0L;
        }
        return ToolCompat.onToolClick((Block)this, aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
    }

    @Override
    public void onMinecartPass(World aWorld, EntityMinecart aCart, int aX, int aY, int aZ) {
        double tMotion = Math.sqrt(aCart.motionX * aCart.motionX + aCart.motionZ * aCart.motionZ);
        if (tMotion > 0.01) {
            aCart.motionX *= 2.0;
            aCart.motionZ *= 2.0;
        } else {
            byte tRailMeta = WD.meta(7L, (IBlockAccess)aWorld, aX, aY, aZ);
            if (tRailMeta == 1) {
                if (aWorld.getBlock(aX - 1, aY, aZ).isNormalCube((IBlockAccess)aWorld, aX - 1, aY, aZ)) {
                    aCart.motionX = 0.02;
                } else if (aWorld.getBlock(aX + 1, aY, aZ).isNormalCube((IBlockAccess)aWorld, aX + 1, aY, aZ)) {
                    aCart.motionX = -0.02;
                }
            } else if (tRailMeta == 0) {
                if (aWorld.getBlock(aX, aY, aZ - 1).isNormalCube((IBlockAccess)aWorld, aX, aY, aZ - 1)) {
                    aCart.motionZ = 0.02;
                } else if (aWorld.getBlock(aX, aY, aZ + 1).isNormalCube((IBlockAccess)aWorld, aX, aY, aZ + 1)) {
                    aCart.motionZ = -0.02;
                }
            }
        }
    }

    @Override
    public boolean onItemUse(ItemBlockBase aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        if (aStack.stackSize == 0) {
            return false;
        }
        Block tBlock = aWorld.getBlock(aX, aY, aZ);
        if (tBlock == Blocks.snow_layer && (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 7) < 1) {
            aSide = 1;
        } else if (tBlock != Blocks.vine && tBlock != Blocks.tallgrass && tBlock != Blocks.deadbush && !tBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
            aX += CS.OFFX[aSide];
            aY += CS.OFFY[aSide];
            aZ += CS.OFFZ[aSide];
        }
        if (!aPlayer.canPlayerEdit(aX, aY, aZ, aSide, aStack) || aY == 255 && this.getMaterial().isSolid() || !aWorld.canPlaceEntityOnSide((Block)this, aX, aY, aZ, false, aSide, (Entity)aPlayer, aStack)) {
            return false;
        }
        int n = CS.SIDES_AXIS_X[UT.Code.getHorizontalForPlayerPlacing((Entity)aPlayer)] ? ((double)aHitZ > 0.5 ? 9 : 1) : ((double)aHitX > 0.5 ? 8 : 0);
        if (aItem.placeBlockAt(aStack, aPlayer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ, n)) {
            aWorld.playSoundEffect((double)((float)aX + 0.5f), (double)((float)aY + 0.5f), (double)((float)aZ + 0.5f), this.stepSound.func_150496_b(), (this.stepSound.getVolume() + 1.0f) / 2.0f, this.stepSound.getPitch() * 0.8f);
            --aStack.stackSize;
        }
        return true;
    }

    @Override
    public float getBlockHardness(World aWorld, int aX, int aY, int aZ) {
        return Blocks.rail.getBlockHardness(aWorld, aX, aY, aZ) / 2.0f;
    }
}

