/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.tank;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.RM;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.item.IItemRottable;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.tileentity.ITileEntityConnectedTank;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class TileEntityBase08Barrel
extends TileEntityBase07Paintable
implements IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_GetMaxStackSize,
ITileEntityFunnelAccessible,
ITileEntityTapAccessible,
ITileEntityProgress,
ITileEntityConnectedTank,
IFluidHandler,
IFluidContainerItem,
IItemRottable {
    public FluidTankGT mTank = new FluidTankGT(16000L);
    public byte mMode = 0;
    public long mSealedTime = 0L;
    public long mMaxSealedTime = 0L;
    public long mMeltingPoint = Long.MAX_VALUE;
    public Recipe mRecipe = null;
    public boolean mGasProof = false;
    public boolean mAcidProof = false;
    public boolean mPlasmaProof = false;
    public boolean mMagicProof = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.gasproof")) {
            this.mGasProof = aNBT.getBoolean("gt.gasproof");
        }
        if (aNBT.hasKey("gt.acidproof")) {
            this.mAcidProof = aNBT.getBoolean("gt.acidproof");
        }
        if (aNBT.hasKey("gt.magicproof")) {
            this.mMagicProof = aNBT.getBoolean("gt.magicproof");
        }
        if (aNBT.hasKey("gt.plasmaproof")) {
            this.mPlasmaProof = aNBT.getBoolean("gt.plasmaproof");
        }
        this.mMeltingPoint = aNBT.hasKey("gt.capacity.hu") ? aNBT.getLong("gt.capacity.hu") : (long)((double)this.mMaterial.mMeltingPoint * 1.25);
        this.mMode = aNBT.getByte("gt.mode");
        this.mSealedTime = aNBT.getLong("gt.progress");
        this.mTank.setPreventDraining(this.keepsFilter()).setCapacity(aNBT.getLong("gt.tankcap")).readFromNBT(aNBT, "gt.tank");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mMode != 0) {
            aNBT.setByte("gt.mode", this.mMode);
        }
        UT.NBT.setNumber(aNBT, "gt.progress", this.mSealedTime);
        this.mTank.writeToNBT(aNBT, "gt.tank");
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        if (this.mMode != 0) {
            aNBT.setByte("gt.mode", this.mMode);
        }
        UT.NBT.setNumber(aNBT, "gt.progress", this.mSealedTime);
        this.mTank.writeToNBT(aNBT, "gt.tank");
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + this.mTank.contentcap());
        if (this.mTank.has() && (this.mMode & CS.B[1]) != 0) {
            aList.add(LH.Chat.CYAN + "Sealed (" + this.mSealedTime + ")");
        }
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.funnel.tap.tank"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.no.powerconducting.fluids"));
        if (this.onlySimple()) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.only.simple"));
        }
        if (this.mGasProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.gas"));
        }
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
        if (this.mPlasmaProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.plasma"));
        }
        if (this.mMagicProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.magic"));
        }
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown") + " (" + this.mMeltingPoint + " K)");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.auto.outputs"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("softhammer")) {
            if (this.mTank.amount() <= 0L) {
                this.mTank.setEmpty();
                this.mMaxSealedTime = 0L;
                this.mSealedTime = 0L;
                this.mMode = (byte)(this.mMode & CS.B[1]);
                return 10000L;
            }
            if (this.canBeSealed()) {
                this.mMode = (byte)(this.mMode ^ CS.B[1]);
                aChatReturn.add((this.mMode & CS.B[1]) == 0 ? "Normal" : "Sealed");
                this.mMaxSealedTime = 0L;
                this.mSealedTime = 0L;
            }
            return 10000L;
        }
        if (aTool.equals("plunger")) {
            this.mMaxSealedTime = 0L;
            this.mSealedTime = 0L;
            return CS.GarbageGT.trash(this.mTank, 1000L);
        }
        if (aTool.equals("wrench") || aTool.equals("monkeywrench")) {
            this.mMode = (byte)(this.mMode ^ CS.B[0]);
            aChatReturn.add((this.mMode & CS.B[0]) == 0 ? "Won't fill vertically adjacent Tanks" : "Will fill vertically adjacent Tanks (depending on Gravity and State of Matter)");
            this.updateClientData();
            this.updateInventory();
            return 10000L;
        }
        if (aTool.equals("thermometer")) {
            if (aChatReturn != null) {
                aChatReturn.add("Temperature: " + FL.temperature(this.mTank) + "K");
            }
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add((this.mMode & CS.B[0]) == 0 ? "Won't fill vertically adjacent Tanks" : "Will fill vertically adjacent Tanks (depending on Gravity and State of Matter)");
                aChatReturn.add(this.mTank.contentcap());
                if (!this.mTank.isEmpty() && (this.mMode & CS.B[1]) != 0) {
                    if (this.mMaxSealedTime > 0L) {
                        aChatReturn.add("Sealed (" + this.mSealedTime + " / " + this.mMaxSealedTime + ")");
                    } else {
                        aChatReturn.add("Sealed");
                    }
                }
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        FluidStack tFluid;
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && (tFluid = this.mTank.getFluid()) != null && tFluid.amount > 0) {
            if (FL.temperature(tFluid) >= this.mMeltingPoint && this.meltdown()) {
                return;
            }
            if (!this.mMagicProof && FL.magic(tFluid)) {
                UT.Sounds.send("random.fizz", this, false);
                CS.GarbageGT.trash(this.mTank);
                WD.set(this.worldObj, this.xCoord, this.yCoord, this.zCoord, FL.gas(tFluid) ? IL.TC_Flux_Gas.block() : IL.TC_Flux_Goo.block(), IL.TC_Flux_Goo.exists() ? 7L : 0L, 3L);
                return;
            }
            if (!this.mAcidProof && FL.acid(tFluid)) {
                UT.Sounds.send("random.fizz", this, false);
                CS.GarbageGT.trash(this.mTank);
                this.setToAir();
                return;
            }
            if (!this.mPlasmaProof && FL.plasma(tFluid)) {
                UT.Sounds.send("random.fizz", this, false);
                CS.GarbageGT.trash(this.mTank);
            } else if (!this.mGasProof && FL.gas(tFluid)) {
                UT.Sounds.send("random.fizz", this, false);
                CS.GarbageGT.trash(this.mTank);
            } else if (!this.allowFluid(tFluid)) {
                UT.Sounds.send("random.fizz", this, false);
                CS.GarbageGT.trash(this.mTank);
            } else if ((this.mMode & CS.B[1]) != 0) {
                if (this.mMaxSealedTime <= 0L || this.mRecipe == null) {
                    this.mRecipe = RM.Fermenter.findRecipe((IHasWorldAndCoords)this, this.mRecipe, true, Long.MAX_VALUE, CS.NI, FL.array(this.mTank.getFluid()), ST.tag(0L));
                    if (this.mRecipe != null && this.mRecipe.mFluidInputs.length > 0 && this.mRecipe.mFluidOutputs.length > 0 && !FL.gas(this.mRecipe.mFluidInputs[0]) && !FL.gas(this.mRecipe.mFluidOutputs[0])) {
                        this.mMaxSealedTime = UT.Code.divup(Math.max(1L, this.mRecipe.getAbsoluteTotalPower()) * Math.max(1L, this.mTank.amount()), Math.max(1, this.mRecipe.mFluidInputs[0].amount));
                    } else {
                        this.mMaxSealedTime = 0L;
                        this.mSealedTime = 0L;
                        this.mRecipe = null;
                    }
                } else if (this.mSealedTime < this.mMaxSealedTime) {
                    ++this.mSealedTime;
                } else {
                    this.mTank.setFluid(FL.mul(this.mRecipe.mFluidOutputs[0], this.mTank.amount(), this.mRecipe.mFluidInputs[0].amount, false));
                    this.mMaxSealedTime = 0L;
                    this.mSealedTime = 0L;
                    this.mRecipe = null;
                }
            } else if ((this.mMode & CS.B[0]) != 0) {
                byte[] tSides = CS.ZL_BYTE;
                tSides = FL.gas(tFluid) ? CS.ALL_SIDES_VERTICAL : (FL.lighter(tFluid) ? CS.ALL_SIDES_TOP : CS.ALL_SIDES_BOTTOM);
                for (byte tSide : tSides) {
                    if (!this.mTank.has() || FL.move(this.mTank, this.getAdjacentTank(tSide)) <= 0L) continue;
                    this.updateInventory();
                }
            }
        }
    }

    public boolean meltdown() {
        if (FL.lava(this.mTank) && this.mTank.has(1000L)) {
            this.mTank.remove(1000L);
            CS.GarbageGT.trash(this.mTank);
            this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, (Block)Blocks.flowing_lava, 0, 3);
        } else {
            CS.GarbageGT.trash(this.mTank);
            this.setToFire();
        }
        WD.burn(this.worldObj, this.getCoords(), false, false);
        return true;
    }

    public boolean allowFluid(FluidStack aFluid) {
        return !FL.powerconducting(aFluid) && FL.temperature(aFluid) < this.mMeltingPoint && (!this.onlySimple() || FL.simple(aFluid));
    }

    public FluidStack getFluid(ItemStack aStack) {
        return this.mTank.getFluid();
    }

    public int getCapacity(ItemStack aStack) {
        return this.mTank.getCapacity();
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean aDoFill) {
        if ((this.mMode & CS.B[1]) != 0) {
            return 0;
        }
        if (!this.allowFluid(aFluid)) {
            return 0;
        }
        if (!this.mGasProof && FL.gas(aFluid)) {
            return 0;
        }
        if (!this.mAcidProof && FL.acid(aFluid)) {
            return 0;
        }
        if (!this.mMagicProof && FL.magic(aFluid)) {
            return 0;
        }
        if (!this.mPlasmaProof && FL.plasma(aFluid)) {
            return 0;
        }
        int tFilled = this.mTank.fill(aFluid, aDoFill);
        if (tFilled > 0 && aDoFill) {
            UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
        }
        return tFilled;
    }

    public FluidStack drain(ItemStack aStack, int aMaxDrain, boolean aDoDrain) {
        if ((this.mMode & CS.B[1]) != 0) {
            return null;
        }
        FluidStack tDrained = this.mTank.drain(aMaxDrain, aDoDrain);
        if (tDrained != CS.NF && aDoDrain) {
            UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
        }
        return tDrained;
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        return (this.mMode & CS.B[1]) != 0 ? 0 : this.mTank.fill(aFluid, aDoFill);
    }

    @Override
    public FluidStack tapDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        return (this.mMode & CS.B[1]) != 0 ? null : this.mTank.drain(aMaxDrain, aDoDrain);
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.mSealedTime;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return this.mMaxSealedTime;
    }

    @Override
    public boolean canDrop(int aSlot) {
        return false;
    }

    public boolean onlySimple() {
        return false;
    }

    public boolean canBeSealed() {
        return true;
    }

    public boolean keepsFilter() {
        return false;
    }

    public int getLogisticsPriorityFluid() {
        return this.mTank.isEmpty() ? 1 : 2;
    }

    public int getLogisticsPriorityItem() {
        return 0;
    }

    public Fluid getLogisticsFilterFluid() {
        return this.mTank.fluid();
    }

    public ItemStack getLogisticsFilterItem() {
        return null;
    }

    @Override
    public byte getMaxStackSize(ItemStack aStack, byte aDefault) {
        return this.mTank.has() ? (byte)1 : aDefault;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return (this.mMode & CS.B[1]) != 0 ? null : this.mTank;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return (this.mMode & CS.B[1]) != 0 ? null : this.mTank;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTank.AS_ARRAY;
    }

    @Override
    public ItemStack getRotten(ItemStack aStack) {
        return this.mMaterial.contains(TD.Properties.BETWEENLANDS) ? aStack : IItemRottable.RottingUtil.rotting(aStack, (IFluidContainerItem)aStack.getItem());
    }

    @Override
    public ItemStack getRotten(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        return this.mMaterial.contains(TD.Properties.BETWEENLANDS) ? aStack : IItemRottable.RottingUtil.rotting(aStack, (IFluidContainerItem)aStack.getItem());
    }

    @Override
    public int addFluidToConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyAddIfItAlreadyHasFluidsOfThatTypeOrIsDedicated) {
        if ((this.mMode & CS.B[1]) != 0) {
            return 0;
        }
        if (aFluid == CS.NF || this.mTank.isEmpty() && aOnlyAddIfItAlreadyHasFluidsOfThatTypeOrIsDedicated) {
            return 0;
        }
        return this.mTank.fill(aFluid, true);
    }

    @Override
    public int removeFluidFromConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyRemoveIfItCanRemoveAllAtOnce) {
        if ((this.mMode & CS.B[1]) == 0 && this.mTank.contains(aFluid) && this.mTank.has(aOnlyRemoveIfItCanRemoveAllAtOnce ? (long)aFluid.amount : 1L)) {
            return (int)this.mTank.remove(aFluid.amount);
        }
        return 0;
    }

    @Override
    public long getAmountOfFluidInConnectedTank(byte aSide, FluidStack aFluid) {
        return (this.mMode & CS.B[1]) == 0 && this.mTank.contains(aFluid) ? this.mTank.amount() : 0L;
    }
}

