/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.inventories;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlockInternal;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.gui.ContainerClientDefault;
import gregapi.gui.ContainerCommonDefault;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.UT;
import java.util.List;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public abstract class MultiTileEntitySafe
extends TileEntityBase09FacingSingle
implements IMultiTileEntity.IMTE_GetPlayerRelativeBlockHardness {
    public String mDungeonLootName = "";

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.dungeonloot")) {
            this.mDungeonLootName = aNBT.getString("gt.dungeonloot");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (UT.Code.stringValid(this.mDungeonLootName)) {
            aNBT.setString("gt.dungeonloot", this.mDungeonLootName);
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (UT.Code.stringValid(this.mDungeonLootName)) {
            aList.add(LH.Chat.BLINKING_CYAN + "Contains Loot of " + LH.Chat.WHITE + LH.get("loot." + this.mDungeonLootName));
        }
        super.addToolTips(aList, aStack, aF3_H);
    }

    protected void generateDungeonLoot() {
        if (this.isServerSide() && UT.Code.stringValid(this.mDungeonLootName)) {
            int j = this.getSizeInventory();
            for (int i = 0; i < j; ++i) {
                if (this.slotHas(i)) continue;
                this.slot(i, ChestGenHooks.getOneItem((String)this.mDungeonLootName, (Random)CS.RNGSUS));
            }
            this.mDungeonLootName = "";
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aSide != this.mFacing) {
            return false;
        }
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.generateDungeonLoot();
            this.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public boolean breakBlock() {
        this.generateDungeonLoot();
        return super.breakBlock();
    }

    @Override
    public boolean getSubItems(MultiTileEntityBlockInternal aBlock, Item aItem, CreativeTabs aTab, List<ItemStack> aList, short aID) {
        if (this.showInCreative()) {
            if (CS.D1) {
                for (String tLoot : new String[]{"mineshaftCorridor", "pyramidDesertyChest", "pyramidJungleChest", "pyramidJungleDispenser", "strongholdCorridor", "strongholdLibrary", "strongholdCrossing", "villageBlacksmith", "bonusChest", "dungeonChest"}) {
                    aList.add(aBlock.mMultiTileEntityRegistry.getItem((int)aID, UT.NBT.makeString("gt.dungeonloot", tLoot)));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        super.onPlaced(aStack, aPlayer, aMTEContainer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ);
        aWorld.playSoundEffect((double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, Blocks.anvil.stepSound.func_150496_b(), (Blocks.anvil.stepSound.getVolume() + 1.0f) / 2.0f, Blocks.anvil.stepSound.getPitch() * 0.8f);
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return aSide != this.mFacing;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return CS.ZL_INTEGER;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public void onExploded(Explosion aExplosion) {
        this.setToAir();
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientDefault(aPlayer.inventory, (ITileEntityInventoryGUI)this, aGUIID);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonDefault(aPlayer.inventory, this, aGUIID);
    }
}

