/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.energy;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.gui.ContainerClientDefault;
import gregapi.gui.ContainerCommonDefault;
import gregapi.item.IItemEnergy;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityBase10EnergyBatBox
extends TileEntityBase09FacingSingle
implements ITileEntityEnergy,
ITileEntityEnergyDataCapacitor,
ITileEntityRunningActively,
ITileEntitySwitchableOnOff,
ITileEntitySwitchableMode,
ITileEntityProgress {
    public boolean mEmitsEnergy = false;
    public boolean mStopped = false;
    public boolean mActive = false;
    public long mEnergy = 0L;
    public long mInput = 32L;
    public long mOutput = 32L;
    public long mBatteryCount = -1L;
    public long mChargeableCount = -1L;
    public long mReceivablePower = 0L;
    public byte mActiveState = 0;
    public byte mMode = 0;
    public TagData mEnergyType = TD.Energy.QU;
    public TagData mEnergyTypeOut = TD.Energy.QU;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.getLong("gt.energy");
        if (aNBT.hasKey("gt.mode")) {
            this.mMode = aNBT.getByte("gt.mode");
        }
        if (aNBT.hasKey("gt.active.energy")) {
            this.mEmitsEnergy = aNBT.getBoolean("gt.active.energy");
        }
        if (aNBT.hasKey("gt.stopped")) {
            this.mStopped = aNBT.getBoolean("gt.stopped");
        }
        if (aNBT.hasKey("gt.active")) {
            this.mActive = aNBT.getBoolean("gt.active");
        }
        if (aNBT.hasKey("gt.input")) {
            this.mInput = aNBT.getLong("gt.input");
        }
        if (aNBT.hasKey("gt.output")) {
            this.mOutput = aNBT.getLong("gt.output");
        }
        if (aNBT.hasKey("gt.energy.emitted")) {
            this.mEnergyType = this.mEnergyTypeOut = TagData.createTagData(aNBT.getString("gt.energy.emitted"));
        }
        if (aNBT.hasKey("gt.energy.accepted")) {
            this.mEnergyType = TagData.createTagData(aNBT.getString("gt.energy.accepted"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mMode != 0) {
            aNBT.setByte("gt.mode", this.mMode);
        }
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
        UT.NBT.setBoolean(aNBT, "gt.active.energy", this.mEmitsEnergy);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        this.addToolTipsEnergy(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.energybattery.1"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.energybattery.2"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.energybattery.3"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    public void addToolTipsEnergy(List<String> aList, ItemStack aStack, boolean aF3_H) {
        LH.addEnergyToolTips(this, aList, this.mEnergyType, this.mEnergyTypeOut, this.getLocalisedInputSide(), this.getLocalisedOutputSide());
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        block32: {
            block33: {
                block34: {
                    if (!aIsServerSide) break block32;
                    if (CS.SERVER_TIME % 20L != 1L) break block33;
                    if (CS.COMPAT_EU_ITEM != null && this.mEnergyType == TD.Energy.EU) break block34;
                    switch (UT.Code.bind3(this.mEnergy / (this.mInput * 40L * (long)this.invsize()))) {
                        case 0: {
                            for (ItemStack tStack : this.getInventory()) {
                                if (!ST.valid(tStack) || !(tStack.getItem() instanceof IItemEnergy)) continue;
                                this.mEnergy += this.mOutput * ((IItemEnergy)tStack.getItem()).doEnergyExtraction(this.mEnergyType, tStack, this.mOutput, 40L, this, this.worldObj, this.xCoord, this.yCoord, this.zCoord, true);
                            }
                            break block33;
                        }
                        case 1: {
                            for (ItemStack tStack : this.getInventory()) {
                                if (!ST.valid(tStack) || !(tStack.getItem() instanceof IItemEnergy)) continue;
                                this.mEnergy += this.mOutput * ((IItemEnergy)tStack.getItem()).doEnergyExtraction(this.mEnergyType, tStack, this.mOutput, 20L, this, this.worldObj, this.xCoord, this.yCoord, this.zCoord, true);
                            }
                            break block33;
                        }
                        case 6: {
                            for (ItemStack tStack : this.getInventory()) {
                                if (!ST.valid(tStack) || !(tStack.getItem() instanceof IItemEnergy)) continue;
                                this.mEnergy -= this.mInput * ((IItemEnergy)tStack.getItem()).doEnergyInjection(this.mEnergyType, tStack, this.mInput, 20L, this, this.worldObj, this.xCoord, this.yCoord, this.zCoord, true);
                            }
                            break block33;
                        }
                        case 7: {
                            for (ItemStack tStack : this.getInventory()) {
                                if (!ST.valid(tStack) || !(tStack.getItem() instanceof IItemEnergy)) continue;
                                this.mEnergy -= this.mInput * ((IItemEnergy)tStack.getItem()).doEnergyInjection(this.mEnergyType, tStack, this.mInput, 40L, this, this.worldObj, this.xCoord, this.yCoord, this.zCoord, true);
                            }
                            break;
                        }
                    }
                    break block33;
                }
                switch (UT.Code.bind3(this.mEnergy / (this.mInput * 40L * (long)this.invsize()))) {
                    case 0: {
                        for (ItemStack tStack : this.getInventory()) {
                            if (!ST.valid(tStack)) continue;
                            if (tStack.getItem() instanceof IItemEnergy) {
                                this.mEnergy += this.mOutput * ((IItemEnergy)tStack.getItem()).doEnergyExtraction(this.mEnergyType, tStack, this.mOutput, 40L, this, this.worldObj, this.xCoord, this.yCoord, this.zCoord, true);
                                continue;
                            }
                            if (!CS.COMPAT_EU_ITEM.is(tStack) || !CS.COMPAT_EU_ITEM.provider(tStack) || IL.IC2_EnergyCrystal.equal(tStack, true, true) || IL.IC2_LapotronCrystal.equal(tStack, true, true) || !CS.COMPAT_EU_ITEM.insidevolt(tStack, this.mOutput / 2L, this.mOutput * 2L)) continue;
                            this.mEnergy += CS.COMPAT_EU_ITEM.decharge(tStack, this.mOutput * 40L, true);
                        }
                        break;
                    }
                    case 1: {
                        for (ItemStack tStack : this.getInventory()) {
                            if (!ST.valid(tStack)) continue;
                            if (tStack.getItem() instanceof IItemEnergy) {
                                this.mEnergy += this.mOutput * ((IItemEnergy)tStack.getItem()).doEnergyExtraction(this.mEnergyType, tStack, this.mOutput, 20L, this, this.worldObj, this.xCoord, this.yCoord, this.zCoord, true);
                                continue;
                            }
                            if (!CS.COMPAT_EU_ITEM.is(tStack) || !CS.COMPAT_EU_ITEM.provider(tStack) || IL.IC2_EnergyCrystal.equal(tStack, true, true) || IL.IC2_LapotronCrystal.equal(tStack, true, true) || !CS.COMPAT_EU_ITEM.insidevolt(tStack, this.mOutput / 2L, this.mOutput * 2L)) continue;
                            this.mEnergy += CS.COMPAT_EU_ITEM.decharge(tStack, this.mOutput * 20L, true);
                        }
                        break;
                    }
                    case 6: {
                        for (ItemStack tStack : this.getInventory()) {
                            if (!ST.valid(tStack)) continue;
                            if (tStack.getItem() instanceof IItemEnergy) {
                                this.mEnergy -= this.mInput * ((IItemEnergy)tStack.getItem()).doEnergyInjection(this.mEnergyType, tStack, this.mInput, 20L, this, this.worldObj, this.xCoord, this.yCoord, this.zCoord, true);
                                continue;
                            }
                            if (!CS.COMPAT_EU_ITEM.is(tStack) || IL.IC2_EnergyCrystal.equal(tStack, true, true) || IL.IC2_LapotronCrystal.equal(tStack, true, true) || !CS.COMPAT_EU_ITEM.insidevolt(tStack, this.mInput / 2L, this.mInput * 2L)) continue;
                            this.mEnergy -= CS.COMPAT_EU_ITEM.charge(tStack, this.mInput * 20L, true);
                        }
                        break;
                    }
                    case 7: {
                        for (ItemStack tStack : this.getInventory()) {
                            if (!ST.valid(tStack)) continue;
                            if (tStack.getItem() instanceof IItemEnergy) {
                                this.mEnergy -= this.mInput * ((IItemEnergy)tStack.getItem()).doEnergyInjection(this.mEnergyType, tStack, this.mInput, 40L, this, this.worldObj, this.xCoord, this.yCoord, this.zCoord, true);
                                continue;
                            }
                            if (!CS.COMPAT_EU_ITEM.is(tStack) || IL.IC2_EnergyCrystal.equal(tStack, true, true) || IL.IC2_LapotronCrystal.equal(tStack, true, true) || !CS.COMPAT_EU_ITEM.insidevolt(tStack, this.mInput / 2L, this.mInput * 2L)) continue;
                            this.mEnergy -= CS.COMPAT_EU_ITEM.charge(tStack, this.mInput * 40L, true);
                        }
                        break;
                    }
                }
            }
            boolean bl = this.mActive = this.mEnergy >= this.mOutput;
            if (this.mBatteryCount < 0L || this.mChargeableCount < 0L || this.mInventoryChanged) {
                this.mChargeableCount = 0L;
                this.mBatteryCount = 0L;
                for (ItemStack tStack : this.getInventory()) {
                    if (!ST.valid(tStack)) continue;
                    if (tStack.getItem() instanceof IItemEnergy) {
                        if (((IItemEnergy)tStack.getItem()).canEnergyInjection(this.mEnergyType, tStack, this.mInput)) {
                            ++this.mChargeableCount;
                        }
                        if (!((IItemEnergy)tStack.getItem()).canEnergyExtraction(this.mEnergyType, tStack, this.mOutput)) continue;
                        ++this.mBatteryCount;
                        continue;
                    }
                    if (CS.COMPAT_EU_ITEM == null || this.mEnergyType != TD.Energy.EU || !CS.COMPAT_EU_ITEM.is(tStack) || IL.IC2_EnergyCrystal.equal(tStack, true, true) || IL.IC2_LapotronCrystal.equal(tStack, true, true)) continue;
                    ++this.mChargeableCount;
                    if (!CS.COMPAT_EU_ITEM.provider(tStack)) continue;
                    ++this.mBatteryCount;
                }
            }
            if (this.mActive) {
                if (!this.mStopped) {
                    long tOutput;
                    long l = tOutput = this.mMode == 0 ? this.mBatteryCount : Math.min((long)this.mMode, this.mBatteryCount);
                    if (tOutput > 0L) {
                        long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeOut, this.mOutput, tOutput, this);
                        this.mEmitsEnergy = tEmittedPackets > 0L;
                        this.mEnergy -= this.mOutput * tEmittedPackets;
                    }
                }
                if (this.mTimer % 600L == 5L) {
                    this.doDefaultStructuralChecks();
                }
            }
            this.mReceivablePower = this.mChargeableCount * this.mInput * 2L;
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        if (aTimer % 20L != 0L) {
            return super.onTickCheck(aTimer);
        }
        byte tActiveState = this.mActiveState;
        this.mActiveState = this.mEnergy < this.mOutput ? (byte)0 : (this.mEnergy >= this.mInput * 300L * (long)this.invsize() ? (byte)1 : (byte)2);
        if (!this.invempty()) {
            this.mActiveState = (byte)(this.mActiveState | 4);
        }
        return tActiveState != this.mActiveState || super.onTickCheck(aTimer);
    }

    @Override
    public void setVisualData(byte aData) {
        this.mActiveState = aData;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        long tConsumed;
        if (this.mReceivablePower <= 0L) {
            return 0L;
        }
        if ((aSize = Math.abs(aSize)) > this.getEnergySizeInputMax(aEnergyType, aSide)) {
            if (aDoInject) {
                this.overcharge(aSize, aEnergyType);
            }
            return aAmount;
        }
        if (this.mEnergy >= this.mInput * 320L * (long)this.invsize()) {
            return 0L;
        }
        long tInput = Math.min(this.mInput * 320L * (long)this.invsize() - this.mEnergy, aSize * aAmount);
        for (tConsumed = Math.min(aAmount, tInput / aSize + (long)(tInput % aSize != 0L ? 1 : 0)); tConsumed > 1L && (tConsumed - 1L) * aSize > this.mReceivablePower; --tConsumed) {
        }
        if (aDoInject) {
            this.mReceivablePower -= tConsumed * aSize;
            this.mEnergy += tConsumed * aSize;
        }
        return tConsumed;
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientDefault(aPlayer.inventory, (ITileEntityInventoryGUI)this, aGUIID);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonDefault(aPlayer.inventory, this, aGUIID);
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return UT.Code.getAscendingArray(this.invsize());
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aStack != null && aStack.getItem() instanceof IItemEnergy && (((IItemEnergy)aStack.getItem()).isEnergyType(this.mEnergyType, aStack, false) || ((IItemEnergy)aStack.getItem()).isEnergyType(this.mEnergyType, aStack, true));
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEnergyType == (aEmitting ? this.mEnergyTypeOut : this.mEnergyType);
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyType;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return (CS.SIDES_INVALID[aSide] || this.isInput(aSide)) && super.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return !(!aTheoretical && this.mStopped || !CS.SIDES_INVALID[aSide] && !this.isOutput(aSide) || !super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical));
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mInput;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        long rAmount = 0L;
        for (ItemStack tStack : this.getInventory()) {
            if (tStack == null || !(tStack.getItem() instanceof IItemEnergy)) continue;
            rAmount += ((IItemEnergy)tStack.getItem()).getEnergyStored(aEnergyType, tStack);
        }
        return rAmount;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        long rAmount = 0L;
        for (ItemStack tStack : this.getInventory()) {
            if (tStack == null || !(tStack.getItem() instanceof IItemEnergy)) continue;
            rAmount += ((IItemEnergy)tStack.getItem()).getEnergyCapacity(aEnergyType, tStack);
        }
        return rAmount;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return new ArrayListNoNulls<TagData>(false, this.mEnergyType, this.mEnergyTypeOut);
    }

    @Override
    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        return this.mEnergyType.AS_LIST;
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.mEnergy;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return this.mInput * 320L * (long)this.invsize();
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public int getMinimumInventorySize() {
        return 1;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mEnergy > this.mOutput;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActive;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mEmitsEnergy;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public byte setStateMode(byte aMode) {
        this.mMode = aMode;
        return this.mMode;
    }

    @Override
    public byte getStateMode() {
        return this.mMode;
    }

    @Override
    public byte getVisualData() {
        return this.mActiveState;
    }

    public boolean isInput(byte aSide) {
        return aSide != this.mFacing;
    }

    public boolean isOutput(byte aSide) {
        return aSide == this.mFacing;
    }

    public String getLocalisedInputSide() {
        return LH.get("gt.lang.face.any.but.front");
    }

    public String getLocalisedOutputSide() {
        return LH.get("gt.lang.face.front");
    }

    static {
        LH.add("gt.tooltip.energybattery.1", "Selector Covers can set the amount of emitted Packets");
        LH.add("gt.tooltip.energybattery.2", "Mode 0 = Emit as much as possible, this is Default");
        LH.add("gt.tooltip.energybattery.3", "Mode 1 - 15 = Emit up to 1 - 15 Packets if enough Energy Storages");
    }
}

