/*
 * Decompiled with CFR 0.152.
 */
package gregapi.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import gregapi.data.CS;
import gregapi.render.IRenderedBlock;
import gregapi.render.IRenderedBlockObject;
import gregapi.render.IRenderedBlockObjectSideCheck;
import gregapi.render.ITexture;
import gregapi.util.ST;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RendererBlockTextured
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public final int mRenderID;
    public static RendererBlockTextured INSTANCE;
    public static NBTTagCompound mUsedNBT;

    public RendererBlockTextured(int aRenderID) {
        INSTANCE = this;
        this.mRenderID = aRenderID;
    }

    public void renderInventoryBlock(Block aBlock, int aMetaData, int aModelID, RenderBlocks aRenderer) {
        aRenderer.setRenderBoundsFromBlock(aBlock);
        ItemStack aStack = ST.make(aBlock, 1L, (long)aMetaData, mUsedNBT);
        ITexture.Util.startRendering(aRenderer, aBlock, null, 0, 0, 0);
        if (aBlock instanceof IRenderedBlock) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            boolean tNeedsToSetBounds = true;
            IRenderedBlockObject tRenderer = ((IRenderedBlock)aBlock).passRenderingToObject(aStack);
            if (tRenderer != null) {
                tRenderer = tRenderer.passRenderingToObject(aStack);
            }
            if (tRenderer == null) {
                int j = ((IRenderedBlock)aBlock).getRenderPasses(aStack);
                for (int i = 0; i < j; ++i) {
                    if (!((IRenderedBlock)aBlock).usesRenderPass(i, aStack)) continue;
                    Tessellator.instance.startDrawingQuads();
                    if (((IRenderedBlock)aBlock).setBlockBounds(i, aStack)) {
                        tNeedsToSetBounds = true;
                        aRenderer.setRenderBoundsFromBlock(aBlock);
                    } else {
                        if (tNeedsToSetBounds) {
                            aBlock.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        }
                        aRenderer.setRenderBoundsFromBlock(aBlock);
                        tNeedsToSetBounds = false;
                    }
                    Tessellator.instance.setNormal(0.0f, -1.0f, 0.0f);
                    RendererBlockTextured.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, ((IRenderedBlock)aBlock).getTexture(i, (byte)0, aStack), !tNeedsToSetBounds, true, aBlock);
                    Tessellator.instance.setNormal(0.0f, 1.0f, 0.0f);
                    RendererBlockTextured.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, ((IRenderedBlock)aBlock).getTexture(i, (byte)1, aStack), !tNeedsToSetBounds, true, aBlock);
                    Tessellator.instance.setNormal(0.0f, 0.0f, -1.0f);
                    RendererBlockTextured.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, ((IRenderedBlock)aBlock).getTexture(i, (byte)2, aStack), !tNeedsToSetBounds, true, aBlock);
                    Tessellator.instance.setNormal(0.0f, 0.0f, 1.0f);
                    RendererBlockTextured.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, ((IRenderedBlock)aBlock).getTexture(i, (byte)3, aStack), !tNeedsToSetBounds, true, aBlock);
                    Tessellator.instance.setNormal(-1.0f, 0.0f, 0.0f);
                    RendererBlockTextured.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, ((IRenderedBlock)aBlock).getTexture(i, (byte)4, aStack), !tNeedsToSetBounds, true, aBlock);
                    Tessellator.instance.setNormal(1.0f, 0.0f, 0.0f);
                    RendererBlockTextured.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, ((IRenderedBlock)aBlock).getTexture(i, (byte)5, aStack), !tNeedsToSetBounds, true, aBlock);
                    Tessellator.instance.draw();
                }
            } else if (!tRenderer.renderItem(aBlock, aRenderer)) {
                int j = tRenderer.getRenderPasses(aBlock, CS.SIDES_ITEM_RENDER);
                for (int i = 0; i < j; ++i) {
                    if (!tRenderer.usesRenderPass(i, CS.SIDES_ITEM_RENDER)) continue;
                    Tessellator.instance.startDrawingQuads();
                    if (tRenderer.setBlockBounds(aBlock, i, CS.SIDES_ITEM_RENDER)) {
                        tNeedsToSetBounds = true;
                        aRenderer.setRenderBoundsFromBlock(aBlock);
                    } else {
                        if (tNeedsToSetBounds) {
                            aBlock.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        }
                        aRenderer.setRenderBoundsFromBlock(aBlock);
                        tNeedsToSetBounds = false;
                    }
                    Tessellator.instance.setNormal(0.0f, -1.0f, 0.0f);
                    RendererBlockTextured.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, tRenderer.getTexture(aBlock, i, (byte)0, CS.SIDES_ITEM_RENDER), !tNeedsToSetBounds, true, tRenderer);
                    Tessellator.instance.setNormal(0.0f, 1.0f, 0.0f);
                    RendererBlockTextured.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, tRenderer.getTexture(aBlock, i, (byte)1, CS.SIDES_ITEM_RENDER), !tNeedsToSetBounds, true, tRenderer);
                    Tessellator.instance.setNormal(0.0f, 0.0f, -1.0f);
                    RendererBlockTextured.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, tRenderer.getTexture(aBlock, i, (byte)2, CS.SIDES_ITEM_RENDER), !tNeedsToSetBounds, true, tRenderer);
                    Tessellator.instance.setNormal(0.0f, 0.0f, 1.0f);
                    RendererBlockTextured.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, tRenderer.getTexture(aBlock, i, (byte)3, CS.SIDES_ITEM_RENDER), !tNeedsToSetBounds, true, tRenderer);
                    Tessellator.instance.setNormal(-1.0f, 0.0f, 0.0f);
                    RendererBlockTextured.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, tRenderer.getTexture(aBlock, i, (byte)4, CS.SIDES_ITEM_RENDER), !tNeedsToSetBounds, true, tRenderer);
                    Tessellator.instance.setNormal(1.0f, 0.0f, 0.0f);
                    RendererBlockTextured.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, tRenderer.getTexture(aBlock, i, (byte)5, CS.SIDES_ITEM_RENDER), !tNeedsToSetBounds, true, tRenderer);
                    Tessellator.instance.draw();
                }
            }
            if (tNeedsToSetBounds) {
                aBlock.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        aRenderer.setRenderBoundsFromBlock(aBlock);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        ITexture.Util.endRendering(aRenderer, aBlock, null, 0, 0, 0);
    }

    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        Tessellator.instance.setBrightness(983055);
        boolean rReturn = false;
        aRenderer.setRenderBoundsFromBlock(aBlock);
        ITexture.Util.startRendering(aRenderer, aBlock, aWorld, aX, aY, aZ);
        if (aBlock instanceof IRenderedBlock) {
            IRenderedBlockObject tRenderer = ((IRenderedBlock)aBlock).passRenderingToObject(aWorld, aX, aY, aZ);
            if (tRenderer != null) {
                tRenderer = tRenderer.passRenderingToObject(aWorld, aX, aY, aZ);
            }
            if (tRenderer == null) {
                boolean tNeedsToSetBounds = true;
                boolean[] tSides = new boolean[6];
                if (aBlock instanceof IRenderedBlockObjectSideCheck) {
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        tSides[tSide] = ((IRenderedBlockObjectSideCheck)aBlock).renderFullBlockSide(aBlock, aRenderer, tSide);
                    }
                } else {
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        tSides[tSide] = aBlock.shouldSideBeRendered(aWorld, aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide], (int)tSide);
                    }
                }
                int j = ((IRenderedBlock)aBlock).getRenderPasses(aWorld, aX, aY, aZ, tSides);
                for (int i = 0; i < j; ++i) {
                    if (!((IRenderedBlock)aBlock).usesRenderPass(i, aWorld, aX, aY, aZ, tSides)) continue;
                    if (((IRenderedBlock)aBlock).setBlockBounds(i, aWorld, aX, aY, aZ, tSides)) {
                        tNeedsToSetBounds = true;
                        aRenderer.setRenderBoundsFromBlock(aBlock);
                    } else {
                        if (tNeedsToSetBounds) {
                            aBlock.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        }
                        aRenderer.setRenderBoundsFromBlock(aBlock);
                        tNeedsToSetBounds = false;
                    }
                    if (RendererBlockTextured.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, ((IRenderedBlock)aBlock).getTexture(i, (byte)0, tSides, aWorld, aX, aY, aZ), !tNeedsToSetBounds, tSides[0], aBlock)) {
                        rReturn = true;
                    }
                    if (RendererBlockTextured.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, ((IRenderedBlock)aBlock).getTexture(i, (byte)1, tSides, aWorld, aX, aY, aZ), !tNeedsToSetBounds, tSides[1], aBlock)) {
                        rReturn = true;
                    }
                    if (RendererBlockTextured.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, ((IRenderedBlock)aBlock).getTexture(i, (byte)2, tSides, aWorld, aX, aY, aZ), !tNeedsToSetBounds, tSides[2], aBlock)) {
                        rReturn = true;
                    }
                    if (RendererBlockTextured.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, ((IRenderedBlock)aBlock).getTexture(i, (byte)3, tSides, aWorld, aX, aY, aZ), !tNeedsToSetBounds, tSides[3], aBlock)) {
                        rReturn = true;
                    }
                    if (RendererBlockTextured.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, ((IRenderedBlock)aBlock).getTexture(i, (byte)4, tSides, aWorld, aX, aY, aZ), !tNeedsToSetBounds, tSides[4], aBlock)) {
                        rReturn = true;
                    }
                    if (!RendererBlockTextured.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, ((IRenderedBlock)aBlock).getTexture(i, (byte)5, tSides, aWorld, aX, aY, aZ), !tNeedsToSetBounds, tSides[5], aBlock)) continue;
                    rReturn = true;
                }
                if (tNeedsToSetBounds) {
                    aBlock.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            } else {
                boolean tNeedsToSetBounds = true;
                if (tRenderer.renderBlock(aBlock, aRenderer, aWorld, aX, aY, aZ)) {
                    rReturn = true;
                } else {
                    boolean[] tSides = new boolean[6];
                    if (tRenderer instanceof IRenderedBlockObjectSideCheck) {
                        for (byte tSide : CS.ALL_SIDES_VALID) {
                            tSides[tSide] = ((IRenderedBlockObjectSideCheck)((Object)tRenderer)).renderFullBlockSide(aBlock, aRenderer, tSide);
                        }
                    } else {
                        for (byte tSide : CS.ALL_SIDES_VALID) {
                            tSides[tSide] = aBlock.shouldSideBeRendered(aWorld, aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide], (int)tSide);
                        }
                    }
                    int j = tRenderer.getRenderPasses(aBlock, tSides);
                    for (int i = 0; i < j; ++i) {
                        if (!tRenderer.usesRenderPass(i, tSides)) continue;
                        if (tRenderer.setBlockBounds(aBlock, i, tSides)) {
                            tNeedsToSetBounds = true;
                            aRenderer.setRenderBoundsFromBlock(aBlock);
                        } else {
                            if (tNeedsToSetBounds) {
                                aBlock.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                            }
                            aRenderer.setRenderBoundsFromBlock(aBlock);
                            tNeedsToSetBounds = false;
                        }
                        if (RendererBlockTextured.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tRenderer.getTexture(aBlock, i, (byte)0, tSides), !tNeedsToSetBounds, tSides[0], tRenderer)) {
                            rReturn = true;
                        }
                        if (RendererBlockTextured.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tRenderer.getTexture(aBlock, i, (byte)1, tSides), !tNeedsToSetBounds, tSides[1], tRenderer)) {
                            rReturn = true;
                        }
                        if (RendererBlockTextured.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tRenderer.getTexture(aBlock, i, (byte)2, tSides), !tNeedsToSetBounds, tSides[2], tRenderer)) {
                            rReturn = true;
                        }
                        if (RendererBlockTextured.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tRenderer.getTexture(aBlock, i, (byte)3, tSides), !tNeedsToSetBounds, tSides[3], tRenderer)) {
                            rReturn = true;
                        }
                        if (RendererBlockTextured.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tRenderer.getTexture(aBlock, i, (byte)4, tSides), !tNeedsToSetBounds, tSides[4], tRenderer)) {
                            rReturn = true;
                        }
                        if (!RendererBlockTextured.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tRenderer.getTexture(aBlock, i, (byte)5, tSides), !tNeedsToSetBounds, tSides[5], tRenderer)) continue;
                        rReturn = true;
                    }
                }
                if (tNeedsToSetBounds) {
                    aBlock.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
        aRenderer.setRenderBoundsFromBlock(aBlock);
        ITexture.Util.endRendering(aRenderer, aBlock, aWorld, aX, aY, aZ);
        return rReturn;
    }

    public static boolean renderNegativeYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture aIcon, boolean aFullBlock, boolean aShouldSideBeRendered, Object aRenderedBlockObject) {
        if (aIcon == null || !aIcon.isValidTexture()) {
            return false;
        }
        int aBrightness = 240;
        if (aWorld != null) {
            if (aFullBlock && !aShouldSideBeRendered) {
                return false;
            }
            aBrightness = aBlock.getMixedBrightnessForBlock(aWorld, aX, aFullBlock ? aY - 1 : aY, aZ);
            aRenderer.enableAO = true;
        }
        aIcon.renderYNeg(aRenderer, aBlock, aX, aY, aZ, aBrightness, !aFullBlock);
        aRenderer.flipTexture = false;
        aRenderer.colorBlueTopRight = 0.5f;
        aRenderer.colorBlueBottomRight = 0.5f;
        aRenderer.colorBlueBottomLeft = 0.5f;
        aRenderer.colorBlueTopLeft = 0.5f;
        aRenderer.colorGreenTopRight = 0.5f;
        aRenderer.colorGreenBottomRight = 0.5f;
        aRenderer.colorGreenBottomLeft = 0.5f;
        aRenderer.colorGreenTopLeft = 0.5f;
        aRenderer.colorRedTopRight = 0.5f;
        aRenderer.colorRedBottomRight = 0.5f;
        aRenderer.colorRedBottomLeft = 0.5f;
        aRenderer.colorRedTopLeft = 0.5f;
        return true;
    }

    public static boolean renderPositiveYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture aIcon, boolean aFullBlock, boolean aShouldSideBeRendered, Object aRenderedBlockObject) {
        if (aIcon == null || !aIcon.isValidTexture()) {
            return false;
        }
        int aBrightness = 240;
        if (aWorld != null) {
            if (aFullBlock && !aShouldSideBeRendered) {
                return false;
            }
            aBrightness = aBlock.getMixedBrightnessForBlock(aWorld, aX, aFullBlock ? aY + 1 : aY, aZ);
            aRenderer.enableAO = true;
        }
        aIcon.renderYPos(aRenderer, aBlock, aX, aY, aZ, aBrightness, !aFullBlock);
        aRenderer.flipTexture = false;
        aRenderer.colorBlueTopRight = 1.0f;
        aRenderer.colorBlueBottomRight = 1.0f;
        aRenderer.colorBlueBottomLeft = 1.0f;
        aRenderer.colorBlueTopLeft = 1.0f;
        aRenderer.colorGreenTopRight = 1.0f;
        aRenderer.colorGreenBottomRight = 1.0f;
        aRenderer.colorGreenBottomLeft = 1.0f;
        aRenderer.colorGreenTopLeft = 1.0f;
        aRenderer.colorRedTopRight = 1.0f;
        aRenderer.colorRedBottomRight = 1.0f;
        aRenderer.colorRedBottomLeft = 1.0f;
        aRenderer.colorRedTopLeft = 1.0f;
        return true;
    }

    public static boolean renderNegativeZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture aIcon, boolean aFullBlock, boolean aShouldSideBeRendered, Object aRenderedBlockObject) {
        if (aIcon == null || !aIcon.isValidTexture()) {
            return false;
        }
        int aBrightness = 240;
        if (aWorld != null) {
            if (aFullBlock && !aShouldSideBeRendered) {
                return false;
            }
            aBrightness = aBlock.getMixedBrightnessForBlock(aWorld, aX, aY, aFullBlock ? aZ - 1 : aZ);
            aRenderer.enableAO = true;
        }
        aRenderer.flipTexture = !aFullBlock;
        aIcon.renderZNeg(aRenderer, aBlock, aX, aY, aZ, aBrightness, !aFullBlock);
        aRenderer.flipTexture = false;
        aRenderer.colorBlueTopRight = 0.8f;
        aRenderer.colorBlueBottomRight = 0.8f;
        aRenderer.colorBlueBottomLeft = 0.8f;
        aRenderer.colorBlueTopLeft = 0.8f;
        aRenderer.colorGreenTopRight = 0.8f;
        aRenderer.colorGreenBottomRight = 0.8f;
        aRenderer.colorGreenBottomLeft = 0.8f;
        aRenderer.colorGreenTopLeft = 0.8f;
        aRenderer.colorRedTopRight = 0.8f;
        aRenderer.colorRedBottomRight = 0.8f;
        aRenderer.colorRedBottomLeft = 0.8f;
        aRenderer.colorRedTopLeft = 0.8f;
        return true;
    }

    public static boolean renderPositiveZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture aIcon, boolean aFullBlock, boolean aShouldSideBeRendered, Object aRenderedBlockObject) {
        if (aIcon == null || !aIcon.isValidTexture()) {
            return false;
        }
        int aBrightness = 240;
        if (aWorld != null) {
            if (aFullBlock && !aShouldSideBeRendered) {
                return false;
            }
            aBrightness = aBlock.getMixedBrightnessForBlock(aWorld, aX, aY, aFullBlock ? aZ + 1 : aZ);
            aRenderer.enableAO = true;
        }
        aIcon.renderZPos(aRenderer, aBlock, aX, aY, aZ, aBrightness, !aFullBlock);
        aRenderer.flipTexture = false;
        aRenderer.colorBlueTopRight = 0.8f;
        aRenderer.colorBlueBottomRight = 0.8f;
        aRenderer.colorBlueBottomLeft = 0.8f;
        aRenderer.colorBlueTopLeft = 0.8f;
        aRenderer.colorGreenTopRight = 0.8f;
        aRenderer.colorGreenBottomRight = 0.8f;
        aRenderer.colorGreenBottomLeft = 0.8f;
        aRenderer.colorGreenTopLeft = 0.8f;
        aRenderer.colorRedTopRight = 0.8f;
        aRenderer.colorRedBottomRight = 0.8f;
        aRenderer.colorRedBottomLeft = 0.8f;
        aRenderer.colorRedTopLeft = 0.8f;
        return true;
    }

    public static boolean renderNegativeXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture aIcon, boolean aFullBlock, boolean aShouldSideBeRendered, Object aRenderedBlockObject) {
        if (aIcon == null || !aIcon.isValidTexture()) {
            return false;
        }
        int aBrightness = 240;
        if (aWorld != null) {
            if (aFullBlock && !aShouldSideBeRendered) {
                return false;
            }
            aBrightness = aBlock.getMixedBrightnessForBlock(aWorld, aFullBlock ? aX - 1 : aX, aY, aZ);
            aRenderer.enableAO = true;
        }
        aIcon.renderXNeg(aRenderer, aBlock, aX, aY, aZ, aBrightness, !aFullBlock);
        aRenderer.flipTexture = false;
        aRenderer.colorBlueTopRight = 0.6f;
        aRenderer.colorBlueBottomRight = 0.6f;
        aRenderer.colorBlueBottomLeft = 0.6f;
        aRenderer.colorBlueTopLeft = 0.6f;
        aRenderer.colorGreenTopRight = 0.6f;
        aRenderer.colorGreenBottomRight = 0.6f;
        aRenderer.colorGreenBottomLeft = 0.6f;
        aRenderer.colorGreenTopLeft = 0.6f;
        aRenderer.colorRedTopRight = 0.6f;
        aRenderer.colorRedBottomRight = 0.6f;
        aRenderer.colorRedBottomLeft = 0.6f;
        aRenderer.colorRedTopLeft = 0.6f;
        return true;
    }

    public static boolean renderPositiveXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture aIcon, boolean aFullBlock, boolean aShouldSideBeRendered, Object aRenderedBlockObject) {
        if (aIcon == null || !aIcon.isValidTexture()) {
            return false;
        }
        int aBrightness = 240;
        if (aWorld != null) {
            if (aFullBlock && !aShouldSideBeRendered) {
                return false;
            }
            aBrightness = aBlock.getMixedBrightnessForBlock(aWorld, aFullBlock ? aX + 1 : aX, aY, aZ);
            aRenderer.enableAO = true;
        }
        aRenderer.flipTexture = !aFullBlock;
        aIcon.renderXPos(aRenderer, aBlock, aX, aY, aZ, aBrightness, !aFullBlock);
        aRenderer.flipTexture = false;
        aRenderer.colorBlueTopRight = 0.6f;
        aRenderer.colorBlueBottomRight = 0.6f;
        aRenderer.colorBlueBottomLeft = 0.6f;
        aRenderer.colorBlueTopLeft = 0.6f;
        aRenderer.colorGreenTopRight = 0.6f;
        aRenderer.colorGreenBottomRight = 0.6f;
        aRenderer.colorGreenBottomLeft = 0.6f;
        aRenderer.colorGreenTopLeft = 0.6f;
        aRenderer.colorRedTopRight = 0.6f;
        aRenderer.colorRedBottomRight = 0.6f;
        aRenderer.colorRedBottomLeft = 0.6f;
        aRenderer.colorRedTopLeft = 0.6f;
        return true;
    }

    public boolean shouldRender3DInInventory(int aModel) {
        return true;
    }

    public int getRenderId() {
        return this.mRenderID;
    }

    public boolean handleRenderType(ItemStack aStack, IItemRenderer.ItemRenderType aType) {
        mUsedNBT = aStack.getTagCompound();
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType aType, ItemStack aStack, IItemRenderer.ItemRendererHelper aHelper) {
        mUsedNBT = aStack.getTagCompound();
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType aType, ItemStack aStack, Object ... data) {
        mUsedNBT = aStack.getTagCompound();
    }

    static {
        mUsedNBT = null;
    }
}

