/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.data.ANY;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.item.IItemColorableRGB;
import gregapi.item.IItemProjectile;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.util.CR;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.wooddict.PlankEntry;
import gregapi.wooddict.WoodDictionary;
import java.util.Collection;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapBath
extends Recipe.RecipeMap {
    public static FL[] OILS = new FL[]{FL.Oil_Seed, FL.Oil_Lin, FL.Oil_Hemp, FL.Oil_Nut, FL.Oil_Olive, FL.Oil_Sunflower, FL.Oil_Creosote};

    public RecipeMapBath(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, false, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (aInputs == null || aInputs.length < 1 || aFluids.length < 1 || aFluids[0] == null || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        if (rRecipe == null) {
            for (ItemStack aInput : aInputs) {
                if (!ST.valid(aInput)) continue;
                PlankEntry aEntry = WoodDictionary.PLANKS_ANY.get(aInput);
                if (aEntry != null && (ANY.WoodUntreated.mToThis.contains(aEntry.mMaterialPlank) || MD.MC.owns(aInput))) {
                    ItemStack tTreated;
                    if (ST.valid(aEntry.mPlank)) {
                        if (IL.MaCu_Polished_Planks.exists()) {
                            this.addRecipe1(false, 0L, 144L, aEntry.mPlank, FL.Oil_Fish.make(1000L), CS.NF, IL.MaCu_Polished_Planks.get(1L, new Object[0]));
                            this.addRecipe1(false, 0L, 144L, aEntry.mPlank, FL.Oil_Whale.make(500L), CS.NF, IL.MaCu_Polished_Planks.get(1L, new Object[0]));
                        }
                        if (!IL.Treated_Planks.equal(aEntry.mPlank, false, true) && !IL.IE_Treated_Planks.equal(aEntry.mPlank, false, true)) {
                            tTreated = IL.IE_Treated_Planks.get(1L, IL.Treated_Planks.get(1L, new Object[0]));
                            for (FL fL : OILS) {
                                this.addRecipe1(false, 0L, 144L, aEntry.mPlank, fL.make(100L), CS.NF, tTreated);
                            }
                        }
                        if (IL.ERE_White_Planks.exists() && !IL.ERE_White_Planks.equal(aEntry.mPlank, false, true)) {
                            tTreated = IL.ERE_White_Planks.get(1L, new Object[0]);
                            for (FluidStack tFluid : CS.DYE_FLUIDS[15]) {
                                this.addRecipe1(false, 0L, 144L, aEntry.mPlank, tFluid, CS.NF, tTreated);
                            }
                        }
                    }
                    if (ST.valid(aEntry.mStair)) {
                        if (IL.IE_Treated_Stairs.exists() && !IL.IE_Treated_Stairs.equal(aEntry.mStair, false, true)) {
                            tTreated = IL.IE_Treated_Stairs.get(1L, new Object[0]);
                            for (FL fL : OILS) {
                                this.addRecipe1(false, 0L, 102L, aEntry.mStair, fL.make(75L), CS.NF, tTreated);
                            }
                        }
                        if (IL.ERE_White_Stairs.exists() && !IL.ERE_White_Stairs.equal(aEntry.mStair, false, true)) {
                            tTreated = IL.ERE_White_Stairs.get(1L, new Object[0]);
                            for (FluidStack tFluid : CS.DYE_FLUIDS[15]) {
                                this.addRecipe1(false, 0L, 102L, aEntry.mStair, FL.mul(tFluid, 3L, 4L, true), CS.NF, tTreated);
                            }
                        }
                    }
                    if (ST.valid(aEntry.mSlab)) {
                        if (!IL.Treated_Planks_Slab.equal(aEntry.mSlab, false, true) && !IL.IE_Treated_Slab.equal(aEntry.mSlab, false, true)) {
                            tTreated = IL.IE_Treated_Slab.get(1L, IL.Treated_Planks_Slab.get(1L, new Object[0]));
                            for (FL fL : OILS) {
                                this.addRecipe1(false, 0L, 72L, aEntry.mSlab, fL.make(50L), CS.NF, tTreated);
                            }
                        }
                        if (IL.ERE_White_Slab.exists() && !IL.ERE_White_Slab.equal(aEntry.mSlab, false, true)) {
                            tTreated = IL.ERE_White_Slab.get(1L, new Object[0]);
                            for (FluidStack tFluid : CS.DYE_FLUIDS[15]) {
                                this.addRecipe1(false, 0L, 72L, aEntry.mSlab, FL.mul(tFluid, 1L, 2L, true), CS.NF, tTreated);
                            }
                        }
                    }
                    rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
                }
                if (MD.ATUM.mLoaded) {
                    Item tItem = ST.item(MD.ATUM, "item.loot");
                    if (aInput.getItem() == tItem) {
                        short tMeta = ST.meta_(aInput);
                        if ((tMeta & 0x1F) == 1) {
                            return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(ST.make(tItem, 1L, (long)((tMeta & 0xFFFFFFE0) + 2 + 2 * CS.RNGSUS.nextInt(6)))), null, null, FL.array(FL.water(aFluids[0]) ? FL.amount(aFluids[0], 100L) : FL.Water.make(100L)), CS.ZL_FS, 512L, 0L, 0L).setNeedEmptyOut();
                        }
                        return null;
                    }
                }
                if (aInput.getItem() instanceof ItemArmor) {
                    for (int tColor = 0; tColor < 16; tColor = (int)((byte)(tColor + 1))) {
                        for (FluidStack aDye : CS.DYE_FLUIDS[tColor]) {
                            if (!FL.equal(aDye, aFluids[0])) continue;
                            ItemStack tOutput = CR.getany((World)(aTileEntity == null ? CS.DW : aTileEntity.getWorld()), ST.array(aInput, CS.NI, CS.NI, CS.NI, CS.NI, CS.NI, CS.NI, CS.NI, ST.make(Items.dye, 1L, (long)tColor)));
                            if (ST.invalid(tOutput)) {
                                return null;
                            }
                            return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(aDye), CS.ZL_FS, 512L, 0L, 0L);
                        }
                    }
                }
                if (aInput.getItem() instanceof IItemColorableRGB) {
                    if (((IItemColorableRGB)aInput.getItem()).canDecolorItem(aInput) && FL.equal(MT.Cl.fluid(648648000L, true), aFluids[0])) {
                        ItemStack tOutput = ST.amount(1L, aInput);
                        if (!((IItemColorableRGB)tOutput.getItem()).decolorItem(tOutput) || ST.invalid(tOutput)) {
                            return null;
                        }
                        return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(MT.Cl.fluid(81081000L, true)), CS.ZL_FS, 512L, 0L, 0L);
                    }
                    if (((IItemColorableRGB)aInput.getItem()).canRecolorItem(aInput)) {
                        for (int tColor = 0; tColor < 16; tColor = (int)((byte)(tColor + 1))) {
                            for (FluidStack aDye : CS.DYE_FLUIDS[tColor]) {
                                if (!FL.equal(aDye, aFluids[0])) continue;
                                ItemStack tOutput = ST.amount(1L, aInput);
                                if (!((IItemColorableRGB)tOutput.getItem()).recolorItem(tOutput, CS.DYES_INT[tColor]) || ST.invalid(tOutput)) {
                                    return null;
                                }
                                return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.mul(aDye, 1L, 8L, true)), CS.ZL_FS, 512L, 0L, 0L);
                            }
                        }
                    }
                }
                if (aInput.getItem() instanceof IItemProjectile && ((IItemProjectile)aInput.getItem()).hasProjectile(null, aInput)) {
                    if (FL.Holywater.is(aFluids[0]) && UT.NBT.getEnchantmentLevel(Enchantment.smite, aInput) < 10) {
                        return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(UT.NBT.addEnchantment(ST.update(ST.amount(1L, aInput)), Enchantment.smite, 10L)), null, null, FL.array(FL.Holywater.make(25L)), CS.ZL_FS, 16L, 0L, 0L);
                    }
                    if (FL.FieryBlood.is(aFluids[0]) && UT.NBT.getEnchantmentLevel(Enchantment.fireAspect, aInput) < 3) {
                        return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(UT.NBT.addEnchantment(ST.update(ST.amount(1L, aInput)), Enchantment.fireAspect, 3L)), null, null, FL.array(FL.FieryBlood.make(25L)), CS.ZL_FS, 16L, 0L, 0L);
                    }
                    if (FL.FieryTears.is(aFluids[0]) && UT.NBT.getEnchantmentLevel(Enchantment.fireAspect, aInput) < 3) {
                        return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(UT.NBT.addEnchantment(ST.update(ST.amount(1L, aInput)), Enchantment.fireAspect, 3L)), null, null, FL.array(FL.FieryTears.make(25L)), CS.ZL_FS, 16L, 0L, 0L);
                    }
                }
                if (!ST.edible(aInput) || FL.getFluid(aInput, true) != null) continue;
                ItemStack tOutput = ST.amount(1L, aInput);
                NBTTagCompound tNBT = UT.NBT.getNBT(tOutput);
                tOutput.setTagCompound(tNBT);
                if (tNBT.hasKey("gt.effects")) continue;
                if (FL.Med_Heal.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.regeneration.id, "time", 120, "lvl", 4, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Med_Laxative.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.hunger.id, "time", 300, "lvl", 10, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Poison.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.poison.id, "time", 450, "lvl", 1, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Harm_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.harm.id, "time", 1, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Harm_2.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.harm.id, "time", 1, "lvl", 1, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Heal_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.heal.id, "time", 1, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Heal_2.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.heal.id, "time", 1, "lvl", 1, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Jump_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.jump.id, "time", 3600, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Jump_2.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.jump.id, "time", 1800, "lvl", 1, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Speed_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.moveSpeed.id, "time", 3600, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Speed_2.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.moveSpeed.id, "time", 1800, "lvl", 1, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Speed_1L.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.moveSpeed.id, "time", 9600, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Strength_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.damageBoost.id, "time", 3600, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Strength_2.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.damageBoost.id, "time", 1800, "lvl", 1, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Strength_1L.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.damageBoost.id, "time", 9600, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Regen_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.regeneration.id, "time", 900, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Regen_2.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.regeneration.id, "time", 450, "lvl", 1, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Regen_1L.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.regeneration.id, "time", 2400, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Poison_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.poison.id, "time", 900, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Poison_2.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.poison.id, "time", 450, "lvl", 1, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Poison_1L.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.poison.id, "time", 2400, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_FireResistance_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.fireResistance.id, "time", 3600, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_FireResistance_1L.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.fireResistance.id, "time", 9600, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_NightVision_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.nightVision.id, "time", 3600, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_NightVision_1L.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.nightVision.id, "time", 9600, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Weakness_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.weakness.id, "time", 1800, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Weakness_1L.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.weakness.id, "time", 4800, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Slowness_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.moveSlowdown.id, "time", 1800, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Slowness_1L.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.moveSlowdown.id, "time", 4800, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_WaterBreathing_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.waterBreathing.id, "time", 3600, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_WaterBreathing_1L.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.waterBreathing.id, "time", 9600, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (FL.Potion_Invisibility_1.is(aFluids[0])) {
                    tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.invisibility.id, "time", 3600, "lvl", 0, "chance", 90));
                    return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
                }
                if (!FL.Potion_Invisibility_1L.is(aFluids[0])) continue;
                tNBT.setTag("gt.effects", (NBTBase)UT.NBT.make("id", (Object)Potion.invisibility.id, "time", 9600, "lvl", 0, "chance", 90));
                return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, FL.array(FL.amount(aFluids[0], 250L)), CS.ZL_FS, 512L, 0L, 0L);
            }
        }
        return rRecipe;
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        PlankEntry aEntry = WoodDictionary.PLANKS_ANY.get(aStack);
        return aEntry != null && ANY.WoodUntreated.mToThis.contains(aEntry.mMaterialPlank) || aStack != null && (aStack.getItem() instanceof ItemArmor || aStack.getItem() instanceof IItemColorableRGB && (((IItemColorableRGB)aStack.getItem()).canRecolorItem(aStack) || ((IItemColorableRGB)aStack.getItem()).canDecolorItem(aStack))) || ST.food(aStack) > 0 && FL.getFluid(aStack, true) == null || super.containsInput(aStack, aTileEntity, aSpecialSlot);
    }

    @Override
    public boolean containsInput(FluidStack aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return aFluid != null && aFluid.getFluid() != null && (super.containsInput(aFluid, aTileEntity, aSpecialSlot) || CS.FluidsGT.BATH.contains(aFluid.getFluid().getName()));
    }

    @Override
    public boolean containsInput(Fluid aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return aFluid != null && (super.containsInput(aFluid, aTileEntity, aSpecialSlot) || CS.FluidsGT.BATH.contains(aFluid.getName()));
    }
}

