/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.handlers;

import gregapi.code.ICondition;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.recipes.IRecipeMapHandler;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapHandlerPrefix
extends IRecipeMapHandler.RecipeMapHandler {
    protected ICondition mCondition;
    protected final OreDictPrefix[] mInputPrefixes;
    protected final OreDictPrefix[] mOutputPrefixes;
    protected final byte[] mInputAmounts;
    protected final byte[] mOutputAmounts;
    protected final ItemStack mAdditionalInput;
    protected final ItemStack mAdditionalOutput;
    protected final FluidStack mFluidInputPerUnit;
    protected final FluidStack mFluidOutputPerUnit;
    protected final long mUnitsInputted;
    protected final long mUnitsOutputted;
    protected final long mEUt;
    protected final long mDuration;
    protected final long mMultiplier;
    protected final boolean mAllowToGenerateAllRecipesAtOnce;
    protected long[] mChances = CS.ZL_LONG;
    protected boolean mAlreadyAddedAllRecipes = false;
    protected boolean mOutputPulverizedRemains = false;
    protected boolean mFlatFluidCosts = false;

    public RecipeMapHandlerPrefix(OreDictPrefix aInputPrefix, long aInputAmount, FluidStack aFluidInputPerUnit, long aEUt, long aDuration, long aMultiplier, FluidStack aFluidOutputPerUnit, OreDictPrefix aOutputPrefix, long aOutputAmount, ItemStack aAdditionalInput, ItemStack aAdditionalOutput, boolean aAllowToGenerateAllRecipesAtOnce, boolean aOutputPulverizedRemains, boolean aFlatFluidCosts, ICondition aCondition) {
        int i;
        OreDictPrefix[] oreDictPrefixArray;
        this.mAllowToGenerateAllRecipesAtOnce = aAllowToGenerateAllRecipesAtOnce;
        this.mFlatFluidCosts = aFlatFluidCosts;
        this.mFluidInputPerUnit = aFluidInputPerUnit;
        this.mFluidOutputPerUnit = aFluidOutputPerUnit;
        this.mCondition = aCondition == null ? ICondition.TRUE : aCondition;
        this.mInputPrefixes = new OreDictPrefix[]{aInputPrefix};
        this.mInputAmounts = new byte[]{UT.Code.bindStack(aInputAmount)};
        if (aOutputPrefix == null) {
            oreDictPrefixArray = CS.ZL_OREDICTPREFIX;
        } else {
            OreDictPrefix[] oreDictPrefixArray2 = new OreDictPrefix[1];
            oreDictPrefixArray = oreDictPrefixArray2;
            oreDictPrefixArray2[0] = aOutputPrefix;
        }
        this.mOutputPrefixes = oreDictPrefixArray;
        this.mOutputAmounts = new byte[]{UT.Code.bindStack(aOutputAmount)};
        this.mAdditionalOutput = aAdditionalOutput;
        this.mAdditionalInput = aAdditionalInput;
        this.mMultiplier = aMultiplier;
        this.mDuration = aDuration;
        this.mEUt = aEUt;
        long tUnitsProcessed = 0L;
        for (i = 0; i < this.mInputPrefixes.length; ++i) {
            tUnitsProcessed += this.mInputPrefixes[i].mAmount * (long)this.mInputAmounts[i];
        }
        this.mUnitsInputted = tUnitsProcessed;
        tUnitsProcessed = 0L;
        for (i = 0; i < this.mOutputPrefixes.length; ++i) {
            tUnitsProcessed += this.mOutputPrefixes[i].mAmount * (long)this.mOutputAmounts[i];
        }
        this.mUnitsOutputted = tUnitsProcessed;
        this.mOutputPulverizedRemains = aOutputPulverizedRemains && this.mUnitsInputted - this.mUnitsOutputted >= OP.dustDiv72.mAmount;
    }

    public RecipeMapHandlerPrefix(OreDictPrefix aInputPrefix1, long aInputAmount1, OreDictPrefix aInputPrefix2, long aInputAmount2, FluidStack aFluidInputPerUnit, long aEUt, long aDuration, long aMultiplier, FluidStack aFluidOutputPerUnit, OreDictPrefix aOutputPrefix1, long aOutputAmount1, OreDictPrefix aOutputPrefix2, long aOutputAmount2, ItemStack aAdditionalInput, ItemStack aAdditionalOutput, boolean aAllowToGenerateAllRecipesAtOnce, boolean aOutputPulverizedRemains, boolean aFlatFluidCosts, ICondition aCondition) {
        int i;
        byte[] byArray;
        OreDictPrefix[] oreDictPrefixArray;
        byte[] byArray2;
        OreDictPrefix[] oreDictPrefixArray2;
        this.mAllowToGenerateAllRecipesAtOnce = aAllowToGenerateAllRecipesAtOnce;
        this.mFlatFluidCosts = aFlatFluidCosts;
        this.mFluidInputPerUnit = aFluidInputPerUnit;
        this.mFluidOutputPerUnit = aFluidOutputPerUnit;
        ICondition iCondition = this.mCondition = aCondition == null ? ICondition.TRUE : aCondition;
        if (aInputPrefix2 == null) {
            OreDictPrefix[] oreDictPrefixArray3 = new OreDictPrefix[1];
            oreDictPrefixArray2 = oreDictPrefixArray3;
            oreDictPrefixArray3[0] = aInputPrefix1;
        } else {
            OreDictPrefix[] oreDictPrefixArray4 = new OreDictPrefix[2];
            oreDictPrefixArray4[0] = aInputPrefix1;
            oreDictPrefixArray2 = oreDictPrefixArray4;
            oreDictPrefixArray4[1] = aInputPrefix2;
        }
        this.mInputPrefixes = oreDictPrefixArray2;
        if (aInputPrefix2 == null) {
            byte[] byArray3 = new byte[1];
            byArray2 = byArray3;
            byArray3[0] = UT.Code.bindStack(aInputAmount1);
        } else {
            byte[] byArray4 = new byte[2];
            byArray4[0] = UT.Code.bindStack(aInputAmount1);
            byArray2 = byArray4;
            byArray4[1] = UT.Code.bindStack(aInputAmount2);
        }
        this.mInputAmounts = byArray2;
        if (aOutputPrefix2 == null) {
            if (aOutputPrefix1 == null) {
                oreDictPrefixArray = CS.ZL_OREDICTPREFIX;
            } else {
                OreDictPrefix[] oreDictPrefixArray5 = new OreDictPrefix[1];
                oreDictPrefixArray = oreDictPrefixArray5;
                oreDictPrefixArray5[0] = aOutputPrefix1;
            }
        } else {
            OreDictPrefix[] oreDictPrefixArray6 = new OreDictPrefix[2];
            oreDictPrefixArray6[0] = aOutputPrefix1;
            oreDictPrefixArray = oreDictPrefixArray6;
            oreDictPrefixArray6[1] = aOutputPrefix2;
        }
        this.mOutputPrefixes = oreDictPrefixArray;
        if (aOutputPrefix2 == null) {
            byte[] byArray5 = new byte[1];
            byArray = byArray5;
            byArray5[0] = UT.Code.bindStack(aOutputAmount1);
        } else {
            byte[] byArray6 = new byte[2];
            byArray6[0] = UT.Code.bindStack(aOutputAmount1);
            byArray = byArray6;
            byArray6[1] = UT.Code.bindStack(aOutputAmount2);
        }
        this.mOutputAmounts = byArray;
        this.mAdditionalOutput = aAdditionalOutput;
        this.mAdditionalInput = aAdditionalInput;
        this.mMultiplier = aMultiplier;
        this.mDuration = aDuration;
        this.mEUt = aEUt;
        long tUnitsProcessed = 0L;
        for (i = 0; i < this.mInputPrefixes.length; ++i) {
            tUnitsProcessed += this.mInputPrefixes[i].mAmount * (long)this.mInputAmounts[i];
        }
        this.mUnitsInputted = tUnitsProcessed;
        tUnitsProcessed = 0L;
        for (i = 0; i < this.mOutputPrefixes.length; ++i) {
            tUnitsProcessed += this.mOutputPrefixes[i].mAmount * (long)this.mOutputAmounts[i];
        }
        this.mUnitsOutputted = tUnitsProcessed;
        this.mOutputPulverizedRemains = aOutputPulverizedRemains && this.mUnitsInputted - this.mUnitsOutputted >= OP.dustDiv72.mAmount;
    }

    public RecipeMapHandlerPrefix(OreDictPrefix[] aInputPrefixes, long[] aInputAmount, FluidStack aFluidInputPerUnit, long aEUt, long aDuration, long aMultiplier, FluidStack aFluidOutputPerUnit, OreDictPrefix[] aOutputPrefixes, long[] aOutputAmount, ItemStack aAdditionalInput, ItemStack aAdditionalOutput, boolean aAllowToGenerateAllRecipesAtOnce, boolean aOutputPulverizedRemains, boolean aFlatFluidCosts, ICondition aCondition) {
        int i;
        int i2;
        this.mAllowToGenerateAllRecipesAtOnce = aAllowToGenerateAllRecipesAtOnce;
        this.mFlatFluidCosts = aFlatFluidCosts;
        this.mFluidInputPerUnit = aFluidInputPerUnit;
        this.mFluidOutputPerUnit = aFluidOutputPerUnit;
        this.mCondition = aCondition == null ? ICondition.TRUE : aCondition;
        this.mInputPrefixes = aInputPrefixes;
        this.mInputAmounts = new byte[this.mInputPrefixes.length];
        for (i2 = 0; i2 < this.mInputAmounts.length; ++i2) {
            this.mInputAmounts[i2] = UT.Code.bindStack(aInputAmount[i2]);
        }
        this.mOutputPrefixes = aOutputPrefixes;
        this.mOutputAmounts = new byte[this.mOutputPrefixes.length];
        for (i2 = 0; i2 < this.mOutputAmounts.length; ++i2) {
            this.mOutputAmounts[i2] = UT.Code.bindStack(aOutputAmount[i2]);
        }
        this.mAdditionalOutput = aAdditionalOutput;
        this.mAdditionalInput = aAdditionalInput;
        this.mMultiplier = aMultiplier;
        this.mDuration = aDuration;
        this.mEUt = aEUt;
        long tUnitsProcessed = 0L;
        for (i = 0; i < this.mInputPrefixes.length; ++i) {
            tUnitsProcessed += this.mInputPrefixes[i].mAmount * (long)this.mInputAmounts[i];
        }
        this.mUnitsInputted = tUnitsProcessed;
        tUnitsProcessed = 0L;
        for (i = 0; i < this.mOutputPrefixes.length; ++i) {
            tUnitsProcessed += this.mOutputPrefixes[i].mAmount * (long)this.mOutputAmounts[i];
        }
        this.mUnitsOutputted = tUnitsProcessed;
        this.mOutputPulverizedRemains = aOutputPulverizedRemains && this.mUnitsInputted - this.mUnitsOutputted >= OP.dustDiv72.mAmount;
    }

    @Override
    public boolean addRecipesUsing(Recipe.RecipeMap aMap, boolean aNEI, ItemStack aStack, OreDictItemData aData) {
        if (this.isDone()) {
            return false;
        }
        if (ST.equal(aStack, this.mAdditionalInput)) {
            return aNEI && this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
        }
        return aData != null && aData.validData() && UT.Code.contains(aData.mPrefix, this.mInputPrefixes) && this.addRecipeForMaterial(aMap, aData.mMaterial.mMaterial);
    }

    @Override
    public boolean addRecipesProducing(Recipe.RecipeMap aMap, boolean aNEI, ItemStack aStack, OreDictItemData aData) {
        if (this.isDone()) {
            return false;
        }
        if (ST.equal(aStack, this.mAdditionalOutput)) {
            return aNEI && this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
        }
        return aData != null && aData.validData() && (UT.Code.contains(aData.mPrefix, this.mOutputPrefixes) || this.mOutputPulverizedRemains && aData.mPrefix == OP.dust) && this.addRecipeForMaterial(aMap, aData.mMaterial.mMaterial);
    }

    @Override
    public boolean addRecipesUsing(Recipe.RecipeMap aMap, boolean aNEI, Fluid aFluid) {
        if (this.isDone()) {
            return false;
        }
        return aNEI && this.mAllowToGenerateAllRecipesAtOnce && this.mFluidInputPerUnit != null && this.mFluidInputPerUnit.getFluid() == aFluid && this.addAllRecipesInternal(aMap);
    }

    @Override
    public boolean addRecipesProducing(Recipe.RecipeMap aMap, boolean aNEI, Fluid aFluid) {
        if (this.isDone()) {
            return false;
        }
        return aNEI && this.mAllowToGenerateAllRecipesAtOnce && this.mFluidOutputPerUnit != null && this.mFluidOutputPerUnit.getFluid() == aFluid && this.addAllRecipesInternal(aMap);
    }

    @Override
    public boolean containsInput(Recipe.RecipeMap aMap, Fluid aFluid) {
        return this.mFluidInputPerUnit != null && this.mFluidInputPerUnit.getFluid() == aFluid;
    }

    @Override
    public boolean addAllRecipes(Recipe.RecipeMap aMap) {
        return this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
    }

    public boolean addAllRecipesInternal(Recipe.RecipeMap aMap) {
        if (this.isDone()) {
            return false;
        }
        aMap.mConfigFile.mSaveOnEdit = false;
        for (OreDictMaterial tMaterial : this.mInputPrefixes[0].mRegisteredMaterials) {
            this.addRecipeForMaterial(aMap, tMaterial);
        }
        this.mAlreadyAddedAllRecipes = true;
        aMap.mConfigFile.mSaveOnEdit = true;
        aMap.mConfigFile.mConfig.save();
        return true;
    }

    public RecipeMapHandlerPrefix chances(long ... aChances) {
        this.mChances = aChances;
        return this;
    }

    @Override
    public boolean isDone() {
        return this.mAlreadyAddedAllRecipes;
    }

    @Override
    public boolean onAddedToMap(Recipe.RecipeMap aMap) {
        if (this.mFluidInputPerUnit != null) {
            aMap.mMaxFluidInputSize = Math.max(this.mFlatFluidCosts ? this.mFluidInputPerUnit.amount : this.mFluidInputPerUnit.amount * 4, aMap.mMaxFluidInputSize);
            Long tSize = aMap.mMinInputTankSizes.get(this.mFluidInputPerUnit.getFluid().getName());
            if (tSize == null || tSize < (long)this.mFluidInputPerUnit.amount) {
                aMap.mMinInputTankSizes.put(this.mFluidInputPerUnit.getFluid().getName(), Long.valueOf(this.mFluidInputPerUnit.amount));
            }
        }
        if (this.mFluidOutputPerUnit != null) {
            aMap.mMaxFluidOutputSize = Math.max(this.mFluidOutputPerUnit.amount * 16, aMap.mMaxFluidOutputSize);
        }
        return true;
    }

    public boolean addRecipeForMaterial(Recipe.RecipeMap aMap, OreDictMaterial aMaterial) {
        if (!this.mCondition.isTrue(aMaterial) || aMaterial.contains(TD.Properties.INVALID_MATERIAL)) {
            return false;
        }
        ItemStack[] tInputs = new ItemStack[this.mInputPrefixes.length + (ST.valid(this.mAdditionalInput) ? 1 : 0)];
        if (ST.valid(this.mAdditionalInput)) {
            tInputs[tInputs.length - 1] = this.mAdditionalInput;
        }
        for (int i = 0; i < this.mInputPrefixes.length; ++i) {
            tInputs[i] = this.mInputPrefixes[i].mat(aMaterial, (long)this.mInputAmounts[i]);
            if (!ST.invalid(tInputs[i])) continue;
            return false;
        }
        OreDictMaterial tMaterial = this.getOutputMaterial(aMaterial);
        ItemStack[] tOutputs = new ItemStack[this.mOutputPrefixes.length + (this.mOutputPulverizedRemains ? 1 : 0) + (ST.valid(this.mAdditionalOutput) ? 1 : 0)];
        for (int i = 0; i < this.mOutputPrefixes.length; ++i) {
            tOutputs[i] = this.mOutputPrefixes[i].mat(tMaterial, (long)this.mOutputAmounts[i]);
            if (!ST.invalid(tOutputs[i])) continue;
            return false;
        }
        if (this.mOutputPulverizedRemains) {
            tOutputs[this.mOutputPrefixes.length] = OM.pulverize(aMaterial, this.mUnitsInputted - this.mUnitsOutputted);
        }
        if (ST.valid(this.mAdditionalOutput)) {
            tOutputs[tOutputs.length - 1] = this.mAdditionalOutput;
        }
        return aMap.addRecipeX(false, true, false, false, !aMaterial.contains(TD.Properties.UNUSED_MATERIAL), this.mEUt, this.mDuration <= 0L ? Math.max(1L, this.getCosts(aMaterial)) : this.mDuration, this.mChances, tInputs, this.mFlatFluidCosts ? this.mFluidInputPerUnit : FL.mul(this.mFluidInputPerUnit, aMaterial.mToolQuality + 1), this.mFlatFluidCosts ? this.mFluidOutputPerUnit : FL.mul(this.mFluidOutputPerUnit, aMaterial.mToolQuality + 1), tOutputs) != null;
    }

    public OreDictMaterial getOutputMaterial(OreDictMaterial aMaterial) {
        return aMaterial;
    }

    public long getCosts(OreDictMaterial aMaterial) {
        return UT.Code.units(Math.max(this.mUnitsInputted, this.mUnitsOutputted), 648648000L, this.mMultiplier + this.mMultiplier * (long)aMaterial.mToolQuality, true);
    }
}

