/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes;

import gregapi.code.TagData;
import gregapi.item.IItemEnergy;
import gregapi.item.IItemGTContainerTool;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.recipes.ICraftingRecipeGT;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class AdvancedCraftingShaped
extends ShapedOreRecipe
implements ICraftingRecipeGT {
    public final boolean mDismantleable;
    public final boolean mRemovableByGT;
    public final boolean mAutoCraftable;
    public final boolean mKeepingNBT;
    private final Enchantment[] mEnchantmentsAdded;
    private final int[] mEnchantmentLevelsAdded;

    public AdvancedCraftingShaped(ItemStack aResult, boolean aDismantleAble, boolean aRemovableByGT, boolean aKeepingNBT, boolean aAutoCraftable, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object ... aRecipe) {
        super(aResult, aRecipe);
        this.mEnchantmentsAdded = aEnchantmentsAdded;
        this.mEnchantmentLevelsAdded = aEnchantmentLevelsAdded;
        this.mRemovableByGT = aRemovableByGT;
        this.mKeepingNBT = aKeepingNBT;
        this.mDismantleable = aDismantleAble;
        this.mAutoCraftable = aAutoCraftable;
    }

    public boolean matches(InventoryCrafting aGrid, World aWorld) {
        if (this.mKeepingNBT) {
            ItemStack tStack = null;
            for (int i = 0; i < aGrid.getSizeInventory(); ++i) {
                if (aGrid.getStackInSlot(i) == null || !aGrid.getStackInSlot(i).hasTagCompound()) continue;
                if (tStack != null && (tStack.hasTagCompound() != aGrid.getStackInSlot(i).hasTagCompound() || tStack.hasTagCompound() && !tStack.getTagCompound().equals((Object)aGrid.getStackInSlot(i).getTagCompound()))) {
                    return false;
                }
                tStack = aGrid.getStackInSlot(i);
            }
        }
        return super.matches(aGrid, aWorld);
    }

    public ItemStack getCraftingResult(InventoryCrafting aGrid) {
        ItemStack rStack = super.getCraftingResult(aGrid);
        if (rStack != null) {
            int i;
            ST.update(rStack);
            if (this.mKeepingNBT) {
                for (i = 0; i < aGrid.getSizeInventory(); ++i) {
                    if (aGrid.getStackInSlot(i) == null || !aGrid.getStackInSlot(i).hasTagCompound()) continue;
                    UT.NBT.set(rStack, (NBTTagCompound)aGrid.getStackInSlot(i).getTagCompound().copy());
                    break;
                }
            }
            if (rStack.getItem() instanceof IItemEnergy) {
                for (TagData tEnergyType : ((IItemEnergy)rStack.getItem()).getEnergyTypes(rStack)) {
                    long tCharge = 0L;
                    for (int i2 = 0; i2 < aGrid.getSizeInventory(); ++i2) {
                        if (aGrid.getStackInSlot(i2) == null || !(aGrid.getStackInSlot(i2).getItem() instanceof IItemEnergy) || aGrid.getStackInSlot(i2).getItem() instanceof IItemGTContainerTool) continue;
                        tCharge += ((IItemEnergy)aGrid.getStackInSlot(i2).getItem()).getEnergyStored(tEnergyType, aGrid.getStackInSlot(i2));
                    }
                    ((IItemEnergy)rStack.getItem()).setEnergyStored(tEnergyType, rStack, tCharge);
                }
            }
            if (this.mDismantleable) {
                NBTTagCompound rNBT = rStack.getTagCompound();
                NBTTagCompound tNBT = UT.NBT.make();
                if (rNBT == null) {
                    rNBT = UT.NBT.make();
                }
                for (int i3 = 0; i3 < 9; ++i3) {
                    ItemStack tStack = aGrid.getStackInSlot(i3);
                    if (tStack == null || ST.container(tStack, true) != null || tStack.getItem() instanceof MultiItemTool) continue;
                    tStack = ST.amount(1L, tStack);
                    tNBT.setTag("" + i3, (NBTBase)ST.save(tStack));
                }
                rNBT.setTag("gt.recycling.comps", (NBTBase)tNBT);
                UT.NBT.set(rStack, rNBT);
            }
            for (i = 0; i < this.mEnchantmentsAdded.length; ++i) {
                UT.NBT.addEnchantment(rStack, this.mEnchantmentsAdded[i], UT.NBT.getEnchantmentLevel(this.mEnchantmentsAdded[i], rStack) + this.mEnchantmentLevelsAdded[i]);
            }
            ST.update(rStack);
        }
        return rStack;
    }

    @Override
    public boolean isRemovableByGT() {
        return this.mRemovableByGT;
    }

    @Override
    public boolean isAutocraftableByGT() {
        return this.mAutoCraftable;
    }
}

