/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregapi.api.Abstract_Mod;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackMap;
import gregapi.code.ItemStackSet;
import gregapi.code.ModData;
import gregapi.config.Config;
import gregapi.data.ANY;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OD;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.item.IPrefixItem;
import gregapi.oredict.IOreDictItemDataOverrideItem;
import gregapi.oredict.IOreDictOptimizedParsingItem;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.oredict.event.IOreDictListenerEvent;
import gregapi.oredict.event.IOreDictListenerRecyclable;
import gregapi.recipes.Recipe;
import gregapi.util.CR;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictManager {
    public static final OreDictManager INSTANCE = new OreDictManager();
    private final Set<IOreDictListenerEvent> mGlobalOreDictListeners = new HashSetNoNulls<IOreDictListenerEvent>();
    private final Set<IOreDictListenerEvent.OreDictRegistrationContainer> mGlobalRegistrations = new HashSetNoNulls<IOreDictListenerEvent.OreDictRegistrationContainer>();
    private final Set<IOreDictListenerRecyclable> mRecyclableOreDictListeners = new HashSetNoNulls<IOreDictListenerRecyclable>();
    private final Set<IOreDictListenerRecyclable.OreDictRecyclingContainer> mRecyclableRegistrations = new HashSetNoNulls<IOreDictListenerRecyclable.OreDictRecyclingContainer>();
    private final Map<String, Collection<String>> mReRegistrationMappings = new HashMap<String, Collection<String>>();
    private final Map<String, OreDictItemData> mStringToItemDataMappings = new HashMap<String, OreDictItemData>();
    private final Map<String, Collection<OreDictMaterial>> mVisibilityTriggers = new HashMap<String, Collection<OreDictMaterial>>();
    private final Set<String> mUnknownMaterials = new HashSetNoNulls<String>();
    private final Set<String> mUnknownNames = new HashSetNoNulls<String>();
    private final Set<String> mAutoBlackListedNames = new HashSetNoNulls<String>();
    private final Set<String> mAutoBlackListedMods = new HashSetNoNulls<String>();
    private final Set<String> mKnownNames = new HashSetNoNulls<String>(false, "oreHeeInstabilityOrb", "oreHeeEndPowder", "oreHeeIgneousRock", "oreHeeStardust", "oreBituminousCoal", "oreBrimstone", "rennetSource", "yeastBrewers", "yeastLager", "yeastBayanus", "yeastEthereal", "yeastOrigin", "holystone", "darkStone", "whiteStone", "brightStone", "lavastone", "mycelium", "podzol", "grass", "soulSand", "taintedSoil", "snowLayer", "ice", "cloud", "antiBlock", "transdimBlock", "carpet", "pendant", "tyrian", "arcaneAsh", "camoPaste", "burntQuartz", "KangarooPaw", "redstoneRoot", "pigment", "diamondShard", "eternalLifeEssence", "honeyDrop", "grubBee", "salmonRaw", "stringFluxed", "aquaRegia", "sludge", "lexicaBotania", "resourceTaint", "chainLink", "sulfuricAcid", "scribingTools", "bacon", "redalloyBundled", "bluestoneInsulated", "infusedteslatiteInsulated", "bluestoneBundled", "redalloyInsulated", "infusedteslatiteBundled", "universalCable", "laserReceptor", "laserEmitter", "laserFocus", "laserMirror", "mobEgg", "awesomeiteHammer", "awesomeCore", "bPlaceholder", "bVial", "bRedString", "bEnderAirBottle", "bFlask", "brDeviceCyaniteProcessor", "prbackpack", "diamondNugget", "UUMatter", "gaiaIngot", "pebble", "treatedStick", "universalReactant", "matterDustRefined", "sourceVegetableOil", "matterDust", "drawerBasic", "hempBrick", "hempBlock", "savehempBrick", "savehempBlock", "saveplatedHempBrick", "saveplatedHempBlock", "platedHempBrick", "platedHempBlock", "platedHemp", "savehemp", "saveplatedHemp");
    private final Set<String> mIgnoredNames = new HashSetNoNulls<String>(false, "rawMeat", "cookedMeat", "rawRubber", "plateTungCar", "ingotRefinedGlowstone", "ingotRefinedObsidian", "oreCompass", "oreBentonite", "oreFullersEarth", "oreKaolinite", "dustRefinedObsidian", "dustRefinedGlowstone", "oreNetherQuartz", "oreNetherite", "oreBasalticMineralSand", "oreLifeCrystal", "cropMaplesyrup", "oreTritanium", "oreDuranium", "plateLapis", "shardEntropy", "shardAir", "shardWater", "shardEarth", "shardFire", "shardOrder", "greggy_greg_do_please_kindly_stuff_a_sock_in_it", "halfSheetCylinderMetal", "halfSheetMetal", "quarterSheetMetal", "sheetCurvedFourMetal", "sheetCurvedOneMetal", "sheetCurvedThreeMetal", "sheetCurvedTwoMetal", "sheetCylinderMetal", "sheetMediumConeMetal", "sheetMetal", "sheetMicroConeMetal", "sheetMicroFinMetal", "sheetSmallConeMetal", "sheetSmallCylinderMetal", "sheetSmallFinMetal", "shirtSheetMetal", "rivetSheetMetal", "triangleSheetMetal");
    private final Set<String> mAlreadyRegisteredNames = new HashSetNoNulls<String>();
    private final Set<ItemStack> mAllRegisteredOres = new HashSetNoNulls<ItemStack>();
    public Config mUnificationConfig;
    private boolean mIsRunningInIterationMode = true;
    private Set<IOreDictListenerEvent> mBufferedListeners1 = new HashSetNoNulls<IOreDictListenerEvent>();
    private Set<IOreDictListenerRecyclable> mBufferedListeners2 = new HashSetNoNulls<IOreDictListenerRecyclable>();
    private List<OreDictEventContainer> mBufferedRegistrations = new ArrayListNoNulls<OreDictEventContainer>();
    private final Map<String, ItemStack> sName2StackMap = new HashMap<String, ItemStack>();
    private final Map<ItemStackContainer, OreDictItemData> sItemStack2DataMap = new ItemStackMap();
    private final ItemStackSet<ItemStackContainer> sNoUnificationSet = ST.hashset(new ItemStack[0]);
    private int isRegisteringOre = 0;
    private int isAddingOre = 0;

    private OreDictManager() {
        for (String string : OreDictionary.getOreNames()) {
            for (ItemStack tOreStack : OreDictionary.getOres((String)string, (boolean)false)) {
                this.onOreRegistration1(new OreDictionary.OreRegisterEvent(string, tOreStack));
            }
        }
        for (String string : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            this.onFluidContainerRegistration(new FluidContainerRegistry.FluidContainerRegisterEvent((FluidContainerRegistry.FluidContainerData)string));
        }
        this.mIsRunningInIterationMode = false;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void addListener(IOreDictListenerEvent aListener) {
        if (CS.GAPI.mStartedPostInit) {
            this.addListenerInternal(aListener);
        } else {
            this.mBufferedListeners1.add(aListener);
        }
    }

    private void addListenerInternal(IOreDictListenerEvent aListener) {
        if (this.mGlobalOreDictListeners.add(aListener)) {
            for (IOreDictListenerEvent.OreDictRegistrationContainer tEvent : this.mGlobalRegistrations) {
                aListener.onOreRegistration(tEvent);
            }
        }
    }

    public void addListener(IOreDictListenerRecyclable aListener) {
        if (CS.GAPI.mStartedPostInit) {
            this.addListenerInternal(aListener);
        } else {
            this.mBufferedListeners2.add(aListener);
        }
    }

    private void addListenerInternal(IOreDictListenerRecyclable aListener) {
        if (this.mRecyclableOreDictListeners.add(aListener)) {
            for (IOreDictListenerRecyclable.OreDictRecyclingContainer tEvent : this.mRecyclableRegistrations) {
                aListener.onRecycleableRegistration(new IOreDictListenerRecyclable.OreDictRecyclingContainer(tEvent));
            }
        }
    }

    public void onPostLoad() {
        if (CS.GAPI.mStartedPostInit) {
            UT.LoadingBar.start("OreDict", 4);
            UT.LoadingBar.step("Unification Entries");
            this.registerUnificationEntries();
            UT.LoadingBar.step("Global Listeners");
            for (IOreDictListenerEvent iOreDictListenerEvent : this.mBufferedListeners1) {
                this.addListenerInternal(iOreDictListenerEvent);
            }
            this.mBufferedListeners1.clear();
            this.mBufferedListeners1 = null;
            UT.LoadingBar.step("Prefix Listeners");
            for (OreDictPrefix oreDictPrefix : OreDictPrefix.VALUES) {
                oreDictPrefix.onPostLoad();
            }
            UT.LoadingBar.step("Recycling Listeners");
            for (IOreDictListenerRecyclable iOreDictListenerRecyclable : this.mBufferedListeners2) {
                this.addListenerInternal(iOreDictListenerRecyclable);
            }
            this.mBufferedListeners2.clear();
            this.mBufferedListeners2 = null;
            UT.LoadingBar.finish();
        }
    }

    public void fixStacksizes() {
        for (ItemStack tStack : this.mAllRegisteredOres) {
            tStack.stackSize = 1;
        }
    }

    public boolean isOreDictItem(ItemStack aStack) {
        return this.mAllRegisteredOres.contains(aStack);
    }

    public boolean addReRegistrationWithReversal(Object aOreToReRegister, Object aAdditionalName) {
        boolean rResult = this.addReRegistration(aOreToReRegister, aAdditionalName);
        return this.addReRegistration(aAdditionalName, aOreToReRegister) || rResult;
    }

    public boolean addAutoBlackListingForMod(Object aAutoBlackListedMod) {
        this.mAutoBlackListedMods.add(aAutoBlackListedMod.toString().toLowerCase());
        this.mAutoBlackListedMods.add(aAutoBlackListedMod.toString().toUpperCase());
        return this.mAutoBlackListedMods.add(aAutoBlackListedMod.toString());
    }

    public boolean addAutoBlackListing(Object aAutoBlackListedString) {
        this.addKnownName(aAutoBlackListedString);
        return this.mAutoBlackListedNames.add(aAutoBlackListedString.toString());
    }

    public boolean addKnownName(Object aOreDictName) {
        return this.mKnownNames.add(aOreDictName.toString());
    }

    public boolean addReRegistration(Object aOreToReRegister, Object aAdditionalName) {
        this.addKnownName(aOreToReRegister);
        this.addKnownName(aAdditionalName);
        if (aOreToReRegister.toString().equals(aAdditionalName.toString())) {
            return false;
        }
        Collection<String> tNames = this.mReRegistrationMappings.get(aOreToReRegister.toString());
        if (tNames == null) {
            tNames = new HashSetNoNulls<String>();
            this.mReRegistrationMappings.put(aOreToReRegister.toString(), tNames);
        }
        if (tNames.add(aAdditionalName.toString())) {
            for (ItemStack tOreStack : OreDictionary.getOres((String)aOreToReRegister.toString(), (boolean)false)) {
                OreDictManager.registerOreSafe(aAdditionalName, tOreStack);
            }
            return true;
        }
        return false;
    }

    public boolean triggerVisibility(Object aName) {
        Collection<OreDictMaterial> tVisibilityTriggers = this.mVisibilityTriggers.get(aName.toString());
        if (tVisibilityTriggers != null) {
            for (OreDictMaterial tMaterial : tVisibilityTriggers) {
                tMaterial.mHidden = false;
            }
        }
        return false;
    }

    public boolean addVisibilityTrigger(Object aName, OreDictMaterial aMaterial) {
        this.addKnownName(aName);
        Collection<OreDictMaterial> tNames = this.mVisibilityTriggers.get(aName.toString());
        if (tNames == null) {
            tNames = new HashSetNoNulls<OreDictMaterial>();
            this.mVisibilityTriggers.put(aName.toString(), tNames);
        }
        if (tNames.add(aMaterial)) {
            for (ItemStack tOreStack : OreDictionary.getOres((String)aName.toString(), (boolean)false)) {
                if (ST.isGT(tOreStack)) continue;
                aMaterial.mHidden = false;
            }
            return true;
        }
        return false;
    }

    public boolean setAutomaticItemData(Object aOreDictName, OreDictItemData aData) {
        this.addKnownName(aOreDictName);
        this.mStringToItemDataMappings.put(aOreDictName.toString(), aData);
        for (ItemStack tStack : OreDictManager.getOres(aOreDictName.toString(), false)) {
            this.addItemData_(tStack, OreDictItemData.copy(aData));
        }
        return true;
    }

    public OreDictItemData getAutomaticItemData(Object aOreDictName) {
        return OreDictItemData.copy(this.mStringToItemDataMappings.get(aOreDictName.toString()));
    }

    public Collection<String> getUnknownMaterials() {
        ArrayListNoNulls<String> rList = new ArrayListNoNulls<String>(this.mUnknownMaterials);
        Collections.sort(rList);
        return rList;
    }

    public Collection<String> getUnknownNames() {
        ArrayListNoNulls<String> rList = new ArrayListNoNulls<String>(this.mUnknownNames);
        Collections.sort(rList);
        return rList;
    }

    public void enableRegistrations() {
        if (CS.GAPI.mStartedInit) {
            List<OreDictEventContainer> tBufferedRegistrations = this.mBufferedRegistrations;
            this.mBufferedRegistrations = null;
            UT.LoadingBar.start(MD.MaCu.mLoaded ? "(Lags because Mariculture) OreDict" : "OreDict", tBufferedRegistrations.size());
            for (OreDictEventContainer tContainer : tBufferedRegistrations) {
                UT.LoadingBar.step(tContainer.mEvent.Name);
                this.onOreRegistration2(tContainer.mModID, tContainer.mMod, tContainer.mRegName, tContainer.mEvent);
            }
            tBufferedRegistrations.clear();
            UT.LoadingBar.finish();
        }
    }

    @SubscribeEvent
    public void onFluidContainerRegistration(FluidContainerRegistry.FluidContainerRegisterEvent aFluidEvent) {
        if (aFluidEvent.data.filledContainer.getItem() == Items.potionitem && ST.meta_(aFluidEvent.data.filledContainer) == 0) {
            aFluidEvent.data.fluid.amount = 0;
        }
        this.addToBlacklist(aFluidEvent.data.emptyContainer);
        FL.set(aFluidEvent.data, false, false);
    }

    @SubscribeEvent
    public void onOreRegistration1(OreDictionary.OreRegisterEvent aEvent) {
        if (aEvent.getClass() != OreDictionary.OreRegisterEvent.class) {
            return;
        }
        String aModID = MD.UNKNOWN.mID;
        ModData aMod = MD.UNKNOWN;
        ModContainer tContainer = Loader.instance().activeModContainer();
        if (!this.mIsRunningInIterationMode && tContainer != null) {
            aModID = tContainer.getModId();
            aMod = ModData.MODS.get(aModID);
        }
        if (aEvent.Ore == null) {
            CS.ERR.println("ERROR: A NULL STACK from the Mod '" + aModID + "' has been registered to the OreDict as: " + aEvent.Name);
            return;
        }
        if (aEvent.Ore.getItem() == null) {
            CS.ERR.println("ERROR: A NULL ITEM from the Mod '" + aModID + "' has been registered to the OreDict as: " + aEvent.Name);
            return;
        }
        String aRegName = ST.regName(aEvent.Ore);
        if (UT.Code.stringInvalid(aRegName)) {
            CS.ERR.println("ERROR: " + aEvent.Ore.getItem().getClass() + " from the Mod '" + aModID + "' has been registered to the OreDict before being registered as an Item/Block with: " + aEvent.Name);
            return;
        }
        if (CS.GT != null && this.isRegisteringOre != 1) {
            String tLowerCase = aEvent.Name.toLowerCase();
            if (MD.TE_FOUNDATION == aMod && MD.TE_FOUNDATION.owns(aRegName, "material") && UT.Code.inside(1024L, 1029L, ST.meta_(aEvent.Ore))) {
                return;
            }
            if (MD.TC == aMod && tLowerCase.endsWith("uicksilver")) {
                return;
            }
            if (MD.HBM.owns(aRegName) && (tLowerCase.endsWith("desh") || tLowerCase.endsWith("redalloy") || tLowerCase.endsWith("redstonealloy") || tLowerCase.startsWith("platedense"))) {
                return;
            }
            if (MD.SC2.owns(aRegName) && tLowerCase.endsWith("rubber")) {
                return;
            }
            if (aRegName.length() >= 26 && aRegName.startsWith("Gala") && tLowerCase.startsWith("plate")) {
                if (aRegName.equalsIgnoreCase("GalacticraftMars:item.itemBasicAsteroids")) {
                    return;
                }
                if (aRegName.equalsIgnoreCase("GalaxySpace:item.CompressedPlates")) {
                    return;
                }
                if (aRegName.equalsIgnoreCase("GalacticraftCore:item.basicItem")) {
                    return;
                }
                if (aRegName.equalsIgnoreCase("GalacticraftMars:item.null")) {
                    return;
                }
            }
            if (MD.RoC.owns(aRegName) && (tLowerCase.equals("pulpwood") || tLowerCase.equals("dustwood") || tLowerCase.equals("dustwheat"))) {
                ItemStack tTargetStack = null;
                ItemStack tFoundStack = null;
                for (ItemStack tStack : OreDictionary.getOres((String)aEvent.Name, (boolean)false)) {
                    if (ST.equal(tStack, aEvent.Ore)) {
                        tFoundStack = tStack;
                        continue;
                    }
                    tTargetStack = tStack;
                }
                if (tTargetStack != null) {
                    ST.set(tFoundStack, tTargetStack);
                    ST.set(aEvent.Ore, tTargetStack);
                }
                return;
            }
        }
        if (aEvent.Name.startsWith("log") && ST.block(aEvent.Ore) != CS.NB) {
            if (ST.meta_(aEvent.Ore) == Short.MAX_VALUE) {
                for (int i = 0; i < 16; ++i) {
                    OreDictManager.registerOreSafe("woodLog", ST.copyMeta(i, aEvent.Ore));
                }
            } else {
                OreDictManager.registerOreSafe("woodLog", aEvent.Ore);
            }
        }
        aEvent.Ore.stackSize = 1;
        this.mAllRegisteredOres.add(aEvent.Ore);
        if (!ST.isGT(aEvent.Ore) && aMod != MD.EtFu) {
            this.triggerVisibility(aEvent.Name);
        }
        if (aEvent.Name.contains(" ")) {
            OreDictManager.registerOreSafe(aEvent.Name.replaceAll(" ", ""), aEvent.Ore);
        } else {
            Collection<String> tReRegistrations;
            if (!(this.mIgnoredNames.contains(aEvent.Name) || aEvent.Name.contains("|") || aEvent.Name.contains("*") || aEvent.Name.contains(":") || aEvent.Name.contains(".") || aEvent.Name.contains("$"))) {
                if (this.mBufferedRegistrations == null) {
                    this.onOreRegistration2(aModID, aMod, aRegName, aEvent);
                } else {
                    this.mBufferedRegistrations.add(new OreDictEventContainer(aModID, aMod, aRegName, aEvent));
                }
            }
            if ((tReRegistrations = this.mReRegistrationMappings.get(aEvent.Name)) != null) {
                for (String tName : tReRegistrations) {
                    OreDictManager.registerOreSafe(tName, aEvent.Ore);
                }
            }
        }
        aEvent.Ore.stackSize = 1;
    }

    public void onOreRegistration2(String aModID, ModData aMod, String aRegName, OreDictionary.OreRegisterEvent aEvent) {
        OreDictPrefix aPrefix = null;
        OreDictMaterial aMaterial = null;
        if (aEvent.Ore.getItem() instanceof IOreDictOptimizedParsingItem) {
            aPrefix = ((IOreDictOptimizedParsingItem)aEvent.Ore.getItem()).getPrefix(ST.meta_(aEvent.Ore));
            aMaterial = ((IOreDictOptimizedParsingItem)aEvent.Ore.getItem()).getMaterial(ST.meta_(aEvent.Ore));
            if (aPrefix == null || aMaterial == null || !aEvent.Name.equals(aPrefix.mNameInternal + aMaterial.mNameInternal)) {
                aPrefix = null;
                aMaterial = null;
            }
        }
        if (this.mAutoBlackListedNames.contains(aEvent.Name) || this.mAutoBlackListedMods.contains(aModID)) {
            this.addToBlacklist_(aEvent.Ore);
        }
        this.addItemData_(aEvent.Ore, OreDictItemData.copy(this.mStringToItemDataMappings.get(aEvent.Name)));
        boolean aNotAlreadyRegisteredName = this.mAlreadyRegisteredNames.add(aEvent.Name);
        if (aPrefix == null) {
            aPrefix = OreDictPrefix.get(aEvent.Name);
        }
        if (aPrefix == null) {
            if (this.addKnownName(aEvent.Name)) {
                this.mUnknownNames.add(aEvent.Name);
            }
        } else {
            String tName;
            if (aPrefix == OP.nugget) {
                OreDictManager.registerOreSafe(aEvent.Name.replaceFirst(aPrefix.mNameInternal, OP.tiny.mNameInternal), aEvent.Ore);
            }
            if (aPrefix != aPrefix.mTargetRegistration) {
                OreDictManager.registerOreSafe(aEvent.Name.replaceFirst(aPrefix.mNameInternal, aPrefix.mTargetRegistration.mNameInternal), aEvent.Ore);
                return;
            }
            if (aPrefix.contains(TD.Prefix.UNIFICATABLE_RECIPES)) {
                this.addToBlacklist_(aEvent.Ore);
            }
            if ((tName = aEvent.Name.replaceFirst(aPrefix.mNameInternal, "")).length() > 0) {
                if (aPrefix == OP.dye) {
                    OreDictManager.registerOreSafe("dye", aEvent.Ore);
                }
                if (aPrefix == OP.flower) {
                    OreDictManager.registerOreSafe("flower", aEvent.Ore);
                }
                if (aPrefix == OP.plantGtFiber) {
                    OreDictManager.registerOreSafe((Object)OD.itemString, aEvent.Ore);
                }
                if (aMaterial == null) {
                    aMaterial = OreDictMaterial.MATERIAL_MAP.get(tName);
                }
                if (aPrefix == OP.ore || aPrefix.contains(TD.Prefix.MATERIAL_BASED)) {
                    if (aMaterial == null) {
                        aMaterial = OreDictMaterial.createAutoInvalidMaterial(tName);
                    }
                    if (aMaterial.contains(TD.Properties.AUTO_MATERIAL) && this.addKnownName(aEvent.Name)) {
                        this.mUnknownMaterials.add(aEvent.Name);
                    }
                    if (aMaterial != aMaterial.mTargetRegistration) {
                        OreDictManager.registerOreSafe(aPrefix.mNameInternal + aMaterial.mTargetRegistration.mNameInternal, aEvent.Ore);
                    }
                    if (aMaterial.contains(TD.Properties.AUTO_BLACKLIST)) {
                        this.addToBlacklist_(aEvent.Ore);
                    }
                    for (OreDictMaterial tReRegisteredMaterial : aMaterial.mReRegistrations) {
                        OreDictManager.registerOreSafe(aPrefix.mNameInternal + tReRegisteredMaterial.mNameInternal, aEvent.Ore);
                    }
                    if (!aMaterial.contains(TD.Properties.INVALID_MATERIAL)) {
                        if (aPrefix == OP.rockGt && aMaterial.contains(TD.Properties.STONE)) {
                            OreDictManager.registerOreSafe((Object)OD.itemRock, aEvent.Ore);
                        }
                        if (aPrefix != OP.ore && aPrefix.contains(TD.Prefix.STANDARD_ORE) && aMaterial.contains(TD.Properties.COMMON_ORE)) {
                            OreDictManager.registerOreSafe(OP.ore.mNameInternal + aMaterial.mNameInternal, aEvent.Ore);
                        }
                        if ((aMod == MD.TFC || aMod == MD.TFCP) && aPrefix.contains(TD.Prefix.UNIFICATABLE)) {
                            this.setTarget_(aPrefix, aMaterial, aEvent.Ore, true, true);
                        } else if (!(aPrefix != OP.gem || aMod != MD.RH || MD.ReC.mLoaded && aMaterial != MT.FluoriteBlack && ANY.CaF2.mToThis.contains(aMaterial))) {
                            this.setTarget_(aPrefix, aMaterial, aEvent.Ore, true, true);
                        } else if (aPrefix == OP.billet && aMod == MD.HBM) {
                            this.setTarget_(aPrefix, aMaterial, aEvent.Ore, true, true);
                        } else if (aPrefix == OP.ore) {
                            this.addItemData_(aEvent.Ore, aPrefix.dat(aMaterial));
                        } else if (aPrefix != OP.plateSteamcraft && aPrefix.contains(TD.Prefix.UNIFICATABLE)) {
                            this.setTarget_(aPrefix, aMaterial, aEvent.Ore, false, true);
                        }
                    }
                }
            }
        }
        IOreDictListenerEvent.OreDictRegistrationContainer tRegistration = new IOreDictListenerEvent.OreDictRegistrationContainer(aPrefix, aMaterial, aEvent.Name, aEvent.Ore, aEvent, aModID, aRegName, aNotAlreadyRegisteredName);
        for (IOreDictListenerEvent tListener : this.mGlobalOreDictListeners) {
            tListener.onOreRegistration(tRegistration);
        }
        if (aPrefix != null) {
            aPrefix.onOreRegistration(tRegistration);
        }
        this.mGlobalRegistrations.add(tRegistration);
    }

    public void addToBlacklist(ItemStack aStack) {
        if (ST.valid(aStack)) {
            this.addToBlacklist_(aStack);
        }
    }

    public void addToBlacklist_(ItemStack aStack) {
        OreDictItemData tData;
        if (this.sNoUnificationSet.add(new ItemStackContainer(aStack)) && (tData = this.getItemData_(aStack)) != null) {
            tData.mBlocked = true;
            tData.mBlackListed = true;
        }
    }

    public boolean isBlacklisted(ItemStack aStack) {
        return this.sNoUnificationSet.contains(aStack, true);
    }

    public boolean addTarget(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        return this.setTarget(aPrefix, aMaterial, aStack, false, false, false);
    }

    public boolean addTarget_(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        return this.setTarget_(aPrefix, aMaterial, aStack, false, false, false);
    }

    public boolean setTarget(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ModData aMod, Object aName, long aMeta, ModData aMod2) {
        ItemStack aStack = ST.make(aMod, aName.toString(), 1L, aMeta);
        if (aMod.mLoaded && aMod2.mLoaded && aStack == null) {
            CS.ERR.println("Item does not exist for Unification Target despite Mod being loaded: " + aMod.mID + ":" + aName);
        }
        return this.setTarget(aPrefix, aMaterial, aStack, true, false, true);
    }

    public boolean setTarget(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ModData aMod, Object aName, long aMeta) {
        ItemStack aStack = ST.make(aMod, aName.toString(), 1L, aMeta);
        if (aMod.mLoaded && aStack == null) {
            CS.ERR.println("Item does not exist for Unification Target despite Mod being loaded: " + aMod.mID + ":" + aName);
        }
        return this.setTarget(aPrefix, aMaterial, aStack, true, false, true);
    }

    public boolean setTarget(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        return this.setTarget(aPrefix, aMaterial, aStack, true, false, true);
    }

    public boolean setTarget_(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        return this.setTarget_(aPrefix, aMaterial, aStack, true, false, true);
    }

    public boolean setTarget(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack, boolean aOverwrite, boolean aAlreadyRegistered) {
        return this.setTarget(aPrefix, aMaterial, aStack, aOverwrite, aAlreadyRegistered, true);
    }

    public boolean setTarget_(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack, boolean aOverwrite, boolean aAlreadyRegistered) {
        return this.setTarget_(aPrefix, aMaterial, aStack, aOverwrite, aAlreadyRegistered, true);
    }

    public boolean setTarget(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack, boolean aOverwrite, boolean aAlreadyRegistered, boolean aIgnoreBlacklist) {
        if (aMaterial == null || aPrefix == null || ST.invalid(aStack) || ST.meta_(aStack) == Short.MAX_VALUE) {
            return false;
        }
        return this.setTarget_(aPrefix, aMaterial, aStack, aOverwrite, aAlreadyRegistered, aIgnoreBlacklist);
    }

    public boolean setTarget_(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack, boolean aOverwrite, boolean aAlreadyRegistered, boolean aIgnoreBlacklist) {
        ++this.isAddingOre;
        aStack = ST.amount(1L, aStack);
        aStack.setTagCompound(null);
        if (!aAlreadyRegistered) {
            this.registerOre_(aPrefix.mNameInternal + aMaterial.mNameInternal, aStack);
        }
        this.addAssociation_(aPrefix, aMaterial, aStack);
        if ((aIgnoreBlacklist || !this.isBlacklisted(aStack)) && (aOverwrite || ST.invalid(this.sName2StackMap.get(aPrefix.mNameInternal + aMaterial.mNameInternal)))) {
            this.sName2StackMap.put(aPrefix.mNameInternal + aMaterial.mNameInternal, aStack);
        }
        --this.isAddingOre;
        return true;
    }

    public ItemStack getFirstOre(Object aName, long aAmount) {
        if (UT.Code.stringInvalid(aName)) {
            return null;
        }
        ItemStack tStack = this.sName2StackMap.get(aName.toString());
        if (ST.valid(tStack)) {
            return ST.amount(aAmount, tStack);
        }
        return ST.size(aAmount, ST.copyFirst(OreDictManager.getOres(aName, false).toArray()));
    }

    public ItemStack getStack(Object aName, long aAmount) {
        return this.getStack(aName, null, aAmount, true, true);
    }

    public ItemStack getStack(Object aName, ItemStack aReplacement, long aAmount) {
        return this.getStack(aName, aReplacement, aAmount, true, true);
    }

    public ItemStack getStack(OreDictPrefix aPrefix, OreDictMaterial aMaterial, long aAmount) {
        return this.getStack(aPrefix, aMaterial, null, aAmount);
    }

    public ItemStack getStack(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aReplacement, long aAmount) {
        if (CS.GAPI.mStartedInit) {
            return this.getStack(aPrefix.mNameInternal + aMaterial.mNameInternal, aReplacement, aAmount, false, false);
        }
        ItemStack rStack = this.getStack(aPrefix.mNameInternal + aMaterial.mNameInternal, aReplacement, aAmount, false, false);
        if (rStack == null && aMaterial.mID >= 0 && aPrefix.isGeneratingItem(aMaterial) && !aPrefix.mRegisteredPrefixItems.isEmpty()) {
            return ST.make((Item)aPrefix.mRegisteredPrefixItems.get(0), aAmount, (long)aMaterial.mID);
        }
        return rStack;
    }

    public ItemStack getStack(Object aName, ItemStack aReplacement, long aAmount, boolean aMentionPossibleTypos, boolean aNoInvalidAmounts) {
        ItemStack rStack;
        if (aNoInvalidAmounts && aAmount < 1L) {
            return aReplacement;
        }
        if (!this.sName2StackMap.containsKey(aName.toString()) && aMentionPossibleTypos) {
            CS.ERR.println("Unknown Key for Unification, Typo? " + aName);
            int i = 0;
            for (StackTraceElement tElement : new Exception().getStackTrace()) {
                if (i++ >= 1 || i >= 11) break;
                CS.ERR.println("\tat " + tElement);
            }
        }
        if ((rStack = this.sName2StackMap.get(aName.toString())) == null) {
            rStack = this.getFirstOre(aName, aAmount);
        }
        return rStack == null ? aReplacement : ST.amount(aAmount, rStack);
    }

    public ItemStack[] setStackArray(boolean aUseBlackList, ItemStack ... aStacks) {
        for (int i = 0; i < aStacks.length; ++i) {
            aStacks[i] = this.getStack(aUseBlackList, aStacks[i]);
        }
        return aStacks;
    }

    public ItemStack[] setStackArray_(boolean aUseBlackList, ItemStack ... aStacks) {
        for (int i = 0; i < aStacks.length; ++i) {
            aStacks[i] = this.getStack_(aUseBlackList, aStacks[i]);
        }
        return aStacks;
    }

    public ItemStack[] getStackArray(boolean aUseBlackList, Object ... aStacks) {
        ItemStack[] rStacks = new ItemStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            rStacks[i] = this.getStack(aUseBlackList, (ItemStack)aStacks[i]);
        }
        return rStacks;
    }

    public ItemStack[] getStackArray_(boolean aUseBlackList, Object ... aStacks) {
        ItemStack[] rStacks = new ItemStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            rStacks[i] = this.getStack_(aUseBlackList, (ItemStack)aStacks[i]);
        }
        return rStacks;
    }

    public ItemStack setStack(boolean aUseBlackList, ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return aStack;
        }
        return this.setStack_(aUseBlackList, aStack);
    }

    public ItemStack setStack_(boolean aUseBlackList, ItemStack aStack) {
        ItemStack tStack = this.getStack_(aUseBlackList, aStack);
        if (tStack == null || ST.equal(aStack, tStack)) {
            return aStack;
        }
        aStack.func_150996_a(tStack.getItem());
        return ST.meta_(aStack, ST.meta_(tStack));
    }

    public ItemStack getStack(boolean aUseBlackList, ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return null;
        }
        return this.getStack_(aUseBlackList, aStack);
    }

    public ItemStack getStack_(boolean aUseBlackList, ItemStack aStack) {
        OreDictItemData tAssociation = this.getAssociation_(aStack, false);
        ItemStack rStack = null;
        if (tAssociation == null || aUseBlackList && tAssociation.mBlocked) {
            return ST.copy(aStack);
        }
        if (tAssociation.mUnificationTarget == null) {
            tAssociation.mUnificationTarget = this.sName2StackMap.get(tAssociation.toString());
        }
        if (ST.invalid(rStack = ST.amount(aStack.stackSize, tAssociation.mUnificationTarget))) {
            return ST.copy(aStack);
        }
        rStack.setTagCompound(aStack.getTagCompound());
        return rStack;
    }

    public boolean equal(boolean aUseBlackList, ItemStack aUnificatableStack, ItemStack aStackToCheckAgainst) {
        return this.equal(aUseBlackList, aUnificatableStack, aStackToCheckAgainst, true);
    }

    public boolean equal_(boolean aUseBlackList, ItemStack aUnificatableStack, ItemStack aStackToCheckAgainst) {
        return this.equal_(aUseBlackList, aUnificatableStack, aStackToCheckAgainst, true);
    }

    public boolean equal(boolean aUseBlackList, ItemStack aUnificatableStack, ItemStack aStackToCheckAgainst, boolean aIgnoreNBT) {
        if (ST.invalid(aUnificatableStack) || ST.invalid(aStackToCheckAgainst)) {
            return false;
        }
        return this.equal_(aUseBlackList, aUnificatableStack, aStackToCheckAgainst, aIgnoreNBT);
    }

    public boolean equal_(boolean aUseBlackList, ItemStack aUnificatableStack, ItemStack aStackToCheckAgainst, boolean aIgnoreNBT) {
        if (ST.equal(aUnificatableStack, aStackToCheckAgainst, aIgnoreNBT)) {
            return true;
        }
        OreDictItemData tAssociation = this.getAssociation_(aUnificatableStack, true);
        if (tAssociation == null || aUseBlackList && tAssociation.mBlocked) {
            return false;
        }
        if (tAssociation.mUnificationTarget == null) {
            tAssociation.mUnificationTarget = this.sName2StackMap.get(tAssociation.toString());
        }
        return ST.valid(tAssociation.mUnificationTarget) && ST.equal(tAssociation.mUnificationTarget, aStackToCheckAgainst, aIgnoreNBT);
    }

    public boolean addItemData(ItemStack aStack, OreDictItemData aData) {
        if (ST.invalid(aStack)) {
            return false;
        }
        if (this.getItemData_(aStack) == null) {
            return this.setItemData_(aStack, aData);
        }
        return false;
    }

    public boolean addItemData_(ItemStack aStack, OreDictItemData aData) {
        if (this.getItemData_(aStack) == null && aData != null) {
            return this.setItemData_(aStack, aData);
        }
        return false;
    }

    public boolean setItemData(ItemStack aStack, OreDictItemData aData) {
        if (ST.invalid(aStack) || aData == null) {
            return false;
        }
        return this.setItemData_(aStack, aData);
    }

    public boolean setItemData_(ItemStack aStack, OreDictItemData aData) {
        OreDictItemData tData = this.getAssociation_(aStack, false);
        if (tData != null && tData.mMaterial.mMaterial != MT.Wood && tData.mMaterial.mMaterial != ANY.Wood) {
            return false;
        }
        if (aStack.stackSize > 1) {
            if (aData.mMaterial != null) {
                aData.mMaterial.mAmount /= (long)aStack.stackSize;
            }
            for (OreDictMaterialStack tMaterial : aData.mByProducts) {
                tMaterial.mAmount /= (long)aStack.stackSize;
            }
            aStack = ST.amount(1L, aStack);
        }
        if (!aData.mBlackListed) {
            aData.mBlackListed = this.isBlacklisted(aStack);
        }
        if (!aData.mBlocked) {
            aData.mBlocked = aData.mBlackListed || ST.block(aStack) != CS.NB || FL.getFluid(aStack, true) != null || aStack.getItem() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) > 0;
        }
        this.sItemStack2DataMap.put(new ItemStackContainer(aStack), aData);
        if (aData.validMaterial()) {
            long tValidMaterialAmount = aData.mMaterial.mMaterial.contains(TD.Processing.UNRECYCLABLE) ? 0L : (aData.mMaterial.mAmount >= 0L ? aData.mMaterial.mAmount : 648648000L);
            for (OreDictMaterialStack tMaterial : aData.mByProducts) {
                tValidMaterialAmount += tMaterial.mMaterial.contains(TD.Processing.UNRECYCLABLE) ? 0L : (tMaterial.mAmount >= 0L ? tMaterial.mAmount : 648648000L);
            }
            if (tValidMaterialAmount < 648648000L && CS.COMPAT_IC2 != null) {
                CS.COMPAT_IC2.blacklist(aStack);
            }
        }
        if (!aData.validPrefix() || aData.mPrefix.contains(TD.Prefix.RECYCLABLE)) {
            IOreDictListenerRecyclable.OreDictRecyclingContainer tRegistration = new IOreDictListenerRecyclable.OreDictRecyclingContainer(aStack, aData);
            for (IOreDictListenerRecyclable tListener : this.mRecyclableOreDictListeners) {
                tListener.onRecycleableRegistration(tRegistration);
            }
            this.mRecyclableRegistrations.add(tRegistration);
        }
        return true;
    }

    public OreDictItemData getItemData(ItemStack aStack) {
        return this.getItemData(aStack, false);
    }

    public OreDictItemData getItemData_(ItemStack aStack) {
        return this.getItemData_(aStack, false);
    }

    public OreDictItemData getItemData(ItemStack aStack, boolean aAllowOverride) {
        if (ST.invalid(aStack)) {
            return null;
        }
        return this.getItemData_(aStack, aAllowOverride);
    }

    public OreDictItemData getItemData_(ItemStack aStack, boolean aAllowOverride) {
        OreDictItemData rData = null;
        if (aAllowOverride) {
            List<OreDictMaterialStack> tList;
            OreDictItemData tData = null;
            NBTTagCompound tNBT = aStack.getTagCompound();
            if (tNBT != null && tNBT.hasKey("gt.recycling.mats") && !(tList = OreDictMaterialStack.loadList("gt.recycling.mats", tNBT)).isEmpty()) {
                rData = new OreDictItemData(tList.remove(0), tList.toArray(CS.ZL_MS));
            }
            if (aStack.getItem() instanceof IOreDictItemDataOverrideItem) {
                tData = ((IOreDictItemDataOverrideItem)aStack.getItem()).getOreDictItemData(aStack);
            }
            if (tData != null) {
                return rData != null ? new OreDictItemData(tData, rData) : tData;
            }
            if (rData != null) {
                return rData;
            }
        }
        if ((rData = this.sItemStack2DataMap.get(new ItemStackContainer(aStack))) != null) {
            return rData;
        }
        rData = this.sItemStack2DataMap.get(new ItemStackContainer(aStack, 32767L));
        if (rData != null) {
            return rData;
        }
        if (aAllowOverride && aStack.getItem().isDamageable() && (rData = this.sItemStack2DataMap.get(new ItemStackContainer(aStack, 0L))) != null && rData.mUseVanillaDamage) {
            OreDictMaterialStack[] tByProducts = new OreDictMaterialStack[rData.mByProducts.length];
            for (int i = 0; i < tByProducts.length; ++i) {
                tByProducts[i] = OM.stack(rData.mByProducts[i].mMaterial, UT.Code.units(aStack.getMaxDamage() - aStack.getItemDamage(), aStack.getMaxDamage(), rData.mByProducts[i].mAmount, false));
            }
            rData = new OreDictItemData(OM.stack(rData.mMaterial.mMaterial, UT.Code.units(aStack.getMaxDamage() - aStack.getItemDamage(), aStack.getMaxDamage(), rData.mMaterial.mAmount, false)), tByProducts);
        }
        return rData;
    }

    public boolean addAssociation(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        if (aPrefix == null || aMaterial == null || ST.invalid(aStack)) {
            return false;
        }
        return this.addAssociation_(aPrefix, aMaterial, aStack);
    }

    public boolean addAssociation_(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        if (ST.meta_(aStack) == Short.MAX_VALUE) {
            for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
                this.setItemData_(ST.copyAmountAndMeta(1L, i, aStack), new OreDictItemData(aPrefix, aMaterial));
            }
        }
        return this.setItemData_(aStack, new OreDictItemData(aPrefix, aMaterial));
    }

    public OreDictItemData getAssociation(ItemStack aStack, boolean aOverwrite) {
        if (ST.invalid(aStack)) {
            return null;
        }
        return this.getAssociation_(aStack, aOverwrite);
    }

    public OreDictItemData getAssociation_(ItemStack aStack, boolean aOverwrite) {
        OreDictItemData rData = this.getItemData_(aStack, aOverwrite);
        return rData != null && rData.validData() && rData.mPrefix != OP.ore ? rData : null;
    }

    public static boolean isItemStackInstanceOf(ItemStack aStack, Object aName) {
        return UT.Code.stringValid(aName) && ST.valid(aStack) && OreDictManager.isItemStackInstanceOf_(aStack, aName);
    }

    public static boolean isItemStackInstanceOf_(ItemStack aStack, Object aName) {
        for (ItemStack tOreStack : OreDictManager.getOres(aName.toString(), false)) {
            if (!ST.equal(tOreStack, aStack, true)) continue;
            return true;
        }
        return false;
    }

    public static void registerOreSafe(Object aName, ItemStack aStack) {
        try {
            if (ST.valid(aStack)) {
                OreDictionary.registerOre((String)aName.toString(), (ItemStack)aStack);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public boolean registerOre(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return false;
        }
        return this.registerOre_(aPrefix, aMaterial, aStack);
    }

    public boolean registerOre_(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        return this.registerOre_(aPrefix.mNameInternal + aMaterial.mNameInternal, aStack);
    }

    public boolean registerOre(Object aName, ItemStack aStack) {
        if (UT.Code.stringInvalid(aName) || ST.invalid(aStack)) {
            return false;
        }
        return this.registerOre_(aName, aStack);
    }

    public boolean registerOre_(Object aName, ItemStack aStack) {
        if ("gt:delate" == aName) {
            if (MD.GT.mLoaded) {
                CR.delate(aStack);
            }
            return MD.GT.mLoaded;
        }
        if (Abstract_Mod.sStartedPostInit > 0) {
            throw new IllegalStateException("Late OreDict Registration using GT OreDict Utility. Only @Init and @PreInit are allowed for this when you use this Function instead of the Forge one.");
        }
        String tName = aName.toString();
        if (UT.Code.stringInvalid(tName)) {
            return false;
        }
        this.addKnownName(tName);
        List<ItemStack> tList = OreDictManager.getOres(tName, false);
        for (int i = 0; i < tList.size(); ++i) {
            if (!ST.equal(tList.get(i), aStack, true)) continue;
            return false;
        }
        ++this.isRegisteringOre;
        OreDictionary.registerOre((String)tName, (ItemStack)ST.amount(1L, aStack));
        --this.isRegisteringOre;
        return true;
    }

    public boolean isRegisteringOres() {
        return this.isRegisteringOre > 0;
    }

    public boolean isAddingOres() {
        return this.isAddingOre > 0;
    }

    private void registerUnificationEntries() {
        for (OreDictItemData tPrefixMaterial : this.sItemStack2DataMap.values()) {
            tPrefixMaterial.mUnificationTarget = null;
        }
        for (IOreDictListenerEvent.OreDictRegistrationContainer tEvent : this.mGlobalRegistrations) {
            if (tEvent.mPrefix == null || tEvent.mMaterial == null || !tEvent.mPrefix.contains(TD.Prefix.UNIFICATABLE) || tEvent.mMaterial.contains(TD.Properties.INVALID_MATERIAL)) continue;
            this.addAssociation_(tEvent.mPrefix, tEvent.mMaterial, tEvent.mStack);
            this.setTarget_(tEvent.mPrefix, tEvent.mMaterial, tEvent.mStack, !(tEvent.mStack.getItem() instanceof IPrefixItem) && !tEvent.mModName.equals(MD.GAPI_POST.mID) && this.mUnificationConfig.get((Object)("specialunificationtargets." + tEvent.mModName), tEvent.mEvent.Name, false), true);
        }
        Recipe.reInit();
    }

    public static List<ItemStack> getOres(OreDictPrefix aPrefix, OreDictMaterial aMaterial, boolean aTransformWildcardBlocksTo16) {
        return OreDictManager.getOres(aPrefix.mNameInternal + aMaterial.mNameInternal, aTransformWildcardBlocksTo16);
    }

    public static List<ItemStack> getOres(OreDictPrefix aPrefix, OreDictMaterialStack aMaterial, boolean aTransformWildcardBlocksTo16) {
        return OreDictManager.getOres(aPrefix.mNameInternal + aMaterial.mMaterial.mNameInternal, aTransformWildcardBlocksTo16);
    }

    public static List<ItemStack> getOres(Object aOreName, boolean aTransformWildcardBlocksTo16) {
        String aName = aOreName == null ? "" : aOreName.toString();
        ArrayListNoNulls<ItemStack> rList = new ArrayListNoNulls<ItemStack>();
        if (UT.Code.stringValid(aName)) {
            if (aTransformWildcardBlocksTo16) {
                List tList = OreDictionary.getOres((String)aName, (boolean)false);
                for (ItemStack tStack : tList) {
                    if (ST.meta_(tStack) == Short.MAX_VALUE && ST.block(tStack) != CS.NB) {
                        for (int i = 0; i < 16; ++i) {
                            rList.add(ST.make(tStack.getItem(), 1L, (long)i));
                        }
                        continue;
                    }
                    rList.add(tStack);
                }
            } else {
                rList.addAll(OreDictionary.getOres((String)aName, (boolean)false));
            }
        }
        return rList;
    }

    private static class OreDictEventContainer {
        protected final String mModID;
        protected final String mRegName;
        protected final OreDictionary.OreRegisterEvent mEvent;
        protected final ModData mMod;

        protected OreDictEventContainer(String aModID, ModData aMod, String aRegName, OreDictionary.OreRegisterEvent aEvent) {
            this.mRegName = aRegName;
            this.mModID = aModID;
            this.mEvent = aEvent;
            this.mMod = aMod;
        }
    }
}

