/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network.packets.data;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import gregapi.block.IBlockSyncData;
import gregapi.network.INetworkHandler;
import gregapi.network.packets.PacketCoordinates;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;

public class PacketSyncDataInteger
extends PacketCoordinates {
    public int mData = 0;

    public PacketSyncDataInteger(int aDecoderType) {
        super(aDecoderType);
    }

    public PacketSyncDataInteger(int aX, int aY, int aZ, int aData) {
        super(aX, aY, aZ);
        this.mData = aData;
    }

    public PacketSyncDataInteger(ChunkCoordinates aCoords, int aData) {
        super(aCoords);
        this.mData = aData;
    }

    @Override
    public byte getPacketIDOffset() {
        return -104;
    }

    @Override
    public ByteArrayDataOutput encode2(ByteArrayDataOutput aData) {
        aData.writeInt(this.mData);
        return aData;
    }

    @Override
    public PacketCoordinates decode2(int aX, int aY, int aZ, ByteArrayDataInput aData) {
        return new PacketSyncDataInteger(aX, aY, aZ, aData.readInt());
    }

    @Override
    public void process(IBlockAccess aWorld, INetworkHandler aNetworkHandler) {
        Block tBlock;
        if (aWorld != null && (tBlock = aWorld.getBlock(this.mX, this.mY, this.mZ)) instanceof IBlockSyncData) {
            ((IBlockSyncData)tBlock).receiveDataInteger(aWorld, this.mX, this.mY, this.mZ, this.mData, aNetworkHandler);
        }
    }
}

