/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network.packets;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import gregapi.network.INetworkHandler;
import gregapi.network.packets.PacketCoordinates;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PacketBlockEvent
extends PacketCoordinates {
    public byte mID = 0;
    public byte mData = 0;

    public PacketBlockEvent(int aDecoderType) {
        super(aDecoderType);
    }

    public PacketBlockEvent(int aX, int aY, int aZ, byte aID, byte aData) {
        super(aX, aY, aZ);
        this.mID = aID;
        this.mData = aData;
    }

    public PacketBlockEvent(ChunkCoordinates aCoords, byte aID, byte aData) {
        super(aCoords);
        this.mID = aID;
        this.mData = aData;
    }

    @Override
    public byte getPacketIDOffset() {
        return 112;
    }

    @Override
    public ByteArrayDataOutput encode2(ByteArrayDataOutput aData) {
        aData.writeByte((int)this.mID);
        aData.writeByte((int)this.mData);
        return aData;
    }

    @Override
    public PacketCoordinates decode2(int aX, int aY, int aZ, ByteArrayDataInput aData) {
        return new PacketBlockEvent(aX, aY, aZ, aData.readByte(), aData.readByte());
    }

    @Override
    public void process(IBlockAccess aWorld, INetworkHandler aNetworkHandler) {
        if (aWorld instanceof World) {
            aWorld.getBlock(this.mX, this.mY, this.mZ).onBlockEventReceived((World)aWorld, this.mX, this.mY, this.mZ, (int)this.mID, (int)this.mData);
        }
    }
}

