/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.ItemStackSet;
import gregapi.code.ObjectStack;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OD;
import gregapi.data.TC;
import gregapi.data.TD;
import gregapi.item.IItemEnergy;
import gregapi.item.IItemGTContainerTool;
import gregapi.item.IItemGTHandTool;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.energy.EnergyStat;
import gregapi.item.multiitem.tools.IToolStats;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;

public class MultiItemTool
extends MultiItem
implements IItemGTHandTool,
IItemGTContainerTool {
    public final HashMap<Short, IToolStats> mToolStats = new HashMap();
    public static ChunkCoordinates LAST_TOOL_COORDS_BEFORE_DAMAGE = null;

    public MultiItemTool(String aModID, String aUnlocalized) {
        super(aModID, aUnlocalized);
        this.setMaxStackSize(1);
    }

    public final ItemStack addTool(int aID, String aEnglish, String aToolTip, IToolStats aToolStats, Object ... aRandomParameters) {
        if (aToolTip == null) {
            aToolTip = "";
        }
        if (aID >= 0 && aID < 32766 && this.isUsableMeta((short)aID)) {
            LH.add(this.getUnlocalizedName() + "." + aID, aEnglish);
            LH.add(this.getUnlocalizedName() + "." + aID + ".tooltip", aToolTip);
            LH.add(this.getUnlocalizedName() + "." + (aID + 1), aEnglish + " (Empty)");
            LH.add(this.getUnlocalizedName() + "." + (aID + 1) + ".tooltip", "You need to recharge it");
            this.mToolStats.put((short)aID, aToolStats);
            this.mToolStats.put((short)(aID + 1), aToolStats);
            aToolStats.onStatsAddedToTool(this, aID);
            ItemStack rStack = ST.make(this, 1L, (long)aID);
            ArrayListNoNulls<TC.TC_AspectStack> tAspects = new ArrayListNoNulls<TC.TC_AspectStack>();
            for (Object tRandomParameter : aRandomParameters) {
                if (tRandomParameter instanceof TC.TC_AspectStack) {
                    ((TC.TC_AspectStack)tRandomParameter).addToAspectList(tAspects);
                    continue;
                }
                if (tRandomParameter instanceof ItemStackSet) {
                    ((ItemStackSet)tRandomParameter).add(rStack.copy());
                    continue;
                }
                OM.reg(tRandomParameter, rStack);
            }
            if (CS.COMPAT_TC != null) {
                CS.COMPAT_TC.registerThaumcraftAspectsToItem(rStack, tAspects, false);
            }
            return rStack;
        }
        return null;
    }

    public final ItemStack getToolWithStats(int aToolID, OreDictMaterial aPrimaryMaterial, OreDictMaterial aSecondaryMaterial) {
        return this.getToolWithStats(aToolID, 1, aPrimaryMaterial, aSecondaryMaterial);
    }

    public final ItemStack getToolWithStats(int aToolID, int aAmount, OreDictMaterial aPrimaryMaterial, OreDictMaterial aSecondaryMaterial) {
        return this.getToolWithStats(aToolID, aAmount, aPrimaryMaterial, aSecondaryMaterial, 0L, 0L);
    }

    public final ItemStack getToolWithStats(int aToolID, int aAmount, OreDictMaterial aPrimaryMaterial, OreDictMaterial aSecondaryMaterial, long aMaxCharge, long aVoltage) {
        return this.getToolWithStats(aToolID, aAmount, aPrimaryMaterial, aSecondaryMaterial, aMaxCharge, aVoltage, 0L);
    }

    public final ItemStack getToolWithStats(int aToolID, int aAmount, OreDictMaterial aPrimaryMaterial, OreDictMaterial aSecondaryMaterial, long aMaxCharge, long aVoltage, long aCharge) {
        ItemStack rStack = ST.make(this, (long)aAmount, (long)aToolID);
        IToolStats tToolStats = this.getToolStats(rStack);
        if (tToolStats != null) {
            NBTTagCompound tMainNBT = UT.NBT.make();
            NBTTagCompound tToolNBT = UT.NBT.make();
            if (aPrimaryMaterial != null) {
                if (aPrimaryMaterial.mID > 0) {
                    tToolNBT.setShort("a", aPrimaryMaterial.mID);
                } else {
                    tToolNBT.setString("b", aPrimaryMaterial.toString());
                }
                UT.NBT.setNumber(tToolNBT, "j", (long)((float)(aPrimaryMaterial.mToolDurability * 100L) * tToolStats.getMaxDurabilityMultiplier()));
            }
            if (aSecondaryMaterial != null) {
                if (aSecondaryMaterial.mID > 0) {
                    tToolNBT.setShort("c", aSecondaryMaterial.mID);
                } else {
                    tToolNBT.setString("d", aSecondaryMaterial.toString());
                }
            }
            if (aMaxCharge > 0L) {
                tToolNBT.setBoolean("e", true);
                UT.NBT.setNumber(tToolNBT, "f", aMaxCharge);
                UT.NBT.setNumber(tToolNBT, "g", aVoltage);
            }
            tMainNBT.setTag("GT.ToolStats", (NBTBase)tToolNBT);
            UT.NBT.set(rStack, tMainNBT);
            if (aCharge > 0L && aMaxCharge > 0L) {
                for (TagData tEnergyType : this.getEnergyTypes(rStack)) {
                    this.setEnergyStored(tEnergyType, rStack, Math.min(aCharge, aMaxCharge));
                }
            }
        }
        this.isItemStackUsable(rStack);
        return rStack;
    }

    public void onHarvestBlockEvent(ArrayList<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMeta, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null || ST.instaharvest(aBlock, aMeta) || !this.isItemStackUsable(aStack) || this.getDigSpeed(aStack, aBlock, aMeta) <= 0.0f) {
            this.doDamage(aStack, 0L, (EntityLivingBase)aPlayer, true);
            return;
        }
        long tDamage = tStats.convertBlockDrops(aDrops, aStack, aPlayer, aBlock, (MultiItemTool.getToolMaxDamage(aStack) - MultiItemTool.getToolDamage(aStack)) / (long)tStats.getToolDamagePerDropConversion(), aX, aY, aZ, aMeta, aFortune, aSilkTouch, aEvent);
        if (aBlock == Blocks.ice && !aDrops.isEmpty()) {
            aPlayer.worldObj.setBlockToAir(aX, aY, aZ);
        }
        if (WD.dimBTL(aPlayer.worldObj) && !MultiItemTool.getPrimaryMaterial(aStack).contains(TD.Properties.BETWEENLANDS)) {
            tDamage *= 4L;
        }
        this.doDamage(aStack, tDamage * (long)tStats.getToolDamagePerDropConversion(), (EntityLivingBase)aPlayer, true);
    }

    public boolean canCollectDropsDirectly(ItemStack aStack) {
        IToolStats tStats = this.getToolStats(aStack);
        return (tStats.canCollect() || MultiItemTool.getPrimaryMaterial(aStack).contains(TD.Properties.AUTO_COLLECTING) || MultiItemTool.getSecondaryMaterial(aStack).contains(TD.Properties.AUTO_COLLECTING)) && this.isItemStackUsable(aStack);
    }

    public boolean canCollectDropsDirectly(ItemStack aStack, Block aBlock, byte aMeta) {
        if (ST.instaharvest(aBlock, aMeta)) {
            return true;
        }
        return this.canCollectDropsDirectly(aStack) && this.getDigSpeed(aStack, aBlock, aMeta) > 0.0f;
    }

    public float onBlockBreakSpeedEvent(float aDefault, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMeta, PlayerEvent.BreakSpeed aEvent) {
        IToolStats tStats;
        if (aBlock == CS.NB || WD.bedrock(aBlock)) {
            return aDefault;
        }
        if (ST.instaharvest(aBlock, aMeta)) {
            return Float.MAX_VALUE;
        }
        if (OD.obsidian.is(ST.make(aBlock, 1L, (long)aMeta))) {
            aDefault *= (float)Math.max(1, MultiItemTool.getPrimaryMaterial((ItemStack)aStack).mToolQuality - 2);
        }
        return (tStats = this.getToolStats(aStack)) == null ? aDefault : tStats.getMiningSpeed(aBlock, aMeta, aDefault, aPlayer, aPlayer.worldObj, aX, aY, aZ);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null || !this.isItemStackUsable(aStack)) {
            return true;
        }
        if (CS.TOOL_SOUNDS) {
            UT.Sounds.play(tStats.getEntityHitSound(), 20, 1.0f, aEntity);
        }
        if (super.onLeftClickEntity(aStack, aPlayer, aEntity)) {
            return true;
        }
        if (aEntity.canAttackWithItem()) {
            boolean tIgnitesFire;
            int tImplosion = UT.NBT.getEnchantmentLevelImplosion(aStack);
            int tFireAspect = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)aPlayer);
            boolean bl = tIgnitesFire = !aEntity.isBurning() && tFireAspect > 0 && aEntity instanceof EntityLivingBase;
            if (tIgnitesFire) {
                aEntity.setFire(1);
            }
            if (aEntity.hitByEntity((Entity)aPlayer)) {
                if (tIgnitesFire) {
                    aEntity.extinguish();
                }
            } else {
                float tMagicDamage = tStats.getMagicDamageAgainstEntity(aEntity instanceof EntityLivingBase ? EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)aPlayer, (EntityLivingBase)((EntityLivingBase)aEntity)) : 0.0f, aEntity, aStack, aPlayer);
                float tDamage = tStats.getNormalDamageAgainstEntity((float)aPlayer.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue() + this.getToolCombatDamage(aStack), aEntity, aStack, aPlayer);
                if (tImplosion > 0 && UT.Entities.isExplosiveCreature(aEntity) && !EntityCreeper.class.isInstance(aEntity)) {
                    tMagicDamage += 1.5f * (float)tImplosion;
                }
                if (tDamage + tMagicDamage > 0.0f) {
                    boolean tCriticalHit;
                    boolean tRealHit = !aEntity.worldObj.isRemote || aEntity.hurtResistantTime <= 0;
                    boolean bl2 = tCriticalHit = aPlayer.fallDistance > 0.0f && !aPlayer.onGround && !aPlayer.isOnLadder() && !aPlayer.isInWater() && !aPlayer.isPotionActive(Potion.blindness) && aPlayer.ridingEntity == null && aEntity instanceof EntityLivingBase;
                    if (tCriticalHit && tDamage > 0.0f) {
                        tDamage = (float)((double)tDamage * 1.5);
                    }
                    float tFullDamage = (tDamage + tMagicDamage) * (float)CS.TFC_DAMAGE_MULTIPLIER;
                    DamageSource tSource = tStats.getDamageSource((EntityLivingBase)aPlayer, aEntity);
                    if (tStats.canPenetrate()) {
                        tSource.setDamageBypassesArmor();
                    }
                    if (MD.BTL.mLoaded && aEntity.getClass().getName().startsWith("thebetweenlands") && MultiItemTool.getPrimaryMaterial(aStack).contains(TD.Properties.BETWEENLANDS)) {
                        float tDamageToDeal = tFullDamage;
                        while (tDamageToDeal > 0.0f && aEntity.attackEntityFrom(tSource, Math.min(tDamageToDeal, 12.0f) / 0.3f)) {
                            if (!((tDamageToDeal -= 12.0f) > 0.0f)) continue;
                            aEntity.hurtResistantTime = 0;
                        }
                        tRealHit &= tDamageToDeal < tFullDamage;
                    } else {
                        tRealHit &= aEntity.attackEntityFrom(tSource, tFullDamage);
                    }
                    if (tRealHit) {
                        tStats.afterDealingDamage(tDamage, tMagicDamage, tFireAspect, tCriticalHit, aEntity, aStack, aPlayer);
                        this.doDamage(aStack, tStats.getToolDamagePerEntityAttack(), (EntityLivingBase)aPlayer, false);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && tStats.canBlock()) {
            aPlayer.setItemInUse(aStack, 72000);
        }
        return super.onItemRightClick(aStack, aWorld, aPlayer);
    }

    public EnumAction getItemUseAction(ItemStack aStack) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && tStats.canBlock()) {
            return EnumAction.block;
        }
        return EnumAction.none;
    }

    public int getMaxItemUseDuration(ItemStack aStack) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && tStats.canBlock()) {
            return 72000;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public final void getSubItems(Item var1, CreativeTabs aCreativeTab, List aList) {
        for (int i = 0; i < 32766; i += 2) {
            if (this.getToolStats(ST.make(this, 1L, (long)i)) == null) continue;
            ItemStack tStack = ST.make(this, 1L, (long)i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
    }

    @Override
    public void addAdditionalToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        long tMaxDamage = MultiItemTool.getToolMaxDamage(aStack);
        long tDamage = MultiItemTool.getToolDamage(aStack);
        OreDictMaterial tMat1 = MultiItemTool.getPrimaryMaterial(aStack);
        OreDictMaterial tMat2 = MultiItemTool.getSecondaryMaterial(aStack);
        IToolStats tStats = this.getToolStats(aStack);
        if (tMaxDamage > 0L && tStats != null) {
            if (tMat1 == MT.NULL) {
                aList.add(LH.Chat.WHITE + "Durability: x" + LH.Chat.GREEN + tStats.getMaxDurabilityMultiplier());
                aList.add(LH.Chat.WHITE + "Level: +" + LH.Chat.YELLOW + tStats.getBaseQuality());
                float tCombat = this.getToolCombatDamage(aStack);
                aList.add(LH.Chat.WHITE + "Melee Damage: +" + LH.Chat.BLUE + tCombat * (float)CS.TFC_DAMAGE_MULTIPLIER + LH.Chat.RED + " (= " + (CS.TFC_DAMAGE_MULTIPLIER > 1 ? (double)(tCombat + 1.0f) * ((double)CS.TFC_DAMAGE_MULTIPLIER / 2.0) + ")" : (tCombat + 1.0f) / 2.0f + " Hearts)"));
                aList.add(LH.Chat.WHITE + "Mining Speed: x" + LH.Chat.PINK + tStats.getSpeedMultiplier());
                if (tStats.canCollect()) {
                    aList.add(LH.Chat.DGRAY + LH.get("gt.lang.autocollect"));
                }
                if (tStats.canPenetrate()) {
                    aList.add(LH.Chat.DGRAY + LH.get("gt.lang.armorpenetrating"));
                }
            } else {
                aList.add(LH.Chat.WHITE + "Durability: " + LH.Chat.GREEN + UT.Code.makeString(tMaxDamage - tDamage) + " / " + UT.Code.makeString(tMaxDamage));
                aList.add(LH.Chat.WHITE + tMat1.getLocal() + LH.Chat.YELLOW + " Level: " + (tStats.getBaseQuality() + tMat1.mToolQuality));
                float tCombat = this.getToolCombatDamage(aStack);
                aList.add(LH.Chat.WHITE + "Melee Damage: " + LH.Chat.BLUE + "+" + tCombat * (float)CS.TFC_DAMAGE_MULTIPLIER + LH.Chat.RED + " (= " + (CS.TFC_DAMAGE_MULTIPLIER > 1 ? (double)(tCombat + 1.0f) * ((double)CS.TFC_DAMAGE_MULTIPLIER / 2.0) + ")" : (tCombat + 1.0f) / 2.0f + " Hearts)"));
                aList.add(LH.Chat.WHITE + "Mining Speed: " + LH.Chat.PINK + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * tMat1.mToolSpeed));
                aList.add(LH.Chat.WHITE + "Crafting Uses: " + LH.Chat.GREEN + UT.Code.divup(this.getEnergyStats(aStack) == null ? tMaxDamage - tDamage : Math.min(this.getEnergyStored(TD.Energy.EU, aStack), this.getEnergyCapacity(TD.Energy.EU, aStack)), tStats.getToolDamagePerContainerCraft()));
                if (MD.BTL.mLoaded && tMat1.contains(TD.Properties.BETWEENLANDS)) {
                    aList.add(LH.Chat.GREEN + LH.get("gt.lang.betweenlands.resist"));
                }
                if (MD.TF.mLoaded && tMat1.contains(TD.Properties.MAZEBREAKER)) {
                    if (this.canHarvestBlock(IL.TF_Mazestone.block(), aStack)) {
                        aList.add(LH.Chat.PINK + LH.get("gt.lang.twilightforest.mazestonebreaking"));
                    }
                    if (this.canHarvestBlock(IL.TF_Mazehedge.block(), aStack)) {
                        aList.add(LH.Chat.PINK + LH.get("gt.lang.twilightforest.mazehedgebreaking"));
                    }
                    if (this.canHarvestBlock(IL.TF_Towerwood.block(), aStack)) {
                        aList.add(LH.Chat.PINK + LH.get("gt.lang.twilightforest.towerwoodbreaking"));
                    }
                }
                if (tMat1.contains(TD.Properties.UNBURNABLE) || tMat2.contains(TD.Properties.UNBURNABLE)) {
                    aList.add(LH.Chat.GREEN + LH.get("gt.lang.unburnable"));
                }
                if (tStats.canCollect() || tMat1.contains(TD.Properties.AUTO_COLLECTING) || tMat2.contains(TD.Properties.AUTO_COLLECTING)) {
                    aList.add(LH.Chat.DGRAY + LH.get("gt.lang.autocollect"));
                }
                if (tStats.canPenetrate()) {
                    aList.add(LH.Chat.DGRAY + LH.get("gt.lang.armorpenetrating"));
                }
            }
        }
    }

    public static final OreDictMaterial getPrimaryMaterial(ItemStack aStack) {
        return MultiItemTool.getPrimaryMaterial(aStack, MT.NULL);
    }

    public static final OreDictMaterial getPrimaryMaterial(ItemStack aStack, OreDictMaterial aDefault) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null && (aNBT = aNBT.getCompoundTag("GT.ToolStats")) != null) {
            if (aNBT.hasKey("a")) {
                return OreDictMaterial.get(aNBT.getShort("a"), aDefault);
            }
            if (aNBT.hasKey("b")) {
                return OreDictMaterial.get(aNBT.getString("b"), aDefault);
            }
        }
        return aDefault;
    }

    public static final OreDictMaterial getSecondaryMaterial(ItemStack aStack) {
        return MultiItemTool.getSecondaryMaterial(aStack, MT.NULL);
    }

    public static final OreDictMaterial getSecondaryMaterial(ItemStack aStack, OreDictMaterial aDefault) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null && (aNBT = aNBT.getCompoundTag("GT.ToolStats")) != null) {
            if (aNBT.hasKey("c")) {
                return OreDictMaterial.get(aNBT.getShort("c"), aDefault);
            }
            if (aNBT.hasKey("d")) {
                return OreDictMaterial.get(aNBT.getString("d"), aDefault);
            }
        }
        return aDefault;
    }

    @Override
    public IItemEnergy getEnergyStats(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null && (aNBT = aNBT.getCompoundTag("GT.ToolStats")) != null && aNBT.getBoolean("e")) {
            return EnergyStat.makeTool(TD.Energy.EU, aNBT.getLong("f"), aNBT.getLong("g"), 64L, ST.make(this, 1L, (long)this.getUnusableMeta(aStack)), ST.make(this, 1L, (long)this.getUsableMeta(aStack)), ST.make(this, 1L, (long)this.getUsableMeta(aStack)));
        }
        return null;
    }

    public float getToolCombatDamage(ItemStack aStack) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return 0.0f;
        }
        return tStats.getBaseDamage() + (float)MultiItemTool.getPrimaryMaterial((ItemStack)aStack).mToolQuality;
    }

    public static final long getToolMaxDamage(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null) {
            if ((aNBT = aNBT.getCompoundTag("GT.ToolStats")).hasKey("j")) {
                return Math.max(1L, aNBT.getLong("j"));
            }
            return Math.max(1L, aNBT.getLong("MaxDamage"));
        }
        return 1L;
    }

    public static final long getToolDamage(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null) {
            if ((aNBT = aNBT.getCompoundTag("GT.ToolStats")).hasKey("k")) {
                return aNBT.getLong("k");
            }
            return aNBT.getLong("Damage");
        }
        return 0L;
    }

    public static final boolean setToolDamage(ItemStack aStack, long aDamage) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null) {
            UT.NBT.setNumber(aNBT.getCompoundTag("GT.ToolStats"), "k", aDamage);
            return true;
        }
        return false;
    }

    @Override
    public boolean destroyCheck(ItemStack aStack, EntityPlayer aPlayer) {
        if (MultiItemTool.getToolDamage(aStack) >= MultiItemTool.getToolMaxDamage(aStack)) {
            this.doDamage(aStack, 0L, (EntityLivingBase)aPlayer, true);
            return true;
        }
        return super.destroyCheck(aStack, aPlayer);
    }

    public boolean doDamage(ItemStack aStack, long aAmount) {
        return this.doDamage(aStack, aAmount, null, true);
    }

    public boolean doDamage(ItemStack aStack, long aAmount, EntityLivingBase aPlayer) {
        return this.doDamage(aStack, aAmount, aPlayer, true);
    }

    public boolean doDamage(ItemStack aStack, long aAmount, EntityLivingBase aPlayer, boolean aAllowBreaking) {
        if (UT.Entities.hasInfiniteItems(aPlayer)) {
            return true;
        }
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IItemEnergy tElectric = this.getEnergyStats(aStack);
        if (tElectric == null || CS.RNGSUS.nextInt(Math.max(10, MultiItemTool.getPrimaryMaterial((ItemStack)aStack).mToolQuality * 20)) == 0) {
            long tNewDamage = MultiItemTool.getToolDamage(aStack) + aAmount;
            MultiItemTool.setToolDamage(aStack, tNewDamage);
            if (aAllowBreaking && tNewDamage >= MultiItemTool.getToolMaxDamage(aStack)) {
                IToolStats tStats = this.getToolStats(aStack);
                if (tStats == null) {
                    ST.use((Entity)aPlayer, true, aStack);
                } else {
                    if (CS.TOOL_SOUNDS) {
                        if (aPlayer != null) {
                            UT.Sounds.send(MultiItemTool.getPrimaryMaterial(aStack) == MT.NULL ? tStats.getCraftingSound() : tStats.getBreakingSound(), (Entity)aPlayer);
                        } else {
                            UT.Sounds.play(MultiItemTool.getPrimaryMaterial(aStack) == MT.NULL ? tStats.getCraftingSound() : tStats.getBreakingSound(), 100, 1.0f, LAST_TOOL_COORDS_BEFORE_DAMAGE);
                        }
                    }
                    LAST_TOOL_COORDS_BEFORE_DAMAGE = null;
                    ItemStack tBroken = tStats.getBrokenItem(aStack);
                    if (ST.invalid(tBroken) || tBroken.stackSize <= 0) {
                        ST.use((Entity)aPlayer, true, aStack);
                    } else if (aPlayer instanceof EntityPlayer) {
                        if (tBroken.stackSize > 64) {
                            tBroken.stackSize = 64;
                        }
                        if (!aPlayer.worldObj.isRemote) {
                            ST.give((Entity)aPlayer, tBroken, false);
                        }
                        ST.use((Entity)aPlayer, true, aStack);
                    } else {
                        if (tBroken.stackSize > 64) {
                            tBroken.stackSize = 64;
                        }
                        ST.set(aStack, tBroken);
                    }
                }
            }
            return tElectric == null || this.useEnergy(TD.Energy.EU, aStack, aAmount, aPlayer, null, null, 0, 0, 0, true);
        }
        return this.useEnergy(TD.Energy.EU, aStack, aAmount, aPlayer, null, null, 0, 0, 0, true);
    }

    public float getDigSpeed(ItemStack aStack, Block aBlock, int aMeta) {
        IToolStats tStats;
        if (aBlock == CS.NB || WD.bedrock(aBlock)) {
            return 0.0f;
        }
        if (ST.instaharvest(aBlock, aMeta)) {
            return 10.0f;
        }
        if (!this.isItemStackUsable(aStack)) {
            return 0.0f;
        }
        if (aMeta > 15 && (aBlock == Blocks.dirt || aBlock == Blocks.grass || aBlock == Blocks.stone)) {
            aMeta = 0;
        }
        float tMultiplier = 1.0f;
        OreDictMaterial tMaterial = MultiItemTool.getPrimaryMaterial(aStack);
        if ((IL.TF_Mazestone.equal(aBlock) || IL.TF_Mazehedge.equal(aBlock) || IL.TF_Towerwood.equal(aBlock)) && tMaterial.contains(TD.Properties.MAZEBREAKER)) {
            tMultiplier *= 40.0f;
        }
        if ((tStats = this.getToolStats(aStack)) == null || tStats.getBaseQuality() + tMaterial.mToolQuality < UT.Code.bind4(aBlock.getHarvestLevel(aMeta))) {
            return 0.0f;
        }
        return tStats.getMiningSpeed(aBlock, (byte)aMeta) * Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * tMultiplier * tMaterial.mToolSpeed);
    }

    public final boolean canHarvestBlock(Block aBlock, ItemStack aStack) {
        return IL.TC_Block_Air.equal(aBlock) || MD.CARP.owns(aBlock) || this.getDigSpeed(aStack, aBlock, 0) > 0.0f;
    }

    public final int getHarvestLevel(ItemStack aStack, String aToolClass) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return -1;
        }
        int rValue = tStats.getBaseQuality() + MultiItemTool.getPrimaryMaterial((ItemStack)aStack).mToolQuality;
        return rValue < 15 ? rValue : Integer.MAX_VALUE;
    }

    public boolean onBlockDestroyed(ItemStack aStack, World aWorld, Block aBlock, int aX, int aY, int aZ, EntityLivingBase aPlayer) {
        if (ST.instaharvest(aBlock) || UT.Entities.hasInfiniteItems(aPlayer)) {
            return true;
        }
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return false;
        }
        if (CS.TOOL_SOUNDS) {
            UT.Sounds.play(tStats.getMiningSound(), 5, 1.0f, aX, aY, aZ);
        }
        String aRegName = ST.regName(aBlock);
        byte aMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        boolean rReturn = this.getDigSpeed(aStack, aBlock, aMeta) > 0.0f;
        double tDamage = (float)tStats.getToolDamagePerBlockBreak() * aBlock.getBlockHardness(aWorld, aX, aY, aZ);
        OreDictMaterial aMat1 = MultiItemTool.getPrimaryMaterial(aStack);
        if (WD.dimBTL(aWorld) && !aMat1.contains(TD.Properties.BETWEENLANDS)) {
            tDamage *= 4.0;
        }
        if (MD.TFC.owns(aRegName) || MD.TFCP.owns(aRegName)) {
            tDamage /= 4.0;
        } else {
            if (IL.TF_Mazestone.equal(aBlock)) {
                tDamage = aMat1.contains(TD.Properties.MAZEBREAKER) ? (tDamage /= 40.0) : (tDamage *= 16.0);
            }
            if (IL.TF_Mazehedge.equal(aBlock)) {
                tDamage = aMat1.contains(TD.Properties.MAZEBREAKER) ? (tDamage /= 40.0) : (tDamage *= 16.0);
                if (!aWorld.isRemote && UT.NBT.getEnchantmentLevel(Enchantment.silkTouch, aStack) <= 0) {
                    if (aPlayer instanceof EntityPlayer && this.canCollectDropsDirectly(aStack, aBlock, aMeta)) {
                        ST.give((Entity)aPlayer, IL.TF_Mazehedge.get(1L, new Object[0]), aWorld, aX, aY, aZ);
                    } else {
                        ST.drop(aWorld, (double)aX, (double)aY, (double)aZ, IL.TF_Mazehedge.get(1L, new Object[0]));
                    }
                }
            }
        }
        this.doDamage(aStack, UT.Code.roundUp(tDamage), aPlayer, false);
        return rReturn;
    }

    @Override
    public ItemStack getContainerItem(ItemStack aStack) {
        if (!this.isUsableMeta(aStack)) {
            return null;
        }
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return null;
        }
        if (CS.TOOL_SOUNDS) {
            UT.Sounds.play(tStats.getCraftingSound(), 200, 1.0f, LAST_TOOL_COORDS_BEFORE_DAMAGE);
        }
        aStack = ST.amount(1L, aStack);
        this.doDamage(aStack, tStats.getToolDamagePerContainerCraft(), null, true);
        return aStack.stackSize > 0 ? aStack : null;
    }

    @Override
    public boolean hasContainerItem(ItemStack aStack) {
        if (!this.isUsableMeta(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return false;
        }
        aStack = ST.amount(1L, aStack);
        this.doDamage(aStack, tStats.getToolDamagePerContainerCraft(), null, true);
        return aStack.stackSize > 0;
    }

    @Override
    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && aPlayer != null) {
            tStats.onToolCrafted(aStack, aPlayer);
        }
        super.onCreated(aStack, aWorld, aPlayer);
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        super.updateItemStack(aStack);
        this.destroyCheck(aStack, null);
    }

    @Override
    public boolean isItemStackUsable(ItemStack aStack) {
        if (aStack.stackSize <= 0) {
            return false;
        }
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT == null) {
            return true;
        }
        if (!this.isUsableMeta(aStack)) {
            aNBT.removeTag("ench");
            return false;
        }
        IToolStats tStats = this.getToolStatsInternal(aStack);
        if (tStats == null) {
            aNBT.removeTag("ench");
            return false;
        }
        OreDictMaterial aMaterial = MultiItemTool.getPrimaryMaterial(aStack);
        if (aMaterial == MT.Empty) {
            aNBT.removeTag("ench");
            return false;
        }
        if (!super.isItemStackUsable(aStack)) {
            aNBT.removeTag("ench");
            return false;
        }
        if (aNBT.hasKey("ench")) {
            return true;
        }
        aNBT.setTag("ench", (NBTBase)new NBTTagList());
        ArrayListNoNulls tEnchantments = new ArrayListNoNulls();
        if (tStats.isMiningTool()) {
            for (ObjectStack<Enchantment> tEnchantment : aMaterial.mEnchantmentTools) {
                tEnchantments.add(new ObjectStack(tEnchantment.mObject, tEnchantment.mAmount));
            }
        }
        if (tStats.isWeapon()) {
            for (ObjectStack<Enchantment> tEnchantment : aMaterial.mEnchantmentWeapons) {
                tEnchantments.add(new ObjectStack(tEnchantment.mObject, tEnchantment.mAmount));
            }
        }
        if (tStats.isRangedWeapon()) {
            for (ObjectStack<Enchantment> tEnchantment : aMaterial.mEnchantmentRanged) {
                tEnchantments.add(new ObjectStack(tEnchantment.mObject, tEnchantment.mAmount));
            }
        }
        Enchantment[] tEnchants = tStats.getEnchantments(aStack, aMaterial);
        int[] tLevels = tStats.getEnchantmentLevels(aStack, aMaterial);
        for (int i = 0; i < tEnchants.length; ++i) {
            if (tLevels[i] <= 0) continue;
            boolean bl = true;
            for (ObjectStack objectStack : tEnchantments) {
                if (objectStack.mObject != tEnchants[i]) continue;
                objectStack.mAmount = 1L + Math.max(objectStack.mAmount, (long)tLevels[i]);
                bl = false;
                break;
            }
            if (!bl) continue;
            tEnchantments.add(new ObjectStack<Enchantment>(tEnchants[i], tLevels[i]));
        }
        for (ObjectStack objectStack : tEnchantments) {
            UT.NBT.addEnchantment(aStack, (Enchantment)objectStack.mObject, objectStack.amountShort());
        }
        return true;
    }

    public boolean isUsableMeta(short aMeta) {
        return aMeta % 2 == 0;
    }

    public boolean isUsableMeta(ItemStack aStack) {
        return this.isUsableMeta(ST.meta(aStack));
    }

    public short getUsableMeta(short aMeta) {
        return (short)(aMeta - aMeta % 2);
    }

    public short getUsableMeta(ItemStack aStack) {
        return this.getUsableMeta(ST.meta(aStack));
    }

    public short getUnusableMeta(short aMeta) {
        return (short)(aMeta + 1 - aMeta % 2);
    }

    public short getUnusableMeta(ItemStack aStack) {
        return this.getUnusableMeta(ST.meta(aStack));
    }

    public int getRenderPasses(int aMetaData) {
        IToolStats tStats = this.getToolStatsInternal(aMetaData);
        if (tStats != null) {
            return tStats.getRenderPasses() + 2;
        }
        return 2;
    }

    public int getColorFromItemStack(ItemStack aStack, int aRenderPass) {
        IToolStats tStats = this.getToolStatsInternal(aStack);
        if (tStats != null) {
            return UT.Code.getRGBaInt(tStats.getRGBa(aStack, aRenderPass));
        }
        return 0xFFFFFF;
    }

    public IIcon getIconIndex(ItemStack aStack) {
        return this.getIcon(aStack, 0);
    }

    public IIcon getIconFromDamageForRenderPass(int aMetaData, int aRenderPass) {
        return this.getIconFromDamage(aMetaData);
    }

    @Override
    public IIcon getIconFromDamage(int aMetaData) {
        return this.getIconIndex(ST.make(this, 1L, (long)aMetaData));
    }

    public IIcon getIcon(ItemStack aStack, int aRenderPass) {
        return this.getIcon(aStack, aRenderPass, null, null, 0);
    }

    public IIcon getIcon(ItemStack aStack, int aRenderPass, EntityPlayer aPlayer, ItemStack aUsedStack, int aUseRemaining) {
        IToolStats tStats = this.getToolStatsInternal(aStack);
        if (tStats == null) {
            return Textures.ItemIcons.VOID.getIcon(0);
        }
        if (aRenderPass < tStats.getRenderPasses()) {
            IIcon rIcon = tStats.getIcon(aStack, aRenderPass);
            return rIcon == null ? Textures.ItemIcons.VOID.getIcon(0) : rIcon;
        }
        if (aPlayer == null) {
            IItemEnergy tElectric;
            if ((aRenderPass -= tStats.getRenderPasses()) == 0) {
                long tDamage = MultiItemTool.getToolDamage(aStack);
                long tMaxDamage = MultiItemTool.getToolMaxDamage(aStack);
                if (tMaxDamage <= 0L) {
                    return Textures.ItemIcons.VOID.getIcon(0);
                }
                if (tDamage <= 0L) {
                    return Textures.ItemIcons.DURABILITY_BAR[8].getIcon(0);
                }
                if (tDamage >= tMaxDamage) {
                    return Textures.ItemIcons.DURABILITY_BAR[0].getIcon(0);
                }
                return Textures.ItemIcons.DURABILITY_BAR[(int)Math.max(0L, Math.min(7L, (tMaxDamage - tDamage) * 8L / tMaxDamage))].getIcon(0);
            }
            if (aRenderPass == 1 && (tElectric = this.getEnergyStats(aStack)) != null) {
                long tStored = tElectric.getEnergyStored(TD.Energy.EU, aStack);
                long tCapacity = tElectric.getEnergyCapacity(TD.Energy.EU, aStack);
                if (tStored <= 0L) {
                    return Textures.ItemIcons.ENERGY_BAR[0].getIcon(0);
                }
                if (tStored >= tCapacity) {
                    return Textures.ItemIcons.ENERGY_BAR[8].getIcon(0);
                }
                return Textures.ItemIcons.ENERGY_BAR[7 - (int)Math.max(0L, Math.min(6L, (tCapacity - tStored) * 7L / tCapacity))].getIcon(0);
            }
        }
        return Textures.ItemIcons.VOID.getIcon(0);
    }

    public IToolStats getToolStats(ItemStack aStack) {
        this.isItemStackUsable(aStack);
        return this.getToolStatsInternal(aStack);
    }

    public IToolStats getToolStatsInternal(ItemStack aStack) {
        return aStack == null ? null : this.getToolStatsInternal(ST.meta_(aStack));
    }

    public IToolStats getToolStatsInternal(int aDamage) {
        return this.mToolStats.get((short)aDamage);
    }

    @Override
    public final boolean doesContainerItemLeaveCraftingGrid(ItemStack aStack) {
        return false;
    }

    @Override
    public final int getItemStackLimit(ItemStack aStack) {
        return 1;
    }

    public boolean isFull3D() {
        return true;
    }

    public int getSpriteNumber() {
        return 1;
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aIconRegister) {
    }

    public boolean hasEffect(ItemStack aStack) {
        return false;
    }

    public boolean hasEffect(ItemStack aStack, int aRenderPass) {
        return false;
    }

    @Override
    public int getItemEnchantability() {
        return 0;
    }

    @Override
    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    @Override
    public boolean getIsRepairable(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    @Override
    public Long[] getFluidContainerStats(ItemStack aStack) {
        return null;
    }
}

