/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.tree;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.tree.BlockBaseTree;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.data.OP;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IOxygenReliantBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="micdoodle8.mods.galacticraft.api.block.IOxygenReliantBlock", modid="GalacticraftCore")})
public abstract class BlockBaseLeaves
extends BlockBaseTree
implements IShearable,
IOxygenReliantBlock {
    public final Block mSaplings;
    public final Block[] mLogs;
    public final byte[] mLogMetas;

    public BlockBaseLeaves(Class<? extends ItemBlock> aItemClass, String aNameInternal, Material aMaterial, Block.SoundType aSoundType, long aMaxMeta, IIconContainer[] aIcons, Block aSaplings, Block[] aLogs, byte[] aLogMetas) {
        super(aItemClass, aNameInternal, aMaterial, aSoundType, Math.min(8L, aMaxMeta), aIcons);
        this.setCreativeTab(CreativeTabs.tabDecorations);
        this.mSaplings = aSaplings;
        this.mLogMetas = aLogMetas;
        this.mLogs = aLogs;
        this.setHardness(0.2f);
    }

    @Override
    public boolean isFireSource(World aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return false;
    }

    @Override
    public int getFlammability(byte aMeta) {
        return 30;
    }

    @Override
    public int getFireSpreadSpeed(byte aMeta) {
        return 60;
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return "sword";
    }

    @Override
    public int damageDropped(int aMeta) {
        return aMeta & 7;
    }

    @Override
    public int getDamageValue(World aWorld, int aX, int aY, int aZ) {
        return WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 7;
    }

    @Override
    public Item getItemDropped(int aMeta, Random aRandom, int aFortune) {
        return Item.getItemFromBlock((Block)this.mSaplings);
    }

    @Override
    public float getBlockHardness(World aWorld, int aX, int aY, int aZ) {
        return Blocks.leaves.getBlockHardness(aWorld, aX, aY, aZ);
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return Blocks.leaves.getExplosionResistance(null);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid(int aMeta, byte aSide) {
        return false;
    }

    public boolean isLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return true;
    }

    public boolean isShearable(ItemStack aItem, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return true;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return UT.Code.bindStack(OP.treeLeaves.mDefaultStackSize);
    }

    @Override
    public IIcon getIcon(int aSide, int aMeta) {
        return this.mIcons[aMeta & 7 | (Blocks.leaves.isOpaqueCube() ? 8 : 0)].getIcon(0);
    }

    public ArrayList<ItemStack> onSheared(ItemStack aItem, IBlockAccess aWorld, int aX, int aY, int aZ, int aFortune) {
        return ST.arraylist(ST.make(this, 1L, (long)(WD.meta(aWorld, aX, aY, aZ) & 7)));
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return MD.TFC.mLoaded || MD.TFCP.mLoaded ? null : super.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
    }

    public void onOxygenAdded(World aWorld, int aX, int aY, int aZ) {
    }

    public void onOxygenRemoved(World aWorld, int aX, int aY, int aZ) {
        if (!aWorld.isRemote) {
            aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 201 + CS.RNGSUS.nextInt(100));
            return;
        }
    }

    @Override
    public void onBlockAdded2(World aWorld, int aX, int aY, int aZ) {
        if (!aWorld.isRemote && !WD.oxygen(aWorld, aX, aY, aZ)) {
            aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 201 + CS.RNGSUS.nextInt(100));
            return;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        Block aBlock = aWorld.getBlock(aX, aY, aZ);
        return !aBlock.isOpaqueCube() && (!Blocks.leaves.isOpaqueCube() || !(aBlock instanceof BlockBaseLeaves));
    }

    public void beginLeavesDecay(World aWorld, int aX, int aY, int aZ) {
        if (aWorld.isRemote) {
            return;
        }
        if (!WD.oxygen(aWorld, aX, aY, aZ)) {
            aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 201 + CS.RNGSUS.nextInt(100));
            return;
        }
        if (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) < 8) {
            return;
        }
        aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 10 + CS.RNGSUS.nextInt(CS.SLOW_LEAF_DECAY ? 6400 : 100));
    }

    @Override
    public void updateTick2(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        if (aWorld.isRemote) {
            return;
        }
        if (!WD.oxygen(aWorld, aX, aY, aZ)) {
            aWorld.setBlockToAir(aX, aY, aZ);
            return;
        }
        byte aMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        if (aMeta < 8) {
            return;
        }
        int tRangeSide = this.getLeavesRangeSide(aMeta);
        int tRangeYNeg = this.getLeavesRangeYNeg(aMeta);
        int tRangeYPos = this.getLeavesRangeYPos(aMeta);
        for (int i = -tRangeSide; i <= tRangeSide; ++i) {
            for (int j = -tRangeYNeg; j <= tRangeYPos; ++j) {
                for (int k = -tRangeSide; k <= tRangeSide; ++k) {
                    if (this.mLogs[aMeta & 7] != WD.block((IBlockAccess)aWorld, aX + i, aY + j, aZ + k) || this.mLogMetas[aMeta & 7] != (WD.meta((IBlockAccess)aWorld, aX + i, aY + j, aZ + k) & 3)) continue;
                    return;
                }
            }
        }
        if (!MD.TFC.mLoaded && !MD.TFCP.mLoaded || aRandom.nextInt(4) == 0) {
            this.dropBlockAsItem(aWorld, aX, aY, aZ, aMeta, 0);
        }
        aWorld.setBlockToAir(aX, aY, aZ);
    }

    public ArrayList<ItemStack> getDrops(World aWorld, int aX, int aY, int aZ, int aMeta, int aFortune) {
        ArrayListNoNulls<ItemStack> rDrops = ST.arraylist(new ItemStack[0]);
        int tChance = 50;
        if (aFortune > 0 && (tChance -= 5 << aFortune) < 5) {
            tChance = 5;
        }
        if (CS.RNGSUS.nextInt(tChance) == 0) {
            rDrops.add(ST.make(this.getItemDropped(aMeta, CS.RNGSUS, aFortune), 1L, (long)this.damageDropped(aMeta)));
        }
        return rDrops;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlockColor() {
        return ColorizerFoliage.getFoliageColor((double)0.5, (double)1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(int p_149741_1_) {
        return ColorizerFoliage.getFoliageColorBasic();
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess aWorld, int aX, int aY, int aZ) {
        int l = 0;
        int i1 = 0;
        int j1 = 0;
        for (int k1 = -1; k1 <= 1; ++k1) {
            for (int l1 = -1; l1 <= 1; ++l1) {
                int i2 = aWorld.getBiomeGenForCoords(aX + l1, aZ + k1).getBiomeFoliageColor(aX + l1, aY, aZ + k1);
                l += (i2 & 0xFF0000) >> 16;
                i1 += (i2 & 0xFF00) >> 8;
                j1 += i2 & 0xFF;
            }
        }
        return (l / 9 & 0xFF) << 16 | (i1 / 9 & 0xFF) << 8 | j1 / 9 & 0xFF;
    }
}

