/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.misc;

import gregapi.block.BlockBaseMeta;
import gregapi.block.ItemBlockBase;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.data.RM;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.IRenderedBlock;
import gregapi.render.IRenderedBlockObject;
import gregapi.render.ITexture;
import gregapi.render.RendererBlockTextured;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import mods.railcraft.common.carts.EntityTunnelBore;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockBaseLilyPad
extends BlockBaseMeta
implements IPlantable,
IRenderedBlock {
    public BlockBaseLilyPad(Class<? extends ItemBlock> aItemClass, String aNameInternal, Material aMaterial, Block.SoundType aSoundType, long aMaxMeta, IIconContainer[] aIcons) {
        super(ItemBlockBase.class, aNameInternal, Material.plants, soundTypeGrass, aMaxMeta, aIcons);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.015625f, 1.0f);
        this.setCreativeTab(CreativeTabs.tabDecorations);
        RM.chisel(aNameInternal, ST.make(this, 1L, 32767L));
        if (MD.RC.mLoaded) {
            try {
                EntityTunnelBore.addMineableBlock((Block)this);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("forester", ST.make(this, 1L, 32767L));
        }
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return "sword";
    }

    @Override
    public int getHarvestLevel(int aMeta) {
        return 0;
    }

    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB aAABB, List aList, Entity aEntity) {
        if (!(aEntity instanceof EntityBoat)) {
            super.addCollisionBoxesToList(aWorld, aX, aY, aZ, aAABB, aList, aEntity);
        }
    }

    public boolean canBlockStay(World aWorld, int aX, int aY, int aZ) {
        return aY >= 0 && aY < 256 && aWorld.getBlock(aX, aY - 1, aZ).getMaterial() == Material.water && aWorld.getBlockMetadata(aX, aY - 1, aZ) == 0;
    }

    public boolean canPlaceBlockAt(World aWorld, int aX, int aY, int aZ) {
        return super.canPlaceBlockAt(aWorld, aX, aY, aZ) && this.canBlockStay(aWorld, aX, aY, aZ);
    }

    @Override
    public boolean checkNoEntityCollision(World aWorld, int aX, int aY, int aZ, byte aMeta, Entity aExceptThisOne) {
        return true;
    }

    @Override
    public void onNeighborBlockChange2(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        this.checkAndDropBlock(aWorld, aX, aY, aZ);
    }

    @Override
    public void updateTick2(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        this.checkAndDropBlock(aWorld, aX, aY, aZ);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    @Override
    public boolean isSideSolid(int aMeta, byte aSide) {
        return false;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    public EnumPlantType getPlantType(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return EnumPlantType.Water;
    }

    public Block getPlant(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return WD.meta(aWorld, aX, aY, aZ);
    }

    @Override
    public float getBlockHardness(World aWorld, int aX, int aY, int aZ) {
        return Blocks.waterlily.getBlockHardness(aWorld, aX, aY, aZ);
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return Blocks.waterlily.getExplosionResistance(null);
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return 64;
    }

    public void checkAndDropBlock(World aWorld, int aX, int aY, int aZ) {
        if (!this.canBlockStay(aWorld, aX, aY, aZ)) {
            this.dropBlockAsItem(aWorld, aX, aY, aZ, WD.meta((IBlockAccess)aWorld, aX, aY, aZ), 0);
            aWorld.setBlock(aX, aY, aZ, BlockBaseLilyPad.getBlockById((int)0), 0, 2);
        }
    }

    @Override
    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        MovingObjectPosition tPos = WD.getMOP(aWorld, aPlayer, true);
        if (tPos == null || tPos.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
            return aStack;
        }
        int aX = tPos.blockX;
        int aY = tPos.blockY;
        int aZ = tPos.blockZ;
        if (!aWorld.canMineBlock(aPlayer, aX, aY, aZ) || !aPlayer.canPlayerEdit(aX, aY, aZ, tPos.sideHit, aStack)) {
            return aStack;
        }
        if (aWorld.getBlock(aX, aY, aZ).getMaterial() == Material.water && WD.meta((IBlockAccess)aWorld, aX, aY, aZ) == 0 && aWorld.isAirBlock(aX, aY + 1, aZ)) {
            aWorld.setBlock(aX, aY + 1, aZ, (Block)this, (int)ST.meta_(aStack), 3);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                --aStack.stackSize;
            }
        }
        return aStack;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return AxisAlignedBB.getBoundingBox((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)((float)aY + 0.015625f), (double)(aZ + 1));
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return AxisAlignedBB.getBoundingBox((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)((float)aY + 0.015625f), (double)(aZ + 1));
    }

    public void setBlockBoundsBasedOnState(IBlockAccess aWorld, int aX, int aY, int aZ) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.015625f, 1.0f);
    }

    @Override
    public IIcon getIcon(int aSide, int aMeta) {
        return this.mIcons[aMeta % this.mIcons.length].getIcon(0);
    }

    public int getRenderType() {
        return RendererBlockTextured.INSTANCE == null ? 23 : RendererBlockTextured.INSTANCE.mRenderID;
    }

    @Override
    public ITexture getTexture(int aRenderPass, byte aSide, ItemStack aStack) {
        return CS.SIDES_VERTICAL[aSide] ? BlockTextureDefault.get(this.mIcons[ST.meta_(aStack) % this.mIcons.length]) : null;
    }

    @Override
    public ITexture getTexture(int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return CS.SIDES_VERTICAL[aSide] ? BlockTextureDefault.get(this.mIcons[WD.meta(aWorld, aX, aY, aZ) % this.mIcons.length]) : null;
    }

    @Override
    public boolean setBlockBounds(int aRenderPass, ItemStack aStack) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.015625f, 1.0f);
        return true;
    }

    @Override
    public boolean setBlockBounds(int aRenderPass, IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.015625f, 1.0f);
        return true;
    }

    @Override
    public int getRenderPasses(ItemStack aStack) {
        return 1;
    }

    @Override
    public int getRenderPasses(IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return 1;
    }

    @Override
    public IRenderedBlockObject passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return null;
    }

    @Override
    public IRenderedBlockObject passRenderingToObject(ItemStack aStack) {
        return null;
    }

    @Override
    public boolean usesRenderPass(int aRenderPass, ItemStack aStack) {
        return true;
    }

    @Override
    public boolean usesRenderPass(int aRenderPass, IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return true;
    }
}

