/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tanks;

import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityPump
extends TileEntityBase09FacingSingle
implements IFluidHandler,
ITileEntityEnergy,
ITileEntityRunningActively,
ITileEntitySwitchableOnOff {
    protected boolean mStopped = false;
    protected boolean mActive = false;
    protected long mEnergy = 0L;
    protected long mInput = 32L;
    protected long mActiveData = 0L;
    protected long mNextCheck = 0L;
    protected byte mActiveState = 0;
    protected byte mExplosionPrevention = 0;
    protected byte mDir = 0;
    protected TagData mEnergyType = TD.Energy.RU;
    protected FluidTankGT mTank = new FluidTankGT();
    public ArrayList<ChunkCoordinates> mCheckList = new ArrayList();
    public LinkedList<ChunkCoordinates> mPumpList = new LinkedList();
    public HashSetNoNulls<ChunkCoordinates> mChecked = new HashSetNoNulls();
    public HashSetNoNulls<Block> mPumpedFluids = new HashSetNoNulls();
    public static IIconContainer[] sColoreds;
    public static IIconContainer[] sOverlays;
    public static IIconContainer[] sOverlaysActive;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mStopped = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.active")) {
            this.mActive = aNBT.func_74767_n("gt.active");
        }
        if (aNBT.func_74764_b("gt.active.data")) {
            this.mActiveData = aNBT.func_74763_f("gt.active.data");
        }
        if (aNBT.func_74764_b("gt.input")) {
            this.mInput = aNBT.func_74763_f("gt.input");
        }
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyType = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
        this.mTank.readFromNBT(aNBT, "gt.tank");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.active.data", this.mActiveData);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
        this.mTank.writeToNBT(aNBT, "gt.tank");
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.tooltip.pump.1"));
        LH.addEnergyToolTips(this, aList, this.mEnergyType, null, LH.get("gt.lang.face.back"), null);
        aList.add(LH.Chat.ORANGE + LH.get("gt.tooltip.pump.2"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.tooltip.pump.3"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (this.mTank.has()) {
                for (byte tSide : CS.ALL_SIDES_VALID_BUT_AXIS[this.mFacing]) {
                    if (!this.mTank.has()) break;
                    FL.move(this.mTank, this.getAdjacentTileEntity(tSide));
                }
            }
            --this.mNextCheck;
            if (this.mStopped || this.mEnergy < 8192L || this.mTank.has()) {
                this.mActive = false;
            } else {
                this.mActive = true;
                if (this.mCheckList.isEmpty()) {
                    if (this.mNextCheck < 0L) {
                        this.scanForFluid(this.getOffsetX(this.mFacing), this.getOffsetY(this.mFacing), this.getOffsetZ(this.mFacing));
                        this.mNextCheck = 3000L;
                    } else {
                        this.mIgnoreUnloadedChunks = false;
                        if (this.mPumpList.isEmpty()) {
                            if (this.mNextCheck > 20L) {
                                this.mNextCheck = 20L;
                            }
                        } else if (!this.drainFluid(this.mPumpList.removeLast())) {
                            this.mNextCheck = 0L;
                        }
                        this.mIgnoreUnloadedChunks = true;
                    }
                } else {
                    this.scanForFluid(this.getOffsetX(this.mFacing), this.getOffsetZ(this.mFacing));
                    this.mNextCheck = 3000L;
                }
            }
            if (this.mTimer % 600L == 5L) {
                if (this.mActiveData != 0L) {
                    this.doDefaultStructuralChecks();
                } else if (this.mExplosionPrevention > 0) {
                    this.mExplosionPrevention = (byte)(this.mExplosionPrevention - 1);
                }
            }
        }
    }

    private void scanForFluid(int aX, int aZ) {
        ChunkCoordinates[] tNeedsToBeChecked = this.mCheckList.toArray(CS.ZL_COORDS);
        this.mCheckList.clear();
        for (ChunkCoordinates tPos : tNeedsToBeChecked) {
            if (this.mDir != 0 && this.mPumpedFluids.contains(this.getBlock(tPos.field_71574_a, tPos.field_71572_b + this.mDir, tPos.field_71573_c))) {
                this.mPumpList = new LinkedList();
                this.mCheckList.clear();
                this.mChecked.clear();
                this.addToList(tPos.field_71574_a, tPos.field_71572_b + this.mDir, tPos.field_71573_c);
                return;
            }
            if (tPos.field_71574_a < aX + 64) {
                this.addToList(tPos.field_71574_a + 1, tPos.field_71572_b, tPos.field_71573_c);
            }
            if (tPos.field_71574_a > aX - 64) {
                this.addToList(tPos.field_71574_a - 1, tPos.field_71572_b, tPos.field_71573_c);
            }
            if (tPos.field_71573_c < aZ + 64) {
                this.addToList(tPos.field_71574_a, tPos.field_71572_b, tPos.field_71573_c + 1);
            }
            if (tPos.field_71573_c <= aZ - 64) continue;
            this.addToList(tPos.field_71574_a, tPos.field_71572_b, tPos.field_71573_c - 1);
        }
    }

    private void scanForFluid(int aX, int aY, int aZ) {
        this.mPumpList = new LinkedList();
        this.mCheckList.clear();
        this.mChecked.clear();
        this.mPumpedFluids.clear();
        Block aBlock = this.getBlockAtSide(this.mFacing);
        if (WD.lava(aBlock)) {
            this.mPumpedFluids.add(Blocks.field_150353_l);
            this.mPumpedFluids.add((Block)Blocks.field_150356_k);
            this.mDir = 1;
        } else if (WD.water(aBlock) || aBlock == CS.BlocksGT.River || aBlock == CS.BlocksGT.Ocean || aBlock == CS.BlocksGT.Swamp) {
            this.mPumpedFluids.add(Blocks.field_150355_j);
            this.mPumpedFluids.add((Block)Blocks.field_150358_i);
            this.mPumpedFluids.add((Block)CS.BlocksGT.River);
            this.mPumpedFluids.add((Block)CS.BlocksGT.Ocean);
            this.mPumpedFluids.add((Block)CS.BlocksGT.Swamp);
            this.mDir = 1;
        } else if (aBlock instanceof IFluidBlock) {
            this.mPumpedFluids.add(aBlock);
            this.mDir = (byte)(FL.lighter(((IFluidBlock)aBlock).getFluid()) ? -1 : 1);
        } else {
            if (this.mEnergy >= 8192L) {
                --this.mEnergy;
            }
            return;
        }
        this.addToList(aX, aY, aZ);
    }

    private boolean addToList(int aX, int aY, int aZ) {
        ChunkCoordinates tCoordinate = new ChunkCoordinates(aX, aY, aZ);
        if (this.mChecked.add(tCoordinate) && this.mPumpedFluids.contains(this.getBlock(aX, aY, aZ))) {
            this.mPumpList.add(tCoordinate);
            this.mCheckList.add(tCoordinate);
            return true;
        }
        return false;
    }

    private boolean drainFluid(ChunkCoordinates aCoords) {
        Block aBlock = this.getBlock(aCoords);
        if (!this.mPumpedFluids.contains(aBlock)) {
            return false;
        }
        if (WD.water(aBlock) || aBlock == CS.BlocksGT.River) {
            if (this.getMetaData(aCoords) == 0) {
                this.mTank.setFluid(FL.Water.make(1000L));
            }
        } else if (WD.lava(aBlock)) {
            if (this.getMetaData(aCoords) == 0) {
                this.mTank.setFluid(FL.Lava.make(1000L));
            }
        } else if (aBlock instanceof IFluidBlock) {
            this.mTank.setFluid(((IFluidBlock)aBlock).drain(this.field_145850_b, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, false));
        }
        this.mEnergy -= Math.max(16L, UT.Code.units(this.mTank.amount(), 1000L, 2048L, true));
        if (!this.field_145850_b.func_147465_d(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, CS.NB, 0, 2)) {
            return false;
        }
        if (this.mPumpedFluids.contains(this.getBlock(aCoords.field_71574_a, aCoords.field_71572_b + this.mDir, aCoords.field_71573_c))) {
            return false;
        }
        return !this.mPumpedFluids.contains(this.getBlock(aCoords.field_71574_a + 1, aCoords.field_71572_b, aCoords.field_71573_c)) || !this.mPumpedFluids.contains(this.getBlock(aCoords.field_71574_a - 1, aCoords.field_71572_b, aCoords.field_71573_c)) || !this.mPumpedFluids.contains(this.getBlock(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c + 1)) || !this.mPumpedFluids.contains(this.getBlock(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c - 1));
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        this.mActiveData <<= 1;
        if (this.mActive) {
            this.mActiveData |= 1L;
        }
        byte tActiveState = this.mActiveState;
        this.mActiveState = this.mActiveData == 0L || this.mStopped ? (byte)0 : (this.mActiveData == -1L ? (byte)1 : (byte)2);
        return tActiveState != this.mActiveState || super.onTickCheck(aTimer);
    }

    @Override
    public void setVisualData(byte aData) {
        this.mActiveState = aData;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return this.mTank;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTank.AS_ARRAY;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if ((aSize = Math.abs(aSize)) > this.getEnergySizeInputMax(aEnergyType, aSide)) {
            if (aDoInject) {
                this.overload(aSize, aEnergyType);
            }
            return aAmount;
        }
        if (this.mEnergy >= 8192L) {
            return 0L;
        }
        long tInput = Math.min(8192L - this.mEnergy, aSize * aAmount);
        long tConsumed = Math.min(aAmount, tInput / aSize + (long)(tInput % aSize != 0L ? 1 : 0));
        if (aDoInject) {
            this.mEnergy += tConsumed * aSize;
        }
        return tConsumed;
    }

    public void overload(long aSize, TagData aEnergyType) {
        if (this.mExplosionPrevention < 100) {
            if (this.mTimer < 100L) {
                CS.DEB.println("Machine overloaded on startup with: " + aSize + " " + aEnergyType.getLocalisedNameLong());
            }
            this.mExplosionPrevention = (byte)(this.mExplosionPrevention + 1);
            this.mEnergy = 0L;
        } else {
            this.overcharge(aSize, aEnergyType);
        }
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting && aEnergyType == this.mEnergyType;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return !(!aTheoretical && this.mStopped || !CS.SIDES_INVALID[aSide] && aSide != CS.OPOS[this.mFacing] || !super.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical));
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mInput;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyType.AS_LIST;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public void onFacingChange(byte aPreviousFacing) {
        this.mNextCheck = 1L;
        this.mChecked.clear();
        this.mCheckList.clear();
        this.mPumpList.clear();
        this.mPumpedFluids.clear();
    }

    @Override
    public boolean getStateRunningPossible() {
        return !(this.mActiveData == 0L && this.mTank.has() || this.mPumpList.isEmpty() && !WD.liquid(this.getBlockAtSide(this.mFacing)));
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActiveData != 0L;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mActiveData != 0L && !this.mPumpedFluids.isEmpty();
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public byte getVisualData() {
        return this.mActiveState;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = aSide == this.mFacing ? 0 : (aSide == CS.OPOS[this.mFacing] ? 1 : 2);
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get((this.mActiveState > 0 ? sOverlaysActive : sOverlays)[aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.pump.rotation";
    }

    static {
        LH.add("gt.tooltip.pump.1", "Usable to clear large Bodies of Fluid");
        LH.add("gt.tooltip.pump.2", "Not suitable for making infinite Fluid Sources!");
        LH.add("gt.tooltip.pump.3", "Use a Drain Cover for that instead!");
        sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/pump/rotation/colored/front"), new Textures.BlockIcons.CustomIcon("machines/pump/rotation/colored/back"), new Textures.BlockIcons.CustomIcon("machines/pump/rotation/colored/side")};
        sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/pump/rotation/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/pump/rotation/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/pump/rotation/overlay/side")};
        sOverlaysActive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/pump/rotation/overlay_active/front"), new Textures.BlockIcons.CustomIcon("machines/pump/rotation/overlay_active/back"), new Textures.BlockIcons.CustomIcon("machines/pump/rotation/overlay_active/side")};
    }
}

