/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.sensors;

import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.IIconContainer;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.MultiTileEntitySensorTE;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityTPSmeter
extends MultiTileEntitySensorTE {
    public long mTime = System.currentTimeMillis();
    public long mCurrentTime = 2000L;
    public static IIconContainer sTextureFront;
    public static IIconContainer sTextureBack;
    public static IIconContainer sTextureSide;
    public static IIconContainer sOverlayFront;
    public static IIconContainer sOverlayBack;
    public static IIconContainer sOverlaySide;

    @Override
    public String getSensorDescription() {
        return LH.get("gt.tooltip.sensor.tpsmeter");
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide && (this.getTickRate() < 2L || aTimer % this.getTickRate() == 0L)) {
            long tTime = this.mTime;
            this.mTime = System.currentTimeMillis();
            this.mCurrentTime = this.mTime - tTime > 0L ? this.getTickRate() * 100000L / (this.mTime - tTime) : 2000L;
        }
        super.onTick2(aTimer, aIsServerSide);
    }

    @Override
    public long getCurrentValue(DelegatorTileEntity<TileEntity> aDelegator) {
        return this.mCurrentTime;
    }

    @Override
    public long getCurrentMax(DelegatorTileEntity<TileEntity> aDelegator) {
        return 2000L;
    }

    @Override
    public long getTickRate() {
        return 20L;
    }

    @Override
    public short[] getSymbolColor() {
        return CS.CA_RED_255;
    }

    @Override
    public IIconContainer getSymbolIcon() {
        return BI.CHAR_CLOCK;
    }

    @Override
    public IIconContainer getTextureFront() {
        return sTextureFront;
    }

    @Override
    public IIconContainer getTextureBack() {
        return sTextureBack;
    }

    @Override
    public IIconContainer getTextureSide() {
        return sTextureSide;
    }

    @Override
    public IIconContainer getOverlayFront() {
        return sOverlayFront;
    }

    @Override
    public IIconContainer getOverlayBack() {
        return sOverlayBack;
    }

    @Override
    public IIconContainer getOverlaySide() {
        return sOverlaySide;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.redstone.sensors.tpsmeter";
    }

    static {
        LH.add("gt.tooltip.sensor.tpsmeter", "Measures TPS of the whole Server");
        sTextureFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/tpsmeter/colored/front");
        sTextureBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/tpsmeter/colored/back");
        sTextureSide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/tpsmeter/colored/side");
        sOverlayFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/tpsmeter/overlay/front");
        sOverlayBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/tpsmeter/overlay/back");
        sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/tpsmeter/overlay/side");
    }
}

