/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.portals;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase04MultiTileEntities;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityDelegating;
import gregapi.util.UT;
import java.io.File;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class MultiTileEntityMiniPortal
extends TileEntityBase04MultiTileEntities
implements ITileEntitySurface,
ITileEntityDelegating,
IFluidHandler,
ISidedInventory,
IMultiTileEntity.IMTE_OnServerStart,
IMultiTileEntity.IMTE_OnServerStop,
IMultiTileEntity.IMTE_OnServerLoad,
IMultiTileEntity.IMTE_OnToolClick,
IMultiTileEntity.IMTE_IsProvidingWeakPower,
IMultiTileEntity.IMTE_GetComparatorInputOverride,
IMultiTileEntity.IMTE_GetExplosionResistance,
IMultiTileEntity.IMTE_GetBlockHardness,
IMultiTileEntity.IMTE_GetLightOpacity,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_SyncDataByte {
    protected boolean mActive = false;
    public MultiTileEntityMiniPortal mTarget = null;
    public final byte[] mRedstone = new byte[]{0, 0, 0, 0, 0, 0};
    public final byte[] mComparator = new byte[]{0, 0, 0, 0, 0, 0};
    public final byte[] xRedstone = new byte[]{0, 0, 0, 0, 0, 0};
    public final byte[] xComparator = new byte[]{0, 0, 0, 0, 0, 0};
    public final byte[] wRedstone = new byte[]{0, 0, 0, 0, 0, 0};
    public final byte[] wComparator = new byte[]{0, 0, 0, 0, 0, 0};
    private static final String sToolTipFunction1 = "gt.tileentity.portal.mini.tooltip.1";
    private static final String sToolTipFunction2 = "gt.tileentity.portal.mini.tooltip.2";
    protected static float[][] sBlockBounds;
    protected static boolean[][] sRenderedSides;
    public byte mLastSide = (byte)6;

    public abstract void findTargetPortal();

    public abstract void addThisPortalToLists();

    public abstract List<MultiTileEntityMiniPortal> getPortalListA();

    public abstract List<MultiTileEntityMiniPortal> getPortalListB();

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.active")) {
            this.mActive = aNBT.func_74767_n("gt.active");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
    }

    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get(sToolTipFunction1));
        aList.add(LH.Chat.CYAN + LH.get(sToolTipFunction2));
        this.addToolTips2(aList, aStack, aF3_H);
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.chunk.loader"));
    }

    public void addToolTips2(List<String> aList, ItemStack aStack, boolean aF3_H) {
    }

    @Override
    public void onTickFirst(boolean aIsServerSide) {
        super.onTickFirst(aIsServerSide);
        if (aIsServerSide && this.mActive) {
            this.addThisPortalToLists();
            this.causeBlockUpdate();
        }
    }

    @Override
    public void onTickStart(long aTimer, boolean aIsServerSide) {
        super.onTickStart(aTimer, aIsServerSide);
        if (aIsServerSide) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (this.mActive) {
                    if (this.xRedstone[tSide] >= 0) {
                        if (this.mRedstone[tSide] != this.xRedstone[tSide]) {
                            this.mRedstone[tSide] = this.xRedstone[tSide];
                            this.causeBlockUpdate();
                        }
                        this.xRedstone[tSide] = -1;
                        this.wRedstone[tSide] = 0;
                    } else if (this.wRedstone[tSide] >= 20) {
                        if (this.mRedstone[tSide] != 0) {
                            this.mRedstone[tSide] = 0;
                            this.causeBlockUpdate();
                        }
                    } else {
                        byte by = tSide;
                        this.wRedstone[by] = (byte)(this.wRedstone[by] + 1);
                    }
                    if (this.xComparator[tSide] >= 0) {
                        if (this.mComparator[tSide] != this.xComparator[tSide]) {
                            this.mComparator[tSide] = this.xComparator[tSide];
                            this.causeBlockUpdate();
                        }
                        this.xComparator[tSide] = -1;
                        this.wComparator[tSide] = 0;
                        continue;
                    }
                    if (this.wComparator[tSide] >= 20) {
                        if (this.mComparator[tSide] == 0) continue;
                        this.mComparator[tSide] = 0;
                        this.causeBlockUpdate();
                        continue;
                    }
                    byte by = tSide;
                    this.wComparator[by] = (byte)(this.wComparator[by] + 1);
                    continue;
                }
                if (this.mRedstone[tSide] != 0) {
                    this.mRedstone[tSide] = 0;
                    this.causeBlockUpdate();
                }
                if (this.mComparator[tSide] == 0) continue;
                this.mComparator[tSide] = 0;
                this.causeBlockUpdate();
            }
        }
    }

    @Override
    public void onTick(long aTimer, boolean aIsServerSide) {
        super.onTick(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (this.mActive && (this.mTarget == null ? aTimer % 100L == 5L : this.mTarget.isDead())) {
                this.findTargetPortal();
            }
            if (this.mTarget != null) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    this.mTarget.xRedstone[CS.OPOS[tSide]] = (byte)UT.Code.bind_(this.mTarget.xRedstone[CS.OPOS[tSide]], 15L, this.getRedstoneIncoming(tSide));
                    this.mTarget.xComparator[CS.OPOS[tSide]] = (byte)UT.Code.bind_(this.mTarget.xComparator[CS.OPOS[tSide]], 15L, this.getComparatorIncoming(tSide));
                }
            }
        }
    }

    public void setPortalActive() {
        if (!this.mActive) {
            this.mActive = true;
            this.addThisPortalToLists();
            this.causeBlockUpdate();
            this.updateClientData();
        }
    }

    public void setPortalInactive() {
        if (this.mActive) {
            this.disableThisPortal();
            this.causeBlockUpdate();
            this.updateClientData();
        }
    }

    public void removeThisPortalFromLists() {
        if (this.getPortalListA().remove(this)) {
            for (MultiTileEntityMiniPortal tPortal : this.getPortalListB()) {
                if (tPortal.mTarget != this) continue;
                tPortal.findTargetPortal();
            }
        }
        if (this.getPortalListB().remove(this)) {
            for (MultiTileEntityMiniPortal tPortal : this.getPortalListA()) {
                if (tPortal.mTarget != this) continue;
                tPortal.findTargetPortal();
            }
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.mActive) {
            this.addThisPortalToLists();
        }
    }

    @Override
    public void func_145843_s() {
        this.disableThisPortal();
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        this.disableThisPortal();
        super.onChunkUnload();
    }

    @Override
    public void onServerStart() {
        this.getPortalListA().clear();
        this.getPortalListB().clear();
    }

    @Override
    public void onServerStop() {
        this.getPortalListA().clear();
        this.getPortalListB().clear();
    }

    @Override
    public void onServerLoad(File aSaveLocation) {
        if (CS.CODE_CLIENT) {
            this.getPortalListA().clear();
            this.getPortalListB().clear();
        }
    }

    public void disableThisPortal() {
        this.mActive = false;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            this.mRedstone[tSide] = 0;
            this.mComparator[tSide] = 0;
            if (this.mTarget == null) continue;
            this.mTarget.xRedstone[CS.OPOS[tSide]] = 0;
            this.mTarget.xComparator[CS.OPOS[tSide]] = 0;
        }
        this.removeThisPortalFromLists();
        this.mTarget = null;
    }

    @Override
    public long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                if (this.mTarget == null) {
                    aChatReturn.add("No Target");
                } else {
                    aChatReturn.add("X: " + this.mTarget.field_145851_c + "   Y: " + this.mTarget.field_145848_d + "   Z: " + this.mTarget.field_145849_e);
                }
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return this.getClientDataPacketByte(aSendAll, (byte)(this.mActive ? 1 : 0));
    }

    @Override
    public boolean receiveDataByte(byte aData, INetworkHandler aNetworkHandler) {
        if (this.mActive) {
            this.mActive = (aData & 1) != 0;
        } else {
            boolean bl = this.mActive = (aData & 1) != 0;
            if (this.mActive && this.mTimer > 20L) {
                UT.Sounds.play("portal.portal", 10, 1.0f, 1.0f, this.getCoords());
            }
        }
        return true;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 1.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 0.75f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque(byte aSide) {
        return this.mActive;
    }

    @Override
    public int getFireSpreadSpeed(byte aSide, boolean aDefault) {
        return 0;
    }

    @Override
    public int getFlammability(byte aSide, boolean aDefault) {
        return 0;
    }

    @Override
    public float getBlockHardness() {
        return Blocks.field_150348_b.func_149712_f(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public float getExplosionResistance2() {
        return Blocks.field_150348_b.func_149638_a(null);
    }

    @Override
    public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 13;
    }

    @Override
    public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        return this.box(aBlock, sBlockBounds[aRenderPass]);
    }

    @Override
    public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return sRenderedSides[aRenderPass][aSide] ? (aRenderPass == 0 ? (this.mActive || this.field_145850_b == null ? (aShouldSideBeRendered[aSide] ? this.getPortalTexture() : null) : this.getInactiveTexture()) : this.getFrameTexture()) : null;
    }

    public abstract ITexture getPortalTexture();

    public abstract ITexture getFrameTexture();

    public ITexture getInactiveTexture() {
        return null;
    }

    @Override
    public DelegatorTileEntity<TileEntity> getDelegateTileEntity(byte aSide) {
        if (this.mTarget == null) {
            return this.delegator(aSide);
        }
        return this.mTarget.getAdjacentTileEntity(CS.OPOS[aSide]);
    }

    @Override
    public boolean isExtender(byte aSide) {
        return this.mTarget != null;
    }

    @Override
    public int getComparatorInputOverride(byte aSide) {
        return this.mComparator[aSide];
    }

    @Override
    public int isProvidingWeakPower(byte aOppositeSide) {
        return this.mRedstone[CS.OPOS[aOppositeSide]];
    }

    public ItemStack func_70298_a(int aSlot, int aDecrement) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70298_a(aSlot, aDecrement);
            }
        }
        return null;
    }

    public ItemStack func_70304_b(int aSlot) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70304_b(aSlot);
            }
        }
        return null;
    }

    public ItemStack func_70301_a(int aSlot) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70301_a(aSlot);
            }
        }
        return null;
    }

    public String func_145825_b() {
        String rName;
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_145825_b();
            }
        }
        if (UT.Code.stringValid(rName = this.getCustomName())) {
            return rName;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        return tRegistry == null ? this.getClass().getName() : tRegistry.getLocal(this.getMultiTileEntityID());
    }

    public int func_70302_i_() {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70302_i_();
            }
        }
        return 0;
    }

    public int func_70297_j_() {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70297_j_();
            }
        }
        return 0;
    }

    public void func_70299_a(int aSlot, ItemStack aStack) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                ((IInventory)tTileEntity.mTileEntity).func_70299_a(aSlot, aStack);
            }
        }
    }

    public boolean func_145818_k_() {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_145818_k_();
            }
        }
        return this.getCustomName() != null;
    }

    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_94041_b(aSlot, aStack);
            }
        }
        return false;
    }

    public int[] func_94128_d(int aSide) {
        this.mLastSide = (byte)aSide;
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mLastSide]);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_94128_d((int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                int[] tReturn = new int[((IInventory)tTileEntity.mTileEntity).func_70302_i_()];
                for (int i = 0; i < tReturn.length; ++i) {
                    tReturn[i] = i;
                }
                return tReturn;
            }
        }
        return CS.ZL_INTEGER;
    }

    public boolean func_102007_a(int aSlot, ItemStack aStack, int aSide) {
        this.mLastSide = (byte)aSide;
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mLastSide]);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_102007_a(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    public boolean func_102008_b(int aSlot, ItemStack aStack, int aSide) {
        this.mLastSide = (byte)aSide;
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mLastSide]);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_102008_b(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.mTarget.getAdjacentTank(CS.OPOS[UT.Code.side(from)]);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).fill(tTileEntity.getForgeSideOfTileEntity(), resource, doFill);
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.mTarget.getAdjacentTank(CS.OPOS[UT.Code.side(from)]);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), resource, doDrain);
            }
        }
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.mTarget.getAdjacentTank(CS.OPOS[UT.Code.side(from)]);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), maxDrain, doDrain);
            }
        }
        return null;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.mTarget.getAdjacentTank(CS.OPOS[UT.Code.side(from)]);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canFill(tTileEntity.getForgeSideOfTileEntity(), fluid);
            }
        }
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.mTarget.getAdjacentTank(CS.OPOS[UT.Code.side(from)]);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canDrain(tTileEntity.getForgeSideOfTileEntity(), fluid);
            }
        }
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.mTarget.getAdjacentTank(CS.OPOS[UT.Code.side(from)]);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).getTankInfo(tTileEntity.getForgeSideOfTileEntity());
            }
        }
        return CS.ZL_FLUIDTANKINFO;
    }

    public boolean func_70300_a(EntityPlayer aPlayer) {
        return aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    static {
        LH.add(sToolTipFunction1, "Teleports Items, Fluids, Redstone, Comparator Signals, GT Energy and more!");
        LH.add(sToolTipFunction2, "Always teleports things to the closest active Portal in Range!");
        sBlockBounds = new float[][]{{CS.PX_P[1], CS.PX_P[1], CS.PX_P[1], CS.PX_N[1], CS.PX_N[1], CS.PX_N[1]}, {CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[14], CS.PX_N[14]}, {CS.PX_P[0], CS.PX_P[2], CS.PX_P[0], CS.PX_N[14], CS.PX_N[2], CS.PX_N[14]}, {CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[14], CS.PX_N[14], CS.PX_N[0]}, {CS.PX_P[14], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[14], CS.PX_N[0]}, {CS.PX_P[14], CS.PX_P[2], CS.PX_P[0], CS.PX_N[0], CS.PX_N[2], CS.PX_N[14]}, {CS.PX_P[0], CS.PX_P[14], CS.PX_P[0], CS.PX_N[14], CS.PX_N[0], CS.PX_N[0]}, {CS.PX_P[0], CS.PX_P[14], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[14]}, {CS.PX_P[0], CS.PX_P[2], CS.PX_P[14], CS.PX_N[14], CS.PX_N[2], CS.PX_N[0]}, {CS.PX_P[0], CS.PX_P[0], CS.PX_P[14], CS.PX_N[0], CS.PX_N[14], CS.PX_N[0]}, {CS.PX_P[0], CS.PX_P[14], CS.PX_P[14], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]}, {CS.PX_P[14], CS.PX_P[2], CS.PX_P[14], CS.PX_N[0], CS.PX_N[2], CS.PX_N[0]}, {CS.PX_P[14], CS.PX_P[14], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]}};
        sRenderedSides = new boolean[][]{{true, true, true, true, true, true}, {true, true, true, true, false, false}, {false, false, true, true, true, true}, {true, true, false, false, true, true}, {true, true, false, false, true, true}, {false, false, true, true, true, true}, {true, true, false, false, true, true}, {true, true, true, true, false, false}, {false, false, true, true, true, true}, {true, true, true, true, false, false}, {true, true, true, true, false, false}, {false, false, true, true, true, true}, {true, true, false, false, true, true}};
    }
}

