/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.plants;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.old.Textures;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.misc.MultiTileEntityTreeHole;
import gregapi.util.ST;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class MultiTileEntityResinHoleRubber
extends MultiTileEntityTreeHole {
    public static List<MultiTileEntityResinHoleRubber> sListResinHoles = new ArrayListNoNulls<MultiTileEntityResinHoleRubber>();

    public static boolean nearby(World aWorld, int aX, int aY, int aZ) {
        Iterator<MultiTileEntityResinHoleRubber> tIterator = sListResinHoles.iterator();
        while (tIterator.hasNext()) {
            MultiTileEntityResinHoleRubber tHole = tIterator.next();
            if (tHole == null || tHole.isDead()) {
                tIterator.remove();
                continue;
            }
            if (tHole.field_145850_b != aWorld || Math.abs(tHole.field_145851_c - aX) >= 256 || Math.abs(tHole.field_145849_e - aZ) >= 256) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onTickFirst2(boolean aIsServerSide) {
        if (aIsServerSide) {
            sListResinHoles.add(this);
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && !this.mHasResin && aTimer % 600L == 0L) {
            int j;
            int i;
            int tTreeHeight = this.field_145848_d + 1;
            int tLeavesCount = 0;
            for (i = 1; i < 10 && (this.getBlockAtSideAndDistance((byte)1, i) == CS.BlocksGT.LogA || this.getMetaDataAtSideAndDistance((byte)1, i) == 0); ++i) {
                ++tTreeHeight;
            }
            if (this.checkLeaves(this.field_145851_c, tTreeHeight, this.field_145849_e)) {
                ++tLeavesCount;
            }
            if (this.checkLeaves(this.field_145851_c, tTreeHeight + 1, this.field_145849_e)) {
                ++tLeavesCount;
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (i == 0 && j == 0 || !this.checkLeaves(this.field_145851_c + i, tTreeHeight - 1, this.field_145849_e + j)) continue;
                    ++tLeavesCount;
                }
            }
            for (i = -2; i <= 2; ++i) {
                for (j = -2; j <= 2; ++j) {
                    if (i == 0 && j == 0) continue;
                    if (Math.abs(i * j) < 2 && this.checkLeaves(this.field_145851_c + i, tTreeHeight - 2, this.field_145849_e + j)) {
                        ++tLeavesCount;
                    }
                    if (Math.abs(i * j) < 4 && this.checkLeaves(this.field_145851_c + i, tTreeHeight - 3, this.field_145849_e + j)) {
                        ++tLeavesCount;
                    }
                    if (Math.abs(i * j) < 4 && this.checkLeaves(this.field_145851_c + i, tTreeHeight - 4, this.field_145849_e + j)) {
                        ++tLeavesCount;
                    }
                    if (!this.checkLeaves(this.field_145851_c + i, tTreeHeight - 5, this.field_145849_e + j)) continue;
                    ++tLeavesCount;
                }
            }
            if (tLeavesCount > 60 && this.rng(260) < tLeavesCount - 60) {
                this.mHasResin = true;
                this.updateClientData();
            }
        }
    }

    private boolean checkLeaves(int aX, int aY, int aZ) {
        return this.getBlock(aX, aY, aZ) == CS.BlocksGT.Leaves_AB && this.getMetaData(aX, aY, aZ) == 8;
    }

    @Override
    public ArrayListNoNulls<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        return this.isClientSide() ? super.getDrops(aFortune, aSilkTouch) : ST.arraylist(ST.make(CS.BlocksGT.LogA, 1L, 0L));
    }

    @Override
    public ItemStack getResinItem(byte aSide) {
        return IL.IC2_Resin.get(1L, IL.Resin.get(1L, new Object[0]));
    }

    @Override
    public FluidStack getResinFluid(byte aSide) {
        return FL.Resin_Rubber.make(250L);
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? (aSide != this.mFacing ? BlockTextureCopied.get(CS.BlocksGT.LogA, 6, 0) : BlockTextureDefault.get(this.mHasResin ? Textures.BlockIcons.LOG_RESIN_RUBBER : Textures.BlockIcons.LOG_HOLE_RUBBER)) : null;
    }

    @Override
    public float getExplosionResistance2() {
        return CS.BlocksGT.LogA.getExplosionResistance((byte)0);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.tree.rubber.resinhole";
    }
}

