/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.GT_API_Proxy;
import gregapi.block.metatype.BlockStones;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.tileentity.ITileEntityMobSpawnInhibitor;
import gregapi.tileentity.data.ITileEntityGibbl;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.multiblocks.IMultiBlockEnergy;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.TileEntityBase10MultiBlockBase;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;

public class MultiTileEntityVonDaGraagg
extends TileEntityBase10MultiBlockBase
implements ITileEntityEnergy,
ITileEntityMobSpawnInhibitor,
IMultiBlockEnergy,
ITileEntityProgress,
ITileEntityGibbl {
    public long mEnergy = 0L;
    public long mCurrentRange = 256L;
    public TagData mEnergyTypeAccepted = TD.Energy.EU;
    private boolean mHasToAddToList = true;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
    }

    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        int tX = this.field_145851_c;
        int tY = this.field_145848_d;
        int tZ = this.field_145849_e;
        if (this.field_145850_b.func_72899_e(tX - 2, tY, tZ - 2) && this.field_145850_b.func_72899_e(tX + 2, tY, tZ - 2) && this.field_145850_b.func_72899_e(tX - 2, tY, tZ + 2) && this.field_145850_b.func_72899_e(tX + 2, tY, tZ + 2)) {
            int j;
            int i;
            boolean tSuccess = true;
            for (i = -2; i <= 2; ++i) {
                for (j = -2; j <= 2; ++j) {
                    if (Math.abs(i * j) >= 4) continue;
                    if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, 0, j, 18028, this.getMultiTileEntityRegistryID(), 0, -3, aCoordinates, aPlayer, aInventory)) {
                        tSuccess = false;
                    }
                    if (ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, 1, j, 18028, this.getMultiTileEntityRegistryID(), 0, -3, aCoordinates, aPlayer, aInventory)) continue;
                    tSuccess = false;
                }
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, 0, 2, 0, 18040, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, 0, 3, 0, 18040, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, 0, 4, 0, 18040, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, 0, 5, 0, 18040, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, 0, 6, 0, 18040, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, 0, 7, 0, 18029, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (i == 0 && j == 0) continue;
                    if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, 6, j, 18029, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                        tSuccess = false;
                    }
                    if (i * j != 0) continue;
                    if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, 5, j, 18029, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                        tSuccess = false;
                    }
                    if (ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, 7, j, 18029, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) continue;
                    tSuccess = false;
                }
            }
            return tSuccess;
        }
        return this.mStructureOkay;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.von.da.graagg.1"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.von.da.graagg.2"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.von.da.graagg.3"));
        aList.add(LH.Chat.CYAN + LH.get("gt.tooltip.multiblock.von.da.graagg.4"));
        LH.addEnergyToolTips(this, aList, this.mEnergyTypeAccepted, null, LH.get("gt.lang.face.bottom"), "");
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        int tX = this.field_145851_c;
        int tY = this.field_145848_d;
        int tZ = this.field_145849_e;
        return aX >= tX - 2 && aY >= tY && aZ >= tZ - 2 && aX <= tX + 2 && aY <= tY + 8 && aZ <= tZ + 2;
    }

    @Override
    public void onUnregisterInhibitor() {
        this.mHasToAddToList = true;
    }

    @Override
    public void onCoordinateChange() {
        super.onCoordinateChange();
        GT_API_Proxy.MOB_SPAWN_INHIBITORS.remove(this);
        this.onUnregisterInhibitor();
    }

    @Override
    public boolean inhibitMobSpawn(LivingSpawnEvent.CheckSpawn aEvent, World aWorld, int aX, int aY, int aZ) {
        if (this.mCurrentRange <= 0L || aWorld != this.field_145850_b || (long)Math.abs(aX - this.field_145851_c) > this.mCurrentRange || (long)Math.abs(aZ - this.field_145849_e) > this.mCurrentRange) {
            return false;
        }
        for (int i = -5; i <= 5; ++i) {
            Block tBlock = aWorld.func_147439_a(aX, aY + i, aZ);
            if (tBlock == Blocks.field_150341_Y) {
                return false;
            }
            if (!(tBlock instanceof BlockStones) || aWorld.func_72805_g(aX, aY + i, aZ) != 2) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (this.mHasToAddToList) {
                GT_API_Proxy.MOB_SPAWN_INHIBITORS.add(this);
                this.mHasToAddToList = false;
            }
            this.mCurrentRange = UT.Code.bind8(this.mStructureOkay ? Math.min(this.mEnergy, 4096L) / 16L : 0L);
            this.mEnergy -= 4096L;
            if (this.mEnergy < 0L) {
                this.mEnergy = 0L;
            }
        }
    }

    @Override
    public void onMagnifyingGlass2(List<String> aChatReturn) {
        aChatReturn.add("Square Radius: " + this.mCurrentRange + "m of 256m");
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_BOTTOM;
    }

    @Override
    public long getGibblValue(byte aSide) {
        return 1000L * this.mCurrentRange;
    }

    @Override
    public long getGibblMax(byte aSide) {
        return 256000L;
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.mCurrentRange;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return 256L;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting && aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, false);
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (aDoInject) {
            this.mEnergy += Math.abs(aAmount * aSize);
        }
        return aAmount;
    }

    @Override
    public long getEnergyDemanded(TagData aEnergyType, byte aSide, long aSize) {
        return 4096L - this.mEnergy;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return 2048L;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 256L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return 4096L;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted ? this.mEnergy : 0L;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted ? 4096L : 0L;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.von.da.graagg";
    }

    static {
        LH.add("gt.tooltip.multiblock.von.da.graagg.1", "cornerless 5x5x2 Base of 41 Dense Galvanized Steel Wall with Main at bottom Center");
        LH.add("gt.tooltip.multiblock.von.da.graagg.2", "A 5m long Pole of Large Copper Coil with +1 Dense Steel Wall ontop");
        LH.add("gt.tooltip.multiblock.von.da.graagg.3", "Wrap a cornerless 3x3x3 of 16 Dense Steel Wall around the Top");
        LH.add("gt.tooltip.multiblock.von.da.graagg.4", "Prevents Mob Spawns except on Mossy Cobblestone, Range depends on Input.");
    }
}

