/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.gui.ContainerClientDefault;
import gregapi.gui.ContainerCommonDefault;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityConnectedInventory;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityDrawerQuad
extends TileEntityBase09FacingSingle
implements ITileEntityConnectedInventory {
    public boolean mSidedAccess = false;
    public static final int[][] SLOTS = new int[][]{{72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107}, UT.Code.getAscendingArray(144), {36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143}, UT.Code.getAscendingArray(144), UT.Code.getAscendingArray(144)};
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/drawers/quad/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/drawers/quad/colored/top"), new Textures.BlockIcons.CustomIcon("machines/drawers/quad/colored/front"), new Textures.BlockIcons.CustomIcon("machines/drawers/quad/colored/back"), new Textures.BlockIcons.CustomIcon("machines/drawers/quad/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/drawers/quad/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/drawers/quad/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/drawers/quad/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/drawers/quad/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/drawers/quad/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.mode")) {
            this.mSidedAccess = aNBT.func_74767_n("gt.mode");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.mode", this.mSidedAccess);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.mInventoryChanged) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                if (!(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
                ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
            }
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.inputs"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aSide != this.mFacing) {
            return false;
        }
        float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
        return this.isClientSide() || this.openGUI(aPlayer, ((double)tCoords[0] > 0.5 ? 1 : 0) | ((double)tCoords[1] > 0.5 ? 2 : 0));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("monkeywrench")) {
            boolean bl = this.mSidedAccess = !this.mSidedAccess;
            if (aChatReturn != null) {
                aChatReturn.add("Automation-Access: " + (this.mSidedAccess ? "Sided" : "Anywhere"));
            }
            return 10000L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientDefault(new ContainerCommonDefault(aPlayer.field_71071_by, this, aGUIID, aGUIID % 4 * 36, 36));
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonDefault(aPlayer.field_71071_by, this, aGUIID, aGUIID % 4 * 36, 36);
    }

    @Override
    public boolean canDrop(int aSlot) {
        return true;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[144];
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return SLOTS[this.mSidedAccess ? CS.FACING_ROTATIONS[this.mFacing][aSide] : 6];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return aSide != this.mFacing;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = aSide == this.mFacing ? 2 : (aSide == CS.OPOS[this.mFacing] ? 3 : (aSide < 2 ? (int)aSide : 4));
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlays[aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.drawer.quad";
    }
}

