/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.generators;

import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.FM;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.old.Textures;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.behavior.TE_Behavior_Active_Trinary;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityAdjacentOnOff;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityMotorLiquid
extends TileEntityBase09FacingSingle
implements IFluidHandler,
ITileEntityFunnelAccessible,
ITileEntityTapAccessible,
ITileEntityEnergy,
ITileEntityRunningActively,
ITileEntityAdjacentOnOff {
    public boolean mStopped = false;
    public short mEfficiency = (short)10000;
    public long mEnergy = 0L;
    public long mRate = 32L;
    public TagData mEnergyTypeEmitted = TD.Energy.RU;
    public Recipe.RecipeMap mRecipes = FM.Engine;
    public Recipe mLastRecipe = null;
    public FluidTankGT[] mTanks = new FluidTankGT[]{new FluidTankGT(1000L), new FluidTankGT(1000L)};
    public TE_Behavior_Active_Trinary mActivity = null;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/motor_liquid/colored/front"), new Textures.BlockIcons.CustomIcon("machines/generators/motor_liquid/colored/back"), new Textures.BlockIcons.CustomIcon("machines/generators/motor_liquid/colored/sides")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/motor_liquid/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/generators/motor_liquid/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/generators/motor_liquid/overlay/sides")};
    public static IIconContainer[] sOverlaysActive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/motor_liquid/overlay_active/front"), new Textures.BlockIcons.CustomIcon("machines/generators/motor_liquid/overlay_active/back"), new Textures.BlockIcons.CustomIcon("machines/generators/motor_liquid/overlay_active/sides")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        this.mActivity = new TE_Behavior_Active_Trinary(this, aNBT);
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mStopped = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.output")) {
            this.mRate = aNBT.func_74763_f("gt.output");
        }
        if (aNBT.func_74764_b("gt.fuelmap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.fuelmap"));
        }
        if (aNBT.func_74764_b("gt.eff")) {
            this.mEfficiency = (short)UT.Code.bind_(0L, 10000L, aNBT.func_74765_d("gt.eff"));
        }
        if (aNBT.func_74764_b("gt.energy.emitted")) {
            this.mEnergyTypeEmitted = TagData.createTagData(aNBT.func_74779_i("gt.energy.emitted"));
        }
        this.mTanks[0].readFromNBT(aNBT, "gt.tank.0").setCapacity(this.mRate * 10L);
        this.mTanks[1].readFromNBT(aNBT, "gt.tank.1").setCapacity(this.mRate * 10L);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
        this.mActivity.save(aNBT);
        this.mTanks[0].writeToNBT(aNBT, "gt.tank.0");
        this.mTanks[1].writeToNBT(aNBT, "gt.tank.1");
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.getToolTipEfficiency(this.mEfficiency));
        LH.addEnergyToolTips(this, aList, null, this.mEnergyTypeEmitted, null, LH.get("gt.lang.face.front"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.funnel.tap.tank"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (this.mEnergy >= this.mRate) {
                ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, this.mRate, 1L, this);
                this.mEnergy -= this.mRate;
            }
            if (this.mEnergy < this.mRate * 2L && !this.mStopped) {
                this.mActivity.mActive = false;
                Recipe tRecipe = this.mRecipes.findRecipe((IHasWorldAndCoords)this, this.mLastRecipe, true, Long.MAX_VALUE, CS.NI, this.mTanks[0].AS_ARRAY, CS.ZL_IS);
                if (tRecipe != null) {
                    if (tRecipe.mFluidOutputs.length <= 0 || this.mTanks[1].canFillAll(tRecipe.mFluidOutputs[0])) {
                        if (tRecipe.isRecipeInputEqual(true, false, this.mTanks[0].AS_ARRAY, CS.ZL_IS)) {
                            this.mActivity.mActive = true;
                            this.mLastRecipe = tRecipe;
                            this.mEnergy += UT.Code.units(tRecipe.getAbsoluteTotalPower(), 10000L, this.mEfficiency, false);
                            if (tRecipe.mFluidOutputs.length > 0) {
                                this.mTanks[1].fill(tRecipe.mFluidOutputs[0]);
                            }
                            while (this.mEnergy < this.mRate * 2L && (tRecipe.mFluidOutputs.length <= 0 || this.mTanks[1].canFillAll(tRecipe.mFluidOutputs[0])) && tRecipe.isRecipeInputEqual(true, false, this.mTanks[0].AS_ARRAY, CS.ZL_IS)) {
                                this.mEnergy += UT.Code.units(tRecipe.getAbsoluteTotalPower(), 10000L, this.mEfficiency, false);
                                if (tRecipe.mFluidOutputs.length > 0) {
                                    this.mTanks[1].fill(tRecipe.mFluidOutputs[0]);
                                }
                                if (!this.mTanks[0].isEmpty()) continue;
                                break;
                            }
                        } else if (this.mActivity.mData == 0L) {
                            this.mTanks[0].setEmpty();
                        }
                    }
                } else {
                    this.mTanks[0].setEmpty();
                }
            }
            if (this.mEnergy < 0L) {
                this.mEnergy = 0L;
            }
            if (this.mTanks[1].has()) {
                FL.move(this.mTanks[1], this.getAdjacentTank(CS.OPOS[this.mFacing]));
                if (FL.gas(this.mTanks[1]) && !WD.hasCollide(this.field_145850_b, this.getOffset(CS.OPOS[this.mFacing], 1))) {
                    this.mTanks[1].setEmpty();
                }
            }
        } else if (this.mActivity.mState != 0 && WD.random(this, 20, CS.CLIENT_TIME)) {
            UT.Sounds.play("minecart.base", 1, 0.5f, this.getCoords());
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("plunger")) {
            if (this.mTanks[1].has()) {
                return CS.GarbageGT.trash(this.mTanks[1]);
            }
            return CS.GarbageGT.trash(this.mTanks[0]);
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add("Input: " + this.mTanks[0].content());
                aChatReturn.add("Output: " + this.mTanks[1].content());
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mActivity.check(this.mStopped) || super.onTickCheck(aTimer);
    }

    @Override
    public void setVisualData(byte aData) {
        this.mActivity.mState = (byte)(aData & 0x7F);
    }

    @Override
    public byte getVisualData() {
        return this.mActivity.mState;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_VALID;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return this.mRecipes.containsInput(aFluidToFill, (IHasWorldAndCoords)this, CS.NI) ? this.mTanks[0] : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return this.mTanks[1];
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        if (!this.mRecipes.containsInput(aFluid, (IHasWorldAndCoords)this, CS.NI)) {
            return 0;
        }
        this.updateInventory();
        return this.mTanks[0].fill(aFluid, aDoFill);
    }

    @Override
    public FluidStack tapDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        this.updateInventory();
        return this.mTanks[this.mTanks[1].has() ? 1 : 0].drain(aMaxDrain, aDoDrain);
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        if (aSide == this.mFacing) {
            return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[0], this.mRGBa), BlockTextureDefault.get((this.mActivity.mState > 0 ? sOverlaysActive : sOverlays)[0]));
        }
        if (aSide == CS.OPOS[this.mFacing]) {
            return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[1], this.mRGBa), BlockTextureDefault.get((this.mActivity.mState > 0 ? sOverlaysActive : sOverlays)[1]));
        }
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[2], this.mRGBa), BlockTextureDefault.get((this.mActivity.mState > 0 ? sOverlaysActive : sOverlays)[2]));
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return CS.ZL_IS;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting && aEnergyType == this.mEnergyTypeEmitted;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return aSide == this.mFacing && super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergyOffered(TagData aEnergyType, byte aSide, long aSize) {
        return Math.min(this.mRate, this.mEnergy);
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeEmitted.AS_LIST;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActivity.mActive;
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mActivity.mActive || this.mTanks[0].has() && !this.mTanks[1].isFull();
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mActivity.mActive;
    }

    @Override
    public boolean setAdjacentOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.generator.motor_liquid";
    }
}

