/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.computer;

import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.gui.ContainerClientDefault;
import gregapi.gui.ContainerCommonDefault;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.computer.TileEntityBase08DataSwitch;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntityUSBSwitch
extends TileEntityBase08DataSwitch {
    public static IIconContainer[] sColoreds;
    public static IIconContainer[] sOverlays;

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.usb.switch.tooltip"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public NBTTagCompound getUSBData(byte aSide, int aUSBTier) {
        ItemStack tUSB = this.slot(this.mMode);
        if (OM.is(CS.OD_USB_STICKS[aUSBTier], tUSB) && tUSB.func_77942_o() && tUSB.func_77978_p().func_74771_c("gt.usb.tier") <= aUSBTier) {
            return tUSB.func_77978_p().func_74775_l("gt.usb.data");
        }
        return null;
    }

    @Override
    public boolean setUSBData(byte aSide, int aUSBTier, NBTTagCompound aData) {
        ItemStack tUSB = this.slot(this.mMode);
        if (OM.is(CS.OD_USB_STICKS[aUSBTier], tUSB)) {
            if (!tUSB.func_77942_o()) {
                tUSB.func_77982_d(UT.NBT.make());
            }
            if (aData == null || aData.func_82582_d()) {
                tUSB.func_77978_p().func_82580_o("gt.usb.data");
                tUSB.func_77978_p().func_82580_o("gt.usb.tier");
            } else {
                tUSB.func_77978_p().func_74782_a("gt.usb.data", (NBTBase)aData);
                tUSB.func_77978_p().func_74774_a("gt.usb.tier", (byte)aUSBTier);
            }
            if (tUSB.func_77978_p().func_82582_d()) {
                tUSB.func_77982_d(null);
            }
            return true;
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[(int)UT.Code.bind_(0L, 2L, aSide)], this.mRGBa), BlockTextureDefault.get(sOverlays[(int)UT.Code.bind_(0L, 2L, aSide)])) : null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.usb.hub";
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[16];
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return OM.is(CS.OD_USB_STICKS[0], aStack);
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientDefault(aPlayer.field_71071_by, this, aGUIID, CS.RES_PATH_GUI + "machines/USBSwitch.png");
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonDefault(aPlayer.field_71071_by, this, aGUIID);
    }

    static {
        LH.add("gt.multitileentity.usb.switch.tooltip", "Switches between 16 different USB Sticks using Selector Covers");
        sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/usb/switch/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/usb/switch/colored/top"), new Textures.BlockIcons.CustomIcon("machines/usb/switch/colored/side")};
        sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/usb/switch/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/usb/switch/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/usb/switch/overlay/side")};
    }
}

