/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.tools.electric;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.RM;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.Behavior_Switch_Metadata;
import gregapi.old.Textures;
import gregapi.recipes.Recipe;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import gregtech.items.tools.electric.GT_Tool_MiningDrill_LV;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;

public class GT_Tool_JackHammer_HV
extends GT_Tool_MiningDrill_LV {
    public final int mSwitchIndex;

    public GT_Tool_JackHammer_HV(int aSwitchIndex) {
        this.mSwitchIndex = aSwitchIndex;
    }

    @Override
    public int getToolDamagePerBlockBreak() {
        return 200;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 200;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 3200;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 800;
    }

    @Override
    public int getBaseQuality() {
        return 1;
    }

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 12.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 2.0f;
    }

    @Override
    public String getCraftingSound() {
        return CS.SFX.IC_DRILL_HARD;
    }

    @Override
    public String getEntityHitSound() {
        return CS.SFX.IC_DRILL_HARD;
    }

    @Override
    public String getMiningSound() {
        return CS.SFX.IC_DRILL_HARD;
    }

    @Override
    public boolean canCollect() {
        return false;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        return "pickaxe".equalsIgnoreCase(aBlock.getHarvestTool((int)aMetaData)) || aBlock instanceof BlockSilverfish || aBlock.func_149688_o() == Material.field_151576_e || aBlock.func_149688_o() == Material.field_151592_s || aBlock.func_149688_o() == Material.field_151588_w || aBlock.func_149688_o() == Material.field_151598_x;
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, long aAvailableDurability, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        Recipe tRecipe;
        int rConversions = 0;
        if (aBlock.hasTileEntity((int)aMetaData) || null == (tRecipe = RM.Hammer.findRecipe(null, null, true, Integer.MAX_VALUE, null, CS.ZL_FS, ST.make(aBlock, 1L, (long)aMetaData)))) {
            ArrayListNoNulls<ItemStack> tDrops = ST.arraylist(new ItemStack[0]);
            for (int i = 0; i < aDrops.size(); ++i) {
                tRecipe = RM.Hammer.findRecipe(null, null, true, Integer.MAX_VALUE, null, CS.ZL_FS, ST.amount(1L, aDrops.get(i)));
                if (tRecipe == null) continue;
                byte tStackSize = (byte)aDrops.get((int)i).field_77994_a;
                rConversions += tStackSize;
                aDrops.remove(i--);
                if (tRecipe.mOutputs.length <= 0) continue;
                for (byte j = 0; j < tStackSize; j = (byte)(j + 1)) {
                    ItemStack[] tHammeringOutput = tRecipe.getOutputs();
                    for (int k = 0; k < tHammeringOutput.length; ++k) {
                        if (tHammeringOutput[k] == null) continue;
                        tDrops.add(tHammeringOutput[k]);
                    }
                }
            }
            aDrops.addAll(tDrops);
        } else {
            aDrops.clear();
            ItemStack[] tHammeringOutput = tRecipe.getOutputs(CS.RNGSUS);
            for (int k = 0; k < tHammeringOutput.length; ++k) {
                if (tHammeringOutput[k] == null) continue;
                aDrops.add(tHammeringOutput[k]);
            }
            ++rConversions;
        }
        return rConversions;
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
        aItem.addItemBehavior(aID, new Behavior_Switch_Metadata(this.mSwitchIndex, true, true));
        super.onStatsAddedToTool(aItem, aID);
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? Textures.ItemIcons.VOID : Textures.ItemIcons.JACKHAMMER;
    }

    @Override
    public String getDeathMessage() {
        return "[VICTIM] has been jackhammered into pieces by [KILLER]";
    }
}

