/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.block.IBlockFoamable;
import gregapi.block.metatype.BlockMetaType;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.tileentity.ITileEntityFoamable;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.blocks.BlockCFoamFresh;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Behavior_Spray_Foam_Remover
extends IBehavior.AbstractBehaviorDefault {
    private final ItemStack mEmpty;
    private final ItemStack mUsed;
    private final ItemStack mFull;
    private final long mUses;

    public Behavior_Spray_Foam_Remover(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aUses) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses * 10L;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        long tRemoved;
        if (aWorld.field_72995_K || aStack.field_77994_a != 1 || !aPlayer.func_82247_a(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        boolean rOutput = false;
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = UT.NBT.make();
        }
        long tUses = tNBT.func_74763_f("gt.remaining");
        if (ST.equal(aStack, this.mFull, true)) {
            aStack.func_150996_a(this.mUsed.func_77973_b());
            ST.meta_(aStack, ST.meta_(this.mUsed));
            tUses = this.mUses;
        }
        if (ST.equal(aStack, this.mUsed, true) && (tRemoved = this.remove(aWorld, aX, aY, aZ, aSide, UT.Entities.hasInfiniteItems(aPlayer) ? this.mUses : tUses, aPlayer, aStack)) > 0L) {
            UT.Sounds.send(CS.SFX.IC_SPRAY, 1.0f, 1.5f, aWorld, aX, aY, aZ);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                tUses -= tRemoved;
            }
            rOutput = true;
        }
        tNBT.func_82580_o("gt.remaining");
        if (tUses > 0L) {
            UT.NBT.setNumber(tNBT, "gt.remaining", tUses);
        }
        UT.NBT.set(aStack, tNBT);
        if (tUses <= 0L) {
            if (this.mEmpty == null) {
                --aStack.field_77994_a;
            } else {
                aStack.func_150996_a(this.mEmpty.func_77973_b());
                ST.meta_(aStack, ST.meta_(this.mEmpty));
            }
        }
        return rOutput;
    }

    public long remove(World aWorld, int aX, int aY, int aZ, byte aSide, long aUses, EntityPlayer aPlayer, ItemStack aStack) {
        if (aUses < 1L) {
            return 0L;
        }
        DelegatorTileEntity<TileEntity> aTileEntity = WD.te(aWorld, aX, aY, aZ, aSide, true);
        if (aTileEntity.mTileEntity instanceof ITileEntityFoamable) {
            return ((ITileEntityFoamable)aTileEntity.mTileEntity).removeFoam(aTileEntity.mSideOfTileEntity, (Entity)aPlayer) ? 10L : 0L;
        }
        Block aBlock = aTileEntity.getBlock();
        aWorld = aTileEntity.mWorld;
        aX = aTileEntity.mX;
        aY = aTileEntity.mY;
        aZ = aTileEntity.mZ;
        if (aBlock instanceof IBlockFoamable) {
            return ((IBlockFoamable)aBlock).removeFoam(aWorld, aX, aY, aZ, aTileEntity.mSideOfTileEntity) ? (aBlock instanceof BlockCFoamFresh && CS.SIDES_VALID[((BlockMetaType)aBlock).mSide] ? 5L : 10L) : 0L;
        }
        try {
            if (UT.Reflection.getClassName(aTileEntity.mTileEntity).startsWith("TileEntityCable")) {
                if (aUses >= 10L && UT.Reflection.getPublicField(aTileEntity.mTileEntity, "foamed").getByte(aTileEntity.mTileEntity) >= 1) {
                    UT.Reflection.callPublicMethod(aTileEntity.mTileEntity, "changeFoam", (byte)0);
                    return 10L;
                }
                return 0L;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        if (IL.IC2_Foam.block() == aBlock || IL.IC2_Wall.block() == aBlock) {
            return aUses >= 10L && aWorld.func_147465_d(aX, aY, aZ, CS.NB, 0, 3) ? 10L : 0L;
        }
        return 0L;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.foamremoverspray.tooltip"));
        NBTTagCompound tNBT = aStack.func_77978_p();
        long tRemaining = ST.equal(aStack, this.mFull, true) ? this.mUses : (tNBT == null ? 0L : tNBT.func_74763_f("gt.remaining"));
        aList.add(LH.get("gt.behaviour.removerspray.uses") + " " + tRemaining / 10L + "." + tRemaining % 10L);
        aList.add(LH.get("gt.behaviour.unstackable"));
        return aList;
    }

    static {
        LH.add("gt.behaviour.foamremoverspray.tooltip", "Can remove C-Foam");
        LH.add("gt.behaviour.removerspray.uses", "Remaining Uses:");
        LH.add("gt.behaviour.unstackable", "Not usable when stacked!");
    }
}

