/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.block.IBlockToolable;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class Behavior_Duct_Tape
extends IBehavior.AbstractBehaviorDefault {
    private final ItemStack mEmpty;
    private final ItemStack mUsed;
    private final ItemStack mFull;
    private final long mUses;
    private final long mQuality;

    public Behavior_Duct_Tape(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aQuality, long aUses) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses;
        this.mQuality = aQuality;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long tUsed;
        if (aWorld.field_72995_K || aStack.field_77994_a != 1 || !aPlayer.func_82247_a(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        boolean rOutput = false;
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = UT.NBT.make();
        }
        long tUses = tNBT.func_74763_f("gt.remaining");
        if (ST.equal(aStack, this.mFull, true)) {
            aStack.func_150996_a(this.mUsed.func_77973_b());
            ST.meta_(aStack, ST.meta_(this.mUsed));
            tUses = this.mUses;
        }
        if (ST.equal(aStack, this.mUsed, true) && (tUsed = this.tape(aWorld, aX, aY, aZ, aSide, UT.Entities.hasInfiniteItems(aPlayer) ? this.mUses : tUses, aPlayer, aStack, aHitX, aHitY, aHitZ)) > 0L) {
            UT.Sounds.send("dig.cloth", aWorld, aX, aY, aZ);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                tUses -= tUsed;
            }
            rOutput = true;
        }
        tNBT.func_82580_o("gt.remaining");
        if (tUses > 0L) {
            UT.NBT.setNumber(tNBT, "gt.remaining", tUses);
        }
        UT.NBT.set(aStack, tNBT);
        if (tUses <= 0L) {
            if (this.mEmpty == null) {
                --aStack.field_77994_a;
            } else {
                aStack.func_150996_a(this.mEmpty.func_77973_b());
                ST.meta_(aStack, ST.meta_(this.mEmpty));
            }
        }
        return rOutput;
    }

    public long tape(World aWorld, int aX, int aY, int aZ, byte aSide, long aUses, EntityPlayer aPlayer, ItemStack aStack, float aHitX, float aHitY, float aHitZ) {
        if (aPlayer == null || CS.SIDES_INVALID[aSide] || aPlayer instanceof FakePlayer || !WD.obstructed(aWorld, aX, aY, aZ, aSide)) {
            ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
            long tDamage = IBlockToolable.Util.onToolClick("ducttape", aUses, this.mQuality, (Entity)aPlayer, tChatReturn, (IInventory)(aPlayer == null ? null : aPlayer.field_71071_by), aPlayer != null && aPlayer.func_70093_af(), aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
            UT.Entities.sendchat((Object)aPlayer, tChatReturn, false);
            return tDamage;
        }
        return 0L;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.ducttape.tooltip"));
        NBTTagCompound tNBT = aStack.func_77978_p();
        long tRemaining = ST.equal(aStack, this.mFull, true) ? this.mUses : (tNBT == null ? 0L : tNBT.func_74763_f("gt.remaining"));
        aList.add(LH.get("gt.behaviour.ducttape.uses") + " " + UT.Code.makeString(tRemaining));
        aList.add(LH.get("gt.behaviour.unstackable"));
        return aList;
    }

    static {
        LH.add("gt.behaviour.ducttape.tooltip", "Can fix anything!*");
        LH.add("gt.behaviour.ducttape.uses", "Remaining Uses:");
        LH.add("gt.behaviour.unstackable", "Not usable when stacked!");
    }
}

