/*
 * Decompiled with CFR 0.152.
 */
package gregtech;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import gregapi.GT_API;
import gregapi.api.Abstract_Mod;
import gregapi.api.Abstract_Proxy;
import gregapi.block.IBlockToolable;
import gregapi.block.metatype.BlockStones;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IIconContainer;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.blocks.fluids.BlockWaterlike;
import gregtech.entities.Override_Drops;
import gregtech.entities.ai.EntityAIBetterAttackOnCollide;
import gregtech.entities.projectiles.EntityArrow_Material;
import gregtech.tileentity.misc.MultiTileEntityCertificate;
import java.util.EnumSet;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fluids.Fluid;

public abstract class GT_Proxy
extends Abstract_Proxy {
    public final HashSetNoNulls<String> mSupporterListSilver = new HashSetNoNulls();
    public final HashSetNoNulls<String> mSupporterListGold = new HashSetNoNulls();
    public String mMessage = "";
    public boolean mDisableVanillaOres = true;
    public boolean mDisableVanillaLakes = true;
    public boolean mVersionOutdated = false;
    public int mSkeletonsShootGTArrows = 16;
    public int mFlintChance = 30;
    private static final EnumSet<OreGenEvent.GenerateMinable.EventType> PREVENTED_ORES = EnumSet.of(OreGenEvent.GenerateMinable.EventType.COAL, new OreGenEvent.GenerateMinable.EventType[]{OreGenEvent.GenerateMinable.EventType.IRON, OreGenEvent.GenerateMinable.EventType.GOLD, OreGenEvent.GenerateMinable.EventType.DIAMOND, OreGenEvent.GenerateMinable.EventType.REDSTONE, OreGenEvent.GenerateMinable.EventType.LAPIS, OreGenEvent.GenerateMinable.EventType.QUARTZ});
    private static final HashSetNoNulls<String> CHECKED_PLAYERS = new HashSetNoNulls();

    public GT_Proxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.ORE_GEN_BUS.register((Object)this);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public void onProxyBeforePreInit(Abstract_Mod aMod, FMLPreInitializationEvent aEvent) {
        Scanner tScanner;
        super.onProxyBeforePreInit(aMod, aEvent);
        try {
            tScanner = new Scanner(this.getClass().getResourceAsStream("/supporterlist.txt"));
            while (tScanner.hasNextLine()) {
                this.mSupporterListSilver.add(tScanner.nextLine().toLowerCase());
            }
            tScanner.close();
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        try {
            tScanner = new Scanner(this.getClass().getResourceAsStream("/supporterlistgold.txt"));
            while (tScanner.hasNextLine()) {
                this.mSupporterListGold.add(tScanner.nextLine().toLowerCase());
            }
            tScanner.close();
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        this.mSupporterListSilver.removeAll(this.mSupporterListGold);
    }

    @SubscribeEvent
    public void onClientConnectedToServerEvent(FMLNetworkEvent.ClientConnectedToServerEvent aEvent) {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEndermanTeleportEvent(EnderTeleportEvent aEvent) {
        if (aEvent.entityLiving instanceof EntityEnderman && aEvent.entityLiving.func_70660_b(Potion.field_76437_t) != null) {
            aEvent.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onOreGenEvent(OreGenEvent.GenerateMinable aEvent) {
        if (this.mDisableVanillaOres && !WD.dimTF(aEvent.world) && PREVENTED_ORES.contains(aEvent.type)) {
            aEvent.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTerrainGenEvent(DecorateBiomeEvent.Decorate aEvent) {
        if (aEvent.world.field_73011_w.field_76574_g == 0) {
            String tClassName;
            if (MD.RTG.mLoaded && ("WorldProviderSurfaceRTG".equalsIgnoreCase(tClassName = UT.Reflection.getLowercaseClass(aEvent.world.field_73011_w.field_76577_b)) || "WorldTypeRTG".equalsIgnoreCase(tClassName))) {
                return;
            }
            if (CS.GENERATE_STREETS && (UT.Code.inside(-48L, 47L, aEvent.chunkX) || UT.Code.inside(-48L, 47L, aEvent.chunkZ))) {
                aEvent.setResult(Event.Result.DENY);
                return;
            }
            if (CS.GENERATE_BIOMES && UT.Code.inside(-96L, 95L, aEvent.chunkX) && UT.Code.inside(-96L, 95L, aEvent.chunkZ)) {
                aEvent.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTerrainGenEvent(PopulateChunkEvent.Populate aEvent) {
        if (aEvent.world.field_73011_w.field_76574_g == 0) {
            String tClassName;
            if (this.mDisableVanillaLakes && (aEvent.type == PopulateChunkEvent.Populate.EventType.LAKE || aEvent.type == PopulateChunkEvent.Populate.EventType.LAVA)) {
                aEvent.setResult(Event.Result.DENY);
                return;
            }
            if (MD.RTG.mLoaded && ("WorldProviderSurfaceRTG".equalsIgnoreCase(tClassName = UT.Reflection.getLowercaseClass(aEvent.world.field_73011_w.field_76577_b)) || "WorldTypeRTG".equalsIgnoreCase(tClassName))) {
                return;
            }
            if (CS.GENERATE_STREETS && (UT.Code.inside(-48L, 47L, aEvent.chunkX) || UT.Code.inside(-48L, 47L, aEvent.chunkZ))) {
                aEvent.setResult(Event.Result.DENY);
                return;
            }
            if (CS.GENERATE_BIOMES && UT.Code.inside(-96L, 95L, aEvent.chunkX) && UT.Code.inside(-96L, 95L, aEvent.chunkZ)) {
                aEvent.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onGetVillageBlockIDEvent(BiomeEvent.GetVillageBlockID aEvent) {
        if (aEvent.original == Blocks.field_150347_e) {
            aEvent.replacement = aEvent.biome == null ? CS.BlocksGT.Andesite : CS.BlocksGT.stones[(aEvent.biome.field_76756_M + 6) % CS.BlocksGT.stones.length];
            aEvent.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onGetVillageBlockMetaEvent(BiomeEvent.GetVillageBlockMeta aEvent) {
        if (aEvent.original == Blocks.field_150347_e || aEvent.original instanceof BlockStones) {
            aEvent.replacement = 12;
            aEvent.setResult(Event.Result.DENY);
        }
        if (aEvent.original == Blocks.field_150322_A) {
            aEvent.replacement = 2;
            aEvent.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteraction(PlayerInteractEvent aEvent) {
        ItemStack aStack;
        if (aEvent.entityPlayer == null || aEvent.entityPlayer.field_70170_p == null || aEvent.action == null || aEvent.world.field_73011_w == null) {
            return;
        }
        String aName = aEvent.entityPlayer.func_70005_c_();
        String aNameLowercase = aName.toLowerCase();
        if (!aEvent.world.field_72995_K && CHECKED_PLAYERS.add(aName) && (this.mSupporterListSilver.contains(aEvent.entityPlayer.func_110124_au().toString()) || this.mSupporterListGold.contains(aEvent.entityPlayer.func_110124_au().toString()) || this.mSupporterListSilver.contains(aNameLowercase) || this.mSupporterListGold.contains(aNameLowercase)) && !MultiTileEntityCertificate.ALREADY_RECEIVED.contains(aNameLowercase) && ST.give((Entity)aEvent.entityPlayer, MultiTileEntityCertificate.getCertificate(1, aName), false)) {
            MultiTileEntityCertificate.ALREADY_RECEIVED.add(aNameLowercase);
            UT.Entities.sendchat((Object)aEvent.entityPlayer, CS.CHAT_GREG + "Thank you, " + aName + ", for Supporting GregTech! Here, have a Certificate. ;)");
        }
        if ((aStack = aEvent.entityPlayer.func_71045_bC()) != null && aStack.field_77994_a > 0) {
            if (aEvent.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
                if (aStack.func_77973_b() == Items.field_151069_bo) {
                    aEvent.setCanceled(true);
                    if (aEvent.world.field_72995_K) {
                        GT_API.api_proxy.sendUseItemPacket(aEvent.entityPlayer, aEvent.world, aStack);
                        return;
                    }
                    MovingObjectPosition tTarget = WD.getMOP(aEvent.world, aEvent.entityPlayer, true);
                    if (tTarget == null || tTarget.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || !aEvent.world.func_72962_a(aEvent.entityPlayer, tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d) || !aEvent.entityPlayer.func_82247_a(tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d, tTarget.field_72310_e, aStack)) {
                        return;
                    }
                    Block tBlock = aEvent.world.func_147439_a(tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d);
                    if (tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150358_i) {
                        if (aEvent.world.func_72805_g(tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d) != 0) {
                            return;
                        }
                        for (int i = 0; i < 3 && aStack.field_77994_a > 0; ++i) {
                            if (aStack.field_77994_a == 1) {
                                aEvent.entityPlayer.field_71071_by.field_70462_a[aEvent.entityPlayer.field_71071_by.field_70461_c] = ST.make((Item)Items.field_151068_bn, 1L, 0L);
                                continue;
                            }
                            ST.use((Entity)aEvent.entityPlayer, aStack);
                            ST.give((Entity)aEvent.entityPlayer, ST.make((Item)Items.field_151068_bn, 1L, 0L), false);
                        }
                        if (!WD.infiniteWater(aEvent.world, tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d)) {
                            aEvent.world.func_147468_f(tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d);
                        }
                        ST.update((Entity)aEvent.entityPlayer);
                        return;
                    }
                    if (tBlock == CS.BlocksGT.River || WD.waterstream(tBlock)) {
                        ItemStack tStack = FL.Water.fill(aStack);
                        if (tStack == null) {
                            return;
                        }
                        ST.use((Entity)aEvent.entityPlayer, aStack);
                        ST.give((Entity)aEvent.entityPlayer, tStack, false);
                        return;
                    }
                    if (tBlock == CS.BlocksGT.Ocean) {
                        ItemStack tStack = FL.Ocean.fill(aStack);
                        if (tStack == null) {
                            return;
                        }
                        ST.use((Entity)aEvent.entityPlayer, aStack);
                        ST.give((Entity)aEvent.entityPlayer, tStack, false);
                        return;
                    }
                    if (tBlock == CS.BlocksGT.Swamp) {
                        ItemStack tStack = FL.Dirty_Water.fill(aStack);
                        if (tStack == null) {
                            return;
                        }
                        ST.use((Entity)aEvent.entityPlayer, aStack);
                        ST.give((Entity)aEvent.entityPlayer, tStack, false);
                        return;
                    }
                    return;
                }
                if (aStack.func_77973_b() == Items.field_151133_ar) {
                    Block tBlock;
                    MovingObjectPosition tTarget = WD.getMOP(aEvent.world, aEvent.entityPlayer, true);
                    if (tTarget != null && tTarget.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (tBlock = aEvent.world.func_147439_a(tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d)) instanceof BlockWaterlike && tBlock != CS.BlocksGT.River) {
                        aEvent.setCanceled(true);
                    }
                    return;
                }
            }
            if (aEvent.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                OreDictItemData tData;
                if (IL.ERE_Spray_Repellant.equal(aStack, true, true)) {
                    if (!aEvent.world.field_72995_K && aStack.func_77973_b().func_77648_a(aStack, aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, aEvent.face, 0.5f, 0.5f, 0.5f)) {
                        aEvent.setCanceled(true);
                        ST.give((Entity)aEvent.entityPlayer, IL.Spray_Empty.get(1L, new Object[0]), aEvent.world, aEvent.x, aEvent.y, aEvent.z);
                        return;
                    }
                } else if (aStack.func_77973_b() == Items.field_151033_d) {
                    if (!aEvent.world.field_72995_K && !UT.Entities.hasInfiniteItems(aEvent.entityPlayer) && CS.RNGSUS.nextInt(100) >= this.mFlintChance) {
                        aEvent.setCanceled(true);
                        aStack.func_77972_a(1, (EntityLivingBase)aEvent.entityPlayer);
                        if (aStack.func_77960_j() >= aStack.func_77958_k()) {
                            ST.use((Entity)aEvent.entityPlayer, aStack);
                        }
                        return;
                    }
                    ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
                    long tDamage = IBlockToolable.Util.onToolClick("igniter", aStack.func_77960_j() * 10000, 1L, (Entity)aEvent.entityPlayer, tChatReturn, (IInventory)aEvent.entityPlayer.field_71071_by, aEvent.entityPlayer.func_70093_af(), aStack, aEvent.world, (byte)aEvent.face, aEvent.x, aEvent.y, aEvent.z, 0.5f, 0.5f, 0.5f);
                    UT.Entities.sendchat((Object)aEvent.entityPlayer, tChatReturn, false);
                    if (tDamage > 0L) {
                        aEvent.setCanceled(true);
                        UT.Sounds.send("fire.ignite", aEvent.world, aEvent.x, aEvent.y, aEvent.z);
                        if (!UT.Entities.hasInfiniteItems(aEvent.entityPlayer)) {
                            aStack.func_77972_a(UT.Code.bindInt(UT.Code.units(tDamage, 10000L, 1L, true)), (EntityLivingBase)aEvent.entityPlayer);
                            if (aStack.func_77960_j() >= aStack.func_77958_k()) {
                                ST.use((Entity)aEvent.entityPlayer, aStack);
                            }
                        }
                        return;
                    }
                } else if (IL.Food_Toast_Sliced.equal(aStack, false, true) || IL.Food_Toasted_Sliced.equal(aStack, false, true)) {
                    int tUsed = Math.min(16, aStack.field_77994_a);
                    if (!aEvent.world.field_72995_K && aEvent.entityPlayer.func_70093_af() && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32105, ST.save("sandwich.0", ST.amount(tUsed, aStack))).func_77943_a(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack, tUsed);
                        aEvent.setCanceled(true);
                    }
                } else if (aStack.func_77973_b() == Items.field_151055_y || IL.Stick.equal(aStack) || OM.is("stickAnyNormalWood", aStack)) {
                    if (!aEvent.world.field_72995_K && aEvent.entityPlayer.func_70093_af() && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32073).func_77943_a(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack);
                        aEvent.setCanceled(true);
                    }
                } else if (aStack.func_77973_b() == Items.field_151145_ak) {
                    if (!aEvent.world.field_72995_K && aEvent.entityPlayer.func_70093_af() && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32074, ST.save("gt.value", ST.amount(1L, aStack))).func_77943_a(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack);
                        aEvent.setCanceled(true);
                    }
                } else if (!aEvent.world.field_72995_K && aEvent.entityPlayer.func_70093_af() && ST.block(aStack) == CS.NB && (tData = OM.anyassociation_(aStack)) != null) {
                    if ((tData.mPrefix == OP.rockGt || tData.mPrefix == OP.oreRaw) && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32074, ST.save("gt.value", ST.amount(1L, aStack))).func_77943_a(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack);
                        aEvent.setCanceled(true);
                    }
                    if (tData.mPrefix == OP.ingot && (!MD.BOTA.mLoaded || tData.mMaterial.mMaterial.mOriginalMod != MD.BOTA || Blocks.field_150461_bJ != aEvent.world.func_147439_a(aEvent.x, aEvent.y, aEvent.z)) && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32084, ST.save("gt.value", aStack)).func_77943_a(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack, aStack.field_77994_a);
                        aEvent.setCanceled(true);
                    }
                    if (tData.mPrefix == OP.plate && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32085, ST.save("gt.value", aStack)).func_77943_a(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack, aStack.field_77994_a);
                        aEvent.setCanceled(true);
                    }
                    if (tData.mPrefix == OP.plateGem && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32086, ST.save("gt.value", aStack)).func_77943_a(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack, aStack.field_77994_a);
                        aEvent.setCanceled(true);
                    }
                    if (tData.mPrefix == OP.scrapGt && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32103, ST.save("gt.value", aStack)).func_77943_a(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack, aStack.field_77994_a);
                        aEvent.setCanceled(true);
                    }
                }
            }
        } else if (aEvent.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && aEvent.entityPlayer.func_70027_ad()) {
            ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
            long tDamage = IBlockToolable.Util.onToolClick("igniter", Long.MAX_VALUE, 1L, (Entity)aEvent.entityPlayer, tChatReturn, (IInventory)aEvent.entityPlayer.field_71071_by, aEvent.entityPlayer.func_70093_af(), CS.NI, aEvent.world, (byte)aEvent.face, aEvent.x, aEvent.y, aEvent.z, 0.5f, 0.5f, 0.5f);
            UT.Entities.sendchat((Object)aEvent.entityPlayer, tChatReturn, false);
            if (tDamage > 0L) {
                UT.Sounds.send("fire.ignite", aEvent.world, aEvent.x, aEvent.y, aEvent.z);
                aEvent.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntitySpawningEvent(EntityJoinWorldEvent aEvent) {
        if (aEvent.entity == null) {
            return;
        }
        if (aEvent.entity instanceof EntityLiving) {
            EntityAITasks tTasks = ((EntityLiving)aEvent.entity).field_70714_bg;
            if (tTasks != null) {
                if (aEvent.entity instanceof EntityVillager) {
                    tTasks.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)aEvent.entity, 0.6, Items.field_151166_bC, false));
                }
                if (aEvent.entity instanceof EntityOcelot && CS.ItemsGT.CANS != null) {
                    tTasks.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)aEvent.entity, 0.6, (Item)CS.ItemsGT.CANS, true));
                }
                if (aEvent.entity instanceof EntityZombie) {
                    for (int i = 0; i < tTasks.field_75782_a.size(); ++i) {
                        EntityAITasks.EntityAITaskEntry tEntry = (EntityAITasks.EntityAITaskEntry)tTasks.field_75782_a.get(i);
                        if (tEntry.field_75733_a.getClass() != EntityAIAttackOnCollide.class) continue;
                        tEntry.field_75733_a = new EntityAIBetterAttackOnCollide((EntityAIAttackOnCollide)tEntry.field_75733_a);
                    }
                }
            }
            if (!aEvent.entity.field_70170_p.field_72995_K && !aEvent.entity.getEntityData().func_74764_b("gt.spawned")) {
                if (aEvent.entity instanceof EntityZombie && !((EntityZombie)aEvent.entity).func_70631_g_() && ST.invalid(((EntityZombie)aEvent.entity).func_71124_b(0))) {
                    if (CS.ZOMBIES_HOLD_TNT && CS.RNGSUS.nextInt(250) == 0) {
                        ((EntityZombie)aEvent.entity).func_70062_b(0, ST.make(Blocks.field_150335_W, (long)(1 + CS.RNGSUS.nextInt(2)), 0L));
                    } else if (CS.ZOMBIES_HOLD_PICKAXES && CS.RNGSUS.nextInt(100) == 0) {
                        ((EntityZombie)aEvent.entity).func_70062_b(0, ST.make(Items.field_151035_b, 1L, Items.field_151035_b.func_77612_l() < 5 ? 0L : (long)(1 + CS.RNGSUS.nextInt(Items.field_151035_b.func_77612_l() - 2))));
                    }
                }
                aEvent.entity.getEntityData().func_74757_a("gt.spawned", true);
            }
            return;
        }
        if (aEvent.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.mSkeletonsShootGTArrows > 0 && aEvent.entity.getClass() == EntityArrow.class && CS.RNGSUS.nextInt(this.mSkeletonsShootGTArrows) == 0 && ((EntityArrow)aEvent.entity).field_70250_c instanceof EntitySkeleton) {
            OreDictMaterial tMaterial = MT.Craponite;
            switch (CS.RNGSUS.nextInt(10)) {
                case 0: {
                    tMaterial = MT.Steel;
                    break;
                }
                case 1: {
                    tMaterial = MT.AnnealedCopper;
                    break;
                }
                case 2: {
                    tMaterial = MT.AstralSilver;
                    break;
                }
                case 3: {
                    tMaterial = MT.BismuthBronze;
                    break;
                }
                case 4: {
                    tMaterial = MT.Pt;
                    break;
                }
                case 5: {
                    tMaterial = MT.Netherite;
                    break;
                }
                case 6: {
                    tMaterial = MT.Efrine;
                    break;
                }
                case 7: {
                    tMaterial = MT.Rubber;
                    break;
                }
                case 8: {
                    tMaterial = MT.DamascusSteel;
                    break;
                }
                case 9: {
                    tMaterial = MT.Craponite;
                }
            }
            ItemStack tArrow = OP.arrowGtWood.mat(tMaterial, 1L);
            if (ST.valid(tArrow)) {
                aEvent.entity.field_70170_p.func_72838_d((Entity)new EntityArrow_Material((EntityArrow)aEvent.entity, tArrow));
                aEvent.entity.func_70106_y();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityLivingDropsEventEvent(LivingDropsEvent aEvent) {
        if (aEvent.entity.field_70170_p.field_72995_K || aEvent.entityLiving == null) {
            return;
        }
        Override_Drops.handleDrops(aEvent.entityLiving, UT.Reflection.getLowercaseClass(aEvent.entityLiving), aEvent.drops, aEvent.source, aEvent.lootingLevel, aEvent.entityLiving.func_70027_ad(), aEvent.recentlyHit);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityLivingFallEvent(LivingFallEvent aEvent) {
        if (!aEvent.entity.field_70170_p.field_72995_K && aEvent.entity instanceof EntityPlayer && (ST.equal(((EntityPlayer)aEvent.entity).func_71045_bC(), (Item)CS.ToolsGT.sMetaTool, 64L) || ST.equal(((EntityPlayer)aEvent.entity).func_71045_bC(), (Item)CS.ToolsGT.sMetaTool, 1012L))) {
            aEvent.distance *= 2.0f;
        }
    }

    @SafeVarargs
    public final Fluid addAutogeneratedLiquid(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
        return FL.createLiquid(aMaterial, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedLiquid(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
        return FL.createPlasma(aMaterial, aTexture, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedGas(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
        return FL.createGas(aMaterial, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedGas(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
        return FL.createGas(aMaterial, aTexture, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedMolten(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
        return FL.createMolten(aMaterial, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedMolten(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
        return FL.createMolten(aMaterial, aTexture, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedVapor(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
        return FL.createVapour(aMaterial, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedVaporized(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
        return FL.createVapour(aMaterial, aTexture, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedPlasma(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
        return FL.createPlasma(aMaterial, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedPlasma(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
        return FL.createPlasma(aMaterial, aTexture, aFluidList);
    }

    @SafeVarargs
    public final Fluid addFluid(String aName, String aLocalized, OreDictMaterial aMaterial, int aState, long aAmountPerUnit, long aTemperatureK, Set<String> ... aFluidList) {
        return FL.create(aName, aLocalized, aMaterial, aState, aAmountPerUnit, aTemperatureK, aFluidList);
    }

    @SafeVarargs
    public final Fluid addFluid(String aName, String aLocalized, OreDictMaterial aMaterial, int aState, long aAmountPerUnit, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount, Set<String> ... aFluidList) {
        return FL.create(aName, aLocalized, aMaterial, aState, aAmountPerUnit, aTemperatureK, aFullContainer, aEmptyContainer, aFluidAmount, aFluidList);
    }

    @SafeVarargs
    public final Fluid addFluid(String aName, IIconContainer aTexture, String aLocalized, OreDictMaterial aMaterial, short[] aRGBa, int aState, long aAmountPerUnit, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount, Set<String> ... aFluidList) {
        return FL.create(aName, aTexture, aLocalized, aMaterial, aRGBa, aState, aAmountPerUnit, aTemperatureK, aFullContainer, aEmptyContainer, aFluidAmount, aFluidList);
    }
}

