/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public abstract class WorldgenOnSurface
extends WorldgenObject {
    public final int mAmount;
    public final int mProbability;

    @SafeVarargs
    public WorldgenOnSurface(String aName, boolean aDefault, int aAmount, int aProbability, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
        this.mAmount = Math.max(1, this.getConfigFile().get((Object)this.mCategory, "Amount", (long)aAmount));
        this.mProbability = Math.max(1, this.getConfigFile().get((Object)this.mCategory, "Probability", (long)aProbability));
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        int i;
        int aAmount = this.canGenerate(aWorld, aChunk, aDimType, aMinX, aMinZ, aMaxX, aMaxZ, aRandom, aBiomes, aBiomeNames);
        if (aAmount <= 0) {
            return false;
        }
        int tMinHeight = Math.min(aWorld.func_72800_K() - 2, WD.waterLevel(aWorld) - 1);
        int tMaxHeight = Math.min(aWorld.func_72800_K() - 1, aWorld.field_73011_w.field_76576_e ? 80 : tMinHeight * 2 + 16);
        boolean[][] tTargets = new boolean[16][16];
        boolean rResult = false;
        for (i = 0; i < aAmount; ++i) {
            tTargets[aRandom.nextInt((int)16)][aRandom.nextInt((int)16)] = true;
        }
        for (i = 0; i < 16; ++i) {
            block2: for (int j = 0; j < 16; ++j) {
                Block tContact;
                if (!tTargets[i][j] || aRandom.nextInt(this.mProbability) != 0) continue;
                int tX = aMinX + i;
                int tZ = aMinZ + j;
                for (int tY = tMaxHeight; tY >= tMinHeight && (tContact = aChunk.func_150810_a(tX & 0xF, tY, tZ & 0xF)) != Blocks.field_150458_ak; --tY) {
                    if (!tContact.func_149688_o().func_76224_d() && (!tContact.func_149662_c() || tContact.isWood((IBlockAccess)aWorld, tX, tY, tZ) || tContact.isLeaves((IBlockAccess)aWorld, tX, tY, tZ))) continue;
                    rResult |= this.tryPlaceStuff(aWorld, tX, tY, tZ, aRandom, tContact);
                    continue block2;
                }
            }
        }
        return rResult;
    }

    public int canGenerate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        return this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ) ? 0 : this.mAmount;
    }

    public abstract boolean tryPlaceStuff(World var1, int var2, int var3, int var4, Random var5, Block var6);
}

