/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.connectors.TileEntityBase10ConnectorRendered;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataConductor;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityWireLaser
extends TileEntityBase10ConnectorRendered
implements ITileEntityQuickObstructionCheck,
ITileEntityEnergy,
ITileEntityEnergyDataConductor {
    public long mTransferred = 0L;
    public long mTransferredLast = 0L;

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.wire.stats.lossless") + " (" + TD.Energy.LU.getLocalisedChatNameShort() + LH.Chat.CYAN + ")");
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            this.mTransferredLast = this.mTransferred;
            this.mTransferred = 0L;
        }
    }

    public long transferLaser(byte aSide, long aFrequency, long aStrength, long aChannel, HashSetNoNulls<TileEntity> aAlreadyPassed) {
        long rUsedStrength = 0L;
        for (byte tSide : CS.ALL_SIDES_VALID_BUT[aSide]) {
            if (!this.canEmitEnergyTo(tSide)) continue;
            if (aStrength <= rUsedStrength) break;
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
            if (!aAlreadyPassed.add((TileEntity)tDelegator.mTileEntity)) continue;
            if (tDelegator.mTileEntity instanceof MultiTileEntityWireLaser) {
                if (!((MultiTileEntityWireLaser)tDelegator.mTileEntity).isEnergyAcceptingFrom(TD.Energy.LU, tDelegator.mSideOfTileEntity, false)) continue;
                rUsedStrength += ((MultiTileEntityWireLaser)tDelegator.mTileEntity).transferLaser(tDelegator.mSideOfTileEntity, aFrequency, aStrength - rUsedStrength, aChannel, aAlreadyPassed);
                continue;
            }
            rUsedStrength += ITileEntityEnergy.Util.insertEnergyInto(TD.Energy.LU, aFrequency, aStrength - rUsedStrength, this, tDelegator);
        }
        this.mTransferred += Math.abs(aFrequency * rUsedStrength);
        return rUsedStrength;
    }

    @Override
    public boolean canConnect(byte aSide, DelegatorTileEntity<TileEntity> aDelegator) {
        if (aDelegator.mTileEntity instanceof ITileEntityEnergy) {
            return ((ITileEntityEnergy)aDelegator.mTileEntity).isEnergyAcceptingFrom(TD.Energy.LU, aDelegator.mSideOfTileEntity, true) || ((ITileEntityEnergy)aDelegator.mTileEntity).isEnergyEmittingTo(TD.Energy.LU, aDelegator.mSideOfTileEntity, true);
        }
        return false;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEnergyType == TD.Energy.LU;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return TD.Energy.LU.AS_LIST;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, true) && this.canEmitEnergyTo(aSide);
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, false) && this.canAcceptEnergyFrom(aSide);
    }

    @Override
    public synchronized long doEnergyExtraction(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoExtract) {
        return 0L;
    }

    @Override
    public synchronized long doEnergyInjection(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        return aSize != 0L && this.isEnergyAcceptingFrom(aEnergyType, aSide, false) ? (aDoInject ? this.transferLaser(aSide, aSize, aAmount, -1L, new HashSetNoNulls<TileEntity>(false, this)) : aAmount) : 0L;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean isEnergyConducting(TagData aEnergyType) {
        return aEnergyType == TD.Energy.LU;
    }

    @Override
    public long getEnergyMaxSize(TagData aEnergyType) {
        return aEnergyType == TD.Energy.LU ? Long.MAX_VALUE : 0L;
    }

    @Override
    public long getEnergyMaxPackets(TagData aEnergyType) {
        return aEnergyType == TD.Energy.LU ? Long.MAX_VALUE : 0L;
    }

    @Override
    public long getEnergyLossPerMeter(TagData aEnergyType) {
        return 0L;
    }

    @Override
    public OreDictMaterial getEnergyConductorMaterial() {
        return this.mMaterial;
    }

    @Override
    public OreDictMaterial getEnergyConductorInsulation() {
        return MT.NULL;
    }

    public boolean canEmitEnergyTo(byte aSide) {
        return this.connected(aSide);
    }

    public boolean canAcceptEnergyFrom(byte aSide) {
        return this.connected(aSide);
    }

    @Override
    public ITexture getTextureSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureMulti.get(BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.FIBER_WIRE, this.mRGBa), BlockTextureDefault.get(Textures.BlockIcons.FIBER_WIRE_OVERLAY));
    }

    @Override
    public ITexture getTextureConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureMulti.get(BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.FIBER_WIRE, this.mRGBa), BlockTextureDefault.get(Textures.BlockIcons.FIBER_WIRE_OVERLAY));
    }

    @Override
    public Collection<TagData> getConnectorTypes(byte aSide) {
        return TD.Connectors.WIRE_LASER.AS_LIST;
    }

    @Override
    public String getFacingTool() {
        return "cutter";
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.connector.wire.laser";
    }
}

