/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.data.CS;
import gregapi.tileentity.connectors.ITileEntityConnector;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;

public interface ITileEntityItemPipe
extends ITileEntityConnector {
    public boolean pipeCapacityCheck();

    public boolean incrementTransferCounter(long var1);

    public boolean sendItemStack(Object var1);

    public boolean canEmitItemsTo(byte var1, Object var2);

    public boolean canAcceptItemsFrom(byte var1, Object var2);

    public boolean insertItemStackIntoTileEntity(Object var1, byte var2);

    public long getStepSize();

    public static class Util {
        public static Map<ITileEntityItemPipe, Long> scanPipes(ITileEntityItemPipe aPipe, Map<ITileEntityItemPipe, Long> aMap, long aStep, boolean aSuckItems, boolean aIgnoreCapacity) {
            if ((aIgnoreCapacity || aPipe.pipeCapacityCheck()) && (aMap.get(aPipe) == null || aMap.get(aPipe) > (aStep += aPipe.getStepSize()))) {
                aMap.put(aPipe, aStep);
                for (byte aSide : CS.ALL_SIDES_VALID) {
                    DelegatorTileEntity<TileEntity> tDelegator;
                    if (aSuckItems) {
                        if (!aPipe.canAcceptItemsFrom(aSide, null)) continue;
                        tDelegator = aPipe.getAdjacentTileEntity(aSide);
                        if (!(tDelegator.mTileEntity instanceof ITileEntityItemPipe) || !UT.Code.haveOneCommonElement(aPipe.getConnectorTypes(aSide), ((ITileEntityItemPipe)tDelegator.mTileEntity).getConnectorTypes(tDelegator.mSideOfTileEntity)) || !((ITileEntityItemPipe)tDelegator.mTileEntity).canEmitItemsTo(tDelegator.mSideOfTileEntity, null)) continue;
                        Util.scanPipes((ITileEntityItemPipe)tDelegator.mTileEntity, aMap, aStep, aSuckItems, aIgnoreCapacity);
                        continue;
                    }
                    if (!aPipe.canEmitItemsTo(aSide, null)) continue;
                    tDelegator = aPipe.getAdjacentTileEntity(aSide);
                    if (!(tDelegator.mTileEntity instanceof ITileEntityItemPipe) || !UT.Code.haveOneCommonElement(aPipe.getConnectorTypes(aSide), ((ITileEntityItemPipe)tDelegator.mTileEntity).getConnectorTypes(tDelegator.mSideOfTileEntity)) || !((ITileEntityItemPipe)tDelegator.mTileEntity).canAcceptItemsFrom(tDelegator.mSideOfTileEntity, null)) continue;
                    Util.scanPipes((ITileEntityItemPipe)tDelegator.mTileEntity, aMap, aStep, aSuckItems, aIgnoreCapacity);
                }
            }
            return aMap;
        }
    }
}

