/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapPlantalyzer
extends Recipe.RecipeMap {
    public RecipeMapPlantalyzer(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, false, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (aInputs == null || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        if (rRecipe == null) {
            for (ItemStack aInput : aInputs) {
                if (!ST.valid(aInput)) continue;
                if (IL.IC2_Crop_Seeds.equal(aInput = ST.amount(1L, aInput), true, true)) {
                    ItemStack rOutput = ST.copy(aInput);
                    NBTTagCompound tNBT = UT.NBT.getOrCreate(rOutput);
                    if (tNBT.func_74771_c("scan") >= 4) {
                        return new Recipe(false, false, false, ST.array(aInput), ST.array(aInput), null, null, null, null, 1L, 16L, 0L);
                    }
                    tNBT.func_74774_a("scan", (byte)4);
                    return new Recipe(false, false, false, ST.array(aInput), ST.array(rOutput), null, null, null, null, 64L, 16L, 0L);
                }
                if (!IL.FR_Tree_Sapling.equal(aInput, true, true)) continue;
                try {
                    IIndividual tIndividual = AlleleManager.alleleRegistry.getIndividual(aInput);
                    if (tIndividual == null || !tIndividual.analyze()) {
                        return new Recipe(false, false, false, ST.array(aInput), ST.array(aInput), null, null, null, null, 1L, 16L, 0L);
                    }
                    ItemStack rOutput = ST.copy(aInput);
                    tIndividual.writeToNBT(UT.NBT.getOrCreate(rOutput));
                    return new Recipe(false, false, false, ST.array(aInput), ST.array(rOutput), null, null, null, null, 64L, 16L, 0L);
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return rRecipe;
    }
}

