/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.util.UT;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

@ChannelHandler.Sharable
public final class NetworkHandler
extends MessageToMessageCodec<FMLProxyPacket, IPacket>
implements INetworkHandler {
    private final EnumMap<Side, FMLEmbeddedChannel> mChannel;
    private final IPacket[] mPacketTypes;
    private final String mModID;

    public NetworkHandler(String aModID, String aChannelName, IPacket ... aPacketTypes) {
        this.mModID = aModID;
        if (aChannelName.length() > 4) {
            throw new IllegalArgumentException("String for Channel Name must contain 4 Characters or less!");
        }
        this.mChannel = NetworkRegistry.INSTANCE.newChannel(aChannelName, new ChannelHandler[]{this, FMLCommonHandler.instance().getSide() == Side.CLIENT ? new HandlerClient(this) : new HandlerServer(this)});
        this.mPacketTypes = new IPacket[256];
        for (int i = 0; i < aPacketTypes.length; ++i) {
            short tID = UT.Code.unsignB(aPacketTypes[i].getPacketID());
            if (this.mPacketTypes[tID] != null) {
                throw new IllegalArgumentException("Duplicate Packet ID! " + tID);
            }
            this.mPacketTypes[tID] = aPacketTypes[i];
        }
    }

    protected void encode(ChannelHandlerContext aContext, IPacket aPacket, List<Object> aOutput) throws Exception {
        aOutput.add(new FMLProxyPacket(Unpooled.buffer().writeByte((int)aPacket.getPacketID()).writeBytes(aPacket.encode().toByteArray()), (String)aContext.channel().attr(NetworkRegistry.FML_CHANNEL).get()));
    }

    protected void decode(ChannelHandlerContext aContext, FMLProxyPacket aPacket, List<Object> aOutput) throws Exception {
        ByteArrayDataInput aData = ByteStreams.newDataInput((byte[])aPacket.payload().array());
        short aID = UT.Code.unsignB(aData.readByte());
        if (this.mPacketTypes[aID] == null) {
            FMLLog.warning((String)("Your Version of '" + this.mModID + "' definetly does not match the Version installed on the Server you joined! Do not report this as a Bug! You failed to install/update the proper Version of '" + this.mModID + "' all by yourself!"), (Object[])new Object[0]);
        } else {
            aOutput.add(this.mPacketTypes[aID].decode(aData));
        }
    }

    @Override
    public void sendToServer(IPacket aPacket) {
        if (aPacket == null) {
            return;
        }
        FMLEmbeddedChannel tChannel = this.getChannel(Side.CLIENT);
        tChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        tChannel.writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendToPlayer(IPacket aPacket, EntityPlayerMP aPlayer) {
        if (aPacket == null) {
            return;
        }
        FMLEmbeddedChannel tChannel = this.getChannel(Side.SERVER);
        tChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        tChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPlayer);
        tChannel.writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendToAllAround(IPacket aPacket, NetworkRegistry.TargetPoint aPosition) {
        if (aPacket == null) {
            return;
        }
        FMLEmbeddedChannel tChannel = this.getChannel(Side.SERVER);
        tChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        tChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPosition);
        tChannel.writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendToAllPlayersInRange(IPacket aPacket, World aWorld, ChunkCoordinates aCoords) {
        this.sendToAllPlayersInRange(aPacket, aWorld, aCoords.field_71574_a, aCoords.field_71573_c);
    }

    @Override
    public void sendToAllPlayersInRange(IPacket aPacket, World aWorld, int aX, int aZ) {
        if (aPacket == null) {
            return;
        }
        if (aWorld != null && !aWorld.field_72995_K) {
            for (Object tObject : aWorld.field_73010_i) {
                if (tObject instanceof EntityPlayerMP) {
                    EntityPlayerMP tPlayer = (EntityPlayerMP)tObject;
                    Chunk tChunk = aWorld.func_72938_d(aX, aZ);
                    if (!tPlayer.func_71121_q().func_73040_p().func_72694_a(tPlayer, tChunk.field_76635_g, tChunk.field_76647_h)) continue;
                    this.sendToPlayer(aPacket, tPlayer);
                    continue;
                }
                return;
            }
        }
    }

    @Override
    public void sendToPlayerIfInRange(IPacket aPacket, UUID aPlayer, World aWorld, ChunkCoordinates aCoords) {
        this.sendToPlayerIfInRange(aPacket, aPlayer, aWorld, aCoords.field_71574_a, aCoords.field_71573_c);
    }

    @Override
    public void sendToPlayerIfInRange(IPacket aPacket, UUID aPlayer, World aWorld, int aX, int aZ) {
        if (aPacket == null) {
            return;
        }
        if (aWorld != null && !aWorld.field_72995_K) {
            for (Object tObject : aWorld.field_73010_i) {
                if (tObject instanceof EntityPlayerMP) {
                    EntityPlayerMP tPlayer = (EntityPlayerMP)tObject;
                    if (!tPlayer.func_110124_au().equals(aPlayer)) continue;
                    Chunk tChunk = aWorld.func_72938_d(aX, aZ);
                    if (tPlayer.func_71121_q().func_73040_p().func_72694_a(tPlayer, tChunk.field_76635_g, tChunk.field_76647_h)) {
                        this.sendToPlayer(aPacket, tPlayer);
                    }
                    return;
                }
                return;
            }
        }
    }

    @Override
    public void sendToAllPlayersInRangeExcept(IPacket aPacket, UUID aPlayer, World aWorld, ChunkCoordinates aCoords) {
        this.sendToAllPlayersInRangeExcept(aPacket, aPlayer, aWorld, aCoords.field_71574_a, aCoords.field_71573_c);
    }

    @Override
    public void sendToAllPlayersInRangeExcept(IPacket aPacket, UUID aPlayer, World aWorld, int aX, int aZ) {
        if (aPacket == null) {
            return;
        }
        if (aWorld != null && !aWorld.field_72995_K) {
            for (Object tObject : aWorld.field_73010_i) {
                if (tObject instanceof EntityPlayerMP) {
                    EntityPlayerMP tPlayer = (EntityPlayerMP)tObject;
                    if (tPlayer.func_110124_au().equals(aPlayer)) continue;
                    Chunk tChunk = aWorld.func_72938_d(aX, aZ);
                    if (!tPlayer.func_71121_q().func_73040_p().func_72694_a(tPlayer, tChunk.field_76635_g, tChunk.field_76647_h)) continue;
                    this.sendToPlayer(aPacket, tPlayer);
                    continue;
                }
                return;
            }
        }
    }

    @Override
    public FMLEmbeddedChannel getChannel(Side aSide) {
        return this.mChannel.get(aSide);
    }

    @ChannelHandler.Sharable
    static final class HandlerServer
    extends SimpleChannelInboundHandler<IPacket> {
        public final INetworkHandler mNetworkHandler;

        public HandlerServer(INetworkHandler aNetworkHandler) {
            this.mNetworkHandler = aNetworkHandler;
        }

        protected void channelRead0(ChannelHandlerContext ctx, IPacket aPacket) throws Exception {
            aPacket.process(null, this.mNetworkHandler);
        }
    }

    @ChannelHandler.Sharable
    static final class HandlerClient
    extends SimpleChannelInboundHandler<IPacket> {
        public final INetworkHandler mNetworkHandler;

        public HandlerClient(INetworkHandler aNetworkHandler) {
            this.mNetworkHandler = aNetworkHandler;
        }

        protected void channelRead0(ChannelHandlerContext ctx, IPacket aPacket) throws Exception {
            aPacket.process((IBlockAccess)(Minecraft.func_71410_x().field_71439_g == null ? null : Minecraft.func_71410_x().field_71439_g.field_70170_p), this.mNetworkHandler);
        }
    }
}

