/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.prefixitem;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.code.ModData;
import gregapi.data.ANY;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.item.CreativeTab;
import gregapi.item.IItemGT;
import gregapi.item.IItemNoGTOverride;
import gregapi.item.IItemUpdatable;
import gregapi.item.IPrefixItem;
import gregapi.lang.LanguageHandler;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class PrefixItem
extends Item
implements Runnable,
IItemUpdatable,
IPrefixItem,
IItemGT,
IItemNoGTOverride {
    public final String mNameInternal;
    public final OreDictPrefix mPrefix;
    public final OreDictMaterial[] mMaterialList;
    public ItemStack mContainerItem = null;
    public String mCraftingSound = null;

    public PrefixItem(ModData aMod, String aNameInternal, OreDictPrefix aPrefix) {
        this(aMod.mID, aMod.mID, aNameInternal, aPrefix, OreDictMaterial.MATERIAL_ARRAY);
    }

    public PrefixItem(String aModIDOwner, String aModIDTextures, String aNameInternal, OreDictPrefix aPrefix, OreDictMaterial ... aMaterialList) {
        this.mPrefix = aPrefix;
        this.mPrefix.mRegisteredPrefixItems.add(this);
        this.mNameInternal = aNameInternal;
        OreDictMaterial[] oreDictMaterialArray = this.mMaterialList = aMaterialList.length > 0 ? aMaterialList : OreDictMaterial.MATERIAL_ARRAY;
        if (this.mMaterialList[0] != MT.Empty) {
            throw new IllegalArgumentException("The first element of the custom Material List has to be MT.Empty for technical reasons!");
        }
        this.func_77656_e(0);
        this.func_77627_a(true);
        GameRegistry.registerItem((Item)this, (String)this.mNameInternal, (String)aModIDOwner);
        this.mPrefix.addTextureSet(aModIDTextures, true);
        LH.add("oredict." + this.mPrefix.dat(MT.Empty).toString(), this.getLocalName(this.mPrefix, MT.Empty));
        LH.add(this.mNameInternal + "." + Short.MAX_VALUE, "Any Sub-Item of this one");
        this.mPrefix.mRegisteredItems.add(this);
        if (CS.SHOW_HIDDEN_PREFIXES || !this.mPrefix.contains(TD.Creative.HIDDEN)) {
            if (this.mPrefix.mCreativeTab == null) {
                this.mPrefix.mCreativeTab = new CreativeTab(this.mPrefix.mNameInternal, this.mPrefix.mNameCategory, this, Short.MAX_VALUE);
            }
            this.func_77637_a(this.mPrefix.mCreativeTab);
        } else {
            this.func_77637_a(CreativeTabs.field_78026_f);
        }
        CS.GAPI.mBeforeInit.add(0, this);
    }

    @Override
    public void run() {
        boolean tUnificationAllowed = this.mPrefix.contains(TD.Prefix.UNIFICATABLE) && !this.mPrefix.contains(TD.Prefix.UNIFICATABLE_RECIPES);
        for (int i = 0; i < this.mMaterialList.length; i = (int)((short)(i + 1))) {
            if (!this.mPrefix.isGeneratingItem(this.mMaterialList[i])) continue;
            ItemStack tStack = ST.update_(ST.make(this, 1L, (long)i));
            LH.add("oredict." + this.mPrefix.dat(this.mMaterialList[i]).toString(), this.getLocalName(this.mPrefix, this.mMaterialList[i]));
            if (tUnificationAllowed) {
                OreDictManager.INSTANCE.addTarget_(this.mPrefix, this.mMaterialList[i], tStack);
                continue;
            }
            OreDictManager.INSTANCE.registerOre_(this.mPrefix, this.mMaterialList[i], tStack);
        }
    }

    public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        if (CS.SHOW_HIDDEN_PREFIXES || !this.mPrefix.contains(TD.Creative.HIDDEN)) {
            for (int i = 0; i < this.mMaterialList.length; ++i) {
                ItemStack tStack;
                if (!this.mPrefix.isGeneratingItem(this.mMaterialList[i]) || !CS.SHOW_HIDDEN_MATERIALS && this.mMaterialList[i].mHidden || (tStack = OM.get_(ST.make(this, 1L, (long)i))).func_77973_b() != this) continue;
                this.updateItemStack(tStack);
                if (ST.meta_(tStack) != i) continue;
                aList.add(tStack);
            }
        }
        if (aList.isEmpty()) {
            ST.hide(this);
        }
    }

    public int func_94901_k() {
        return 1;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
    }

    public boolean func_77623_v() {
        return this.mPrefix.mIconIndexItem >= 0;
    }

    public IIcon func_77650_f(ItemStack aStack) {
        return this.func_77618_c(ST.meta_(aStack), 0);
    }

    public IIcon func_77617_a(int aMetaData) {
        return this.func_77618_c(aMetaData, 0);
    }

    public IIcon getIcon(ItemStack aStack, int aRenderPass) {
        return this.func_77618_c(ST.meta_(aStack), aRenderPass);
    }

    public IIcon getIcon(ItemStack aStack, int aRenderPass, EntityPlayer aPlayer, ItemStack aUsedStack, int aUseRemaining) {
        return this.func_77618_c(ST.meta_(aStack), aRenderPass);
    }

    public IIcon func_77618_c(int aMetaData, int aRenderPass) {
        if (this.mPrefix.mIconIndexItem >= 0) {
            if (UT.Code.exists(aMetaData, this.mMaterialList) && this.mMaterialList[aMetaData].mTextureSetsItems != null) {
                return this.mMaterialList[aMetaData].mTextureSetsItems.get(this.mPrefix.mIconIndexItem).getIcon(aRenderPass);
            }
            return MT.NULL.mTextureSetsItems.get(this.mPrefix.mIconIndexItem).getIcon(aRenderPass);
        }
        return null;
    }

    public int func_82790_a(ItemStack aStack, int aRenderPass) {
        short aMetaData;
        if (aRenderPass == 0 && UT.Code.exists(aMetaData = ST.meta_(aStack), this.mMaterialList)) {
            return UT.Code.getRGBInt(this.mMaterialList[aMetaData].mRGBa[this.mPrefix.mState]);
        }
        return 0xFFFFFF;
    }

    public final String func_77667_c(ItemStack aStack) {
        short aMetaData = ST.meta_(aStack);
        if (aMetaData == Short.MAX_VALUE) {
            return this.mNameInternal + "." + Short.MAX_VALUE;
        }
        if (UT.Code.exists(aMetaData, this.mMaterialList)) {
            return "oredict." + this.mPrefix.dat(this.mMaterialList[aMetaData]).toString();
        }
        return this.mNameInternal;
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        ItemStack itemStack;
        if (ST.equal(aStack, this.mContainerItem, true)) {
            return null;
        }
        if (this.mCraftingSound != null) {
            UT.Sounds.play(this.mCraftingSound, 20, 1.0f);
        }
        if (this.mContainerItem != null) {
            itemStack = ST.amount(1L, this.mContainerItem);
        } else if (this.mPrefix.mContainerItem != null) {
            this.mContainerItem = this.mPrefix.mContainerItem;
            itemStack = ST.amount(1L, this.mContainerItem);
        } else {
            itemStack = null;
        }
        return itemStack;
    }

    public boolean isBeaconPayment(ItemStack aStack) {
        if (this.mPrefix.mAmount >= 648648000L && (this.mPrefix.contains(TD.Prefix.GEM_BASED) || this.mPrefix.contains(TD.Prefix.INGOT_BASED))) {
            short aMetaData = ST.meta_(aStack);
            return UT.Code.exists(aMetaData, this.mMaterialList) && (this.mMaterialList[aMetaData].contains(TD.Properties.VALUABLE) || ANY.Iron.mToThis.contains(this.mMaterialList[aMetaData]));
        }
        return false;
    }

    @Override
    public void updateItemStack(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        this.updateItemStack(aStack);
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        if (this.mMaterialList != OreDictMaterial.MATERIAL_ARRAY) {
            return;
        }
        short aMeta = ST.meta_(aStack);
        if (UT.Code.exists(aMeta, this.mMaterialList)) {
            OreDictMaterial aMaterial = this.mMaterialList[aMeta];
            if (aMeta != aMaterial.mTargetRegistration.mID) {
                ST.meta_(aStack, aMaterial.mTargetRegistration.mID);
            }
            if (!this.mPrefix.isGeneratingItem(aMaterial.mTargetRegistration)) {
                ST.set(aStack, this.mPrefix.mat(aMaterial.mTargetRegistration, 1L), false, false);
            }
        }
    }

    public float getSmeltingExperience(ItemStack aStack) {
        return this.mPrefix == OP.gem ? 1.0f : 0.0f;
    }

    public String toString() {
        return this.mNameInternal;
    }

    public final String func_77658_a() {
        return this.mNameInternal;
    }

    public final Item func_77655_b(String aName) {
        return this;
    }

    public String func_77653_i(ItemStack aStack) {
        return StatCollector.func_74838_a((String)this.func_77667_c(aStack));
    }

    public final boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack) != null;
    }

    public boolean func_77630_h(ItemStack aStack) {
        return false;
    }

    public void func_77622_d(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        this.updateItemStack(aStack);
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public int getItemStackLimit(ItemStack aStack) {
        return this.mPrefix.mDefaultStackSize;
    }

    @Override
    public OreDictItemData getOreDictItemData(ItemStack aStack) {
        return UT.Code.exists(ST.meta_(aStack), this.mMaterialList) ? new OreDictItemData(this.mPrefix, this.mMaterialList[ST.meta_(aStack)]) : null;
    }

    @Override
    public OreDictMaterial getMaterial(int aMetaData) {
        return UT.Code.exists(aMetaData, this.mMaterialList) ? this.mMaterialList[aMetaData] : null;
    }

    @Override
    public OreDictPrefix getPrefix(int aMetaData) {
        return this.mPrefix;
    }

    public boolean func_77636_d(ItemStack aStack) {
        return false;
    }

    public boolean hasEffect(ItemStack aStack, int aRenderPass) {
        return false;
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        while (aList.remove(null)) {
        }
    }

    public String getLocalName(OreDictPrefix aPrefix, OreDictMaterial aMaterial) {
        return LanguageHandler.getLocalName(aPrefix, aMaterial);
    }
}

