/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enviromine.handlers.EM_StatusManager;
import enviromine.trackers.EnviroDataTracker;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.IItemContainer;
import gregapi.code.ItemStackSet;
import gregapi.code.TagData;
import gregapi.cover.CoverRegistry;
import gregapi.cover.ICover;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.RM;
import gregapi.data.TC;
import gregapi.data.TD;
import gregapi.item.IItemEnergy;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.item.multiitem.energy.EnergyStatDebug;
import gregapi.item.multiitem.food.IFoodStat;
import gregapi.item.prefixitem.PrefixItem;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class MultiItemRandom
extends MultiItem
implements Runnable {
    public final BitSet mEnabledItems = new BitSet(Short.MAX_VALUE);
    public final BitSet mVisibleItems = new BitSet(Short.MAX_VALUE);
    public final IIcon[][] mIconList = new IIcon[Short.MAX_VALUE][1];
    public final HashMap<Short, IFoodStat> mFoodStats = new HashMap();
    public final HashMap<Short, IItemEnergy> mElectricStats = new HashMap();
    public final HashMap<Short, Short> mBurnValues = new HashMap();
    private boolean mAllowedToAddItems = false;
    protected short mLastID = Short.MAX_VALUE;

    public MultiItemRandom(String aModID, String aUnlocalized) {
        super(aModID, aUnlocalized);
        CS.GAPI.mBeforeInit.add(this);
    }

    public abstract void addItems();

    @Override
    public final void run() {
        this.mAllowedToAddItems = true;
        this.addItems();
    }

    @Override
    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        this.useEnergy(TD.Energy.EU, aStack, 0L, (EntityLivingBase)aPlayer, null, null, 0, 0, 0, true);
        this.isItemStackUsable(aStack);
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        if (tStat != null && (UT.Entities.isCreative(aPlayer) || aPlayer.func_71024_bL().func_75121_c() || tStat.alwaysEdible(this, aStack, aPlayer))) {
            aPlayer.func_71008_a(aStack, this.func_77626_a(aStack));
        }
        return super.func_77659_a(aStack, aWorld, aPlayer);
    }

    public ItemStack last() {
        return this.last(1);
    }

    public ItemStack last(int aAmount) {
        return ST.make(this, (long)aAmount, (long)this.mLastID);
    }

    public ItemStack prev() {
        return this.prev(1);
    }

    public ItemStack prev(int aAmount) {
        return ST.make(this, (long)aAmount, (long)(this.mLastID - 1));
    }

    public ItemStack next() {
        return this.next(1);
    }

    public ItemStack next(int aAmount) {
        return ST.make(this, (long)aAmount, (long)(this.mLastID + 1));
    }

    public final ItemStack addItem(int aID, String aEnglish, String aToolTip, Object ... aRandomData) {
        if (aToolTip == null) {
            aToolTip = "";
        }
        if (this.mAllowedToAddItems && aID >= 0 && aID < Short.MAX_VALUE && aID != Short.MAX_VALUE) {
            this.mLastID = (short)aID;
            ItemStack aStack = ST.make(this, 1L, (long)aID);
            if (UT.Code.stringValid(aEnglish)) {
                this.mEnabledItems.set(aID);
                this.mVisibleItems.set(aID);
                LH.add(this.func_77667_c(aStack), aEnglish);
                LH.add(this.func_77667_c(aStack) + ".tooltip", aToolTip);
            }
            ArrayListNoNulls<TC.TC_AspectStack> tAspects = new ArrayListNoNulls<TC.TC_AspectStack>();
            for (Object tRandomData : aRandomData) {
                if (!(tRandomData instanceof TagData)) continue;
                if (tRandomData == TD.Creative.HIDDEN) {
                    this.mVisibleItems.set(aID, false);
                    continue;
                }
                if (tRandomData != TD.Properties.AUTO_BLACKLIST) continue;
                OM.blacklist_(aStack);
            }
            for (Object tRandomData : aRandomData) {
                if (tRandomData == null) continue;
                boolean tUseOreDict = true;
                if (tRandomData instanceof ItemStackSet) {
                    ((ItemStackSet)tRandomData).add(aStack);
                    continue;
                }
                if (tRandomData instanceof TagData) continue;
                if (tRandomData instanceof Number) {
                    this.setBurnValue(aID, ((Number)tRandomData).intValue());
                    continue;
                }
                if (tRandomData instanceof IFoodStat) {
                    int tFoodValue;
                    this.setFoodBehavior(aID, (IFoodStat)tRandomData);
                    if (IL.IC2_Food_Can_Empty.exists() && IL.IC2_Food_Can_Filled.exists() && this.getContainerItem(aStack) == null && (tFoodValue = ((IFoodStat)tRandomData).getFoodLevel(this, aStack, null)) > 0) {
                        RM.Canner.addRecipe2(true, 16L, (long)(tFoodValue * 16), aStack, IL.IC2_Food_Can_Empty.get(tFoodValue, new Object[0]), ((IFoodStat)tRandomData).isRotten(this, aStack, null) ? IL.IC2_Food_Can_Spoiled.get(tFoodValue, IL.IC2_Food_Can_Filled.get(tFoodValue, new Object[0])) : IL.IC2_Food_Can_Filled.get(tFoodValue, new Object[0]));
                    }
                    tUseOreDict = false;
                }
                if (tRandomData instanceof ICover) {
                    CoverRegistry.put(aStack, (ICover)tRandomData);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IBehavior) {
                    this.addItemBehavior(aID, (IBehavior)tRandomData);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemEnergy) {
                    this.setElectricStats(aID, (IItemEnergy)tRandomData);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemContainer) {
                    ((IItemContainer)tRandomData).set(aStack);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof TC.TC_AspectStack) {
                    ((TC.TC_AspectStack)tRandomData).addToAspectList(tAspects);
                    continue;
                }
                if (tRandomData instanceof OreDictItemData) {
                    if (((OreDictItemData)tRandomData).validData()) {
                        OM.reg(aStack, tRandomData);
                        ItemStack tStack = ((OreDictItemData)tRandomData).getStack(1L);
                        if (ST.invalid(tStack) || tStack.func_77973_b() instanceof PrefixItem) {
                            OreDictManager.INSTANCE.setTarget_(((OreDictItemData)tRandomData).mPrefix, ((OreDictItemData)tRandomData).mMaterial.mMaterial, aStack);
                            continue;
                        }
                    }
                    OreDictManager.INSTANCE.addItemData_(aStack, (OreDictItemData)tRandomData);
                    continue;
                }
                if (tRandomData instanceof FluidStack) {
                    tRandomData = new FluidContainerRegistry.FluidContainerData((FluidStack)tRandomData, ST.copy_(aStack), this.getContainerItem(aStack), true);
                    FL.reg((FluidContainerRegistry.FluidContainerData)tRandomData, true, false);
                    continue;
                }
                if (tRandomData instanceof FluidContainerRegistry.FluidContainerData) {
                    FL.reg((FluidContainerRegistry.FluidContainerData)tRandomData, true, false);
                    continue;
                }
                if (tRandomData instanceof Runnable) {
                    CS.GAPI.mAfterPostInit.add((Runnable)tRandomData);
                    tUseOreDict = false;
                }
                if (!tUseOreDict) continue;
                OM.reg(tRandomData, aStack);
            }
            if (CS.COMPAT_TC != null) {
                CS.COMPAT_TC.registerThaumcraftAspectsToItem(aStack, tAspects, false);
            }
            return ST.update(ST.make(this, 1L, (long)aID));
        }
        return null;
    }

    public MultiItemRandom setFoodBehavior(int aMetaValue, IFoodStat aFoodBehavior) {
        if (aMetaValue < 0 || aMetaValue >= Short.MAX_VALUE) {
            return this;
        }
        if (aFoodBehavior == null) {
            this.mFoodStats.remove((short)aMetaValue);
        } else {
            this.mFoodStats.put((short)aMetaValue, aFoodBehavior);
        }
        return this;
    }

    public MultiItemRandom setBurnValue(int aMetaValue, int aValue) {
        if (aMetaValue < 0 || aMetaValue >= Short.MAX_VALUE || aValue < 0) {
            return this;
        }
        if (aValue == 0) {
            this.mBurnValues.remove((short)aMetaValue);
        } else {
            this.mBurnValues.put((short)aMetaValue, (short)(aValue > Short.MAX_VALUE ? Short.MAX_VALUE : (short)aValue));
        }
        return this;
    }

    public MultiItemRandom setElectricStats(int aMetaValue, IItemEnergy aStats) {
        if (aMetaValue < 0 || aMetaValue >= Short.MAX_VALUE) {
            return this;
        }
        if (aStats == null) {
            this.mElectricStats.remove((short)aMetaValue);
        } else {
            this.mElectricStats.put((short)aMetaValue, aStats);
            if (!(aStats instanceof EnergyStatDebug)) {
                this.mIconList[aMetaValue] = Arrays.copyOf(this.mIconList[aMetaValue], Math.max(9, this.mIconList[aMetaValue].length));
            }
        }
        return this;
    }

    public MultiItemRandom setFluidContainerStats(int aMetaValue, long aCapacity, long aStacksize) {
        if (aMetaValue < 0 || aMetaValue >= Short.MAX_VALUE) {
            return this;
        }
        if (aCapacity < 0L) {
            this.mFluidContainerStats.remove((short)aMetaValue);
        } else {
            this.mFluidContainerStats.put((short)aMetaValue, new Long[]{aCapacity, Math.max(1L, aStacksize)});
        }
        return this;
    }

    public int func_77626_a(ItemStack aStack) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        return tStat == null ? 0 : Math.max(tStat.getFoodLevel(this, aStack, null) * 8, 16);
    }

    public EnumAction func_77661_b(ItemStack aStack) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        return tStat == null ? EnumAction.none : tStat.getFoodAction(this, aStack);
    }

    public ItemStack func_77654_b(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        if (tStat != null) {
            float tSaturationLevel;
            int tFoodLevel = tStat.getFoodLevel(this, aStack, aPlayer);
            if ((float)tFoodLevel * (tSaturationLevel = tStat.getSaturation(this, aStack, aPlayer)) > 0.0f) {
                if (tStat.useAppleCoreFunctionality(this, aStack, aPlayer) && MD.APC.mLoaded) {
                    aPlayer.func_71024_bL().func_151686_a((ItemFood)UT.Reflection.callConstructor("squeek.applecore.api.food.ItemFoodProxy", 0, null, true, this), aStack);
                } else {
                    aPlayer.func_71024_bL().func_75122_a(tFoodLevel, tSaturationLevel);
                }
            }
            if (!aWorld.field_72995_K && MD.ENVM.mLoaded) {
                try {
                    float tTemperature = tStat.getTemperature(this, aStack, aPlayer) - 273.0f;
                    float tHydration = tStat.getHydration(this, aStack, aPlayer);
                    EnviroDataTracker tTracker = EM_StatusManager.lookupTracker((EntityLivingBase)aPlayer);
                    if (tTracker != null && tTracker.bodyTemp >= 0.0f) {
                        tTracker.bodyTemp += (tTemperature - tTracker.bodyTemp) * tStat.getTemperatureEffect(this, aStack, aPlayer);
                        if (tHydration > 0.0f) {
                            tTracker.hydrate(tHydration);
                        } else if (tHydration < 0.0f) {
                            tTracker.dehydrate(-tHydration);
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
            tStat.onEaten(this, aStack, aPlayer, true, true);
        }
        return aStack;
    }

    @Override
    public IItemEnergy getEnergyStats(ItemStack aStack) {
        return this.mElectricStats.get(ST.meta_(aStack));
    }

    @Override
    public Long[] getFluidContainerStats(ItemStack aStack) {
        return (Long[])this.mFluidContainerStats.get(ST.meta_(aStack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aCreativeTab, List aList) {
        if (aItem == this) {
            int j = this.mEnabledItems.length();
            for (int i = 0; i < j; ++i) {
                ItemStack tStack;
                if (!this.mVisibleItems.get(i) && (!CS.SHOW_HIDDEN_ITEMS || !this.mEnabledItems.get(i))) continue;
                IItemEnergy tStats = this.mElectricStats.get((short)i);
                if (tStats == null || tStats instanceof EnergyStatDebug) {
                    tStack = ST.make(this, 1L, (long)i);
                    this.isItemStackUsable(tStack);
                    aList.add(tStack);
                    continue;
                }
                tStack = ST.make(this, 1L, (long)i);
                this.isItemStackUsable(tStack);
                aList.add(tStack);
                tStack = ST.make(this, 1L, (long)i);
                for (TagData tEnergyType : tStats.getEnergyTypes(tStack)) {
                    tStats.setEnergyStored(tEnergyType, tStack, tStats.getEnergyCapacity(tEnergyType, tStack));
                }
                this.isItemStackUsable(tStack);
                aList.add(tStack);
            }
        }
        if (aList.isEmpty()) {
            ST.hide(this);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        short tMaxMeta = (short)this.mEnabledItems.length();
        for (short aMeta = 0; aMeta < tMaxMeta; aMeta = (short)(aMeta + 1)) {
            if (!this.mEnabledItems.get(aMeta)) continue;
            for (int k = 1; k < this.mIconList[aMeta].length; k = (int)((byte)(k + 1))) {
                this.mIconList[aMeta][k] = aIconRegister.func_94245_a(this.mModID + ":" + this.func_77658_a() + "/" + aMeta + "/" + k);
            }
            this.mIconList[aMeta][0] = aIconRegister.func_94245_a(this.mModID + ":" + this.func_77658_a() + "/" + aMeta);
        }
    }

    public IIcon func_77650_f(ItemStack aStack) {
        short aMetaData = ST.meta_(aStack);
        if (!UT.Code.exists(aMetaData, this.mIconList)) {
            return Textures.ItemIcons.RENDERING_ERROR.getIcon(0);
        }
        IItemEnergy tStats = this.mElectricStats.get(aMetaData);
        if (tStats != null && this.mIconList[aMetaData].length > 1) {
            TagData tEnergyType = tStats.getEnergyTypes(aStack).iterator().next();
            long tStored = tStats.getEnergyStored(tEnergyType, aStack);
            long tCapacity = tStats.getEnergyCapacity(tEnergyType, aStack);
            if (tStored <= 0L) {
                return this.mIconList[aMetaData][1];
            }
            if (tStored >= tCapacity) {
                return this.mIconList[aMetaData][8];
            }
            return this.mIconList[aMetaData][7 - (int)Math.max(0L, Math.min(5L, (tCapacity - tStored) * 6L / tCapacity))];
        }
        return this.mIconList[aMetaData][0];
    }

    public IIcon getIcon(ItemStack aStack, int aRenderPass) {
        return this.func_77650_f(aStack);
    }

    public IIcon getIcon(ItemStack aStack, int aRenderPass, EntityPlayer aPlayer, ItemStack aUsedStack, int aUseRemaining) {
        return this.getIcon(aStack, aRenderPass);
    }

    @Override
    public IIcon func_77617_a(int aMetaData) {
        return UT.Code.exists(aMetaData, this.mIconList) ? this.mIconList[aMetaData][0] : Textures.ItemIcons.RENDERING_ERROR.getIcon(0);
    }

    public IIcon func_77618_c(int aMetaData, int aRenderPass) {
        return UT.Code.exists(aMetaData, this.mIconList) ? this.mIconList[aMetaData][0] : Textures.ItemIcons.RENDERING_ERROR.getIcon(0);
    }

    @Override
    public void addAdditionalToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        if (tStat != null) {
            tStat.addAdditionalToolTips(this, aList, aStack, aF3_H);
        }
    }

    public boolean canBeStoredInToolbox(ItemStack aStack) {
        return this.mElectricStats.get(ST.meta(aStack)) != null;
    }

    public boolean isPlanStorage(ItemStack aStack) {
        return OM.is(CS.OD_USB_STICKS[2], aStack);
    }

    public boolean setSetup(ItemStack aStack, String aSetup) {
        if (OM.is(CS.OD_USB_STICKS[2], aStack)) {
            if (!aStack.func_77942_o()) {
                aStack.func_77982_d(UT.NBT.make());
            }
            aStack.func_77978_p().func_74782_a("gt.usb.data", (NBTBase)UT.NBT.makeString(UT.NBT.makeString("gt.reactor.setup.name", "" + aSetup.hashCode()), "gt.reactor.setup", aSetup));
            aStack.func_77978_p().func_74774_a("gt.usb.tier", (byte)2);
            return true;
        }
        return false;
    }

    public void setPlanName(ItemStack aStack, String aName) {
        aStack.func_77978_p().func_74775_l("gt.usb.data").func_74778_a("gt.reactor.setup.name", aName);
    }

    public boolean hasSetup(ItemStack aStack) {
        return OM.is(CS.OD_USB_STICKS[2], aStack) && aStack.func_77942_o() && aStack.func_77978_p().func_74775_l("gt.usb.data").func_74764_b("gt.reactor.setup");
    }

    public String getSetup(ItemStack aStack) {
        return aStack.func_77978_p().func_74775_l("gt.usb.data").func_74779_i("gt.reactor.setup");
    }
}

