/*
 * Decompiled with CFR 0.152.
 */
package gregapi.fluid;

import gregapi.data.FL;
import gregapi.recipes.Recipe;
import gregapi.util.UT;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class FluidTankGT
implements IFluidTank {
    public final FluidTankGT[] AS_ARRAY = new FluidTankGT[]{this};
    private FluidStack mFluid;
    private long mCapacity = 0L;
    private long mAmount = 0L;
    private boolean mPreventDraining = false;
    private boolean mVoidExcess = false;
    private boolean mChangedFluids = false;
    private Map<String, Long> mAdjustableCapacity = null;
    private long mAdjustableMultiplier = 1L;
    public int mIndex = 0;

    public FluidTankGT() {
        this.mCapacity = Long.MAX_VALUE;
    }

    public FluidTankGT(long aCapacity) {
        this.mCapacity = aCapacity;
    }

    public FluidTankGT(FluidStack aFluid) {
        this.mFluid = aFluid;
        if (aFluid != null) {
            this.mCapacity = aFluid.amount;
            this.mAmount = aFluid.amount;
        }
    }

    public FluidTankGT(FluidStack aFluid, long aCapacity) {
        this.mFluid = aFluid;
        this.mCapacity = aCapacity;
        this.mAmount = aFluid == null ? 0 : aFluid.amount;
    }

    public FluidTankGT(FluidStack aFluid, long aAmount, long aCapacity) {
        this.mFluid = aFluid;
        this.mCapacity = aCapacity;
        this.mAmount = aFluid == null ? 0L : aAmount;
    }

    public FluidTankGT(Fluid aFluid, long aAmount) {
        this(FL.make(aFluid, aAmount));
        this.mAmount = aAmount;
    }

    public FluidTankGT(Fluid aFluid, long aAmount, long aCapacity) {
        this(FL.make(aFluid, aAmount), aCapacity);
        this.mAmount = aAmount;
    }

    public FluidTankGT(NBTTagCompound aNBT, long aCapacity) {
        this.mCapacity = aCapacity;
        if (aNBT != null && !aNBT.func_82582_d()) {
            this.mFluid = FL.load_(aNBT);
            this.mAmount = this.isEmpty() ? 0L : (aNBT.func_74764_b("LAmount") ? aNBT.func_74763_f("LAmount") : (long)this.mFluid.amount);
        }
    }

    public FluidTankGT(NBTTagCompound aNBT, String aKey, long aCapacity) {
        this(aNBT.func_74764_b(aKey) ? aNBT.func_74775_l(aKey) : null, aCapacity);
    }

    public FluidTankGT readFromNBT(NBTTagCompound aNBT, String aKey) {
        if (aNBT.func_74764_b(aKey) && (aNBT = aNBT.func_74775_l(aKey)) != null && !aNBT.func_82582_d()) {
            this.mFluid = FL.load_(aNBT);
            this.mAmount = this.isEmpty() ? 0L : (aNBT.func_74764_b("LAmount") ? aNBT.func_74763_f("LAmount") : (long)this.mFluid.amount);
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound aNBT, String aKey) {
        if (this.mFluid != null && (this.mPreventDraining || this.mAmount > 0L)) {
            NBTTagCompound tNBT = UT.NBT.make();
            this.mFluid.amount = UT.Code.bindInt(this.mAmount);
            aNBT.func_74782_a(aKey, (NBTBase)this.mFluid.writeToNBT(tNBT));
            if (this.mAmount > Integer.MAX_VALUE) {
                tNBT.func_74772_a("LAmount", this.mAmount);
            }
        } else {
            aNBT.func_82580_o(aKey);
        }
        return aNBT;
    }

    public NBTTagCompound writeToNBT(String aKey) {
        NBTTagCompound aNBT = UT.NBT.make();
        if (this.mFluid != null && (this.mPreventDraining || this.mAmount > 0L)) {
            NBTTagCompound tNBT = UT.NBT.make();
            this.mFluid.amount = UT.Code.bindInt(this.mAmount);
            aNBT.func_74782_a(aKey, (NBTBase)this.mFluid.writeToNBT(tNBT));
            if (this.mAmount > Integer.MAX_VALUE) {
                tNBT.func_74772_a("LAmount", this.mAmount);
            }
        } else {
            aNBT.func_82580_o(aKey);
        }
        return aNBT;
    }

    public static NBTTagCompound writeToNBT(String aKey, FluidStack aFluid) {
        NBTTagCompound rNBT = UT.NBT.make();
        if (aFluid != null && aFluid.amount > 0) {
            rNBT.func_74782_a(aKey, (NBTBase)aFluid.writeToNBT(UT.NBT.make()));
        }
        return rNBT;
    }

    public static NBTTagCompound writeToNBT(NBTTagCompound aNBT, String aKey, FluidStack aFluid) {
        if (aFluid != null && aFluid.amount > 0) {
            aNBT.func_74782_a(aKey, (NBTBase)aFluid.writeToNBT(UT.NBT.make()));
        } else {
            aNBT.func_82580_o(aKey);
        }
        return aNBT;
    }

    public FluidStack drain(int aDrained) {
        return this.drain(aDrained, true);
    }

    public FluidStack drain(int aDrained, boolean aDoDrain) {
        if (this.isEmpty() || aDrained <= 0) {
            return null;
        }
        if (this.mAmount < (long)aDrained) {
            aDrained = (int)this.mAmount;
        }
        FluidStack rFluid = new FluidStack(this.mFluid, aDrained);
        if (aDoDrain) {
            this.mAmount -= (long)aDrained;
            if (this.mAmount <= 0L) {
                if (this.mPreventDraining) {
                    this.mAmount = 0L;
                } else {
                    this.setEmpty();
                }
            }
        }
        return rFluid;
    }

    public boolean drainAll(long aDrained) {
        if (this.isEmpty() || this.mAmount < aDrained) {
            return false;
        }
        this.mAmount -= aDrained;
        if (this.mAmount <= 0L) {
            if (this.mPreventDraining) {
                this.mAmount = 0L;
            } else {
                this.setEmpty();
            }
        }
        return true;
    }

    public long remove(long aDrained) {
        if (this.isEmpty() || this.mAmount <= 0L || aDrained <= 0L) {
            return 0L;
        }
        if (this.mAmount < aDrained) {
            aDrained = this.mAmount;
        }
        this.mAmount -= aDrained;
        if (this.mAmount <= 0L) {
            if (this.mPreventDraining) {
                this.mAmount = 0L;
            } else {
                this.setEmpty();
            }
        }
        return aDrained;
    }

    public long add(long aFilled) {
        if (this.isEmpty() || aFilled <= 0L) {
            return 0L;
        }
        long tCapacity = this.capacity();
        if (this.mAmount + aFilled > tCapacity) {
            if (!this.mVoidExcess) {
                aFilled = tCapacity - this.mAmount;
            }
            this.mAmount = tCapacity;
            return aFilled;
        }
        this.mAmount += aFilled;
        return aFilled;
    }

    public long add(long aFilled, FluidStack aFluid) {
        if (aFluid == null || aFilled <= 0L) {
            return 0L;
        }
        if (this.isEmpty()) {
            this.mFluid = aFluid.copy();
            this.mChangedFluids = true;
            this.mAmount = Math.min(this.capacity(aFluid), aFilled);
            return this.mVoidExcess ? aFilled : this.mAmount;
        }
        return this.contains(aFluid) ? this.add(aFilled) : 0L;
    }

    public int fill(FluidStack aFluid) {
        return this.fill(aFluid, true);
    }

    public int fill(FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null) {
            return 0;
        }
        if (aDoFill) {
            if (this.isEmpty()) {
                this.mFluid = aFluid.copy();
                this.mChangedFluids = true;
                this.mAmount = Math.min(this.capacity(aFluid), (long)aFluid.amount);
                return this.mVoidExcess ? aFluid.amount : (int)this.mAmount;
            }
            if (!this.contains(aFluid)) {
                return 0;
            }
            long tCapacity = this.capacity(aFluid);
            long tFilled = tCapacity - this.mAmount;
            if ((long)aFluid.amount < tFilled) {
                this.mAmount += (long)aFluid.amount;
                tFilled = aFluid.amount;
            } else {
                this.mAmount = tCapacity;
            }
            return this.mVoidExcess ? aFluid.amount : (int)tFilled;
        }
        return UT.Code.bindInt(this.isEmpty() ? (this.mVoidExcess ? (long)aFluid.amount : Math.min(this.capacity(aFluid), (long)aFluid.amount)) : (this.contains(aFluid) ? (this.mVoidExcess ? (long)aFluid.amount : Math.min(this.capacity(aFluid) - this.mAmount, (long)aFluid.amount)) : 0L));
    }

    public boolean canFillAll(FluidStack aFluid) {
        return aFluid == null || aFluid.amount <= 0 || (this.isEmpty() ? this.mVoidExcess || (long)aFluid.amount <= this.capacity(aFluid) : this.contains(aFluid) && (this.mVoidExcess || this.mAmount + (long)aFluid.amount <= this.capacity(aFluid)));
    }

    public boolean canFillAll(long aAmount) {
        return aAmount <= 0L || this.mVoidExcess || this.mAmount + aAmount <= this.capacity();
    }

    public boolean fillAll(FluidStack aFluid) {
        if (aFluid == null || aFluid.amount <= 0) {
            return true;
        }
        if (this.isEmpty()) {
            long tCapacity = this.capacity(aFluid);
            if ((long)aFluid.amount <= tCapacity || this.mVoidExcess) {
                this.mFluid = aFluid.copy();
                this.mChangedFluids = true;
                this.mAmount = aFluid.amount;
                if (this.mAmount > tCapacity) {
                    this.mAmount = tCapacity;
                }
                return true;
            }
            return false;
        }
        if (this.contains(aFluid)) {
            if (this.mAmount + (long)aFluid.amount <= this.capacity()) {
                this.mAmount += (long)aFluid.amount;
                return true;
            }
            if (this.mVoidExcess) {
                this.mAmount = this.capacity();
                return true;
            }
        }
        return false;
    }

    public boolean fillAll(FluidStack aFluid, long aMultiplier) {
        if (aMultiplier <= 0L) {
            return true;
        }
        if (aMultiplier == 1L) {
            return this.fillAll(aFluid);
        }
        if (aFluid == null || aFluid.amount <= 0) {
            return true;
        }
        if (this.isEmpty()) {
            long tCapacity = this.capacity(aFluid);
            if ((long)aFluid.amount * aMultiplier <= tCapacity || this.mVoidExcess) {
                this.mFluid = aFluid.copy();
                this.mChangedFluids = true;
                this.mAmount = (long)aFluid.amount * aMultiplier;
                if (this.mAmount > tCapacity) {
                    this.mAmount = tCapacity;
                }
                return true;
            }
            return false;
        }
        if (this.contains(aFluid)) {
            if (this.mAmount + (long)aFluid.amount * aMultiplier <= this.capacity()) {
                this.mAmount += (long)aFluid.amount * aMultiplier;
                return true;
            }
            if (this.mVoidExcess) {
                this.mAmount = this.capacity();
                return true;
            }
        }
        return false;
    }

    public FluidTankGT setEmpty() {
        if (this.mFluid != null) {
            this.mChangedFluids = true;
        }
        this.mFluid = null;
        this.mAmount = 0L;
        return this;
    }

    public FluidTankGT setFluid(FluidStack aFluid) {
        if (aFluid == null) {
            return this.setEmpty();
        }
        if (!FL.equal(this.mFluid, aFluid)) {
            this.mChangedFluids = true;
        }
        this.mFluid = aFluid;
        this.mAmount = this.mFluid.amount;
        return this;
    }

    public FluidTankGT setFluid(FluidStack aFluid, long aAmount) {
        if (aFluid == null) {
            return this.setEmpty();
        }
        if (!FL.equal(this.mFluid, aFluid)) {
            this.mChangedFluids = true;
        }
        this.mFluid = aFluid;
        this.mAmount = aAmount;
        return this;
    }

    public FluidTankGT setFluid(FluidTankGT aTank) {
        if (aTank == null || aTank.mFluid == null) {
            return this.setEmpty();
        }
        if (!FL.equal(this.mFluid, aTank.mFluid)) {
            this.mChangedFluids = true;
        }
        this.mFluid = FL.amount(aTank.mFluid, aTank.mAmount);
        this.mAmount = aTank.mAmount;
        return this;
    }

    public FluidTankGT setIndex(int aIndex) {
        this.mIndex = aIndex;
        return this;
    }

    public FluidTankGT setCapacity(long aCapacity) {
        if (aCapacity >= 0L) {
            this.mCapacity = aCapacity;
        }
        return this;
    }

    public FluidTankGT setPreventDraining() {
        return this.setPreventDraining(true);
    }

    public FluidTankGT setPreventDraining(boolean aPrevent) {
        this.mPreventDraining = aPrevent;
        return this;
    }

    public FluidTankGT setVoidExcess() {
        return this.setVoidExcess(true);
    }

    public FluidTankGT setVoidExcess(boolean aVoidExcess) {
        this.mVoidExcess = aVoidExcess;
        return this;
    }

    public FluidTankGT setCapacity(Recipe.RecipeMap aMap, long aCapacityMultiplier) {
        this.mAdjustableCapacity = aMap.mMinInputTankSizes;
        this.mAdjustableMultiplier = aCapacityMultiplier;
        return this;
    }

    public FluidTankGT setCapacity(Map<String, Long> aMap, long aCapacityMultiplier) {
        this.mAdjustableCapacity = aMap;
        this.mAdjustableMultiplier = aCapacityMultiplier;
        return this;
    }

    public FluidTankGT setCapacity(FluidStack aFluid) {
        return this.setCapacity(aFluid.getFluid(), (long)aFluid.amount);
    }

    public FluidTankGT setCapacity(Fluid aFluid, long aCapacity) {
        return this.setCapacity(aFluid.getName(), aCapacity);
    }

    public FluidTankGT setCapacity(String aFluid, long aCapacity) {
        if (this.mAdjustableCapacity == null) {
            this.mAdjustableCapacity = new HashMap<String, Long>();
        }
        this.mAdjustableCapacity.put(aFluid, aCapacity);
        return this;
    }

    public boolean isEmpty() {
        return this.mFluid == null;
    }

    public boolean isFull() {
        return this.mAmount >= this.capacity();
    }

    public boolean isHalf() {
        return this.mAmount * 2L >= this.capacity();
    }

    public boolean overHalf() {
        return this.mAmount * 2L > this.capacity();
    }

    public boolean underHalf() {
        return this.mAmount * 2L < this.capacity();
    }

    public boolean contains(Fluid aFluid) {
        return this.mFluid != null && this.mFluid.getFluid() == aFluid;
    }

    public boolean contains(FluidStack aFluid) {
        return FL.equal(this.mFluid, aFluid);
    }

    public boolean has(long aAmount) {
        return this.mAmount >= aAmount;
    }

    public boolean has() {
        return this.mAmount > 0L;
    }

    public boolean check() {
        if (this.mChangedFluids) {
            this.mChangedFluids = false;
            return true;
        }
        return false;
    }

    public boolean update() {
        this.mChangedFluids = true;
        return true;
    }

    public boolean changed() {
        return this.mChangedFluids;
    }

    public long amount() {
        return this.isEmpty() ? 0L : this.mAmount;
    }

    public long amount(long aMax) {
        return this.isEmpty() || aMax <= 0L ? 0L : Math.min(this.mAmount, aMax);
    }

    public long capacity() {
        return this.mAdjustableCapacity == null ? this.mCapacity : this.capacity_(this.mFluid);
    }

    public long capacity(FluidStack aFluid) {
        return this.mAdjustableCapacity == null ? this.mCapacity : this.capacity_(aFluid);
    }

    public long capacity(Fluid aFluid) {
        return this.mAdjustableCapacity == null ? this.mCapacity : this.capacity_(aFluid);
    }

    public long capacity(String aFluid) {
        return this.mAdjustableCapacity == null ? this.mCapacity : this.capacity_(aFluid);
    }

    public long capacity_(FluidStack aFluid) {
        return aFluid == null ? this.mCapacity : this.capacity_(aFluid.getFluid());
    }

    public long capacity_(Fluid aFluid) {
        return aFluid == null ? this.mCapacity : this.capacity_(aFluid.getName());
    }

    public long capacity_(String aFluid) {
        if (aFluid == null) {
            return this.mCapacity;
        }
        Long tSize = this.mAdjustableCapacity.get(aFluid);
        return tSize == null ? Math.max(this.mAmount, this.mCapacity) : Math.max(tSize * this.mAdjustableMultiplier, Math.max(this.mAmount, this.mCapacity));
    }

    public String name() {
        return this.mFluid == null ? null : this.mFluid.getFluid().getName();
    }

    public String name(boolean aLocalised) {
        return FL.name(this.mFluid, aLocalised);
    }

    public String content() {
        return this.content("Empty");
    }

    public String content(String aEmptyMessage) {
        return this.mFluid == null ? aEmptyMessage : UT.Code.makeString(this.amount()) + " L of " + this.name(true) + " (" + (FL.gas(this.mFluid) ? "Gaseous" : "Liquid") + ")";
    }

    public String contentcap() {
        return this.mFluid == null ? "Capacity: " + UT.Code.makeString(this.mCapacity) + " L" : UT.Code.makeString(this.amount()) + " L of " + this.name(true) + " (" + (FL.gas(this.mFluid) ? "Gaseous" : "Liquid") + "); Max: " + UT.Code.makeString(this.capacity()) + " L)";
    }

    public Fluid fluid() {
        return this.mFluid == null ? null : this.mFluid.getFluid();
    }

    public FluidStack make(int aAmount) {
        return FL.make(this.fluid(), (long)aAmount);
    }

    public FluidStack get() {
        return this.mFluid;
    }

    public FluidStack get(long aMax) {
        return this.isEmpty() || aMax <= 0L ? null : new FluidStack(this.mFluid, UT.Code.bindInt(this.mAmount < aMax ? this.mAmount : aMax));
    }

    public FluidStack getFluid() {
        if (this.mFluid != null) {
            this.mFluid.amount = UT.Code.bindInt(this.mAmount);
        }
        return this.mFluid;
    }

    public int getFluidAmount() {
        return UT.Code.bindInt(this.mAmount);
    }

    public int getCapacity() {
        return UT.Code.bindInt(this.capacity());
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.isEmpty() ? null : this.mFluid.copy(), UT.Code.bindInt(this.capacity()));
    }
}

