/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.fluid.FluidTankGT;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.connectors.MultiTileEntityPipeFluid;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.IFluidHandler;

public class CoverPressureValve
extends AbstractCoverAttachment {
    public static final float[][] BOXES_VALVES = new float[][]{{CS.PX_P[6], CS.PX_P[0], CS.PX_P[6], CS.PX_N[6], CS.PX_N[8], CS.PX_N[6]}, {CS.PX_P[6], CS.PX_P[8], CS.PX_P[6], CS.PX_N[6], CS.PX_N[0], CS.PX_N[6]}, {CS.PX_P[6], CS.PX_P[6], CS.PX_P[0], CS.PX_N[6], CS.PX_N[6], CS.PX_N[8]}, {CS.PX_P[6], CS.PX_P[6], CS.PX_P[8], CS.PX_N[6], CS.PX_N[6], CS.PX_N[0]}, {CS.PX_P[0], CS.PX_P[6], CS.PX_P[6], CS.PX_N[8], CS.PX_N[6], CS.PX_N[6]}, {CS.PX_P[8], CS.PX_P[6], CS.PX_P[6], CS.PX_N[0], CS.PX_N[6], CS.PX_N[6]}};
    public static final ITexture sTextureFront = BlockTextureDefault.get("machines/covers/pressurevalve/front");
    public static final ITexture sTextureSide = BlockTextureDefault.get("machines/covers/pressurevalve/side");

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !(aData.mTileEntity instanceof MultiTileEntityPipeFluid) || ((MultiTileEntityPipeFluid)aData.mTileEntity).mTanks.length != 1 || aData.mTileEntity.getAdjacentTileEntity((byte)aCoverSide).mTileEntity instanceof MultiTileEntityPipeFluid;
    }

    @Override
    public boolean interceptConnect(byte aCoverSide, CoverData aData) {
        return aData.mTileEntity.getAdjacentTileEntity((byte)aCoverSide).mTileEntity instanceof MultiTileEntityPipeFluid;
    }

    @Override
    public void onTickPost(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && !aData.mStopped && aTimer > 2L && aData.mTileEntity instanceof MultiTileEntityPipeFluid) {
            FluidTankGT tTank = ((MultiTileEntityPipeFluid)aData.mTileEntity).mTanks[0];
            ((MultiTileEntityPipeFluid)aData.mTileEntity).disconnect(aSide, true);
            if (tTank.isFull()) {
                DelegatorTileEntity<IFluidHandler> tDelegator = aData.mTileEntity.getAdjacentTank(aSide);
                if (tDelegator.mTileEntity != null) {
                    FL.move(tTank, tDelegator);
                } else if (FL.gas(tTank) && !tDelegator.hasCollisionBox()) {
                    UT.Sounds.send("random.fizz", aData.mTileEntity);
                    try {
                        for (Entity tEntity : (ArrayList)aData.mTileEntity.getWorld().func_72872_a(Entity.class, aData.box(-2.0, -2.0, -2.0, 3.0, 3.0, 3.0))) {
                            UT.Entities.applyTemperatureDamage(tEntity, FL.temperature(tTank.getFluid()), 2.0f, 10.0f);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                    CS.GarbageGT.trash(tTank);
                }
            }
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.CYAN + "Releases Fluids when Pipe is full.");
        aList.add(LH.Chat.ORANGE + "Liquids require Tank in front!");
        aList.add(LH.Chat.ORANGE + "Gases require Air or Tank in front!");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.controlcover.to.toggle"));
    }

    @Override
    public float[] getCoverBounds(byte aCoverSide, CoverData aData) {
        return BOXES_VALVES[aCoverSide];
    }

    @Override
    public float[] getHolderBounds(byte aCoverSide, CoverData aData) {
        return BOXES_VALVES[aCoverSide];
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return sTextureFront;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide == aTextureSide ? sTextureFront : null;
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide == aTextureSide ? null : sTextureSide;
    }

    @Override
    public boolean isSolid(byte aSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean isOpaque(byte aSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean isFullTexture(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {
        return false;
    }
}

