/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.connectors.ITileEntityConnector;
import gregapi.tileentity.logistics.ITileEntityLogistics;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public abstract class AbstractCoverAttachmentLogistics
extends AbstractCoverAttachment {
    public static final ITexture sTextureBase = BlockTextureDefault.get("machines/covers/logistics/base");

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !(aData.mTileEntity instanceof ITileEntityLogistics) || !((ITileEntityLogistics)aData.mTileEntity).canLogistics((byte)6);
    }

    @Override
    public boolean interceptConnect(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public void onCoverPlaced(byte aSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        if (aData.mTileEntity instanceof ITileEntityConnector && ((ITileEntityConnector)((Object)aData.mTileEntity)).connected(aSide)) {
            ((ITileEntityConnector)((Object)aData.mTileEntity)).disconnect(aSide, true);
        }
        super.onCoverPlaced(aSide, aData, aPlayer, aCover);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.controlcover.to.toggle"));
        if (this.usePriorities()) {
            aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        }
        if (this.useTargetStackSize()) {
            aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.cutter.to.toggle"));
        }
    }

    @Override
    public long onToolClick(byte aCoverSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("screwdriver") && this.usePriorities()) {
            aData.value(aCoverSide, (short)(aData.mValues[aCoverSide] & 0xFFFFFFFC | aData.mValues[aCoverSide] + 1 & 3));
            if (aChatReturn != null) {
                switch (aData.mValues[aCoverSide]) {
                    case 0: {
                        aChatReturn.add("Priority: Unmodified");
                        break;
                    }
                    case 1: {
                        aChatReturn.add("Priority: Generic");
                        break;
                    }
                    case 2: {
                        aChatReturn.add("Priority: Semi-Filtered");
                        break;
                    }
                    case 3: {
                        aChatReturn.add("Priority: Filtered");
                    }
                }
            }
            return 10000L;
        }
        if (aTool.equals("cutter") && this.useTargetStackSize()) {
            aData.value(aCoverSide, (short)(aData.mValues[aCoverSide] & 3 | ((aData.mValues[aCoverSide] >> 2) + 1) % 65 << 2));
            if (aChatReturn != null) {
                int tTargetSize = aData.mValues[aCoverSide] >> 2 & 0x7F;
                if (tTargetSize == 0) {
                    aChatReturn.add("Variable Target Stacksize");
                } else {
                    aChatReturn.add("Target Stacksize: " + tTargetSize);
                }
            }
            return 1000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null && this.usePriorities()) {
                switch (aData.mValues[aCoverSide]) {
                    case 0: {
                        aChatReturn.add("Priority: Unmodified");
                        break;
                    }
                    case 1: {
                        aChatReturn.add("Priority: Generic");
                        break;
                    }
                    case 2: {
                        aChatReturn.add("Priority: Semi-Filtered");
                        break;
                    }
                    case 3: {
                        aChatReturn.add("Priority: Filtered");
                    }
                }
            }
            if (aChatReturn != null && this.useTargetStackSize()) {
                int tTargetSize = aData.mValues[aCoverSide] >> 2 & 0x7F;
                if (tTargetSize == 0) {
                    aChatReturn.add("Variable Target Stacksize");
                } else {
                    aChatReturn.add("Target Stacksize: " + tTargetSize);
                }
            }
            return 1L;
        }
        return super.onToolClick(aCoverSide, aData, aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSideClicked, aHitX, aHitY, aHitZ);
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return aCoverSide == aTextureSide ? this.getCoverTextureSurface(aCoverSide, aData) : sTextureBase;
    }

    @Override
    public ITexture getCoverTextureHolder(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return sTextureBase;
    }

    @Override
    public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {
        return false;
    }

    public boolean useTargetStackSize() {
        return false;
    }

    public boolean usePriorities() {
        return true;
    }
}

