/*
 * Decompiled with CFR 0.152.
 */
package gregapi.code;

import gregapi.GT_API;
import gregapi.code.IItemContainer;
import gregapi.code.ItemStackContainer;
import gregapi.code.ModData;
import gregapi.util.ST;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemStackMap<K extends ItemStackContainer, V>
extends HashMap<ItemStackContainer, V> {
    private static final long serialVersionUID = 1L;
    private boolean mHasWildcards = false;

    public ItemStackMap() {
        GT_API.STACKMAPS.add(this);
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    public boolean containsKey(long aID, long aMeta, boolean aWildcard) {
        if (this.mHasWildcards) {
            if (aWildcard) {
                if (this.containsKey(new ItemStackContainer(aID, 1L, 32767L))) {
                    return true;
                }
                if (aMeta == 32767L) {
                    return false;
                }
            }
        } else if (aMeta == 32767L) {
            return false;
        }
        return this.containsKey(new ItemStackContainer(aID, 1L, aMeta));
    }

    public boolean containsKey(Item aItem, long aMeta, boolean aWildcard) {
        if (this.mHasWildcards) {
            if (aWildcard) {
                if (this.containsKey(new ItemStackContainer(aItem, 1L, 32767L))) {
                    return true;
                }
                if (aMeta == 32767L) {
                    return false;
                }
            }
        } else if (aMeta == 32767L) {
            return false;
        }
        return this.containsKey(new ItemStackContainer(aItem, 1L, aMeta));
    }

    public boolean containsKey(Block aBlock, long aMeta, boolean aWildcard) {
        if (this.mHasWildcards) {
            if (aWildcard) {
                if (this.containsKey(new ItemStackContainer(aBlock, 1L, 32767L))) {
                    return true;
                }
                if (aMeta == 32767L) {
                    return false;
                }
            }
        } else if (aMeta == 32767L) {
            return false;
        }
        return this.containsKey(new ItemStackContainer(aBlock, 1L, aMeta));
    }

    public boolean containsKey(ItemStack aStack, boolean aWildcard) {
        if (this.mHasWildcards) {
            if (aWildcard) {
                if (this.containsKey(new ItemStackContainer(aStack, 32767L))) {
                    return true;
                }
                if (ST.meta(aStack) == Short.MAX_VALUE) {
                    return false;
                }
            }
        } else if (ST.meta(aStack) == Short.MAX_VALUE) {
            return false;
        }
        return this.containsKey(new ItemStackContainer(aStack));
    }

    public boolean containsKey(ItemStackContainer aStack, boolean aWildcard) {
        if (this.mHasWildcards) {
            if (aWildcard) {
                if (aStack.mMetaData == Short.MAX_VALUE) {
                    return this.containsKey(aStack);
                }
                if (this.containsKey(new ItemStackContainer(aStack.mItem, 1L, 32767L))) {
                    return true;
                }
            }
        } else if (aStack.mMetaData == Short.MAX_VALUE) {
            return false;
        }
        return this.containsKey(aStack);
    }

    public V get(IItemContainer aStack) {
        return this.get(new ItemStackContainer(aStack.get(1L, new Object[0])));
    }

    public V get(ItemStack aStack) {
        return this.get(new ItemStackContainer(aStack));
    }

    public V get(ItemStack aStack, long aMeta) {
        return this.get(new ItemStackContainer(aStack, aMeta));
    }

    public V get(long aID, long aMeta) {
        return this.get(new ItemStackContainer(aID, 1L, aMeta));
    }

    public V get(Item aItem, long aMeta) {
        return this.get(new ItemStackContainer(aItem, 1L, aMeta));
    }

    public V get(Block aBlock, long aMeta) {
        return this.get(new ItemStackContainer(aBlock, 1L, aMeta));
    }

    public V get(ModData aMod, String aName, long aMeta) {
        return aMod.mLoaded ? (V)this.get(new ItemStackContainer(ST.make(aMod, aName, 1L, aMeta))) : null;
    }

    @Override
    public V put(ItemStackContainer aKey, V aValue) {
        if (aKey.mMetaData == Short.MAX_VALUE) {
            this.mHasWildcards = true;
        }
        return super.put(aKey, aValue);
    }

    @Override
    public V put(IItemContainer aKey, V aValue) {
        ItemStackContainer tKey = new ItemStackContainer(aKey.get(1L, new Object[0]));
        if (tKey.mMetaData == Short.MAX_VALUE) {
            this.mHasWildcards = true;
        }
        return this.put(tKey, aValue);
    }

    @Override
    public V put(ItemStack aKey, V aValue) {
        ItemStackContainer tKey = new ItemStackContainer(aKey);
        if (tKey.mMetaData == Short.MAX_VALUE) {
            this.mHasWildcards = true;
        }
        return this.put(tKey, aValue);
    }

    public V put(long aID, long aMeta, V aValue) {
        if (aMeta == 32767L) {
            this.mHasWildcards = true;
        }
        return this.put(new ItemStackContainer(aID, 1L, aMeta), aValue);
    }

    public V put(Item aItem, long aMeta, V aValue) {
        if (aMeta == 32767L) {
            this.mHasWildcards = true;
        }
        return this.put(new ItemStackContainer(aItem, 1L, aMeta), aValue);
    }

    public V put(Block aBlock, long aMeta, V aValue) {
        if (aMeta == 32767L) {
            this.mHasWildcards = true;
        }
        return this.put(new ItemStackContainer(aBlock, 1L, aMeta), aValue);
    }

    public V put(ModData aMod, String aName, long aMeta, V aValue) {
        if (aMeta == 32767L) {
            this.mHasWildcards = true;
        }
        return this.put(new ItemStackContainer(ST.make(aMod, aName, 1L, aMeta)), aValue);
    }
}

