/*
 * Decompiled with CFR 0.152.
 */
package gregapi.code;

import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public interface ITagDataContainer<C> {
    public boolean contains(TagData var1);

    public boolean containsAll(TagData ... var1);

    public boolean containsAll(Collection<TagData> var1);

    public C add(TagData ... var1);

    public boolean remove(TagData var1);

    public static final class BasicTagDataContainer
    implements ITagDataContainer<BasicTagDataContainer> {
        private final Set<TagData> mTags = new HashSetNoNulls<TagData>();

        @Override
        public boolean contains(TagData aTag) {
            return this.mTags.contains(aTag);
        }

        @Override
        public boolean containsAll(TagData ... aTags) {
            return this.mTags.containsAll(Arrays.asList(aTags));
        }

        @Override
        public boolean containsAll(Collection<TagData> aTags) {
            return this.mTags.containsAll(aTags);
        }

        @Override
        public BasicTagDataContainer add(TagData ... aTags) {
            if (aTags != null) {
                for (TagData aTag : aTags) {
                    this.mTags.add(aTag);
                }
            }
            return this;
        }

        @Override
        public boolean remove(TagData aTag) {
            return this.mTags.remove(aTag);
        }
    }
}

